/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.scaling;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import se.datadosen.jalbum.scaling.BetterMediumScaler;
import se.datadosen.jalbum.scaling.FastScaler;
import se.datadosen.jalbum.scaling.HardwareSmoothScaler;
import se.datadosen.jalbum.scaling.SmoothScaler;

public abstract class ImageScaler {
    public static ImageScaler getScaler(String name) {
        return ImageScaler.getScaler(name, true);
    }

    public static ImageScaler getScaler(String name, boolean hardwareScaling) {
        if ("ScaleFast".equals(name)) {
            return new FastScaler();
        }
        if ("ScaleSmooth".equals(name)) {
            return hardwareScaling ? new HardwareSmoothScaler() : new SmoothScaler();
        }
        return new BetterMediumScaler();
    }

    BufferedImage createBufferedImage(Image src, int w, int h) {
        BufferedImage buf = new BufferedImage(w, h, 1);
        Graphics g = buf.getGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        src.flush();
        return buf;
    }

    public abstract BufferedImage scale(Image var1, int var2, int var3);
}

