/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumManifest;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.event.DeleteEvent;
import se.datadosen.jalbum.event.UploadEvent;
import se.datadosen.jalbum.event.UploadListener;
import se.datadosen.util.IO;
import se.datadosen.util.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadBean
implements RemoteFSProgressMonitor {
    private static final String TIME_DIFF_TEST_NAME = "timedifftester";
    private static final String AUTOUNZIP_EXTENSION = "zipstream";
    private static final String ZIPPED_ALBUM_NAME = "album.zipstream";
    private static final String ZIPPED_TEST_NAME = "test.zipstream";
    private static final String FILETREE_NAME = ":filetree";
    private transient Vector uploadListeners;
    private transient Vector albumBeanListeners;
    private RemoteFSDelegate remoteFSBean = RemoteFSBean.createInstance();
    private long processedBytes;
    private long totalBytes;
    private UploadEvent eventObject;
    private AlbumBean engine;
    private String remoteDirectory = "album";
    private String baseDirectory = "";
    private String ftpServer = "";
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean myjalbum;
    private boolean ftpForceUTF8 = false;
    private boolean secureFtp = false;
    private boolean passiveMode = true;
    private int ftpPort = 21;
    private boolean fireProgressEvents = true;
    private long timeDifference = 0L;

    public static void showErrorDialog(Component owner, RemoteFSException ex, String messagePrefix, String title) {
        String message = messagePrefix != null ? messagePrefix + ": " : "";
        message = message + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    protected void finalize() throws Throwable {
        if (this.remoteFSBean.isConnected()) {
            this.remoteFSBean.disconnect();
        }
    }

    public RemoteFSDelegate getRemoteFS() {
        return this.remoteFSBean;
    }

    private void deleteDirectory2(String remotePath) throws RemoteFSException, IOException {
        this.remoteFSBean.setDirectory(remotePath);
        String relativeRemotePath = this.toRelative(remotePath);
        RemoteFile[] files = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter);
        for (int i = 0; i < files.length; ++i) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, relativeRemotePath, files[i].getName(), 0, 1, 0, 1);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String fullPath = IO.combinePaths(remotePath, files[i].getName());
            if (files[i].isDirectory()) {
                this.deleteDirectory2(fullPath);
            } else {
                this.remoteFSBean.removeFile(fullPath);
            }
            this.fireImageProcessingFinished(eventObject);
        }
        this.remoteFSBean.toParentDirectory();
        this.remoteFSBean.removeDirectory(remotePath);
    }

    public void deleteDirectory(String remoteDir) throws ParameterException, RemoteFSException, IOException {
        if (remoteDir.length() == 0) {
            throw new ParameterException("Cannot delete ftp root (security)");
        }
        String remotePath = this.toAbsolute(remoteDir);
        try {
            this.remoteFSBean.removeDirectory(remotePath);
            return;
        }
        catch (RemoteFSException remoteFSException) {
            this.deleteDirectory2(remotePath);
            return;
        }
    }

    public void setFtpServer(String newFtpServer) {
        this.ftpServer = newFtpServer.trim();
        int colonIndex = this.ftpServer.indexOf("://");
        if (colonIndex != -1) {
            this.ftpServer = this.ftpServer.substring(colonIndex + 3);
        }
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public void setFtpPort(int newFtpPort) throws RemoteFSException {
        this.ftpPort = newFtpPort;
    }

    public int getFtpPort() throws RemoteFSException {
        return this.ftpPort;
    }

    public void setFtpUser(String newFtpUser) {
        this.ftpUser = newFtpUser.trim();
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpPassword(String newFtpPassword) {
        this.ftpPassword = newFtpPassword.trim();
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public boolean isMyjalbum() {
        return this.myjalbum;
    }

    public void setMyjalbum(boolean myjalbum) {
        this.myjalbum = myjalbum;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim();
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public boolean isFtpForceUTF8() throws RemoteFSException {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean force) throws RemoteFSException {
        this.ftpForceUTF8 = force;
    }

    public void setSecureFtp(boolean newSecureFtp) {
        this.secureFtp = newSecureFtp;
    }

    public boolean isSecureFtp() {
        return this.secureFtp;
    }

    public void setPassiveMode(boolean newPassiveMode) throws RemoteFSException {
        this.passiveMode = newPassiveMode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void connect() throws RemoteFSException, IOException {
        this.remoteFSBean.setSecure(this.isSecureFtp());
        this.remoteFSBean.setProgressMonitor(this);
        this.remoteFSBean.setForceUTF8(this.isFtpForceUTF8());
        this.remoteFSBean.setPassiveMode(this.isPassiveMode());
        this.remoteFSBean.setPort(this.getFtpPort());
        this.remoteFSBean.connect(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
        this.baseDirectory = this.remoteFSBean.getDirectory();
    }

    public void disconnect() {
        try {
            this.remoteFSBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        try {
            return this.remoteFSBean.isConnected();
        }
        catch (RemoteFSException ex) {
            return false;
        }
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.testConnection(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private void deleteFiles(Set<RemoteFile> toDelete, String remoteDir) throws IOException, RemoteFSException {
        String lastPath = "";
        int fileNum = 1;
        for (RemoteFile rf : toDelete) {
            String path;
            int i;
            String newPath = IO.combinePaths(remoteDir, rf.getFullPath());
            int slashIndex = newPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                newPath = newPath.substring(0, slashIndex);
            }
            if (!newPath.equals(lastPath)) {
                this.remoteFSBean.setDirectory(newPath);
                lastPath = newPath;
            }
            if ((i = (path = rf.getFullPath()).lastIndexOf(47)) > 0) {
                path = path.substring(0, i);
            }
            DeleteEvent eventObject = new DeleteEvent((Object)this, path, Msg.get("upload.deletingUnusedFiles"), fileNum, toDelete.size());
            this.fireFileProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            this.remoteFSBean.removeFile(rf.getName());
            this.fireFileProcessingFinished(eventObject);
            ++fileNum;
        }
    }

    public static long getTotalSize(Set<RemoteFile> files, int clusterSize) {
        long total = 0L;
        for (RemoteFile rf : files) {
            total += (rf.size() + (long)clusterSize - 1L) / (long)clusterSize * (long)clusterSize;
        }
        return total;
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.baseDirectory, path);
    }

    private String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.baseDirectory);
        if (rel.startsWith("..")) {
            return path;
        }
        return rel;
    }

    Set<RemoteFile> getExistingAlbumFiles(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.setProgressMonitor(this);
        this.eventObject = new UploadEvent(this, "", Msg.get("upload.comparingFilesInfo"), 0L, 1L);
        String remoteDir = this.toAbsolute(engine.getRemoteDirectory());
        try {
            AlbumManifest manifest = new AlbumManifest(this.remoteFSBean, remoteDir);
            return manifest.getContent();
        }
        catch (RemoteFSException ex) {
            try {
                Set<RemoteFile> existingFiles = this.getFileTree(remoteDir);
                return existingFiles;
            }
            catch (ParseException ex2) {
                ex2.printStackTrace(System.err);
                throw new RemoteFSException(ex2);
            }
        }
    }

    private Set<RemoteFile> getFileTree(String remoteDir) throws IOException, RemoteFSException, ParseException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.remoteFSBean.get(IO.combinePaths(remoteDir, FILETREE_NAME), bos);
        bos.flush();
        bos.close();
        byte[] rawbytes = bos.toByteArray();
        String content = new String(rawbytes, "UTF-8");
        TreeSet<RemoteFile> files = new TreeSet<RemoteFile>();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Scanner sc = new Scanner(content);
        int pathStart = remoteDir.length() + 1;
        while (sc.hasNextLine()) {
            String rights = sc.next();
            if (rights.charAt(0) == 'd') {
                sc.nextLine();
                continue;
            }
            sc.next();
            sc.next();
            sc.next();
            long size = sc.nextLong();
            Date date = dateFormatter.parse(sc.next());
            sc.next();
            sc.next();
            String pathFromRoot = sc.nextLine().substring(1);
            files.add(new RemoteFileImpl(pathFromRoot.substring(pathStart), size, date.getTime()));
        }
        return files;
    }

    public void uploadAlbum(AlbumBean engine, boolean fullUpdate) throws ParameterException, RemoteFSException, IOException, OperationAbortedException {
        AlbumManifest manifest;
        Set<RemoteFile> newFiles;
        Set<File> skipFiles;
        String remoteDir;
        File dir;
        block6: {
            this.engine = engine;
            dir = engine.getInterpretedOutputDirectory();
            if (!dir.isDirectory()) {
                throw new IOException(Msg.get("publish.invalidOutputDirectoryError"));
            }
            this.processedBytes = 0L;
            this.remoteFSBean.setProgressMonitor(this);
            this.eventObject = new UploadEvent(this, dir.getName(), Msg.get("upload.comparingFilesInfo"), 0L, 1L);
            remoteDir = this.toAbsolute(engine.getRemoteDirectory());
            skipFiles = new TreeSet<File>();
            newFiles = this.getAllFiles(new File[]{dir}, dir);
            Set<Object> existingFiles = new TreeSet();
            try {
                manifest = new AlbumManifest(this.remoteFSBean, remoteDir);
                existingFiles = manifest.getContent();
                TreeSet<RemoteFile> toDelete = new TreeSet<RemoteFile>();
                toDelete.addAll(existingFiles);
                toDelete.removeAll(newFiles);
                this.deleteFiles(toDelete, remoteDir);
                this.remoteFSBean.setDirectory(remoteDir);
                this.remoteFSBean.removeFile("manifest.jmf");
                for (RemoteFile remoteFile : existingFiles) {
                    File local;
                    if (!newFiles.contains(remoteFile) || (local = new File(dir, remoteFile.getFullPath())).lastModified() / 1000L * 1000L != remoteFile.getModificationDate().getTime()) continue;
                    skipFiles.add(local);
                }
            }
            catch (Exception ex) {
                if (fullUpdate) break block6;
                this.fireFileProcessingStarted(this.eventObject);
                this.timeDifference = this.calcTimeDifference();
                skipFiles = this.findFilesToSkip(dir, remoteDir);
            }
        }
        this.totalBytes = this.getTotalFileSize(dir.listFiles(new UploadFileFilter()), skipFiles);
        manifest = new AlbumManifest(newFiles);
        Stopwatch uploadWatch = new Stopwatch("Upload");
        uploadWatch.start();
        if (Config.getConfig().isZipstreaming() && this.hasZipstreamingSupport()) {
            System.out.println("Zip stream support detected");
            this.uploadFilesZipped(this.toFileSet(dir.listFiles(new UploadFileFilter())), dir, skipFiles, remoteDir, manifest);
        } else {
            this.uploadFiles(this.toFileSet(dir.listFiles(new UploadFileFilter())), skipFiles, remoteDir);
            manifest.write(this.remoteFSBean, remoteDir);
        }
        System.out.println(uploadWatch);
    }

    public void uploadFiles(File[] filesDirs, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedBytes = 0L;
        this.totalBytes = this.getTotalFileSize(filesDirs, null);
        this.remoteFSBean.setProgressMonitor(this);
        this.uploadFiles(this.toFileSet(filesDirs), null, this.toAbsolute(remotePath));
    }

    private Set<File> toFileSet(File[] files) {
        TreeSet<File> set = new TreeSet<File>();
        for (File f : files) {
            set.add(f);
        }
        return set;
    }

    private long calcTimeDifference() {
        long diff = 0L;
        try {
            this.remoteFSBean.setDirectory(this.toAbsolute(this.engine.getRemoteDirectory()));
            Date localTime = new Date();
            String s = "The purpose of this file is to synchronize the clock of the server with Jalbum. It can be safely removed";
            byte[] bytes = s.getBytes("ISO-8859-1");
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.remoteFSBean.put(in, TIME_DIFF_TEST_NAME);
            in.close();
            RemoteFile[] files = this.remoteFSBean.getFiles();
            this.remoteFSBean.removeFile(TIME_DIFF_TEST_NAME);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(TIME_DIFF_TEST_NAME)) continue;
                diff = files[i].getModificationDate().getTime() - localTime.getTime();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (RemoteFSException ex) {
            ex.printStackTrace(System.err);
        }
        return diff;
    }

    private void uploadFiles(Set<File> filesDirs, Set<File> skipFiles, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        if (skipFiles != null) {
            filesDirs.removeAll(skipFiles);
        }
        this.remoteFSBean.setDirectory(remotePath);
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                Set<File> children = this.toFileSet(f.listFiles(new UploadFileFilter()));
                if (skipFiles != null) {
                    children.removeAll(skipFiles);
                }
                if (children.size() <= 0) continue;
                try {
                    this.remoteFSBean.createDirectory(f.getName());
                }
                catch (RemoteFSException ex) {
                    // empty catch block
                }
                String newPath = IO.combinePaths(remotePath, f.getName());
                this.uploadFiles(children, skipFiles, newPath);
                this.remoteFSBean.toParentDirectory();
                continue;
            }
            this.eventObject = new UploadEvent(this, f.getParentFile().getName(), f.getName(), this.processedBytes, this.totalBytes);
            this.fireFileProcessingStarted(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            int attempt = 1;
            while (true) {
                try {
                    if (attempt > 1) {
                        if (this.remoteFSBean.isConnected()) {
                            this.remoteFSBean.disconnect();
                        }
                        this.remoteFSBean.reconnect();
                    }
                    this.remoteFSBean.putFile(f, f.getName());
                }
                catch (IOException ex) {
                    if (attempt > 6) {
                        throw ex;
                    }
                    System.err.println("Caught " + ex.toString() + " while uploading " + f + ". Attempt " + attempt);
                    try {
                        Thread.sleep(1000 * attempt * attempt);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
            this.fireFileProcessingFinished(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            this.processedBytes += f.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadZipEntry(String path, InputStream in, ZipOutputStream out, boolean fireEvents) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        out.putNextEntry(ze);
        try {
            byte[] b = new byte[32768];
            int bytesRead = 0;
            this.eventObject.processedBytes = this.processedBytes;
            while (bytesRead >= 0) {
                bytesRead = in.read(b);
                if (bytesRead <= 0) continue;
                out.write(b, 0, bytesRead);
                if (!fireEvents) continue;
                this.eventObject.processedBytes += (long)bytesRead;
                this.fireFileProcessingProgress(this.eventObject);
            }
            out.closeEntry();
        }
        finally {
            in.close();
        }
    }

    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, ZipOutputStream out) throws RemoteFSException, IOException {
        if (skipFiles != null) {
            filesDirs.removeAll(skipFiles);
        }
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                Set<File> children = this.toFileSet(f.listFiles(new UploadFileFilter()));
                if (skipFiles != null) {
                    children.removeAll(skipFiles);
                }
                if (children.size() <= 0) continue;
                out.putNextEntry(new ZipEntry(IO.relativePath(f, root) + '/'));
                this.uploadFilesZipped(children, root, skipFiles, out);
                continue;
            }
            this.eventObject = new UploadEvent(this, f.getParentFile().getName(), f.getName(), this.processedBytes, this.totalBytes);
            this.fireFileProcessingStarted(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String path = IO.relativePath(f, root);
            this.uploadZipEntry(path, new FileInputStream(f), out, true);
            this.fireFileProcessingFinished(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            this.processedBytes += f.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, String remotePath, AlbumManifest manifest) throws RemoteFSException, IOException, OperationAbortedException {
        this.remoteFSBean.setDirectory(remotePath);
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        Thread putterThread = new Thread("putter thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    UploadBean.this.fireProgressEvents = false;
                    UploadBean.this.remoteFSBean.put(in, UploadBean.ZIPPED_ALBUM_NAME);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    UploadBean.this.fireProgressEvents = true;
                }
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        try {
            this.uploadFilesZipped(filesDirs, root, skipFiles, zout);
            this.uploadZipEntry("manifest.jmf", new ByteArrayInputStream(manifest.getBytes()), zout, false);
            zout.finish();
        }
        finally {
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasZipstreamingSupport() throws IOException, RemoteFSException {
        String testFileName = "" + new Date().getTime() + ".tmp";
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        Thread putterThread = new Thread("putter thread"){

            public void run() {
                try {
                    UploadBean.this.remoteFSBean.put(in, UploadBean.ZIPPED_TEST_NAME);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        try {
            zout.putNextEntry(new ZipEntry(testFileName));
            zout.closeEntry();
            zout.finish();
        }
        finally {
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException ex) {}
        }
        try {
            this.remoteFSBean.removeFile(testFileName);
            return true;
        }
        catch (RemoteFSException ex) {
            this.remoteFSBean.removeFile(ZIPPED_TEST_NAME);
            return false;
        }
    }

    private Set<File> findFilesToSkip(File dir, String remotePath) throws RemoteFSException, IOException {
        return this.findFilesToSkip(dir, remotePath, new HashSet<File>());
    }

    private Set<File> findFilesToSkip(File dir, String remotePath, Set<File> skipFiles) throws RemoteFSException, IOException {
        RemoteFile[] rFiles;
        File[] filesDirs = dir.listFiles(new UploadFileFilter());
        HashMap<String, File> localFiles = new HashMap<String, File>();
        for (File f : filesDirs) {
            localFiles.put(f.getName(), f);
        }
        this.remoteFSBean.setDirectory(remotePath);
        for (RemoteFile remoteFile : rFiles = this.remoteFSBean.getFiles()) {
            File localFile = (File)localFiles.get(remoteFile.getName());
            if (remoteFile.isFile() && localFile != null) {
                if (!this.identical(localFile, remoteFile)) continue;
                skipFiles.add(localFile);
                continue;
            }
            if (localFile == null || !localFile.isDirectory()) continue;
            this.findFilesToSkip(localFile, IO.combinePaths(remotePath, remoteFile.getName()), skipFiles);
        }
        return skipFiles;
    }

    private long getTotalFileSize(File[] filesDirs, Set<File> skipFiles) {
        long size = 0L;
        if (filesDirs == null) {
            return 0L;
        }
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                size += this.getTotalFileSize(f.listFiles(new UploadFileFilter()), skipFiles);
                continue;
            }
            if (skipFiles != null && skipFiles.contains(f)) continue;
            size += f.length();
        }
        return size;
    }

    private Set<RemoteFile> getAllFiles(File[] filesDirs, File root) {
        return this.getAllFiles(filesDirs, new TreeSet<RemoteFile>(), root);
    }

    private Set<RemoteFile> getAllFiles(File[] filesDirs, Set<RemoteFile> allFiles, File root) {
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                this.getAllFiles(f.listFiles(new UploadFileFilter()), allFiles, root);
                continue;
            }
            allFiles.add(new RemoteFileImpl(f, root));
        }
        return allFiles;
    }

    private boolean identical(File local, RemoteFile remote) {
        long adjustedRemoteTime = remote.getModificationDate().getTime() - this.timeDifference;
        return local.length() == remote.size() && adjustedRemoteTime > local.lastModified();
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    public synchronized void addUploadListener(UploadListener l) {
        Vector v;
        Vector vector = v = this.uploadListeners == null ? new Vector(2) : (Vector)this.uploadListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.uploadListeners = v;
        }
    }

    public synchronized void removeUploadListener(UploadListener l) {
        if (this.uploadListeners != null && this.uploadListeners.contains(l)) {
            Vector v = (Vector)this.uploadListeners.clone();
            v.removeElement(l);
            this.uploadListeners = v;
        }
    }

    protected void fireFileProcessingStarted(UploadEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((UploadListener)listeners.elementAt(i)).fileProcessingStarted(e);
            }
        }
    }

    protected void fireFileProcessingProgress(UploadEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((UploadListener)listeners.elementAt(i)).fileProcessingProgress(e);
            }
        }
    }

    protected void fireFileProcessingFinished(UploadEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((UploadListener)listeners.elementAt(i)).fileProcessingFinished(e);
            }
        }
    }

    public synchronized void addAlbumBeanListener(AlbumBeanListener l) {
        Vector v;
        Vector vector = v = this.albumBeanListeners == null ? new Vector(2) : (Vector)this.albumBeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.albumBeanListeners = v;
        }
    }

    public synchronized void removeAlbumBeanListener(AlbumBeanListener l) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l)) {
            Vector v = (Vector)this.albumBeanListeners.clone();
            v.removeElement(l);
            this.albumBeanListeners = v;
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((UploadListener)listeners.elementAt(i)).errorOccured(param1, param2);
            }
        }
    }

    @Override
    public void bytesTransferred(long bytes) {
        if (this.fireProgressEvents && this.eventObject != null) {
            this.eventObject.processedBytes = this.processedBytes + bytes;
            this.fireFileProcessingProgress(this.eventObject);
        }
    }

    static class UploadFileFilter
    implements FileFilter {
        private Pattern pattern;

        public UploadFileFilter(String ignorePattern) {
            this.pattern = Pattern.compile(ignorePattern);
        }

        public UploadFileFilter() {
            this.pattern = this.pattern = Pattern.compile("");
        }

        public boolean accept(File file) {
            String name = file.getName();
            Matcher m = this.pattern.matcher(name);
            return !m.matches() && !name.endsWith(".jap") && !name.equals(".DS_Store") && !name.equals(".jalbum");
        }
    }
}

