/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;
import se.datadosen.util.httpClient.ModuleException;

public class Notifier {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    JPublishWizard publishWizard;
    JAlbumFrame window;
    JAlbumSite site;
    boolean debug = false;

    public Notifier(JPublishWizard parent, JAlbumFrame window) throws ElementException, IOException {
        this.publishWizard = parent;
        this.window = window;
        this.site = JAlbumSite.getTrueInstance();
    }

    public String albumAdded(String albumUrl, boolean profileOnly) throws IOException, ModuleException {
        if (profileOnly && !Config.getConfig().isUpdateProfilePage()) {
            return null;
        }
        AlbumObject root = this.window.albumExplorer.getRootFolder();
        String thumbnailPath = root.getThumbnailPath();
        String cid = this.publishWizard.getCurrentCid();
        HttpConnection conn = new HttpConnection(new URL(this.site.getAddAlbumUrl()));
        Properties data = new Properties();
        data.setProperty("albumUrl", Notifier.urlEncode(albumUrl));
        if (profileOnly) {
            data.setProperty("profileOnly", "true");
        }
        if (thumbnailPath != null) {
            String thumbnailUrl = Notifier.urlEncode(IO.combinePaths(albumUrl, thumbnailPath));
            data.setProperty("thumbnailUrl", thumbnailUrl);
        }
        data.setProperty("albumName", root.getName());
        data.setProperty("albumDescription", root.getComment());
        data.setProperty("skin", this.window.engine.getSkin());
        data.setProperty("style", this.window.engine.getStyle());
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        this.log("albumAdded", data);
        HttpResponse resp = conn.Post(data);
        if (resp.getStatusCode() != 200) {
            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
        }
        String content = resp.getContentAsString();
        return content;
    }

    public void albumAddedBg(final String albumUrl, final boolean hidden) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumAdded(albumUrl, hidden);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    public String albumDeleted(String oldUrl) throws IOException, ModuleException {
        if (!Config.getConfig().isUpdateProfilePage()) {
            return null;
        }
        String cid = this.publishWizard.getCurrentCid();
        HttpConnection conn = new HttpConnection(new URL(this.site.getUpdateAlbumUrl()));
        Properties data = new Properties();
        data.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        this.log("albumDeleted", data);
        HttpResponse resp = conn.Post(data);
        if (resp.getStatusCode() != 200) {
            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
        }
        String content = resp.getContentAsString();
        return content;
    }

    public void albumDeletedBg(final String oldUrl) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumDeleted(oldUrl);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    public String albumMoved(String oldUrl, String newUrl) throws IOException, ModuleException {
        if (!Config.getConfig().isUpdateProfilePage()) {
            return null;
        }
        String cid = this.publishWizard.getCurrentCid();
        HttpConnection conn = new HttpConnection(new URL(this.site.getUpdateAlbumUrl()));
        Properties data = new Properties();
        data.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        data.setProperty("newUrl", Notifier.urlEncode(newUrl));
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        this.log("albumMoved", data);
        HttpResponse resp = conn.Post(data);
        if (resp.getStatusCode() != 200) {
            throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
        }
        String content = resp.getContentAsString();
        return content;
    }

    public void albumMovedBg(final String oldUrl, final String newUrl) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumMoved(oldUrl, newUrl);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    private void log(String text, Properties data) {
        if (this.debug) {
            System.out.println(text + ":");
            for (Map.Entry<Object, Object> e : data.entrySet()) {
                System.out.println(e.getKey() + "=" + e.getValue());
            }
        }
    }

    private void log(Throwable t) {
        if (this.debug) {
            t.printStackTrace();
        }
    }

    private static String urlEncode(String s) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || chars[i] == ' ' || chars[i] == '#' || chars[i] == '%' || chars[i] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

