/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JThumbnailChooser;
import se.datadosen.jalbum.Msg;

public class JGeneralSettingsPanel
extends ControlPanel {
    JLabel albumThumbnailLabel = new JLabel();
    JThumbnailChooser albumThumbnail = new JThumbnailChooser();
    JLabel albumTitleLabel = new JLabel();
    JBackgroundTextField albumTitle = new JBackgroundTextField(20);
    JLabel albumDescriptionLabel = new JLabel();
    JTextArea albumDescription = new JSmartTextArea(8, 20);
    private PropertyChangeListener changeListener;

    public JGeneralSettingsPanel() {
        this.init();
    }

    public AlbumObject getAlbumObject() {
        return this.albumThumbnail.getAlbumObject();
    }

    public void setAlbumObject(AlbumObject root) {
        this.changeListener = null;
        this.albumThumbnail.setAlbumObject(root);
        boolean okRoot = root != null && root.getChildren() != null;
        this.setEnabled(okRoot);
        if (okRoot) {
            this.albumTitle.setBackgroundText(root.getName());
            this.albumTitle.setText((String)root.getProperties().get("title"));
            this.albumDescription.setText(root.getComment());
            this.changeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("comment")) {
                        JGeneralSettingsPanel.this.albumDescription.setText(JGeneralSettingsPanel.this.getAlbumObject().getComment());
                        JGeneralSettingsPanel.this.albumDescription.repaint();
                    } else if (evt.getPropertyName().equals("properties")) {
                        JGeneralSettingsPanel.this.albumTitle.setText((String)JGeneralSettingsPanel.this.getAlbumObject().getProperties().get("title"));
                    }
                }
            };
            root.addPropertyChangeListener(this.changeListener);
        } else {
            this.albumTitle.setText("");
            this.albumTitle.setBackgroundText("");
            this.albumDescription.setText("");
        }
    }

    private void init() {
        this.setLayout(new RiverLayout(0, 0));
        this.albumDescription.setFocusTraversalKeys(0, null);
        this.albumDescription.setFocusTraversalKeys(1, null);
        this.albumDescription.setLineWrap(true);
        this.albumDescription.setWrapStyleWord(true);
        this.albumTitle.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AlbumObjectProperties props = JGeneralSettingsPanel.this.getAlbumObject().getProperties();
                props.put("title", JGeneralSettingsPanel.this.albumTitle.getText());
                props.save();
            }
        });
        this.albumDescription.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    JGeneralSettingsPanel.this.getAlbumObject().setComment(JGeneralSettingsPanel.this.albumDescription.getText());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.setTexts();
        ControlPanel leftPanel = new ControlPanel();
        leftPanel.add(this.albumThumbnailLabel);
        leftPanel.add("br", this.albumThumbnail);
        this.add("vtop", leftPanel);
        ControlPanel rightPanel = new ControlPanel();
        rightPanel.add(this.albumTitleLabel);
        rightPanel.add("br hfill", this.albumTitle);
        rightPanel.add("p", this.albumDescriptionLabel);
        JScrollPane scrollPane = new JScrollPane(this.albumDescription);
        rightPanel.add("br hfill", scrollPane);
        this.add("hfill", rightPanel);
    }

    void setTexts() {
        this.albumThumbnailLabel.setText(Msg.get("edit.albumThumbnail"));
        this.albumTitleLabel.setText(Msg.get("edit.albumTitle"));
        this.albumTitleLabel.setToolTipText(Msg.get("edit.titleToolTip"));
        this.albumTitle.setToolTipText(Msg.get("edit.titleToolTip"));
        this.albumDescriptionLabel.setText(Msg.get("edit.albumDescription"));
    }

    class JBackgroundTextField
    extends JSmartTextField {
        private String backgroundText;

        public String getBackgroundText() {
            return this.backgroundText;
        }

        public void setBackgroundText(String backgroundText) {
            this.backgroundText = backgroundText;
            this.repaint();
        }

        public JBackgroundTextField(int chars) {
            super(chars);
            this.init();
        }

        private void init() {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    JBackgroundTextField.this.repaint();
                }

                public void focusLost(FocusEvent e) {
                    JBackgroundTextField.this.repaint();
                }
            });
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.getText().equals("") && !this.hasFocus() && this.backgroundText != null) {
                g.setColor(Color.gray);
                FontMetrics fm = g.getFontMetrics();
                String s = this.backgroundText;
                Rectangle2D rect = fm.getStringBounds(s, g);
                LineMetrics lm = fm.getLineMetrics(s, g);
                g.drawString(s, 6, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            }
        }
    }
}

