/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartToggleButton;
import se.datadosen.component.JStackLabel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.io.DualPrintStream;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumUtils;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.EasyJFrame;
import se.datadosen.jalbum.FileListMenuListener;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAboutWindow;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JConsoleFrame;
import se.datadosen.jalbum.JExternalToolsMenu;
import se.datadosen.jalbum.JFileListMenu;
import se.datadosen.jalbum.JFileMenuItem;
import se.datadosen.jalbum.JMainSettingsPanel;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.JPreferencesWindow;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.JSettingsWindow;
import se.datadosen.jalbum.JShareWindow;
import se.datadosen.jalbum.JSkinPreview;
import se.datadosen.jalbum.JToolBarButton;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.ThumbnailFileView;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.jalbum.event.JAlbumListener;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.Stopwatch;

public class JAlbumFrame
extends EasyJFrame {
    public static final String PROJECT_EXTENSION = ".jap";
    public static final String PROJECT_FILE_NAME = "jalbum-settings.jap";
    static final File defaultProjectFile = new File(System.getProperty("user.home"), ".jalbum-defaults.jap");
    public JPreferencesWindow preferencesWindow = new JPreferencesWindow(this);
    JConsoleFrame console = new JConsoleFrame(this);
    private Thread processThread = null;
    private Thread updateCheckerThread = null;
    Config cfg = Config.getConfig();
    private Properties cleanProjectSettings = null;
    JAlbumFrameIcons icons = JAlbumFrameIcons.getInstance();
    public JAlbumFrameActions actions = new JAlbumFrameActions();
    public JMainSettingsPanel mainSettingsPanel = new JMainSettingsPanel(this);
    public JAlbumExplorer albumExplorer = new JAlbumExplorer(this);
    public JAlbumFrameButtons toolBars = new JAlbumFrameButtons();
    JAlbumFrameMenus frameMenus = new JAlbumFrameMenus();
    JShareWindow shareWindow = new JShareWindow(this);
    public JSettingsWindow settingsWindow = new JSettingsWindow(this);
    JPublishWizard publishWizard;
    JSkinPreview skinPreview = new JSkinPreview();
    public JProgressDialog progressDialog;
    public JStackLabel statusBar = new JStackLabel();
    public AlbumBean engine;
    private File editDirectory;
    StringBuffer errorBuffer = new StringBuffer();
    public DeferredChooser projectChooser = new DeferredChooser(JFileChooser.class);
    private JFileChooser addFileChooser;
    private JAlbumAdapter _adapter;
    boolean exitOnClose = true;
    boolean loadHints = true;
    private ArrayList jalbumListeners = new ArrayList();
    public DummyCheckBox useLayoutHints;
    private Properties previousSettings;
    private Properties appliedHints;
    private javax.swing.filechooser.FileFilter albumProjectFileFilter;

    public JAlbumFrame(File projectFile) {
        this.useLayoutHints = new DummyCheckBox(this.preferencesWindow.useLayoutHints);
        this.previousSettings = null;
        this.appliedHints = null;
        this.albumProjectFileFilter = new javax.swing.filechooser.FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(JAlbumFrame.PROJECT_EXTENSION);
            }

            public String getDescription() {
                return "Jalbum Project files (*.jap)";
            }
        };
        JAlbumContext.getInstance().setFrame(this);
        this.enableEvents(64L);
        try {
            File myAlbums;
            this.engine = new AlbumBean();
            JAlbumContext.getInstance().setEngine(this.engine);
            this.init();
            if (projectFile == null && defaultProjectFile.exists()) {
                projectFile = defaultProjectFile;
            }
            if ((myAlbums = new File(this.preferencesWindow.myAlbumsLocation.getText())).exists()) {
                this.projectChooser.setCurrentDirectory(myAlbums);
            }
            this.newProject(projectFile);
            if (this.preferencesWindow.checkForUpdates.isSelected()) {
                this.checkForUpdates(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pack() {
        this.settingsWindow.pack();
    }

    public void packThis() {
        super.pack();
        JAlbumFrame.optimizeFrameSize(this);
    }

    private static void optimizeFrameSize(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)frameSize.height < (double)screenSize.height / 1.6) {
            frameSize.height = (int)((double)screenSize.height / 1.6);
        }
        if (frameSize.height < 540) {
            frameSize.height = 540;
        }
        if ((double)frameSize.height > (double)screenSize.height / 1.15) {
            frameSize.height = (int)((double)screenSize.height / 1.15);
        }
        float aspect = 1.25f;
        if (screenSize.width < screenSize.height) {
            aspect = 1.0f / aspect;
        }
        frameSize.width = (int)(30.0f + (float)frameSize.height * aspect);
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        frame.setSize(frameSize);
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    void setTitle() {
        String title = Msg.get("ui.windowTitle");
        File f = this.projectChooser.getSelectedFile();
        if (f != null) {
            f = new File(f.getAbsolutePath());
            title = title + " [";
            File parent = f.getParentFile();
            String projectFileName = "";
            if (!f.getName().equals(PROJECT_FILE_NAME)) {
                projectFileName = File.separatorChar + f.getName();
            }
            title = parent.getParentFile() == null ? title + parent.getName() + projectFileName + "]" : title + parent.getParentFile().getName() + File.separatorChar + parent.getName() + projectFileName + "]";
        }
        this.setTitle(title);
    }

    boolean askProjectSave(String title) {
        try {
            if (!this.preferencesWindow.showWarnings.isSelected()) {
                return true;
            }
            this.ui2Engine();
            Properties currentProjectSettings = this.getProjectSettings();
            if (this.cleanProjectSettings != null && this.projectChooser.getSelectedFile() != null && !this.arePropertiesEqual(currentProjectSettings, this.cleanProjectSettings)) {
                int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.saveChangesToProjectQuestion"), title, 1);
                switch (answer) {
                    case 0: {
                        return this.saveProject(false);
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return true;
    }

    private boolean arePropertiesEqual(Properties a, Properties b) {
        if (!a.equals(b) && this.cfg.isDebugMode()) {
            System.out.println("Project differences:");
            for (Object key : a.keySet()) {
                if (!b.containsKey(key)) {
                    System.out.println("Missing " + key + " in second property set");
                    continue;
                }
                if (a.get(key).equals(b.get(key))) continue;
                System.out.println("Key " + key + ": " + a.get(key) + " != " + b.get(key));
            }
            for (Object key : b.keySet()) {
                if (a.containsKey(key)) continue;
                System.out.println("Missing " + key + " in first property set");
            }
        }
        return a.equals(b);
    }

    boolean askStopSharing() {
        if (!this.shareWindow.shareBean.isRunning() || this.shareWindow.shareBean.getShares().size() == 0) {
            return true;
        }
        int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.activeSharesWarning"), Msg.get("ui.exitMenu"), 2, 2);
        return answer == 0;
    }

    void setTexts() {
        this.setTitle(Msg.get("ui.windowTitle"));
        this.actions.setTexts();
        this.frameMenus.setTexts();
        this.toolBars.setTexts();
        this.albumExplorer.setTexts();
        this.shareWindow.setTexts();
        this.preferencesWindow.setTexts();
        this.mainSettingsPanel.setTexts();
        this.settingsWindow.setTexts();
        this.preferencesWindow.setTitle(Msg.get("ui.prefsPanel"));
        this.settingsWindow.setTitle(Msg.get("ui.albumSettingsTitle"));
        this.console.setTitle(Msg.get("ui.consoleMenu"));
        this.progressDialog.setTitle(Msg.get("ui.generatingAlbumInfo"));
        this.statusBar.setText("");
    }

    private void renameTab(JTabbedPane tabs, JComponent comp, String newName) {
        int index = tabs.indexOfTab(comp.getName());
        if (index != -1) {
            tabs.setTitleAt(index, newName);
            comp.setName(newName);
        }
    }

    public synchronized void removeJAlbumListener(JAlbumListener listener) {
        if (this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.remove(listener);
            this.jalbumListeners = list;
        }
    }

    public synchronized void addJAlbumListener(JAlbumListener listener) {
        if (!this.jalbumListeners.contains(listener)) {
            ArrayList list = this.jalbumListeners == null ? new ArrayList(2) : (ArrayList)this.jalbumListeners.clone();
            list.add(listener);
            this.jalbumListeners = list;
        }
    }

    protected void fireSkinUIDisplayed(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIDisplayed(e);
        }
    }

    protected void fireSkinUIHidden(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinUIHidden(e);
        }
    }

    protected void fireStyleChanged(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).styleChanged(e);
        }
    }

    protected void fireSkinChanged(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).skinChanged(e);
            it.remove();
        }
    }

    protected void fireAlbumCreationStarted(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationStarted(e);
        }
    }

    protected void fireAlbumCreationFinished(JAlbumEvent e) {
        Iterator it = this.jalbumListeners.iterator();
        while (it.hasNext()) {
            ((JAlbumListener)it.next()).albumCreationFinished(e);
        }
    }

    private void init() throws Exception {
        this.initConsole();
        this.setGlassPane(this.skinPreview);
        if (!JAlbum.isMac()) {
            this.setIconImage(this.icons.windowIcon.getImage());
        }
        if (System.getProperty("java.version").compareTo("1.5") < 0) {
            JOptionPane.showMessageDialog(this, Msg.get("ui.javaVersionError", "1.5"), "Jalbum", 0);
            System.exit(20);
        }
        this.progressDialog = new JProgressDialog(this, "", true);
        this.setTexts();
        this.setJMenuBar(this.frameMenus.mainMenuBar);
        this.projectChooser.setFileFilter(this.albumProjectFileFilter);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.albumExplorer.leftPanel.add((Component)this.toolBars.getLeftToolBar(), "North");
        this.albumExplorer.rightPanel.add((Component)this.toolBars.getMainToolBar(), "North");
        contentPane.add((Component)this.albumExplorer, "Center");
        this.settingsWindow.populateWithDefaultTabs();
        contentPane.add((Component)this.createStatusPanel(), "South");
        if (this.shareWindow.shareBean.isAutoStart()) {
            Thread t = new Thread("Web server launcher thread"){

                public void run() {
                    JAlbumFrame.this.shareWindow.startAction.actionPerformed(null);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 18));
        this.statusBar.setFont(new Font("SansSerif", 0, 11));
        panel.add((Component)this.statusBar, "West");
        panel.add((Component)new JLabel(" "), "Center");
        JButton helpButton = new JButton(this.actions.helpAction){

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = 20;
                return dim;
            }
        };
        helpButton.setBorderPainted(false);
        helpButton.setContentAreaFilled(false);
        helpButton.setFocusable(false);
        helpButton.setRolloverEnabled(true);
        helpButton.setRolloverIcon(Icons.getIcon("big.help"));
        panel.add((Component)helpButton, "East");
        JPanel containingPanel = new JPanel(new BorderLayout());
        containingPanel.setBorder(JAlbumBorders.createStatusbarBorder());
        containingPanel.add((Component)panel, "Center");
        return containingPanel;
    }

    private void initConsole() {
        if (this.cfg.isDebugMode()) {
            System.setOut(new DualPrintStream(System.out, this.console.getPrintStream()));
            System.setErr(new DualPrintStream(System.err, this.console.getPrintStream()));
        } else {
            System.setOut(this.console.getPrintStream());
            System.setErr(this.console.getPrintStream());
        }
        JAlbumFrame.log("Jalbum 8.3.5 system console.");
        JAlbumFrame.log("This section captures debug prints sent to System.out and System.err");
        JAlbumFrame.log("The top section evaluates BeanShell expressions (interpreted Java)");
        JAlbumFrame.log("Press " + KeyEvent.getKeyModifiersText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) + "+E to evaluate an expression. (Evaluates selected text if selection is active)");
        JAlbumFrame.log("You have access to the basic Jalbum implicit objects such as engine and window");
        JAlbumFrame.log("\nSample expressions:");
        JAlbumFrame.log("4*(3+2); // Basic calculations");
        JAlbumFrame.log("engine.getSkin(); // Use of implicit object");
        JAlbumFrame.log("for (int i=1; i<10; i++) System.out.println(i); // Iterations");
        JAlbumFrame.log("window.messageBox(\"You can interact with any Java object\");\n");
    }

    public void initProject(File inputDirectory) {
        this.settingsWindow.directory.setText(inputDirectory.getAbsolutePath());
        File projectFile = new File(inputDirectory, PROJECT_FILE_NAME);
        this.projectChooser.setSelectedFile(projectFile);
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        } else {
            this.ui2Engine();
        }
        this.setTitle();
        this.initView();
        this.fixUIdisabling();
    }

    private static void log(String s) {
        System.out.println(s);
    }

    void showAboutBox() {
        JAboutWindow dlg = new JAboutWindow(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public void doExit(ActionEvent e) {
        if (this.exitOnClose) {
            if (this.shareWindow.trayIcon != null) {
                this.setVisible(false);
                return;
            }
            if (!this.askProjectSave(Msg.get("ui.exitMenu"))) {
                return;
            }
            if (!this.askStopSharing()) {
                return;
            }
            if (PluginManager.onExit()) {
                System.exit(0);
            }
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.shareWindow.trayIcon != null) {
                this.setVisible(false);
                return;
            }
            if (!this.askProjectSave(Msg.get("ui.exitMenu")) || !this.askStopSharing()) {
                return;
            }
            if (PluginManager.onExit()) {
                System.exit(0);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    void doMakeAlbum() {
        this.doMakeAlbum(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMakeAlbum(final Boolean appendImages) {
        int res;
        boolean warn = false;
        String imageDir = this.settingsWindow.getDirectory();
        String outputDir = this.settingsWindow.getOutputDirectory();
        if (this.settingsWindow.getSameDirectory()) {
            if (!imageDir.equals(this.engine.getDirectory())) {
                warn = true;
            }
        } else if (!outputDir.equals(this.engine.getOutputDirectory())) {
            warn = true;
        }
        if (!(imageDir.equals(outputDir) || this.settingsWindow.getLinkScaled() || this.settingsWindow.getCopyOriginals())) {
            res = 1;
            if (this.preferencesWindow.showWarnings.isSelected()) {
                res = this.messageBox(Msg.get("ui.externalLinksWarning"), 19, Msg.get("ui.makeAlbum"));
            }
            if (res != 1) {
                return;
            }
        }
        if (warn && (res = this.messageBox(Msg.get("ui.makeAlbumInfo", outputDir), 3, Msg.get("ui.makeAlbum"))) != 1) {
            return;
        }
        Object object = JAlbum.initializedOkMonitor;
        synchronized (object) {
            try {
                this.ui2Engine();
                SignInManager manager = SignInManager.getInstance(this);
                if (manager.isSignedIn()) {
                    this.engine.setUserName(manager.getUserName());
                } else {
                    this.engine.setUserName(null);
                }
                if (appendImages != null) {
                    this.engine.setAppendImages(appendImages);
                }
                if (Runtime.getRuntime().availableProcessors() > 1) {
                    this.engine.setCpuCores((Integer)this.preferencesWindow.cpuCores.getSelectedItem());
                }
                this.fireAlbumCreationStarted(new JAlbumEvent(this));
                if (this.processThread == null) {
                    this.processThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                JAlbumFrame.this.errorBuffer = new StringBuffer();
                                Stopwatch timer = new Stopwatch("Make Jalbum");
                                timer.start();
                                if (appendImages != null) {
                                    JAlbumFrame.this.engine.makeAlbum();
                                } else {
                                    JAlbumFrame.this.engine.smartMakeAlbum();
                                }
                                System.out.println(timer);
                                if (JAlbumFrame.this.preferencesWindow.closeProgressDialog.isSelected()) {
                                    JAlbumFrame.this.progressDialog.setVisible(false);
                                } else {
                                    JAlbumFrame.this.progressDialog.setDialogToFinishedState();
                                }
                                JAlbumFrame.this.processThread = null;
                            }
                            catch (Throwable t) {
                                JAlbumFrame.this.processThread = null;
                                try {
                                    throw t;
                                }
                                catch (ParameterException ex) {
                                    JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                }
                                catch (UnsupportedEncodingException ex) {
                                    JAlbumFrame.this.messageBox(Msg.get("ui.unsupportedEncodingError", JAlbumFrame.this.engine.getTextEncoding()), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.toString());
                                }
                                catch (IOException ex) {
                                    JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                                    JAlbumFrame.this.statusBar.setText(ex.getMessage());
                                }
                                catch (OperationAbortedException ex) {
                                    JAlbumFrame.this.progressDialog.updateStateAndSetVisible(false);
                                    JAlbumFrame.this.statusBar.setText(Msg.get("ui.operationAborted"));
                                    if (ex.getMessage() != null) {
                                        JOptionPane.showMessageDialog(JAlbumFrame.this, ex.getMessage(), Msg.get("ui.operationAborted"), 0);
                                    }
                                }
                                catch (ElementException ex) {
                                    Debug.showCopyableError(JAlbumFrame.this, ex, Msg.get("ui.scriptingError"));
                                }
                                catch (Throwable t2) {
                                    Debug.showStackTraceDialog(JAlbumFrame.this, t2);
                                }
                            }
                            finally {
                                JAlbumFrame.this.fireAlbumCreationFinished(new JAlbumEvent(this));
                                JAlbumFrame.this.engine2UI(true);
                                JAlbumFrame.this.directorySelected();
                            }
                            if (JAlbumFrame.this.errorBuffer.length() > 0) {
                                JScrollPane sp = new JScrollPane();
                                JSmartTextArea ta = new JSmartTextArea(JAlbumFrame.this.errorBuffer.toString());
                                ta.setEditable(false);
                                sp.getViewport().add((Component)ta, null);
                                JOptionPane.showMessageDialog(JAlbumFrame.this, sp, Msg.get("ui.errorsDuringAlbumGeneration"), 2);
                            }
                        }
                    };
                    this.processThread.setPriority(1);
                    this.processThread.setDaemon(true);
                    this.progressDialog.abort = false;
                    this.processThread.start();
                    this.progressDialog.updateStateAndSetVisible(true);
                } else {
                    this.processThread = null;
                }
            }
            catch (BeanBinderException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    private static void enableComponents(JComponent comp, boolean enable) {
        comp.setEnabled(enable);
        Component[] components = comp.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            JAlbumFrame.enableComponents((JComponent)components[i], enable);
        }
    }

    void setPreviewImage() {
        String skin = this.mainSettingsPanel.getSelectedSkin();
        String style = this.mainSettingsPanel.getSelectedStyle();
        if (skin == null || style == null) {
            return;
        }
        this.setPreviewImage(skin, style);
    }

    void setPreviewImage(String skin, String style) {
        File skinDir = this.cfg.chainedSkinsDir.getFile(skin);
        File f = new File(skinDir, "styles/" + IO.baseName(style) + ".jpg");
        if (!f.exists()) {
            f = new File(skinDir, "preview.jpg");
        }
        if (f.exists()) {
            this.skinPreview.setImage(f);
        } else {
            this.skinPreview.setText(Msg.get("ui.noPreviewAvailable"));
        }
    }

    void executeScript(File f) {
        if (f.exists()) {
            try {
                this.engine.processBeanShellFile(f);
            }
            catch (ElementException ex) {
                Debug.showCopyableError(this, ex, Msg.get("ui.scriptingError"));
                ex.printStackTrace(System.out);
            }
            catch (OperationAbortedException ex) {
                this.statusBar.setText(Msg.get("ui.operationAborted"));
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
    }

    public boolean isSkinUISelected() {
        return this.settingsWindow.isSkinUISelected();
    }

    public void setSkinUI(ControlPanel ui) {
        this.settingsWindow.setSkinUI(ui);
    }

    void markAsClean() {
        try {
            this.cleanProjectSettings = this.getProjectSettings();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void markSkinAsClean() {
        Iterator<Map.Entry<Object, Object>> it = this.cleanProjectSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> e = it.next();
            if (!((String)e.getKey()).startsWith("skin.")) continue;
            it.remove();
        }
        this.addSkinVariables(this.cleanProjectSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newProject(File projectFile) {
        if (!this.askProjectSave(defaultProjectFile.equals(projectFile) ? Msg.get("ui.newProjectMenu") : Msg.get("ui.openProjectMenu"))) {
            return;
        }
        this.engine = new AlbumBean();
        JAlbumContext.getInstance().setEngine(this.engine);
        this.engine.addAlbumBeanListener(this.progressDialog);
        this.engine.addAlbumBeanListener(new AlbumBeanListener(){

            public void imageProcessingStarted(AlbumBeanEvent e) {
                JAlbumFrame.this.statusBar.setText(Msg.get("ui.albumGenerationProgress", new Integer(e.imageNum), new Integer(e.imageSum), e.directory));
                if (JAlbumFrame.this.processThread == null) {
                    e.abortProcessing();
                    JAlbumFrame.this.statusBar.setText(Msg.get("ui.processingAborted"));
                }
            }

            public void imageProcessingFinished(AlbumBeanEvent e) {
                JAlbumFrame.this.statusBar.setText(Msg.get("ui.albumGenerationProgress", new Integer(e.imageNum), new Integer(e.imageSum), e.directory) + Msg.get("ui.albumGenerationDone"));
                if (JAlbumFrame.this.processThread == null) {
                    e.abortProcessing();
                    JAlbumFrame.this.statusBar.setText(Msg.get("ui.processingAborted"));
                }
            }

            public void errorOccured(Throwable t, File f) {
                String msg;
                if (t instanceof RuntimeException && JAlbumFrame.this.cfg.isDebugMode()) {
                    throw (RuntimeException)t;
                }
                if (JAlbumFrame.this.errorBuffer.length() == 0) {
                    JAlbumFrame.this.errorBuffer.append(Msg.get("ui.fileProcessingError") + "\n");
                }
                if ((msg = t.getMessage()) == null || t instanceof RuntimeException) {
                    msg = t.toString();
                }
                JAlbumFrame.this.errorBuffer.append(f.getName() + ": " + msg + "\n");
            }
        });
        File skinDir = this.cfg.chainedSkinsDir.getFile(this.engine.getSkin());
        JAlbumFrame.fillCombo(this.mainSettingsPanel.style, new File(skinDir, "styles"), (FileFilter)new StyleFileFilter());
        this.projectChooser.setSelectedFile(null);
        this.setTitle();
        if (projectFile != null) {
            this.doLoadProject(projectFile);
        } else {
            try {
                this.loadHints = false;
                try {
                    this.mainSettingsPanel.skin.setSelectedItem(this.engine.getSkin());
                    this.engine2UI();
                }
                finally {
                    this.loadHints = true;
                }
                this.loadHints();
                this.ui2Engine();
                this.cleanProjectSettings = this.getProjectSettings();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.updateCheckerThread == null || !this.updateCheckerThread.isAlive()) {
            this.statusBar.setText(Msg.get("ui.introInfo"));
        }
    }

    static void fillCombo(JComboBox combo, File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            return;
        }
        JAlbumFrame.fillCombo(combo, new ChainedDirectory(dir), filter);
    }

    static void fillCombo(JComboBox combo, ChainedDirectory dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(((File)o1).getName(), ((File)o2).getName());
            }
        });
        for (File f : files) {
            if (f.getName().toLowerCase().endsWith(".css")) {
                combo.addItem(new Item(f.getName(), IO.baseName(f)));
                continue;
            }
            combo.addItem(f.getName());
        }
    }

    boolean saveProject(boolean alwaysSaveAs) {
        if (alwaysSaveAs || this.projectChooser.getSelectedFile() == null) {
            int returnVal = this.projectChooser.showSaveDialog(this);
            if (returnVal == 0) {
                this.saveProject(this.projectChooser.getSelectedFile());
                return true;
            }
            return false;
        }
        this.saveProject(this.projectChooser.getSelectedFile());
        return true;
    }

    public void scanImageDirectory() {
        File dir = new File(this.settingsWindow.getDirectory());
        if (!dir.isDirectory()) {
            return;
        }
        File projectFile = new File(dir, PROJECT_FILE_NAME);
        if (projectFile.exists()) {
            this.loadProject(projectFile);
        }
    }

    private Set getChangedKeys(Properties before, Properties after) {
        HashSet<String> changedKeys = new HashSet<String>();
        if (before == null) {
            return changedKeys;
        }
        for (String string : before.keySet()) {
            if (before.getProperty(string).equals(after.getProperty(string))) continue;
            changedKeys.add(string);
        }
        return changedKeys;
    }

    private Properties filterProperties(Properties allSettings, Set keysToKeep) {
        Properties filtered = new Properties();
        for (String key : keysToKeep) {
            if (!allSettings.containsKey(key)) continue;
            filtered.put(key, allSettings.get(key));
        }
        return filtered;
    }

    void loadHints() {
        if (!this.preferencesWindow.useLayoutHints.isSelected()) {
            return;
        }
        try {
            File skinDir;
            File hintsFile;
            this.ui2Engine();
            if (this.preferencesWindow.restorePreviousSettings.isSelected() && this.previousSettings != null) {
                Set changedKeys = this.getChangedKeys(this.appliedHints, BeanBinder.getProperties(this.engine));
                for (String key : changedKeys) {
                    this.previousSettings.remove(key);
                }
                BeanBinder.setProperties((Object)this.engine, this.previousSettings);
            }
            if (!(hintsFile = new File(skinDir = this.cfg.chainedSkinsDir.getFile(this.mainSettingsPanel.getSelectedSkin()), "hints.jap")).exists()) {
                this.appliedHints = null;
                this.previousSettings = null;
                this.engine.setSkinVariables(new PrintSafeHashMap());
                this.engine2UI(true);
                return;
            }
            Properties hints = IO.readPropertyFile(hintsFile);
            Iterator it = this.engine.getUserVariables().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!((String)e.getKey()).startsWith("filter")) continue;
                it.remove();
            }
            if (this.preferencesWindow.restorePreviousSettings.isSelected()) {
                Properties allSettings = BeanBinder.getProperties((Object)this.engine, false);
                this.previousSettings = this.filterProperties(allSettings, hints.keySet());
            }
            BeanBinder.setProperties((Object)this.engine, hints);
            this.appliedHints = hints;
            Map userVariables = this.engine.getUserVariables();
            userVariables.putAll(AlbumUtils.getUserVariables(hints));
            this.engine.setUserVariables(userVariables);
            this.engine.setSkinVariables(AlbumUtils.getSkinVariables(hints));
            this.engine2UI(true);
        }
        catch (IOException ex) {
            this.engine2UI();
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
    }

    public boolean renameImageDirectory(String newImageDirectoryName) throws IOException {
        File currentProjectFile;
        File currentImageDirectory = new File(this.settingsWindow.directory.getText());
        File newImageDirectory = new File(currentImageDirectory.getParent(), newImageDirectoryName);
        File projectFile = currentProjectFile = this.projectChooser.getSelectedFile();
        if (!currentImageDirectory.renameTo(newImageDirectory)) {
            return false;
        }
        this.settingsWindow.directory.setText(newImageDirectory.getAbsolutePath());
        if (currentProjectFile.getParentFile().equals(currentImageDirectory)) {
            projectFile = new File(newImageDirectory, currentProjectFile.getName());
            this.projectChooser.setSelectedFile(projectFile);
            this.frameMenus.fileMenuRecentFilesMenu.replaceFile(currentProjectFile, projectFile);
            this.setTitle();
        }
        if (projectFile.exists()) {
            Properties props = IO.readPropertyFile(projectFile);
            props.setProperty("directory", newImageDirectory.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(projectFile);
            props.store(fos, "Jalbum Project");
        }
        this.ui2Engine();
        this.initView();
        return true;
    }

    public void loadProject(File projectFile) {
        if (!projectFile.equals(defaultProjectFile) && !this.askProjectSave(Msg.get("ui.openProjectMenu"))) {
            return;
        }
        this.doLoadProject(projectFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadProject(File projectFile) {
        try {
            Properties props = IO.readPropertyFile(projectFile);
            BeanBinder.setProperties((Object)this.engine, props);
            this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
            this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
            File imageDirectory = new File(this.engine.getDirectory());
            if (this.engine.getDirectory().length() > 0 && !projectFile.equals(defaultProjectFile) && !imageDirectory.exists()) {
                this.engine.setDirectory(projectFile.getParentFile().getAbsolutePath());
            }
            if (projectFile.equals(defaultProjectFile)) {
                BeanBinder.setProperties((Object)Config.getConfig(), props);
                PropertyBinder.syncUI(props, this.preferencesWindow);
            } else {
                this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
                this.statusBar.setText(Msg.get("ui.projectLoaded") + " " + projectFile.getAbsolutePath());
            }
            this.loadHints = false;
            this.mainSettingsPanel.skin.setSelectedItem(this.engine.getSkin());
            this.engine2UI();
            this.initView();
            this.albumExplorer.selectRootFolderInTreeView();
            try {
                this.markAsClean();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        catch (IOException ex) {
            this.engine2UI();
            Debug.showErrorDialog(this, ex);
        }
        catch (Exception ex) {
            this.statusBar.setText(ex.getMessage());
            Debug.showErrorDialog(this, ex);
        }
        finally {
            this.loadHints = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProject(File projectFile) {
        String fileName = projectFile.getName();
        if (!fileName.endsWith(PROJECT_EXTENSION)) {
            fileName = fileName + PROJECT_EXTENSION;
        }
        projectFile = new File(projectFile.getParentFile(), fileName);
        FileOutputStream fos = null;
        try {
            this.ui2Engine();
            this.markAsClean();
            Properties props = this.getProjectSettings();
            if (projectFile.equals(defaultProjectFile)) {
                BeanBinder.getProperties((Object)Config.getConfig(), props);
                PropertyBinder.getProperties(this.preferencesWindow, props);
                props.remove("directory");
            } else {
                this.frameMenus.fileMenuRecentFilesMenu.addFile(projectFile);
                this.frameMenus.fileMenuSaveItem.setEnabled(true);
                this.projectChooser.setSelectedFile(projectFile);
                this.setTitle();
            }
            fos = new FileOutputStream(projectFile);
            props.store(fos, "Jalbum Project");
            this.statusBar.setText(Msg.get("ui.projectSaved") + " " + projectFile.getAbsolutePath());
            boolean bl = true;
            IO.close(fos);
            return bl;
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            IO.close(fos);
        }
    }

    private Properties getProjectSettings() throws Exception {
        Properties props = BeanBinder.getProperties(this.engine);
        props.remove("userVariables");
        props.remove("skinVariables");
        this.addUserVariables(props);
        this.addSkinVariables(props);
        return props;
    }

    private void addUserVariables(Properties props) {
        for (Map.Entry item : this.settingsWindow.userVariablesTable.getMap().entrySet()) {
            props.setProperty("user." + item.getKey(), item.getValue().toString());
        }
    }

    private void addSkinVariables(Properties props) {
        if (this.settingsWindow.skinUI != null) {
            for (Map.Entry<Object, Object> item : PropertyBinder.getProperties(this.settingsWindow.skinUI).entrySet()) {
                props.setProperty("skin." + item.getKey(), item.getValue().toString());
            }
        }
    }

    public void engine2UI() {
        this.engine2UI(false);
    }

    void engine2UI(boolean quick) {
        try {
            if (quick) {
                this.mainSettingsPanel.skin.removeActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            Object[] uis = new Object[]{this, this.settingsWindow, this.mainSettingsPanel};
            BeanBinder.getProperties((Object)this.engine, uis);
            if (quick) {
                this.mainSettingsPanel.skin.addActionListener(this.mainSettingsPanel.skinSelectedActionListener);
            }
            this.settingsWindow.userVariablesTable.clear();
            TreeMap vars = new TreeMap(this.engine.getUserVariables());
            this.settingsWindow.userVariablesTable.putAll(vars);
            this.settingsWindow.userVariablesTable.updateUI();
            if (this.settingsWindow.skinUI != null) {
                PropertyBinder.syncUI(vars, this.settingsWindow.skinUI);
                PropertyBinder.syncUI(this.engine.getSkinVariables(), this.settingsWindow.skinUI);
            }
            this.initView();
            this.fixUIdisabling();
            this.repaint();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.statusBar.setText(ex.getMessage());
        }
    }

    public void ui2Engine() throws BeanBinderException {
        this.ui2Engine(this.engine);
    }

    public void ui2Engine(AlbumBean engine) throws BeanBinderException {
        Object[] uis = new Object[]{this, this.settingsWindow, this.mainSettingsPanel};
        BeanBinder.setProperties((Object)engine, uis);
        if (this.settingsWindow.skinUI != null) {
            engine.setSkinVariables(PropertyBinder.getProperties(this.settingsWindow.skinUI));
        }
        engine.setUserVariables(this.settingsWindow.userVariablesTable.getMap());
        BeanBinder.setProperties((Object)engine, this.preferencesWindow);
    }

    void fixUIdisabling() {
        this.frameMenus.fileMenuSaveItem.setEnabled(this.projectChooser.getSelectedFile() != null);
        this.directorySelected();
    }

    void directorySelected() {
        boolean selected = this.settingsWindow.getDirectory().length() > 0 && (this.settingsWindow.getSameDirectory() || this.settingsWindow.getOutputDirectory().length() > 0);
        this.shareWindow.setShareCurrentEnabled(selected);
        this.actions.makeAction.setEnabled(selected);
        this.actions.makeAllAction.setEnabled(selected);
        this.actions.makeChangesAction.setEnabled(selected);
        this.actions.slideShowAction.setEnabled(selected);
        boolean hasFiles = this.albumDirHasFiles();
        this.actions.viewAlbumAction.setEnabled(selected && hasFiles);
        this.actions.publishAction.setEnabled(selected && hasFiles);
    }

    private boolean albumDirHasFiles() {
        File dir = new File(this.settingsWindow.getSameDirectory() ? this.settingsWindow.getDirectory() : this.settingsWindow.getOutputDirectory());
        if (!dir.isAbsolute()) {
            dir = new File(this.settingsWindow.getDirectory(), this.settingsWindow.getOutputDirectory());
        }
        if (dir.exists()) {
            File[] files = dir.listFiles(new UploadBean.UploadFileFilter());
            return files.length > 0;
        }
        return false;
    }

    public void initView() {
        File f = new File(this.settingsWindow.directory.getText());
        if (this.editDirectory == null || !this.editDirectory.equals(f)) {
            this.editDirectory = f;
            AlbumObjectFactory factory = new AlbumObjectFactory(this.engine){

                public boolean isCacheThumbnails() {
                    return Config.getConfig().isCacheThumbnails();
                }
            };
            JAlbumContext.getInstance().setAlbumObjectfactory(factory);
            AlbumObject root = factory.createInstance(f);
            this.albumExplorer.setRootFolder(root);
            this.albumExplorer.viewFolder(root);
        }
    }

    void checkForUpdates(final boolean onStartup) {
        this.updateCheckerThread = new Thread("UpdateChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JAlbumFrame.this.statusBar.pushText(Msg.get("ui.updateCheckInfo"));
                    String padVersion = JAlbumSite.getTrueInstance().getClientVersion();
                    if (padVersion.compareTo("8.3.5") <= 0) {
                        if (!onStartup) {
                            String msg = Msg.get("ui.versionIsCurrentInfo");
                            JOptionPane.showMessageDialog(JAlbumFrame.this, msg, Msg.get("ui.checkForUpdates"), 1);
                        }
                        return;
                    }
                    String msg = Msg.get("ui.newUpdateAvailable", padVersion);
                    int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, msg, Msg.get("ui.checkForUpdatesTitle"), 0, 1);
                    if (answer == 0) {
                        BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getUpgradeUrl());
                    }
                }
                catch (Exception ex) {
                    if (!onStartup) {
                        JOptionPane.showMessageDialog(JAlbumFrame.this, ex.toString(), Msg.get("ui.checkForUpdatesTitle"), 0);
                    }
                }
                finally {
                    JAlbumFrame.this.statusBar.popText(Msg.get("ui.updateCheckInfo"));
                }
            }
        };
        this.updateCheckerThread.setDaemon(true);
        this.updateCheckerThread.start();
    }

    void prepareWindow(Window win) {
        if (win.isShowing()) {
            win.toFront();
            return;
        }
        win.pack();
        Dimension windowPreferedSize = win.getPreferredSize();
        Dimension assignedSize = this.min(windowPreferedSize, Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle appBounds = this.getBounds();
        win.setSize(assignedSize);
        int xpos = (appBounds.width - assignedSize.width) / 2 + appBounds.x;
        int ypos = (appBounds.height - assignedSize.height) / 2 + appBounds.y;
        win.setLocation(xpos, ypos);
    }

    public void show(Window win) {
        this.prepareWindow(win);
        win.setVisible(true);
    }

    public static void centerRelativeTo(Component comp, Component ref) {
        Point refLoc = ref.getLocationOnScreen();
        Dimension refSize = ref.getSize();
        Dimension compSize = comp.getSize();
        int xpos = (refSize.width - compSize.width) / 2 + refLoc.x;
        int ypos = (refSize.height - compSize.height) / 2 + refLoc.y;
        comp.setLocation(xpos, ypos);
    }

    private Dimension min(Dimension d1, Dimension d2) {
        int minWidth = d1.width < d2.width ? d1.width : d2.width;
        int minHeight = d1.height < d2.height ? d1.height : d2.height;
        return new Dimension(minWidth, minHeight);
    }

    public AlbumBean getEngine() {
        return this.engine;
    }

    public ControlPanel getSkinUI() {
        return this.settingsWindow.skinUI;
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public class JAlbumFrameActions {
        Action parentFolderAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.albumExplorer.parentFolderAction.actionPerformed(e);
            }
        };
        public Action addAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (JAlbumFrame.this.addFileChooser == null) {
                    JAlbumFrame.this.addFileChooser = new JFileChooser();
                    String myPicturesPath = System.getProperty("my.pictures.path");
                    if (myPicturesPath != null) {
                        File myPicturesDir = new File(myPicturesPath);
                        JAlbumFrame.this.addFileChooser.setCurrentDirectory(myPicturesDir);
                    }
                    JAlbumFrame.this.addFileChooser.setDialogTitle(Msg.get("ui.addImagesTooltip"));
                    JAlbumFrame.this.addFileChooser.setDialogType(2);
                    JAlbumFrame.this.addFileChooser.setMultiSelectionEnabled(true);
                    JAlbumFrame.this.addFileChooser.setFileSelectionMode(2);
                    JAlbumFrame.this.addFileChooser.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            File[] selectedFiles;
                            if (e.getActionCommand().equals("ApproveSelection") && (selectedFiles = JAlbumFrame.this.addFileChooser.getSelectedFiles()) != null && selectedFiles.length > 0) {
                                List<File> files = Arrays.asList(selectedFiles);
                                JAlbumFrame.this.albumExplorer.explorer.handleFileAdd(files);
                            }
                        }
                    });
                }
                JAlbumFrame.this.addFileChooser.setFileView(JAlbumFrame.this.preferencesWindow.thumbnailsInFileChooser.isSelected() ? new ThumbnailFileView() : null);
                JAlbumFrame.this.addFileChooser.showDialog(JAlbumFrame.this, Msg.get("add"));
            }
        };
        Action refreshAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.albumExplorer.refreshAction.actionPerformed(e);
            }
        };
        Action slideShowAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(122, 0));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.albumExplorer.slideShowAction.actionPerformed(e);
            }
        };
        Action signInAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("small.signIn"));
            }

            public void actionPerformed(ActionEvent e) {
                SignInManager.getInstance(JAlbumFrame.this).showDialog();
            }
        };
        Action signOutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.toolBars.signInOutButton.setAction(JAlbumFrameActions.this.signInAction);
                SignInManager.getInstance(JAlbumFrame.this).doSignOut();
            }
        };
        Action helpAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("big.help-gray"));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    File localHelp = new File(JAlbumFrame.this.cfg.progDir, "help/index.html");
                    if (localHelp.exists()) {
                        BrowserLauncher.openLocal(localHelp);
                    } else {
                        BrowserLauncher.openURL(JAlbumSite.getInstance().getHelpUrl() + "?referrer=jalbumHelpButton");
                    }
                }
                catch (IOException ex) {
                    JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                }
            }
        };
        Action makeAction = new AbstractAction(){
            {
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 0));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.doMakeAlbum(null);
            }
        };
        Action makeChangesAction = new AbstractAction(){
            {
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 8));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.doMakeAlbum(new Boolean(true));
            }
        };
        Action makeAllAction = new AbstractAction(){
            {
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(120, 1));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.doMakeAlbum(new Boolean(false));
            }
        };
        Action sneakPeekAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("big.sneakpeek"));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrameActions.this.viewAlbumAction.actionPerformed(e);
            }
        };
        public Action viewAlbumAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("big.preview"));
                this.setEnabled(false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    File indexFile;
                    File dir = new File(JAlbumFrame.this.settingsWindow.getSameDirectory() ? JAlbumFrame.this.settingsWindow.getDirectory() : JAlbumFrame.this.settingsWindow.getOutputDirectory());
                    if (!dir.isAbsolute()) {
                        dir = new File(JAlbumFrame.this.settingsWindow.getDirectory(), JAlbumFrame.this.settingsWindow.getOutputDirectory());
                    }
                    if (!(indexFile = new File(dir, JAlbumFrame.this.settingsWindow.indexPageName.getText() + JAlbumFrame.this.settingsWindow.pageExtension.getText())).exists()) {
                        int answer = JOptionPane.showConfirmDialog(JAlbumFrame.this, Msg.get("ui.albumNotFoundInfo"), Msg.get("ui.preview"), 0, 1);
                        if (answer != 0) {
                            return;
                        }
                        JAlbumFrameActions.this.makeChangesAction.actionPerformed(e);
                    }
                    if (JAlbumFrame.this.cfg.isShowPreviewInfoBar()) {
                        try {
                            BrowserLauncher.openLocal(this.createIframeFor(indexFile));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(System.err);
                            BrowserLauncher.openLocal(indexFile);
                        }
                    } else {
                        BrowserLauncher.openLocal(indexFile);
                    }
                }
                catch (IOException ex) {
                    System.err.println(e);
                    JAlbumFrame.this.statusBar.setText(ex.getMessage());
                }
            }

            private File createIframeFor(File indexFile) throws IOException, ElementException {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                File previewDir = new File(tmpDir, Msg.get("preview.previewFolder"));
                previewDir.mkdir();
                File projectDir = new File(JAlbumFrame.this.settingsWindow.directory.getText());
                File iframeTemplate = new File(JAlbumFrame.this.cfg.progDir, "system/preview.htt");
                File iframeTopTemplate = new File(JAlbumFrame.this.cfg.progDir, "system/preview-top.htt");
                File iframeBottomTemplate = new File(JAlbumFrame.this.cfg.progDir, "system/preview-bottom.htt");
                File iframeFile = new File(previewDir, projectDir.getName() + ".html");
                File iframeTopFile = new File(previewDir, projectDir.getName() + "-top" + ".html");
                File iframeBottomFile = new File(previewDir, projectDir.getName() + "-bottom" + ".html");
                HashMap<String, String> vars = new HashMap<String, String>();
                String path = indexFile.toURL().toExternalForm();
                String content = IO.readTextFile(indexFile);
                boolean widgetsOk = content.contains("_jaUserName");
                vars.put("textEncoding", JAlbumFrame.this.engine.isWriteUTF8() ? "UTF-8" : JAlbumFrame.this.engine.getTextEncoding());
                vars.put("indexPagePath", path);
                vars.put("title", Msg.get("preview.title", projectDir.getName()));
                vars.put("projectName", projectDir.getName());
                vars.put("closeInfoBar", Msg.get("preview.closeInfoBar"));
                vars.put("topMessage", Msg.get("preview.topMessage"));
                vars.put("noIframeSupport", Msg.get("preview.noIframeSupport", path));
                String widgetsUrl = JAlbumSite.getInstance().getWidgetsUrl();
                vars.put("bottomMessage", widgetsOk ? Msg.get("preview.bottomMessage", widgetsUrl) : Msg.get("preview.bottomMessageNoWidgets", widgetsUrl));
                AlbumBean tmpEngine = new AlbumBean();
                try {
                    tmpEngine.init();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                tmpEngine.processTemplateFile(iframeTemplate, iframeFile, vars);
                tmpEngine.processTemplateFile(iframeTopTemplate, iframeTopFile, vars);
                tmpEngine.processTemplateFile(iframeBottomTemplate, iframeBottomFile, vars);
                IO.copyFile(new File(JAlbumFrame.this.cfg.progDir, "res/close.png"), previewDir);
                IO.copyFile(new File(JAlbumFrame.this.cfg.progDir, "res/information.gif"), previewDir);
                return iframeFile;
            }
        };
        public Action showAlbumSettingsWindow = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.show(JAlbumFrame.this.settingsWindow);
            }
        };
        Action showShareWindowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.show(JAlbumFrame.this.shareWindow);
            }
        };
        Action showPublishWindowAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent e) {
                if (JAlbumFrame.this.publishWizard != null && JAlbumFrame.this.publishWizard.isShowing() && (e.getModifiers() & 8) == 0) {
                    JAlbumFrame.this.publishWizard.toFront();
                    return;
                }
                JAlbumFrame.this.publishWizard = new JPublishWizard(JAlbumFrame.this, JAlbumFrame.this.engine);
                JAlbumFrame.this.show(JAlbumFrame.this.publishWizard);
            }
        };
        Action publishAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AccountManager manager = AccountManager.getInstance();
                if (!manager.hasAccounts() || (e.getModifiers() & 8) != 0) {
                    JAlbumFrameActions.this.showPublishWindowAction.actionPerformed(e);
                } else {
                    JAlbumFrame.this.ui2Engine();
                    File dir = JAlbumFrame.this.engine.getInterpretedOutputDirectory();
                    if (!dir.isDirectory()) {
                        JOptionPane.showMessageDialog(JAlbumFrame.this, Msg.get("publish.invalidOutputDirectoryError"), Msg.get("publish.publishAlbumTitle"), 1);
                        return;
                    }
                    JPublishWizard pw = new JPublishWizard(JAlbumFrame.this, JAlbumFrame.this.engine);
                    JAlbumFrame.this.prepareWindow(pw);
                    pw.accountsStep.connectAction.actionPerformed(null);
                    pw.publishStep.smartUploadAction.actionPerformed(null);
                }
            }
        };
        Action showPreferencesWindowAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.show(JAlbumFrame.this.preferencesWindow);
            }
        };
        Action showConsoleWindowAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumFrame.this.console.setVisible(true);
            }
        };

        public JAlbumFrameActions() {
            this.setTexts();
        }

        public void setTexts() {
            this.sneakPeekAction.putValue("Name", Msg.get("ui.sneakPeek"));
            this.viewAlbumAction.putValue("Name", Msg.get("ui.preview"));
            this.viewAlbumAction.putValue("ShortDescription", Msg.get("ui.viewAlbumToolTip"));
            this.showPublishWindowAction.putValue("Name", Msg.get("ui.manage") + "...");
            this.publishAction.putValue("Name", Msg.get("ui.publish"));
            this.publishAction.putValue("ShortDescription", Msg.get("ui.publishToolTip"));
        }
    }

    public class JAlbumFrameButtons {
        public final int HEIGHT = JAlbum.isMac() ? 32 : 28;
        public static final int MARGIN = 4;
        private JToolBar mainToolBar = new JToolBar();
        private JToolBar leftToolBar = new JToolBar();
        private JButton addButton;
        private JButton newFolderButton;
        private JButton rotateLeftButton;
        private JButton rotateRightButton;
        private JButton includeButton;
        public JButton excludeButton;
        private JButton editButton;
        private JToggleButton editModeButton;
        private JToggleButton explorerButton;
        private JButton slideShowButton;
        public JButton signInOutButton;

        JAlbumFrameButtons() {
            this.addButton = new JToolBarButton(JAlbumFrame.this.actions.addAction);
            this.newFolderButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.newFolderAction);
            this.rotateLeftButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.rotateLeftAction, false);
            this.rotateRightButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.rotateRightAction, false);
            this.includeButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.includeSelectedAction);
            this.excludeButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.excludeSelectedAction);
            this.editButton = new JToolBarButton(JAlbumFrame.this.albumExplorer.propertiesAction);
            this.editModeButton = new JSmartToggleButton(JAlbumFrame.this.albumExplorer.editModeAction, false);
            this.explorerButton = new JSmartToggleButton(JAlbumFrame.this.albumExplorer.explorerAction, false);
            this.slideShowButton = new JToolBarButton(JAlbumFrame.this.actions.slideShowAction, false);
            this.signInOutButton = new JToolBarButton(JAlbumFrame.this.actions.signInAction);
            this.init();
        }

        public JComponent getLeftToolBar() {
            return this.leftToolBar;
        }

        public JComponent getMainToolBar() {
            return this.mainToolBar;
        }

        private void init() {
            this.leftToolBar.setFloatable(false);
            this.mainToolBar.setFloatable(false);
            Color c = new Color(165, 165, 165);
            this.leftToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
            this.mainToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
            ButtonGroup viewModeGroup = new ButtonGroup();
            viewModeGroup.add(this.editModeButton);
            viewModeGroup.add(this.explorerButton);
            this.slideShowButton.setBorderPainted(false);
            this.explorerButton.putClientProperty("JButton.segmentPosition", "first");
            this.editModeButton.putClientProperty("JButton.segmentPosition", "middle");
            this.slideShowButton.putClientProperty("JButton.segmentPosition", "last");
            this.explorerButton.setSelected(true);
            JAlbumFrame.this.albumExplorer.explorerAction.putValue("toggleButton", this.explorerButton);
            JAlbumFrame.this.albumExplorer.editModeAction.putValue("toggleButton", this.editModeButton);
            this.addButton.setIcon(Icons.getIcon("toolbar.addImages"));
            this.newFolderButton.setIcon(Icons.getIcon("toolbar.folder-new"));
            this.rotateLeftButton.setIcon(Icons.getIcon("toolbar.rotate-left"));
            this.rotateLeftButton.putClientProperty("JButton.segmentPosition", "first");
            this.rotateRightButton.setIcon(Icons.getIcon("toolbar.rotate-right"));
            this.rotateRightButton.putClientProperty("JButton.segmentPosition", "last");
            this.includeButton.setIcon(Icons.getIcon("toolbar.include"));
            this.excludeButton.setIcon(Icons.getIcon("toolbar.exclude"));
            this.editButton.setIcon(Icons.getIcon("toolbar.edit"));
            this.explorerButton.setIcon(Icons.getIcon("toolbar.explorermode"));
            this.editModeButton.setIcon(Icons.getIcon("toolbar.editmode"));
            this.slideShowButton.setIcon(Icons.getIcon("toolbar.slideshow"));
            this.mainToolBar.add(this.addButton);
            this.mainToolBar.add(this.newFolderButton);
            this.mainToolBar.add(this.rotateLeftButton);
            this.mainToolBar.add(this.rotateRightButton);
            this.mainToolBar.add(this.excludeButton);
            this.mainToolBar.add(this.editButton);
            this.mainToolBar.add(Box.createHorizontalGlue());
            this.mainToolBar.add(Box.createVerticalStrut(this.HEIGHT));
            this.mainToolBar.add(this.explorerButton);
            this.mainToolBar.add(this.editModeButton);
            this.mainToolBar.add(this.slideShowButton);
            this.mainToolBar.add(Box.createHorizontalStrut(4));
            this.leftToolBar.add(Box.createHorizontalStrut(4));
            this.leftToolBar.add(this.signInOutButton);
            this.leftToolBar.add(Box.createVerticalStrut(this.HEIGHT));
        }

        void setTexts() {
            JAlbumFrame.this.actions.addAction.putValue("Name", Msg.get("add"));
            JAlbumFrame.this.actions.addAction.putValue("ShortDescription", Msg.get("ui.addImagesTooltip"));
            JAlbumFrame.this.actions.refreshAction.putValue("Name", Msg.get("edit.update"));
            JAlbumFrame.this.actions.slideShowAction.putValue("Name", Msg.get("edit.runSlideshow"));
            this.slideShowButton.setText("");
            this.slideShowButton.setToolTipText(Msg.get("edit.runSlideshowToolTip"));
        }
    }

    class JAlbumFrameMenus {
        final JMenuBar mainMenuBar = new JMenuBar();
        final JMenu fileMenu = new JMenu();
        final JMenuItem fileMenuNewItem = new JMenuItem();
        final JMenuItem fileMenuOpenItem = new JMenuItem();
        final JFileListMenu fileMenuRecentFilesMenu = new JFileListMenu(new File(System.getProperty("user.home"), ".jalbum-recent-projects.properties"));
        final JMenuItem fileMenuImportSettingsItem = new JMenuItem();
        final JMenuItem fileMenuCloseItem = new JMenuItem();
        final JMenuItem fileMenuSaveItem = new JMenuItem();
        final JMenuItem fileMenuSaveAsItem = new JMenuItem();
        final JMenuItem fileMenuSaveAsDefaultItem = new JMenuItem();
        final JMenuItem fileMenuExitItem = new JMenuItem();
        final JMenu editMenu = new JMenu();
        final JMenu viewMenu = new JMenu();
        final JMenuItem viewMenuLargeThumbnailsItem;
        final JMenuItem viewMenuHideExcludedItem;
        final JMenu viewMenuOrderBySubMenu;
        final JMenu viewMenuOrderFoldersBySubMenu;
        final JMenuItem viewMenuRefreshItem;
        final JMenu albumMenu;
        final JMenuItem albumMenuMakeAlbumItem;
        final JMenuItem albumMenuMakeAllItem;
        final JMenuItem albumMenuMakeChangesItem;
        final JMenuItem albumMenuViewAlbumItem;
        final JMenuItem albumMenuSettingsItem;
        final JMenu toolsMenu;
        final JMenuItem toolsMenuRunSlideshowItem;
        final JMenuItem toolsMenuShareMenuItem;
        final JMenuItem toolsMenuPublishMenuItem;
        final JMenu openDirectoriesMenu;
        final JMenuItem openSkinDirectoryMenuItem;
        final JMenuItem openProgramDirectoryMenuItem;
        final JMenuItem openImageDirectoryMenuItem;
        final JMenuItem openOutputDirectoryMenuItem;
        final JMenu toolsMenuExternalToolsSubMenu;
        final JMenuItem toolsMenuPreferencesMenuItem;
        final JMenu helpMenu;
        final JMenuItem helpMenuCheckForUpdates;
        final JMenuItem helpMenuTopicsItem;
        final JMenuItem helpMenuWebItem;
        final JMenuItem helpMenuSupportingItem;
        final JMenuItem helpMenuAboutItem;

        JAlbumFrameMenus() {
            this.viewMenuLargeThumbnailsItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.largeThumbnailsAction);
            this.viewMenuHideExcludedItem = new JCheckBoxMenuItem(JAlbumFrame.this.albumExplorer.hideExcludedAction);
            this.viewMenuOrderBySubMenu = new JMenu();
            this.viewMenuOrderFoldersBySubMenu = new JMenu();
            this.viewMenuRefreshItem = new JMenuItem(JAlbumFrame.this.actions.refreshAction);
            this.albumMenu = new JMenu();
            this.albumMenuMakeAlbumItem = new JMenuItem(JAlbumFrame.this.actions.makeAction);
            this.albumMenuMakeAllItem = new JMenuItem(JAlbumFrame.this.actions.makeAllAction);
            this.albumMenuMakeChangesItem = new JMenuItem(JAlbumFrame.this.actions.makeChangesAction);
            this.albumMenuViewAlbumItem = new JMenuItem(JAlbumFrame.this.actions.viewAlbumAction);
            this.albumMenuSettingsItem = new JMenuItem(JAlbumFrame.this.actions.showAlbumSettingsWindow);
            this.toolsMenu = new JMenu();
            this.toolsMenuRunSlideshowItem = new JMenuItem(JAlbumFrame.this.actions.slideShowAction);
            this.toolsMenuShareMenuItem = new JMenuItem(JAlbumFrame.this.actions.showShareWindowAction);
            this.toolsMenuPublishMenuItem = new JMenuItem(JAlbumFrame.this.actions.showPublishWindowAction);
            this.openDirectoriesMenu = new JMenu();
            this.openSkinDirectoryMenuItem = new JMenuItem();
            this.openProgramDirectoryMenuItem = new JMenuItem();
            this.openImageDirectoryMenuItem = new JMenuItem();
            this.openOutputDirectoryMenuItem = new JMenuItem();
            this.toolsMenuExternalToolsSubMenu = new JExternalToolsMenu(JAlbumFrame.this);
            this.toolsMenuPreferencesMenuItem = new JMenuItem(JAlbumFrame.this.actions.showPreferencesWindowAction);
            this.helpMenu = new JMenu();
            this.helpMenuCheckForUpdates = new JMenuItem();
            this.helpMenuTopicsItem = new JMenuItem();
            this.helpMenuWebItem = new JMenuItem();
            this.helpMenuSupportingItem = new JMenuItem();
            this.helpMenuAboutItem = new JMenuItem();
            this.fileMenuExitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.doExit(e);
                }
            });
            this.albumMenuViewAlbumItem.setIcon(null);
            this.helpMenuTopicsItem.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
            this.helpMenuTopicsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        File localHelp = new File(JAlbumFrame.this.cfg.progDir, "help/index.html");
                        if (localHelp.exists()) {
                            BrowserLauncher.openLocal(localHelp);
                        } else {
                            BrowserLauncher.openURL(JAlbumSite.getInstance().getHelpUrl() + "?referrer=jalbumHelpMenu");
                        }
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuWebItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BrowserLauncher.openURL("http://jalbum.net");
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuSupportingItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BrowserLauncher.openURL(JAlbumSite.getInstance().getSupportingUrl() + "?referrer=jalbumHelpMenu");
                    }
                    catch (IOException ex) {
                        JAlbumFrame.this.messageBox(ex.getMessage(), 32);
                    }
                }
            });
            this.helpMenuAboutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.showAboutBox();
                }
            });
            this.fileMenuNewItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuNewItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.newProject(defaultProjectFile.exists() ? defaultProjectFile : null);
                    JNewProjectDialog newProjectDialog = new JNewProjectDialog(JAlbumFrame.this);
                    JAlbumFrame.this.show(newProjectDialog);
                }
            });
            this.fileMenuImportSettingsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser projectChooser = new JFileChooser();
                    File myAlbums = new File(JAlbumFrame.this.preferencesWindow.myAlbumsLocation.getText());
                    if (myAlbums.exists()) {
                        projectChooser.setCurrentDirectory(myAlbums);
                    }
                    projectChooser.setDialogTitle(Msg.get("ui.importSettingsTitle"));
                    projectChooser.setFileFilter(JAlbumFrame.this.albumProjectFileFilter);
                    int returnVal = projectChooser.showOpenDialog(JAlbumFrame.this);
                    if (returnVal == 0) {
                        try {
                            File f = projectChooser.getSelectedFile();
                            Properties props = IO.readPropertyFile(f);
                            props.remove("directory");
                            props.remove("outputDirectory");
                            BeanBinder.setProperties((Object)JAlbumFrame.this.engine, props);
                            JAlbumFrame.this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
                            JAlbumFrame.this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
                            JAlbumFrame.this.mainSettingsPanel.skin.setSelectedItem(JAlbumFrame.this.engine.getSkin());
                            BeanBinder.setProperties((Object)JAlbumFrame.this.engine, props);
                            JAlbumFrame.this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
                            JAlbumFrame.this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
                            JAlbumFrame.this.engine2UI();
                            JAlbumFrame.this.statusBar.setText(Msg.get("ui.importSettingsDone", f.getAbsolutePath()));
                        }
                        catch (IOException ex) {
                            Debug.showFriendlyErrorDialog(JAlbumFrame.this, ex);
                        }
                    }
                }
            });
            if (JAlbum.isMac()) {
                this.fileMenuCloseItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            }
            this.fileMenuCloseItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.newProject(defaultProjectFile.exists() ? defaultProjectFile : null);
                }
            });
            this.fileMenuOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuOpenItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!JAlbumFrame.this.askProjectSave(Msg.get("ui.openProjectMenu"))) {
                        return;
                    }
                    int returnVal = JAlbumFrame.this.projectChooser.showOpenDialog(JAlbumFrame.this);
                    if (returnVal == 0) {
                        JAlbumFrame.this.doLoadProject(JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.fileMenuSaveItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (JAlbumFrame.this.projectChooser.getSelectedFile() != null) {
                        JAlbumFrame.this.saveProject(JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveAsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int returnVal = JAlbumFrame.this.projectChooser.showSaveDialog(JAlbumFrame.this);
                    if (returnVal == 0) {
                        JAlbumFrame.this.saveProject(JAlbumFrame.this.projectChooser.getSelectedFile());
                    }
                }
            });
            this.fileMenuSaveAsDefaultItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.saveProject(defaultProjectFile);
                }
            });
            this.openSkinDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openSkinDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        File skinDir = JAlbumFrame.this.cfg.chainedSkinsDir.getFile(JAlbumFrame.this.engine.getSkin());
                        BrowserLauncher.openLocal(skinDir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.openProgramDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openProgramDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BrowserLauncher.openLocal(JAlbumFrame.this.cfg.progDir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.openImageDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openImageDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JAlbumFrame.this.ui2Engine();
                        BrowserLauncher.openLocal(new File(JAlbumFrame.this.engine.getDirectory()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.openOutputDirectoryMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.openOutputDirectoryMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        JAlbumFrame.this.ui2Engine();
                        BrowserLauncher.openLocal(JAlbumFrame.this.engine.getInterpretedOutputDirectory());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.fileMenuRecentFilesMenu.addFileListMenuListener(new FileListMenuListener(){

                public void fileSelected(ActionEvent e) {
                    JFileMenuItem item = (JFileMenuItem)e.getSource();
                    JAlbumFrame.this.loadProject(item.getFullPath());
                }
            });
            this.helpMenuCheckForUpdates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JAlbumFrame.this.checkForUpdates(false);
                }
            });
            this.buildMenu();
        }

        private void buildMenu() {
            this.fileMenu.add(this.fileMenuNewItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuOpenItem);
            this.fileMenu.add(this.fileMenuRecentFilesMenu);
            this.fileMenu.add(this.fileMenuImportSettingsItem);
            this.fileMenu.add(this.fileMenuCloseItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuSaveItem);
            this.fileMenu.add(this.fileMenuSaveAsItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.fileMenuSaveAsDefaultItem);
            if (!JAlbum.isMac()) {
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.fileMenuExitItem);
            }
            this.editMenu.add(JAlbumFrame.this.albumExplorer.pasteAction);
            this.editMenu.addSeparator();
            this.editMenu.add(JAlbumFrame.this.albumExplorer.selectAllAction);
            this.editMenu.add(JAlbumFrame.this.albumExplorer.invertSelectionAction);
            this.viewMenuLargeThumbnailsItem.setModel(JAlbumFrame.this.albumExplorer.largeThumbnailsMenuItem.getModel());
            this.viewMenu.add(this.viewMenuLargeThumbnailsItem);
            this.viewMenuHideExcludedItem.setModel(JAlbumFrame.this.albumExplorer.hideExcludedMenuItem.getModel());
            this.viewMenu.add(this.viewMenuHideExcludedItem);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.viewMenuOrderBySubMenu);
            JAlbumFrame.this.albumExplorer.populateOrderingSubMenu(this.viewMenuOrderBySubMenu);
            this.viewMenu.add(this.viewMenuOrderFoldersBySubMenu);
            JAlbumFrame.this.albumExplorer.populateFolderOrderingSubMenu(this.viewMenuOrderFoldersBySubMenu);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.viewMenuRefreshItem);
            this.albumMenu.add(this.albumMenuMakeAlbumItem);
            this.albumMenu.add(this.albumMenuMakeAllItem);
            this.albumMenu.add(this.albumMenuMakeChangesItem);
            this.albumMenu.add(this.albumMenuViewAlbumItem);
            this.albumMenu.addSeparator();
            this.albumMenu.add(this.albumMenuSettingsItem);
            this.toolsMenu.add(this.toolsMenuRunSlideshowItem);
            this.toolsMenu.add(this.toolsMenuShareMenuItem);
            this.toolsMenu.add(this.toolsMenuPublishMenuItem);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.openDirectoriesMenu);
            this.openDirectoriesMenu.add(this.openImageDirectoryMenuItem);
            this.openDirectoriesMenu.add(this.openOutputDirectoryMenuItem);
            this.openDirectoriesMenu.add(this.openSkinDirectoryMenuItem);
            this.openDirectoriesMenu.add(this.openProgramDirectoryMenuItem);
            this.toolsMenu.add(this.toolsMenuExternalToolsSubMenu);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(JAlbumFrame.this.actions.showConsoleWindowAction);
            if (!JAlbum.isMac()) {
                this.toolsMenu.addSeparator();
                this.toolsMenu.add(this.toolsMenuPreferencesMenuItem);
            }
            this.helpMenu.add(this.helpMenuTopicsItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.helpMenuCheckForUpdates);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.helpMenuWebItem);
            this.helpMenu.add(this.helpMenuSupportingItem);
            if (!JAlbum.isMac()) {
                this.helpMenu.addSeparator();
                this.helpMenu.add(this.helpMenuAboutItem);
            }
            this.mainMenuBar.add(this.fileMenu);
            this.mainMenuBar.add(this.editMenu);
            this.mainMenuBar.add(this.viewMenu);
            this.mainMenuBar.add(this.albumMenu);
            this.mainMenuBar.add(this.toolsMenu);
            this.mainMenuBar.add(this.helpMenu);
        }

        void setTexts() {
            this.fileMenu.setText(Msg.get("ui.fileMenu"));
            this.fileMenuOpenItem.setText(Msg.get("ui.openProjectMenu"));
            this.fileMenuNewItem.setText(Msg.get("ui.newProjectMenu") + "...");
            this.fileMenuImportSettingsItem.setText(Msg.get("ui.importSettingsMenu"));
            this.fileMenuCloseItem.setText(Msg.get("ui.closeProjectMenu"));
            this.fileMenuSaveItem.setText(Msg.get("ui.saveProjectMenu"));
            this.fileMenuSaveAsItem.setText(Msg.get("ui.saveProjectAsMenu"));
            this.fileMenuSaveAsDefaultItem.setText(Msg.get("ui.saveAsDefaultMenu"));
            this.fileMenuRecentFilesMenu.setText(Msg.get("ui.recentProjectsMenu"));
            this.fileMenuExitItem.setText(Msg.get("ui.exitMenu"));
            this.helpMenu.setText(Msg.get("ui.helpMenu"));
            this.helpMenuTopicsItem.setText(Msg.get("ui.helpTopicsMenu"));
            this.helpMenuWebItem.setText(Msg.get("ui.jalbumOnTheWebMenu"));
            this.helpMenuSupportingItem.setText(Msg.get("ui.supportingJAlbumMenu"));
            this.helpMenuAboutItem.setText(Msg.get("ui.aboutMenu"));
            this.helpMenuCheckForUpdates.setText(Msg.get("ui.checkForUpdatesMenu"));
            this.toolsMenu.setText(Msg.get("ui.toolsMenu"));
            this.toolsMenuShareMenuItem.setText(Msg.get("ui.sharePanel") + "...");
            this.toolsMenuPublishMenuItem.setText(Msg.get("ui.publishPanel") + "...");
            this.openDirectoriesMenu.setText(Msg.get("ui.openDirectoriesMenu"));
            this.openSkinDirectoryMenuItem.setText(Msg.get("ui.skinDirectoryMenu"));
            this.openProgramDirectoryMenuItem.setText(Msg.get("ui.programDirectoryMenu"));
            this.openImageDirectoryMenuItem.setText(Msg.get("ui.imageDirectoryLabel"));
            this.openOutputDirectoryMenuItem.setText(Msg.get("ui.outputDirectory"));
            this.toolsMenuExternalToolsSubMenu.setText(Msg.get("ui.externalToolsMenu"));
            JAlbumFrame.this.actions.showConsoleWindowAction.putValue("Name", Msg.get("ui.consoleMenu"));
            this.toolsMenuPreferencesMenuItem.setText(Msg.get("ui.prefsPanel") + "...");
            this.albumMenu.setText(Msg.get("ui.albumMenu"));
            JAlbumFrame.this.actions.signInAction.putValue("Name", Msg.get("ui.signIn"));
            JAlbumFrame.this.actions.signOutAction.putValue("Name", Msg.get("ui.signOutUser", SignInManager.getInstance(JAlbumFrame.this).getUserName()));
            JAlbumFrame.this.actions.helpAction.putValue("Name", Msg.get("ui.helpMenu"));
            JAlbumFrame.this.actions.makeAction.putValue("Name", Msg.get("ui.makeAlbum"));
            JAlbumFrame.this.actions.makeAction.putValue("ShortDescription", Msg.get("ui.makeAlbumToolTip"));
            JAlbumFrame.this.actions.makeChangesAction.putValue("Name", Msg.get("ui.makeChanges"));
            JAlbumFrame.this.actions.makeChangesAction.putValue("ShortDescription", Msg.get("ui.makeAlbumToolTip"));
            JAlbumFrame.this.actions.makeAllAction.putValue("Name", Msg.get("ui.makeAll"));
            JAlbumFrame.this.actions.makeAllAction.putValue("ShortDescription", Msg.get("ui.rebuildAllToolTip"));
            this.albumMenuViewAlbumItem.setText(Msg.get("ui.preview"));
            this.albumMenuSettingsItem.setText(Msg.get("ui.settings") + "...");
            this.editMenu.setText(Msg.get("ui.edit"));
            this.viewMenu.setText(Msg.get("ui.view"));
            this.viewMenuOrderBySubMenu.setText(Msg.get("edit.orderBy"));
            this.viewMenuOrderFoldersBySubMenu.setText(Msg.get("edit.orderFoldersBy"));
        }
    }

    public class CheckBoxProxy {
        private JCheckBox cb;

        public CheckBoxProxy(JCheckBox cb) {
            this.cb = cb;
        }

        public boolean isSelected() {
            return this.cb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.cb.setSelected(selected);
        }
    }

    public class DummyCheckBox {
        JCheckBox cb;

        public DummyCheckBox(JCheckBox cb) {
            this.cb = cb;
        }

        public boolean isSelected() {
            return this.cb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.cb.setSelected(selected);
        }
    }
}

