/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import se.datadosen.component.CurvedLineBorder;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.NorthLineBorder;
import se.datadosen.component.StatusbarBorder;
import se.datadosen.jalbum.JAlbum;

public class JAlbumBorders {
    private JAlbumBorders() {
    }

    public static JSmartSeparator createSeparator() {
        return JAlbumBorders.createSeparator("");
    }

    public static JSmartSeparator createSeparator(String text) {
        return new JSmartSeparator(text);
    }

    public static Border createTitledCurveBorder(String title) {
        return JAlbumBorders.createTitledCurveBorder(title, true);
    }

    public static Border createTitledCurveBorder(String title, boolean extraSpace) {
        Border outer = JAlbumBorders.emptyBorder(extraSpace ? 6 : 0, 0, 0, 0);
        Border inner = JAlbumBorders.curvedTitledBorder(title);
        return JAlbumBorders.compound(outer, inner);
    }

    public static Border createNorthLineBorder() {
        return new NorthLineBorder();
    }

    public static Border createStatusbarBorder() {
        return new StatusbarBorder();
    }

    public static Border createTitledHeaderBorder(String title) {
        return JAlbumBorders.titledBorder(title, JAlbumBorders.createNorthLineBorder());
    }

    private static Border curvedTitledBorder(String title) {
        return JAlbumBorders.titledBorder(title, new CurvedLineBorder());
    }

    private static Border compound(Border outer, Border inner) {
        return BorderFactory.createCompoundBorder(outer, inner);
    }

    private static Border emptyBorder(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(top, left, bottom, right);
    }

    private static Border titledBorder(String title, Border b) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(b, title);
        if (JAlbum.isMac()) {
            Font f = titledBorder.getTitleFont();
            titledBorder.setTitleFont(f.deriveFont(f.getSize2D() - 2.0f));
            titledBorder.setTitlePosition(1);
        }
        return titledBorder;
    }

    public static Border createImageBorder() {
        Color veryLightGray = new Color(15526360);
        return JAlbumBorders.createCompoundBorder(new Border[]{new LineBorder(veryLightGray, 1), BorderFactory.createLineBorder(new Color(0xFFFFFF, true), 2)});
    }

    public static Border createSelectedImageBorder() {
        return new LineBorder(SystemColor.textHighlight, 3);
    }

    public static Border createCompoundBorder(Border[] borders) {
        Border border = null;
        for (int i = 0; i < borders.length; ++i) {
            border = border == null ? borders[i] : BorderFactory.createCompoundBorder(borders[i], border);
        }
        return border;
    }
}

