/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.Primitive;
import bsh.TargetError;
import bsh.UtilEvalError;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import marcoschmidt.ImageInfo;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAFilterNode;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.MetaObjectCache;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.FileFilters;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.IO;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.Replacer;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.Template;

public class AlbumBean
implements ImageObserver {
    public static final String PRODUCT_DISPLAY_VERSION = "8.3";
    public static final String PRODUCT_INTERNAL_VERSION = "8.3.5";
    public static final String ORDER_BY_DATE = "OrderByDate";
    public static final String ORDER_BY_NAME = "OrderByName";
    public static final String ORDER_BY_SIMPLE_NAME = "OrderBySimpleName";
    public static final String CUSTOM_ORDER_FILE = "albumfiles.txt";
    public static final String LINK_ORIGINALS = "LinkOriginals";
    public static final String LINK_ORIGINALS_VIA_SCALED = "LinkOriginalsViaScaled";
    public static final String LINK_SCALED = "LinkScaled";
    public static final String SCALE_SMOOTH = "ScaleSmooth";
    public static final String SCALE_MEDIUM = "ScaleMedium";
    public static final String SCALE_FAST = "ScaleFast";
    static final String GIFS_DIR = "gifs";
    private static final String STYLES_FILE = "styles.css";
    static Image filmImage = new ImageIcon(JAlbumObject.class.getResource("images/bigfilm.png")).getImage();
    private static final String DEFAULT_INDEX_PAGE_NAME = "index";
    private static final int MAX_ROWS = 999;
    protected static final Map application = new PrintSafeHashMap();
    public HashMap evalStats = new HashMap();
    AlbumObjectFactory albumObjectFactory;
    private ImageInfoFormatter formatter = new ImageInfoFormatter();
    private Config cfg = Config.getConfig();
    Object using;
    private Map album;
    Scope globalVariables;
    Map fileVariables;
    Template indexTemplate;
    Template slideTemplate;
    private boolean mediaRSS = true;
    private boolean widgetInjection = true;
    private boolean suppressIEWarnings = true;
    private SkinProperties skinProperties;
    private String userName = null;
    private static final String mediaRSSPath = "album.rss";
    private long startTime;
    private int processedFiles;
    private int totalFiles;
    private String directory = "";
    private String thumbSize = "124x124";
    private String imageSize = "800x800";
    private Color imageBackgroundColor = Color.white;
    private String lastThumbSize;
    private String lastImageSize;
    Dimension thumbDim = new Dimension(124, 124);
    Dimension imageDim = new Dimension(800, 800);
    private int cols = 6;
    private int rows = 4;
    private int limit = 0;
    private int qualityPercent = 75;
    private int sharpenPercent = 50;
    private boolean progressiveMode = true;
    private boolean classicReaders = true;
    private boolean useThumbForFolderIcon = false;
    private int cpuCores = Runtime.getRuntime().availableProcessors();
    private boolean slides = true;
    private transient Vector albumBeanListeners;
    private PropertyChangeSupport changeSupport;
    private String dateFormat = "";
    private String scalingMethod = "ScaleMedium";
    private boolean hardwareScaling = false;
    private boolean subdirs = true;
    private boolean appendImages = false;
    private boolean updatedDirsOnly = false;
    private boolean excludeByDefault = false;
    private boolean keepMetaData = false;
    private String indexPageName = "index";
    private String framesetPageName;
    private boolean urlEncode = false;
    private String imageOrdering = "OrderByDate";
    private Comparator customImageOrdering;
    private boolean metaData = true;
    private boolean sameDirectory = false;
    private String outputDirectory = "album";
    private String imageLinking = "LinkScaled";
    private boolean copyOriginals = true;
    private String skin = "Chameleon";
    private String style = "Black.css";
    private String resourceDirectory = "res";
    private String thumbDirectory = "thumbs";
    private String closeupDirectory = "slides";
    private String slideDirectory = "slides";
    private String thumbnailPrefix = "";
    private String closeupPrefix = "";
    private String pageExtension = ".html";
    private boolean includeDirectories = true;
    private Map userVariables = new PrintSafeHashMap();
    private Map skinVariables = new PrintSafeHashMap();
    private Map extras = new PrintSafeHashMap();
    private boolean frames;
    private String accountProfileName = "";
    private String remoteDirectory = "album";
    private boolean reverseOrder;
    private LinkedList<JAFilterNode> filters = new LinkedList();
    private String characterEncoding;
    private String textEncoding;
    private boolean writeUTF8 = true;
    private boolean directoriesFirst = true;
    private String ignorePattern = "\\..*";
    private String includePattern = "";
    boolean textFileComment = true;
    boolean jpegComment = false;
    boolean iptcCaption = true;
    boolean exifUserComment = true;
    boolean highQualityThumbs = true;
    boolean exifImageDescription = false;
    private DateFormat df = new SimpleDateFormat();
    private DateFormat mediaRssDf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private File skinDir;
    private File slidesDir;
    private File resDir;
    public File srcResDir;
    private File rootImageDir;
    private File rootOutputDir;
    int currentRows;
    int indexNum;
    File[] files;
    int imagesPerIndex;
    int indexImageCount;
    Scope indexVariables;
    Interpreter interpreter;
    TemplateParser parser;

    public AlbumBean() {
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.textEncoding = System.getProperty("file.encoding");
        if (this.textEncoding.equals("MacRoman") || this.textEncoding.equals("Cp1252")) {
            this.setTextEncoding("ISO-8859-1");
        }
        this.initInterpreter();
    }

    void initInterpreter() {
        this.interpreter = new Interpreter();
        File skinPluginsDir = new File(this.skinDir, "plugins");
        URLClassLoader loader = null;
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        try {
            loader = skinPluginsDir.exists() ? new URLClassLoader(new URL[]{skinPluginsDir.toURI().toURL(), this.cfg.pluginsDir.toURI().toURL()}, parent) : new URLClassLoader(new URL[]{this.cfg.pluginsDir.toURI().toURL()}, parent);
            this.interpreter.setClassLoader((ClassLoader)loader);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
    }

    private String getImageSettingsHash() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("imageSize", this.getImageSize());
        props.put("thumbSize", this.getThumbSize());
        props.put("scalingMethod", this.getScalingMethod());
        props.put("sharpenPercent", this.getSharpenPercent());
        props.put("qualityPercent", this.getQualityPercent());
        props.put("progressiveMode", this.isProgressiveMode());
        props.put("keepMetaData", this.isKeepMetaData());
        props.put("filterStack", this.filters);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(bos));
        e.setExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        });
        e.writeObject(props);
        e.close();
        try {
            String line;
            String s = bos.toString("UTF-8");
            BufferedReader in = new BufferedReader(new StringReader(s));
            in.readLine();
            in.readLine();
            StringBuilder buf = new StringBuilder();
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            return DigestUtil.md5(buf.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public void setDirectory(String newDirectory) {
        this.directory = newDirectory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setThumbSize(String newThumbSize) throws ParameterException {
        this.thumbSize = newThumbSize;
        this.thumbDim = AlbumBean.parseSize(this.thumbSize);
    }

    public String getThumbSize() {
        return this.thumbSize;
    }

    public void setImageSize(String newImageSize) throws ParameterException {
        this.imageSize = newImageSize;
        this.imageDim = AlbumBean.parseSize(this.imageSize);
    }

    public String getImageSize() {
        return this.imageSize;
    }

    String getLastImageSize() {
        return this.lastImageSize;
    }

    String getLastThumbSize() {
        return this.lastThumbSize;
    }

    public void setCols(int newCols) {
        this.cols = newCols;
    }

    public int getCols() {
        return this.cols;
    }

    public void setQualityPercent(int newQualityPercent) {
        this.qualityPercent = newQualityPercent;
    }

    public int getQualityPercent() {
        return this.qualityPercent;
    }

    public void setSharpenPercent(int newSharpenPercent) {
        this.sharpenPercent = newSharpenPercent;
    }

    public int getSharpenPercent() {
        return this.sharpenPercent;
    }

    public void setProgressiveMode(boolean newProgressiveMode) {
        this.progressiveMode = newProgressiveMode;
    }

    public boolean isProgressiveMode() {
        return this.progressiveMode;
    }

    public void setClassicReaders(boolean newClassicReaders) {
        this.classicReaders = newClassicReaders;
    }

    public boolean isClassicReaders() {
        return this.classicReaders;
    }

    public void setUseThumbForFolderIcon(boolean newUseThumbForFolderIcon) {
        this.useThumbForFolderIcon = newUseThumbForFolderIcon;
    }

    public boolean isUseThumbForFolderIcon() {
        return this.useThumbForFolderIcon;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public void setSlides(boolean newSlides) {
        this.slides = newSlides;
    }

    public boolean isSlides() {
        return this.slides;
    }

    public void setDateFormat(String newDateFormat) {
        this.dateFormat = newDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public DateFormat getDateFormatAsObject() {
        return this.df;
    }

    public Color getImageBackgroundColor() {
        return this.imageBackgroundColor;
    }

    public void setImageBackgroundColor(Color backgroundColor) {
        this.imageBackgroundColor = backgroundColor;
    }

    public void processTemplateFile(File source, File dest) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        data = this.processTemplate(data);
        IO.writeTextFile(data, dest, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    public String processTemplate(String template) throws ElementException {
        String data = template;
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), this.parser.getVariables());
        data = replacer.replace(data);
        data = this.parser.parseElements(data);
        return data;
    }

    public void processTemplateFile(File source, File dest, Map vars) throws IOException, ElementException {
        this.processTemplateFile(source, dest, vars, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    private void processTemplateFile(File source, File dest, Map vars, String encoding) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), vars);
        data = replacer.replace(data);
        this.parser.reset();
        this.parser.putAll(vars);
        data = this.parser.parseElements(data);
        IO.writeTextFile(data, dest, encoding);
    }

    public File[] listFiles(File dir, boolean includeDirs, File outputDir) throws IOException {
        FileCollection fc = new FileCollection(this, dir);
        fc.setDoSort(true);
        AlbumFileFilter filter = includeDirs ? new AlbumFileFilter(this, outputDir, this.ignorePattern) : new AlbumFileFilter(this, null, this.ignorePattern);
        File[] files = fc.listFiles(filter);
        return files;
    }

    private void cleanIfRequested(File dir) throws IOException {
        dir.mkdir();
        if (this.cfg.isCleanOutputFiles() && !this.appendImages) {
            this.cleanDirectory(dir);
        }
    }

    private void cleanDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || files[i].lastModified() >= this.startTime) continue;
            files[i].delete();
        }
    }

    private void cleanDirectoryTree(File dir) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.cleanDirectoryTree(files[i]);
            }
            if (files[i].lastModified() >= this.startTime) continue;
            files[i].delete();
        }
    }

    private File[] limitTo(File[] arr, int max) {
        if (max > 0 && max < arr.length) {
            File[] limited = new File[max];
            for (int i = 0; i < max; ++i) {
                limited[i] = arr[i];
            }
            return limited;
        }
        return arr;
    }

    private void makeAlbumForDirectory(File dir, File outputDir, int level) throws ParameterException, IOException, OperationAbortedException, ElementException {
        File gifsDir;
        File[] files;
        if (!dir.isDirectory()) {
            throw new ParameterException(Msg.get("engine.invalidDirectoryError"));
        }
        File[] filesDirs = files = this.listFiles(dir, false, null);
        if (this.subdirs || this.includeDirectories) {
            filesDirs = this.listFiles(dir, true, outputDir);
        }
        files = this.limitTo(files, this.limit);
        if ((filesDirs = this.limitTo(filesDirs, this.limit)).length == 0) {
            return;
        }
        outputDir.mkdirs();
        File srcResDir2 = new File(this.skinDir, "styles/" + IO.baseName(this.style));
        if (this.resDir != null && level == 0) {
            IO.copyDirectoryContent(this.srcResDir, this.resDir, true);
            if (srcResDir2.exists()) {
                IO.copyDirectoryContent(srcResDir2, this.resDir, true);
            }
            File styleFile = new File(this.skinDir, "styles/" + this.style);
            if (this.style != null && styleFile.exists()) {
                this.processTemplateFile(styleFile, new File(this.resDir, STYLES_FILE), this.globalVariables);
            }
        }
        if ((gifsDir = new File(this.skinDir, GIFS_DIR)).exists()) {
            File outputGifsDir = new File(outputDir, GIFS_DIR);
            this.cleanIfRequested(outputGifsDir);
            IO.copyDirectoryContent(gifsDir, outputGifsDir, true);
        }
        AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir, IO.relativePath(dir, this.rootImageDir.getParentFile()), Msg.get("engine.readingMetadataInfo"), 0, files.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        Collection errorFiles = this.registerVariables(dir, filesDirs, outputDir);
        filesDirs = this.excludeErrorFiles(filesDirs, errorFiles);
        files = this.excludeErrorFiles(files, errorFiles);
        eventObject = new AlbumBeanEvent(this, dir, IO.relativePath(dir, this.rootImageDir.getParentFile()), Msg.get("engine.makingIndexPages"), 0, files.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        this.makeIndexPages(dir, outputDir, this.includeDirectories ? filesDirs : files, files, level);
        if (this.slides || this.imageLinking != LINK_ORIGINALS) {
            this.slidesDir = new File(outputDir, this.slideDirectory);
            this.slidesDir.mkdir();
        }
        this.adjustImageLinks(outputDir, files);
        Counter c = new Counter(0);
        if (this.cpuCores > 1) {
            int i;
            ThreadGroup threads = new ThreadGroup("Image processing threads");
            ImageProcessingThread[] processThreads = new ImageProcessingThread[this.cpuCores];
            for (i = 0; i < this.cpuCores; ++i) {
                processThreads[i] = new ImageProcessingThread(threads, "Processing thread " + i, c, dir, outputDir, files);
                processThreads[i].start();
            }
            for (i = 0; i < this.cpuCores; ++i) {
                try {
                    processThreads[i].join();
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.cpuCores; ++i) {
                Throwable t = processThreads[i].throwable;
                if (t == null) continue;
                if (t instanceof ElementException) {
                    throw (ElementException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof OperationAbortedException) {
                    throw (OperationAbortedException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
        } else {
            this.makeThumbs(c, dir, outputDir, files);
        }
        AlbumBean.removeIfEmpty(new File(outputDir, this.thumbDirectory));
        AlbumBean.removeIfEmpty(new File(outputDir, this.slideDirectory));
        if (this.subdirs) {
            for (int i = 0; i < filesDirs.length; ++i) {
                File outputSubDir;
                File sourceSubDir;
                if (!filesDirs[i].isDirectory() || !this.needsToProcessDir(sourceSubDir = filesDirs[i], outputSubDir = new File(outputDir, sourceSubDir.getName()))) continue;
                this.makeAlbumForDirectory(filesDirs[i], outputSubDir, level + 1);
            }
        }
    }

    private boolean needsToProcessDir(File inputDir, File outputDir) throws IOException {
        boolean needToProcessDir = !this.updatedDirsOnly || !outputDir.exists() || this.deepLastModified(inputDir) >= IO.deepLastModified(outputDir);
        return needToProcessDir;
    }

    private long deepLastModified(File dir) throws IOException {
        long lastModified = dir.lastModified();
        FileCollection fc = new FileCollection(this, dir);
        AlbumFileFilter ff = new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern);
        ff.setIgnoreControlFiles(false);
        File[] content = fc.listFiles(ff);
        if (content != null) {
            for (File file : content) {
                long lm = file.lastModified();
                if (file.isDirectory()) {
                    lm = this.deepLastModified(file);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    private static void removeIfEmpty(File dir) throws IOException {
        if (dir.exists() && dir.listFiles().length == 0) {
            dir.delete();
        }
    }

    private File[] excludeErrorFiles(File[] files, Collection errorFiles) {
        if (errorFiles.size() == 0) {
            return files;
        }
        LinkedList<File> files2 = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            files2.addLast(files[i]);
        }
        files2.removeAll(errorFiles);
        files = new File[files2.size()];
        Iterator it = files2.iterator();
        int i = 0;
        while (it.hasNext()) {
            files[i] = (File)it.next();
            ++i;
        }
        return files;
    }

    ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        FileInputStream fis = new FileInputStream(file);
        ii.setCollectComments(true);
        ii.setInput(fis);
        ii.setEncoding(this.textEncoding);
        if (!ii.check()) {
            throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
        }
        fis.close();
        return ii;
    }

    private String getOriginalPath(File file, Scope vars, File outputDir, File fromDir) {
        String path;
        if (this.copyOriginals || this.getImageLinking(vars).equals(LINK_SCALED)) {
            file = new File(outputDir, file.getName());
        }
        if ((path = this.attemptRelativePath(file, fromDir)).startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    private String attemptRelativePath(File file, File fromDir) {
        String rel = IO.relativePath(file, fromDir);
        File relativeFile = new File(rel);
        if (relativeFile.isAbsolute()) {
            int i;
            String uri = relativeFile.toURI().toString();
            String prefix = "file:";
            for (i = prefix.length(); i < uri.length() && uri.charAt(i) == '/'; ++i) {
            }
            return prefix + "///" + uri.substring(i);
        }
        return this.encode(rel);
    }

    static Map getFolderProperties(File dir) throws IOException {
        File mapFile = new File(dir, "meta.properties");
        if (mapFile.exists()) {
            Map props = IO.readMapFile(mapFile);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!((String)e.getValue()).equals("")) continue;
                it.remove();
            }
            return props;
        }
        return new HashMap();
    }

    private File addImageLinks(File file, Scope vars, File outputDir, File fromDir, boolean inSlides) throws IOException {
        String thumbPath;
        String imagePath;
        File representingFile;
        String toSlides = inSlides ? "" : this.slideDirectory + "/";
        String fromSlides = inSlides ? "../" : "";
        String fileName = file.getName();
        String label = IO.baseName(fileName);
        String closeupPath = null;
        String originalPath = null;
        String iconPath = null;
        String resPath = this.resDir != null ? IO.relativePath(this.resDir, fromDir) : fromSlides + GIFS_DIR;
        File thmFile = IO.thumbFile(file);
        if (file.isDirectory()) {
            closeupPath = fromSlides + this.encode(file.getName()) + "/" + this.getJAlbumWeb();
            AlbumObject ao = this.albumObjectFactory.createInstance(file);
            representingFile = ao.getRepresentingIconFile();
            if (representingFile != null) {
                AlbumObject rep = ao.getRepresentingAlbumObject();
                String pathFromRoot = rep.getPathFromRoot();
                String path = "";
                int slashIndex = pathFromRoot.lastIndexOf(47);
                if (slashIndex == -1) {
                    String name = pathFromRoot;
                } else {
                    path = pathFromRoot.substring(0, slashIndex);
                    String name = pathFromRoot.substring(slashIndex + 1);
                }
                path = IO.relativePath(path, ao.getPathFromRoot());
                if (".".equals(path)) {
                    path = "";
                }
                path = IO.combinePaths(file.getName(), path);
                path = IO.combinePaths(path, this.thumbDirectory);
                path = IO.combinePaths(path, this.thumbnailPrefix + AlbumBean.jpegName(representingFile.getName()));
                thumbPath = imagePath = this.encode(path);
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                iconPath = imagePath = resPath + '/' + representingFile.getName();
                thumbPath = imagePath;
            }
        } else if (!AlbumBean.isSupported(file)) {
            closeupPath = originalPath = this.getOriginalPath(file, vars, outputDir, fromDir);
            if (thmFile.exists()) {
                thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + this.encode(AlbumBean.jpegName(fileName));
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                representingFile = thmFile;
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                IO.copyFile(representingFile, this.resDir, false);
                iconPath = imagePath = resPath + '/' + representingFile.getName();
                thumbPath = imagePath;
            }
        } else {
            thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + this.encode(AlbumBean.jpegName(fileName));
            representingFile = thmFile.exists() ? thmFile : file;
            String il = this.getImageLinking(vars);
            if (this.slides || il.equals(LINK_ORIGINALS_VIA_SCALED)) {
                closeupPath = toSlides + this.encode(label) + this.pageExtension;
            }
            if (il.equals(LINK_ORIGINALS)) {
                imagePath = this.getOriginalPath(file, vars, outputDir, fromDir);
                if (!this.slides) {
                    closeupPath = imagePath;
                }
            } else if (il.equals(LINK_ORIGINALS_VIA_SCALED)) {
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                originalPath = this.getOriginalPath(file, vars, outputDir, fromDir);
            } else {
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                if (!this.slides) {
                    closeupPath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                }
            }
        }
        vars.put("thumbPath", thumbPath);
        if (iconPath != null) {
            vars.put("iconPath", iconPath);
        }
        vars.put("closeupPath", closeupPath);
        vars.put("imagePath", imagePath);
        if (originalPath != null) {
            vars.put("originalPath", originalPath);
        }
        vars.put("representingFile", representingFile);
        return representingFile;
    }

    void addGlobals(Map vars) {
        vars.put("generator", "Jalbum 8.3");
        vars.put("generatorUrl", JAlbumSite.getInstance().getGeneratorUrl());
        vars.put("internalVersion", PRODUCT_INTERNAL_VERSION);
        vars.put("styleFile", STYLES_FILE);
        vars.put("skin", this.skin);
        if (this.style != null) {
            vars.put("style", this.style);
        }
        vars.put("maxImageWidth", new Integer(this.imageDim.width));
        vars.put("maxImageHeight", new Integer(this.imageDim.height));
        vars.put("maxThumbWidth", new Integer(this.thumbDim.width));
        vars.put("maxThumbHeight", new Integer(this.thumbDim.height));
        vars.put("rows", new Integer(this.rows));
        vars.put("cols", new Integer(this.cols));
        vars.put("engine", this);
        vars.put("window", JAlbumContext.getInstance().getFrame());
        if (JAlbum.mainFrame != null) {
            vars.put("explorer", JAlbum.mainFrame.albumExplorer.explorer);
        }
        vars.put("album", this.album);
        vars.put("application", application);
        vars.put("programDirectory", this.cfg.progDir.getAbsoluteFile());
        vars.put("skinDirectory", this.skinDir);
        vars.put("rootImageDirectory", this.rootImageDir);
        vars.put("rootOutputDirectory", this.rootOutputDir);
        if (this.resDir != null) {
            vars.put("resDirectory", this.resDir);
        }
        if (this.srcResDir != null) {
            vars.put("skinResDirectory", this.srcResDir);
        }
        vars.put("currentDate", this.df.format(new Date()));
        int tf = this.totalFiles;
        if (this.updatedDirsOnly) {
            try {
                tf = this.countFiles(new File(this.directory));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        vars.put("executedNormally", new Boolean(false));
        vars.put("totalAlbumImages", new Integer(tf));
        vars.put("textEncoding", this.writeUTF8 ? "UTF-8" : this.textEncoding);
        this.addInternationalTexts(vars);
    }

    String readComment(File file, File imageDir, Metadata metadata) {
        File commentFile;
        String comment = null;
        if (metadata != null) {
            try {
                String iptcComment;
                Directory directory;
                if (metadata.containsDirectory(ExifDirectory.class)) {
                    this.formatter.setMetadata(metadata);
                    this.formatter.setDateFormat(this.df);
                    directory = metadata.getDirectory(ExifDirectory.class);
                    ExifDescriptor desc = new ExifDescriptor(directory);
                    if (this.exifUserComment) {
                        comment = desc.getUserCommentDescription();
                    }
                    if (this.exifImageDescription && !AlbumBean.exists(comment)) {
                        comment = (String)this.formatter.format(270);
                    }
                }
                if (this.iptcCaption && metadata.containsDirectory(IptcDirectory.class) && AlbumBean.exists(iptcComment = (directory = metadata.getDirectory(IptcDirectory.class)).getString(632))) {
                    comment = iptcComment;
                }
            }
            catch (MetadataException ex) {
                // empty catch block
            }
        }
        if (this.jpegComment) {
            try {
                ImageInfo ii = this.getImageInfo(file);
                String jpegComment = "";
                int ncomm = ii.getNumberOfComments();
                for (int i = 0; i < ncomm; ++i) {
                    if (i > 0) {
                        jpegComment = jpegComment + ", ";
                    }
                    jpegComment = jpegComment + ii.getComment(i);
                }
                if (AlbumBean.exists(jpegComment) && !AlbumBean.isCopyright(jpegComment)) {
                    comment = jpegComment;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.textFileComment && (commentFile = new File(imageDir, "comments.properties")).exists()) {
            try {
                Map comments = IO.readMapFile(commentFile);
                String textFileComment = (String)comments.get(file.getName());
                if (textFileComment != null) {
                    comment = textFileComment;
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        return comment != null ? comment : "";
    }

    private void addInternationalTexts(Map vars) {
        try {
            Locale locale = this.extras.containsKey("language") ? new Locale((String)this.extras.get("language"), "") : Locale.getDefault();
            SmartResourceBundle texts = null;
            try {
                texts = SmartResourceBundle.getBundle(new File(this.skinDir, "texts"), "texts", locale);
            }
            catch (MissingResourceException ex) {
                texts = SmartResourceBundle.getBundle(this.skinDir, "texts", locale);
            }
            for (String k : texts.getKeys()) {
                vars.put("text." + k, texts.getString(k));
            }
            vars.put("texts", texts);
            vars.put("text", texts);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static boolean isCopyright(String s) {
        return s.startsWith("ACD Systems Digital Imaging") || s.startsWith("LEAD Technologies") || s.startsWith("AppleMark") || s.startsWith("Intel(R) JPEG Library") || s.startsWith("Created with The GIMP") || s.startsWith("ASCII") || s.startsWith("OLYMPUS DIGITAL CAMERA") || s.startsWith("KONICA MINOLTA") || s.startsWith("File written by Adobe Photoshop");
    }

    private void registerFolderVariables(File file, Scope vars) throws IOException {
        Map fp = AlbumBean.getFolderProperties(file);
        fp.remove("title");
        String desc = (String)fp.get("descript");
        if (desc != null) {
            fp.put("description", desc);
        }
        fp.remove("descript");
        vars.putAll(fp);
    }

    public void registerVariables(File file, File outputDir) throws IOException {
        this.registerVariables(file, outputDir, true);
    }

    private void registerVariables(File file, File outputDir, boolean calculateSizes) throws IOException {
        Scope vars = (Scope)this.fileVariables.get(file);
        if (vars == null) {
            vars = new Scope(this.globalVariables);
            this.fileVariables.put(file, vars);
        }
        String fileName = file.getName();
        vars.put("fileName", fileName);
        vars.put("fileDate", new FormattedDate(file.lastModified(), this.df));
        this.addAlbumObjectProperties(file, vars);
        if (!file.isDirectory()) {
            vars.put("fileSize", new Long(file.length()));
            vars.put("label", IO.baseName(fileName));
        } else {
            vars.put("folder", (Object)true);
            vars.put("label", fileName);
        }
        if (AlbumBean.isSupported(file)) {
            if (this.metaData) {
                try {
                    Metadata imageInfo = JpegMetadataReader.readMetadata((File)file);
                    if (imageInfo != null) {
                        this.addImageInfo(file, imageInfo, vars);
                        vars.put("orientation", RotationSupport.getOrientationAsString(file));
                    }
                }
                catch (MetadataException ex) {
                }
                catch (JpegProcessingException ex) {
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.err.println(ex);
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            } else {
                try {
                    vars.put("orientation", RotationSupport.getOrientationAsString(file));
                }
                catch (IOException ex) {
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.err.println(ex);
                }
            }
        }
        File representingFile = this.addImageLinks(file, vars, outputDir, outputDir, false);
        String ext = IO.extensionOf(representingFile).toLowerCase();
        FileFilters.BasicImageInfo info = FileFilters.getBasicImageInfo(representingFile);
        int originalWidth = info.width;
        int originalHeight = info.height;
        vars.put("formatName", info.formatName);
        vars.put("originalWidth", new Integer(originalWidth));
        vars.put("originalHeight", new Integer(originalHeight));
        if (this.jpegComment) {
            this.addOldJPEGComment(representingFile, vars);
        }
        if (calculateSizes) {
            this.addFilteredImageSizes(file, vars);
        }
    }

    private void addOldJPEGComment(File file, Map vars) {
        try {
            ImageInfo ii = this.getImageInfo(file);
            String comment = "";
            int ncomm = ii.getNumberOfComments();
            for (int i = 0; i < ncomm; ++i) {
                if (i > 0) {
                    comment = comment + ", ";
                }
                comment = comment + ii.getComment(i);
            }
            if (AlbumBean.exists(comment) && !AlbumBean.isCopyright(comment)) {
                vars.put("comment", comment);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addAlbumObjectProperties(File file, Scope vars) {
        try {
            String title;
            AlbumObject ao = this.albumObjectFactory.createInstance(file);
            AlbumObjectProperties props = ao.getProperties();
            for (String key : props.keySet()) {
                vars.put(key, props.get(key));
            }
            if (ao.isFolder()) {
                this.registerFolderVariables(file, vars);
            }
            if ((title = (String)props.get("title")) != null && title.length() > 0) {
                vars.put(ao.isFolder() ? "folderTitle" : "fileTitle", title);
            } else {
                vars.put("title", ao.isFolder() ? file.getName() : IO.baseName(file.getName()));
            }
            Map userVars = (Map)props.get("userVariables");
            if (userVars != null) {
                vars.putAll(userVars);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Collection registerVariables(File imageDir, File[] files, File outputDir) {
        LinkedList<File> errorFiles = new LinkedList<File>();
        File commentFile = new File(imageDir, "comments.properties");
        Map comments = new HashMap();
        if (commentFile.exists()) {
            try {
                comments = IO.readMapFile(commentFile);
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                String comment;
                Scope vars = new Scope(this.globalVariables);
                this.fileVariables.put(files[i], vars);
                this.registerVariables(files[i], outputDir, false);
                if (!this.textFileComment || (comment = (String)comments.get(files[i].getName())) == null) continue;
                vars.put("comment", comment);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                errorFiles.add(files[i]);
                this.fireErrorOccured(t, files[i]);
            }
        }
        return errorFiles;
    }

    public void processBeanShellFile(File f) throws ElementException, IOException {
        Scope gv = new Scope();
        this.addGlobals(gv);
        this.globalVariables = gv = gv.push(this.extras);
        this.processBeanShellFile(f, this.globalVariables);
    }

    void processBeanShellFile(File f, Map vars) throws ElementException, IOException {
        if (f.exists()) {
            String content = IO.readTextFile(f);
            this.processExpression(content, vars);
        }
    }

    Object processExpression(String expr) throws ElementException {
        Scope vars = new Scope(this.globalVariables);
        vars = vars.push(this.extras);
        return this.processExpression(expr, vars);
    }

    Object processExpression(String expr, Map vars) throws ElementException {
        AlbumBean.setVars(vars, this.interpreter);
        return this.doProcessExpression(expr);
    }

    Object doProcessExpression(String expr) throws ElementException {
        try {
            return this.interpreter.eval(expr);
        }
        catch (ParseException e) {
            throw new ElementException(e.getMessage() + "\n\nDetails:\n" + e.getErrorSourceFile());
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            String s = "Exception caused by line " + e.getErrorLineNumber() + ": " + e.getTarget() + "\n\nDetails:\n" + e.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.getTarget().printStackTrace(out);
            out.close();
            throw new ElementException(s + "\n\nStack trace:\n" + sw.toString());
        }
        catch (EvalError e) {
            throw new ElementException("Evaluation error on line " + e.getErrorLineNumber() + ":\n\nDetails:\n" + e.getMessage());
        }
    }

    public int countFiles(File dir) throws IOException {
        int counter = 0;
        FileCollection fc = new FileCollection(this, dir);
        File[] filesDirs = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (filesDirs == null) {
            return 0;
        }
        for (int i = 0; i < filesDirs.length; ++i) {
            if (filesDirs[i].isDirectory()) {
                if (!this.subdirs) continue;
                counter += this.countFiles(filesDirs[i]);
                continue;
            }
            ++counter;
        }
        return counter;
    }

    int countChangedFiles(File inputDir, File outputDir) throws IOException {
        int counter = 0;
        FileCollection fc = new FileCollection(this, inputDir);
        File[] inputSubFiles = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (inputSubFiles == null) {
            return 0;
        }
        for (int i = 0; i < inputSubFiles.length; ++i) {
            File inputSubFile = inputSubFiles[i];
            if (inputSubFile.isDirectory()) {
                File outputSubDir = new File(outputDir, inputSubFile.getName());
                if (!this.subdirs || !this.needsToProcessDir(inputSubFile, outputSubDir)) continue;
                counter += this.countChangedFiles(inputSubFiles[i], outputSubDir);
                continue;
            }
            ++counter;
        }
        return counter;
    }

    public void init() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(false, false);
    }

    public void makeAlbum() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(true, false);
    }

    void smartMakeAlbum() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAlbum(boolean doMake, boolean smart) throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.startTime = System.currentTimeMillis();
        this.myAssert(this.directory != null, Msg.get("engine.missingDirectoryError"));
        if (!this.sameDirectory) {
            this.myAssert(this.outputDirectory != null, Msg.get("engine.missingOutputDirectoryError"));
        } else {
            this.outputDirectory = this.directory;
        }
        this.myAssert(this.thumbSize != null, Msg.get("engine.missingThumbSizeError"));
        this.myAssert(this.imageSize != null, Msg.get("engine.missingImageSizeError"));
        File inputDir = new File(this.directory);
        File outputDir = null;
        if (this.directory != null && this.directory.length() > 0 || doMake) {
            if (!inputDir.isDirectory()) {
                throw new IOException(Msg.get("engine.notADirectoryError"));
            }
            outputDir = this.getInterpretedOutputDirectory();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            this.rootImageDir = inputDir;
            this.rootOutputDir = outputDir;
        }
        this.fileVariables = new PrintSafeHashMap();
        this.album = new PrintSafeHashMap();
        this.df = this.dateFormat != null && !this.dateFormat.equals("") ? new SimpleDateFormat(this.dateFormat) : new SimpleDateFormat();
        this.albumObjectFactory = new AlbumObjectFactory(this);
        this.initInterpreter();
        this.parser = new TemplateParser();
        this.globalVariables = new Scope();
        if (!doMake) {
            this.addGlobals(this.globalVariables);
            this.globalVariables = this.globalVariables.push(this.extras);
            return;
        }
        this.srcResDir = new File(this.skinDir, "res");
        if (this.srcResDir.exists()) {
            this.resDir = new File(this.rootOutputDir, this.resourceDirectory);
            if (this.resDir.exists() && this.cfg.isCleanOutputFiles() && !this.appendImages) {
                this.cleanDirectoryTree(this.resDir);
            }
        } else {
            this.resDir = null;
            this.srcResDir = new File(this.skinDir, GIFS_DIR);
        }
        this.processedFiles = 0;
        this.totalFiles = this.countChangedFiles(inputDir, outputDir);
        this.skinProperties = new SkinProperties(this.skinDir);
        this.indexTemplate = new Template(IO.readTextFile(new File(this.skinDir, "index.htt")));
        if (this.slides) {
            this.slideTemplate = new Template(IO.readTextFile(new File(this.skinDir, "slide.htt")));
        }
        this.addGlobals(this.globalVariables);
        this.globalVariables = this.globalVariables.push(this.extras);
        this.setUsing(null);
        this.processBeanShellFile(new File(this.cfg.progDir, "system/init.bsh"), this.globalVariables);
        this.parser.putAll(this.globalVariables);
        this.processBeanShellFile(new File(this.skinDir, "init.bsh"), this.globalVariables);
        String imageSettingsHash = null;
        String lastImageSettingsHash = null;
        AlbumObjectProperties lastProps = null;
        if (smart || !this.isAppendImages()) {
            imageSettingsHash = this.getImageSettingsHash();
            AlbumObject rootAlbumObject = this.albumObjectFactory.createInstance(this.rootImageDir);
            lastProps = rootAlbumObject.getProperties();
            lastImageSettingsHash = (String)lastProps.get("imageSettingsHash");
            if (smart) {
                if (!imageSettingsHash.equals(lastImageSettingsHash)) {
                    this.setAppendImages(false);
                } else {
                    this.setAppendImages(true);
                }
            }
        }
        try {
            File framesetFile = new File(this.skinDir, "frameset.htt");
            if (framesetFile.exists()) {
                this.frames = true;
                this.framesetPageName = this.indexPageName;
                this.indexPageName = this.indexPageName + "-frame";
            }
            this.makeAlbumForDirectory(inputDir, outputDir, 0);
            this.globalVariables.put("executedNormally", new Boolean(true));
            if (!this.isAppendImages()) {
                lastProps.put("imageSettingsHash", imageSettingsHash);
                lastProps.save();
            }
        }
        finally {
            if (this.frames) {
                this.frames = false;
                this.indexPageName = this.framesetPageName;
                this.framesetPageName = null;
            }
            this.processBeanShellFile(new File(this.skinDir, "finally.bsh"), this.globalVariables);
            this.processBeanShellFile(new File(this.cfg.progDir, "system/finally.bsh"), this.globalVariables);
        }
        inputDir = null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    private void makeIndexPages(File imageDir, File outputDir, File[] files, File[] filesOnly, int level) throws IOException, ElementException {
        File framesetFile;
        this.files = files;
        this.imagesPerIndex = this.rows * this.cols;
        if (this.rows == 0) {
            this.imagesPerIndex = 999 * this.cols;
        }
        int totalIndexes = (int)Math.ceil((double)files.length / (double)this.imagesPerIndex);
        if (files.length == 0) {
            return;
        }
        Scope dirVars = new Scope(this.globalVariables);
        dirVars.put("level", new Integer(level));
        this.addAlbumObjectProperties(imageDir, dirVars);
        dirVars.put("imageDirectory", imageDir);
        dirVars.put("outputDirectory", outputDir);
        dirVars.put("firstIndexPage", this.encode(this.getIndexName(0)));
        dirVars.put("lastIndexPage", this.encode(this.getIndexName(totalIndexes - 1)));
        dirVars.put("files", files);
        dirVars.put("fileVariables", this.fileVariables);
        dirVars.put("totalImages", new Integer(filesOnly.length));
        dirVars.put("currentDate", this.df.format(new Date()));
        Map parentVars = (Map)this.fileVariables.get(imageDir);
        if (parentVars != null && !this.frames) {
            dirVars.put("parentIndexPage", "../" + parentVars.get("indexPage"));
        } else {
            String parentWeb = this.getExistingWeb(outputDir.getParentFile());
            if (parentWeb != null) {
                dirVars.put("parentIndexPage", "../" + parentWeb);
            }
        }
        String rootPath = IO.relativePath(this.rootOutputDir, outputDir);
        dirVars.put("rootPath", rootPath);
        dirVars.put("resPath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) : GIFS_DIR);
        dirVars.put("stylePath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) + '/' + STYLES_FILE : STYLES_FILE);
        if (this.resDir == null) {
            File styleFile = new File(this.skinDir, "styles/" + this.style);
            if (this.style != null && styleFile.exists()) {
                this.processTemplateFile(styleFile, new File(outputDir, STYLES_FILE), dirVars.push(this.extras));
            }
        }
        if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
            this.processTemplateFile(framesetFile, new File(outputDir, this.framesetPageName + this.pageExtension), dirVars.push(this.extras));
        }
        this.indexNum = 0;
        while (this.indexNum < totalIndexes) {
            this.indexVariables = new Scope(dirVars);
            this.indexVariables.put("indexPage", this.encode(this.getIndexName(this.indexNum)));
            this.indexImageCount = Math.min(this.imagesPerIndex, files.length - this.indexNum * this.imagesPerIndex);
            this.indexVariables.put("indexImageCount", new Integer(this.indexImageCount));
            this.currentRows = (int)Math.ceil((double)this.indexImageCount / (double)this.cols);
            this.indexVariables.put("currentRows", new Integer(this.currentRows));
            if (totalIndexes > 1) {
                this.indexVariables.put("indexNum", new Integer(this.indexNum + 1));
                this.indexVariables.put("totalIndexes", new Integer(totalIndexes));
                if (this.indexNum > 0) {
                    this.indexVariables.put("previousIndexPage", this.encode(this.getIndexName(this.indexNum - 1)));
                }
                if (this.indexNum < totalIndexes - 1) {
                    this.indexVariables.put("nextIndexPage", this.encode(this.getIndexName(this.indexNum + 1)));
                }
            }
            for (int i = this.indexNum * this.imagesPerIndex; i < files.length && i < this.imagesPerIndex * (this.indexNum + 1); ++i) {
                Scope locals = (Scope)this.fileVariables.get(files[i]);
                locals.setOuter(this.indexVariables);
                locals.put("imageNum", new Integer(i + 1));
                locals.put("currentFile", files[i]);
                locals.put("current", this.fileVariables.get(files[i]));
                locals.put("local", locals.getMap());
                if (i > 0) {
                    locals.put("previous", this.fileVariables.get(files[i - 1]));
                }
                if (i < files.length - 1) {
                    locals.put("next", this.fileVariables.get(files[i + 1]));
                }
                this.addFilteredImageSizes(files[i], locals);
            }
            String template = this.indexTemplate.toString(this.indexVariables.push(this.extras));
            StringBuilder buf = new StringBuilder();
            this.parser.reset();
            this.parser.putAll(this.indexVariables.push(this.extras));
            if (this.suppressIEWarnings) {
                template = this.injectSuppressWarningsCode(template);
            }
            if (this.mediaRSS) {
                template = this.injectMediaRssCode(template, false);
            }
            if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
                template = this.injectWidgetCode(template, DEFAULT_INDEX_PAGE_NAME, rootPath);
            }
            this.parser.parseElements(template, buf);
            String indexContent = buf.toString();
            File f = new File(outputDir, this.getIndexName(this.indexNum));
            IO.writeChangedTextFile(indexContent, f, this.writeUTF8 ? "UTF-8" : this.textEncoding);
            if (this.mediaRSS) {
                File mediaRSSFile = new File(this.cfg.progDir, "system/album.rss");
                if (mediaRSSFile.exists()) {
                    dirVars.put("mediarssPath", mediaRSSPath);
                    dirVars.put("mediarssDate", this.mediaRssDf.format(new Date()));
                    this.processTemplateFile(mediaRSSFile, new File(outputDir, mediaRSSPath), dirVars.push(this.extras), "UTF-8");
                }
            } else {
                new File(outputDir, mediaRSSPath).delete();
            }
            ++this.indexNum;
        }
    }

    private String injectSuppressWarningsCode(String template) {
        int headIndex;
        String injectCode = "<!-- saved from url=(0014)about:internet -->";
        int i1 = template.indexOf("<head>");
        int i2 = template.indexOf("<HEAD>");
        if (i1 < 0) {
            i1 = Integer.MAX_VALUE;
        }
        if (i2 < 0) {
            i2 = Integer.MAX_VALUE;
        }
        if ((headIndex = Math.min(i1, i2)) < Integer.MAX_VALUE) {
            String firstPart = template.substring(0, headIndex);
            String lastPart = template.substring(headIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String injectMediaRssCode(String template, boolean slide) {
        int headIndex;
        String path = slide ? "../" : "";
        path = path.concat(mediaRSSPath);
        String injectCode = "<link rel=\"alternate\" href=\"" + path + "\" type=\"application/rss+xml\"" + (AlbumBean.isXHTML(template) ? "/>" : ">");
        int i1 = template.indexOf("</head>");
        int i2 = template.indexOf("</HEAD>");
        if (i1 < 0) {
            i1 = Integer.MAX_VALUE;
        }
        if (i2 < 0) {
            i2 = Integer.MAX_VALUE;
        }
        if ((headIndex = Math.min(i1, i2)) < Integer.MAX_VALUE) {
            String firstPart = template.substring(0, headIndex);
            String lastPart = template.substring(headIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String injectWidgetCode(String template, String pageType, String rootPath) {
        int i2;
        String injectCode = this.getWidgetInjectionCode(pageType, rootPath);
        int i1 = template.lastIndexOf("</body>");
        int bodyIndex = Math.max(i1, i2 = template.lastIndexOf("</BODY>"));
        if (bodyIndex > 0) {
            String firstPart = template.substring(0, bodyIndex);
            String lastPart = template.substring(bodyIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String getWidgetInjectionCode(String pageType, String rootPath) {
        StringBuilder injectionCode = new StringBuilder();
        String language = Config.getConfig().getLanguage();
        if (language.equals("default")) {
            language = System.getProperty("user.language");
        }
        injectionCode.append("<div id=\"jalbumwidgetcontainer\"></div>\n");
        injectionCode.append("<script type=\"text/javascript\" charset=\"utf-8\"><!--//--><![CDATA[//><!--\n");
        injectionCode.append("_jaSkin = \"");
        injectionCode.append(this.skin);
        injectionCode.append("\";\n");
        injectionCode.append("_jaStyle = \"");
        injectionCode.append(this.style);
        injectionCode.append("\";\n");
        injectionCode.append("_jaVersion = \"");
        injectionCode.append(PRODUCT_INTERNAL_VERSION);
        injectionCode.append("\";\n");
        injectionCode.append("_jaLanguage = \"");
        injectionCode.append(language);
        injectionCode.append("\";\n");
        injectionCode.append("_jaPageType = \"");
        injectionCode.append(pageType);
        injectionCode.append("\";\n");
        injectionCode.append("_jaRootPath = \"");
        injectionCode.append(rootPath);
        injectionCode.append("\";\n");
        if (this.userName != null && this.userName.length() > 0) {
            injectionCode.append("_jaUserName = \"");
            injectionCode.append(this.userName);
            injectionCode.append("\";\n");
        }
        injectionCode.append("var script = document.createElement(\"script\");\n");
        injectionCode.append("script.type = \"text/javascript\";\n");
        injectionCode.append("script.src = \"http://jalbum.net/widgetapi/load.js\";\n");
        injectionCode.append("document.getElementById(\"jalbumwidgetcontainer\").appendChild(script);\n");
        injectionCode.append("//--><!]]></script>\n");
        return injectionCode.toString();
    }

    private static boolean isXHTML(String doc) {
        int doctypeIndex = doc.indexOf("<!DOCTYPE");
        if (doctypeIndex == -1) {
            return doc.contains("/>");
        }
        int endTagIndex = doc.indexOf(62, doctypeIndex);
        if (endTagIndex == -1) {
            return false;
        }
        return doc.substring(doctypeIndex, endTagIndex).toUpperCase().indexOf("XHTML") > 0;
    }

    private void addFilteredImageSizes(File file, Scope vars) throws IOException {
        AlbumObject ao;
        boolean hasIcon = FileFilters.hasIcon(file);
        File repFile = IO.thumbFile(file);
        if (repFile.exists()) {
            hasIcon = false;
        }
        if ((repFile = (ao = this.albumObjectFactory.createInstance(file)).getRepresentingIconFile()) != null) {
            hasIcon = false;
        }
        int originalWidth = (Integer)vars.get("originalWidth");
        int originalHeight = (Integer)vars.get("originalHeight");
        String orientation = (String)vars.get("orientation");
        if (orientation == null && repFile != null) {
            try {
                orientation = RotationSupport.getOrientationAsString(repFile);
            }
            catch (IOException ok) {
            }
            catch (Throwable t) {
                System.err.println("File " + repFile + " has broken data structures. Orientation data ignored");
            }
        }
        Dimension imageDim = orientation != null && !orientation.equals("normal") && originalWidth > originalHeight ? new Dimension(originalHeight, originalWidth) : new Dimension(originalWidth, originalHeight);
        Dimension closeupDim = imageDim;
        FilterList stack = (FilterList)ao.getProperties().get("filterList");
        FilterRenderer filterRenderer = null;
        if (stack != null) {
            filterRenderer = new FilterRenderer();
            filterRenderer.setFilterList(stack);
        }
        if (!this.getImageLinking(vars).equals(LINK_ORIGINALS)) {
            if (!hasIcon) {
                imageDim = this.getFilteredSize(filterRenderer, imageDim, vars, 1);
                imageDim = closeupDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.imageDim);
                imageDim = this.getFilteredSize(filterRenderer, imageDim, vars, 2);
                closeupDim = this.getFilteredSize(filterRenderer, imageDim, vars, 3);
            }
            vars.put("imageWidth", new Integer(closeupDim.width));
            vars.put("imageHeight", new Integer(closeupDim.height));
        } else {
            vars.put("imageWidth", new Integer(originalWidth));
            vars.put("imageHeight", new Integer(originalHeight));
        }
        Dimension thumbDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.thumbDim);
        if (!hasIcon) {
            imageDim = this.getFilteredSize(filterRenderer, imageDim, vars, 4);
            thumbDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.thumbDim);
            thumbDim = this.getFilteredSize(filterRenderer, thumbDim, vars, 5);
        }
        vars.put("thumbWidth", new Integer(thumbDim.width));
        vars.put("thumbHeight", new Integer(thumbDim.height));
    }

    static Replacer fillReplacer(Replacer replacer, Map variables) {
        for (Map.Entry e : variables.entrySet()) {
            if (e.getValue() == null || e.getValue() instanceof Map) continue;
            replacer.add("$" + (String)e.getKey(), e.getValue().toString());
        }
        return replacer;
    }

    private String getJAlbumWeb() {
        return (this.framesetPageName != null ? this.framesetPageName : this.indexPageName) + this.pageExtension;
    }

    private String getExistingWeb(File dir) {
        String[] indexFiles = new String[]{this.getJAlbumWeb(), "index.htm", "index.html", "index.jsp", "index.asp", "index.php3"};
        for (int i = 0; i < indexFiles.length; ++i) {
            File test = new File(dir, indexFiles[i]);
            if (!test.exists()) continue;
            return indexFiles[i];
        }
        return null;
    }

    public static String jpegName(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        String ext = name.substring(dotIndex + 1).toLowerCase();
        if (!ext.equals("jpg") && !ext.equals("jpeg")) {
            return name.substring(0, dotIndex) + ".jpg";
        }
        return name;
    }

    private void adjustImageLinks(File outputDir, File[] files) throws IOException {
        if (this.slides) {
            File slidesDir = new File(outputDir, this.slideDirectory);
            String resPath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) : "../gifs";
            String stylePath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) + '/' + STYLES_FILE : "../styles.css";
            for (int i = 0; i < files.length; ++i) {
                Scope locals = (Scope)this.fileVariables.get(files[i]);
                locals.put("resPath", resPath);
                locals.put("stylePath", stylePath);
                this.addImageLinks(files[i], locals, outputDir, new File(outputDir, this.slideDirectory), true);
                locals.put("files", files);
                locals.put("current", this.fileVariables.get(files[i]));
                locals.put("local", locals.getMap());
                if (i > 0) {
                    locals.put("previous", this.fileVariables.get(files[i - 1]));
                }
                if (i < files.length - 1) {
                    locals.put("next", this.fileVariables.get(files[i + 1]));
                }
                locals.put("imageNum", new Integer(i + 1));
                locals.put("currentFile", files[i]);
                locals.put("totalImages", new Integer(files.length));
                if (i > 0) {
                    locals.put("previousPage", this.encode(this.getSlideName(files[i - 1])));
                }
                locals.put("currentPage", this.encode(this.getSlideName(files[i])));
                if (i < files.length - 1) {
                    locals.put("nextPage", this.encode(this.getSlideName(files[i + 1])));
                }
                locals.put("firstPage", this.encode(this.getSlideName(files[0])));
                locals.put("lastPage", this.encode(this.getSlideName(files[files.length - 1])));
            }
        }
    }

    private void makeThumbs(Counter c, File dir, File outputDir, File[] files) throws IOException, OperationAbortedException, ElementException {
        File thumbsDir = new File(outputDir, this.thumbDirectory);
        thumbsDir.mkdir();
        String rootPath = IO.relativePath(this.rootOutputDir, thumbsDir);
        int i = c.next();
        while (i < files.length) {
            Scope locals = (Scope)this.fileVariables.get(files[i]);
            String il = this.getImageLinking(locals);
            if (!outputDir.equals(files[i].getParentFile()) && (this.copyOriginals && !il.equals(LINK_SCALED) || il.equals(LINK_SCALED) && !AlbumBean.isSupported(files[i]))) {
                IO.copyFile(files[i], outputDir, !this.appendImages);
            }
            if (this.slides) {
                this.makeSlide(files, i, rootPath);
            }
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir, IO.relativePath(dir, this.rootImageDir.getParentFile()), files[i].getName(), i + 1, files.length, this.processedFiles, this.totalFiles);
            this.fireImageProcessingStarted(eventObject);
            File file = files[i];
            File repFile = IO.thumbFile(file);
            boolean mediaFile = "Media file".equals(FileFilters.getFileCategory(file));
            if (repFile.exists()) {
                file = repFile;
            }
            if (repFile.exists() || AlbumBean.isSupported(files[i])) {
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                File thumbFile = new File(thumbsDir, this.thumbnailPrefix + AlbumBean.jpegName(files[i].getName()));
                File scaledFile = new File(this.slidesDir, this.closeupPrefix + AlbumBean.jpegName(files[i].getName()));
                try {
                    BufferedImage original;
                    AlbumObject ao = this.albumObjectFactory.createInstance(file);
                    FilterList stack = (FilterList)ao.getProperties().get("filterList");
                    FilterRenderer filterRenderer = null;
                    if (stack != null) {
                        filterRenderer = new FilterRenderer();
                        filterRenderer.setFilterList(stack);
                    }
                    if (!this.appendImages || AlbumBean.isDirty(thumbFile, ao) || !il.equals(LINK_ORIGINALS) && AlbumBean.isDirty(scaledFile, ao)) {
                        int scale = 1;
                        if (!this.scalingMethod.equals(SCALE_SMOOTH)) {
                            scale = FileFilters.calculateSubsamplingByScale(file, this.imageDim);
                        }
                        if ((original = FileFilters.loadImage(file, scale)).getWidth() > original.getHeight()) {
                            original = RotationSupport.adjustOrientation(original, (String)locals.get("orientation"));
                        }
                        if (!il.equals(LINK_ORIGINALS)) {
                            String ext = IO.extensionOf(file).toLowerCase();
                            if (("jpeg".equals(ext) || "jpg".equals(ext)) && (double)original.getWidth() <= this.imageDim.getWidth() && (double)original.getHeight() <= this.imageDim.getHeight() && (stack == null || stack.getPosition() == 0) && this.filters.size() == 0) {
                                IO.copyFile(file, scaledFile, !this.appendImages);
                            } else {
                                BufferedImage bi = this.processFilters(filterRenderer, original, locals, 1);
                                bi = this.scaleToFit(bi, this.imageDim, this.getScalingMethod());
                                bi = this.processFilters(filterRenderer, bi, locals, 2);
                                original.flush();
                                original = bi;
                                BufferedImage tmpImage = this.processFilters(filterRenderer, bi, locals, 3);
                                if (repFile.exists() && mediaFile) {
                                    if (tmpImage == bi) {
                                        tmpImage = AlbumBean.copyImage(bi);
                                    }
                                    Graphics g = tmpImage.getGraphics();
                                    g.drawImage(filmImage, 1, 2, null);
                                    g.dispose();
                                }
                                IIOMetadata meta = null;
                                if (this.keepMetaData) {
                                    ImageInputStream iis = ImageIO.createImageInputStream(file);
                                    Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(file));
                                    if (it.hasNext()) {
                                        ImageReader ir = it.next();
                                        ir.setInput(iis);
                                        meta = ir.getImageMetadata(ir.getMinIndex());
                                    }
                                }
                                FileFilters.saveJPEG(tmpImage, scaledFile, this, meta);
                                this.lastImageSize = this.imageSize;
                            }
                        }
                    } else {
                        original = null;
                    }
                    if (!this.appendImages || AlbumBean.isDirty(thumbFile, ao)) {
                        BufferedImage bi = this.processFilters(filterRenderer, original, locals, 4);
                        BufferedImage thumb = this.scaleToFit(bi, this.thumbDim, this.highQualityThumbs ? SCALE_SMOOTH : this.getScalingMethod());
                        if (repFile.exists() && mediaFile) {
                            Graphics g = thumb.getGraphics();
                            g.drawImage(filmImage, 1, 2, null);
                            g.dispose();
                        }
                        bi = this.processFilters(filterRenderer, thumb, locals, 5);
                        FileFilters.saveJPEG(bi, thumbFile, this);
                        this.lastThumbSize = this.thumbSize;
                    }
                }
                catch (Exception ex) {
                    this.fireErrorOccured(ex, files[i]);
                }
            }
            eventObject = new AlbumBeanEvent(this, dir, IO.relativePath(dir, this.rootImageDir.getParentFile()), files[i].getName(), i + 1, files.length, ++this.processedFiles, this.totalFiles);
            this.fireImageProcessingFinished(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            i = c.next();
        }
    }

    private static boolean isDirty(File dest, AlbumObject source) {
        if (!dest.exists()) {
            return true;
        }
        return source.getLastModified() > dest.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSlide(File[] files, int i, String rootPath) throws IOException, ElementException {
        Scope locals = (Scope)this.fileVariables.get(files[i]);
        Scope allLocals = locals.push(this.extras);
        locals.put("currentDate", this.df.format(new Date()));
        locals.put("rootPath", rootPath);
        String template = this.slideTemplate.toString(allLocals);
        if (this.suppressIEWarnings) {
            template = this.injectSuppressWarningsCode(template);
        }
        if (this.mediaRSS) {
            template = this.injectMediaRssCode(template, true);
        }
        if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
            template = this.injectWidgetCode(template, "slide", rootPath);
        }
        TemplateParser templateParser = this.parser;
        synchronized (templateParser) {
            this.parser.reset();
            this.parser.putAll(allLocals);
            String slideContent = this.parser.parseElements(template);
            File f = new File(this.slidesDir, this.getSlideName(files[i]));
            IO.writeChangedTextFile(slideContent, f, this.writeUTF8 ? "UTF-8" : this.textEncoding);
        }
    }

    private void addImageInfo(File file, Metadata metadata, Map variables) throws MetadataException {
        ExifDescriptor desc;
        Directory dir;
        this.formatter.setMetadata(metadata);
        this.formatter.setDateFormat(this.df);
        if (metadata.containsDirectory(ExifDirectory.class)) {
            dir = metadata.getDirectory(ExifDirectory.class);
            desc = new ExifDescriptor(dir);
            String comment = null;
            if (this.exifUserComment) {
                comment = desc.getUserCommentDescription();
            }
            if (this.exifImageDescription && !AlbumBean.exists(comment)) {
                comment = (String)this.formatter.format(270);
            }
            variables.put("comment", comment);
            variables.put("originalDate", this.formatter.format(36867));
            variables.put("resolution", this.formatter.format(40962) + " x " + this.formatter.format(40963));
            variables.put("flash", desc.getFlashDescription());
            variables.put("focalLength", this.formatter.format(37386));
            String focalLength35mm = (String)this.formatter.format(41989);
            if (focalLength35mm != null) {
                variables.put("focalLength35mm", focalLength35mm);
            }
            variables.put("exposureTime", this.formatter.format(33434));
            variables.put("aperture", this.formatter.format(33437));
            variables.put("focusDistance", this.formatter.format(37382));
            variables.put("meteringMode", desc.getDescription(37383));
            variables.put("cameraMake", this.formatter.format(271));
            variables.put("cameraModel", this.formatter.format(272));
            variables.put("sensorType", this.formatter.format(41495));
            variables.put("compressionLevel", this.formatter.format(37122));
            variables.put("originalWidthDpi", this.formatter.format(282));
            variables.put("originalHeightDpi", this.formatter.format(283));
            variables.put("isoEquivalent", this.formatter.format(34855));
            variables.put("orientation", dir.getString(274));
        }
        if (metadata.containsDirectory(GpsDirectory.class)) {
            dir = metadata.getDirectory(GpsDirectory.class);
            desc = new GpsDescriptor(dir);
            variables.put("foo", "bar");
            variables.put("gpsLongitude", desc.getGpsLongitudeDescription());
            variables.put("gpsLatitude", desc.getGpsLatitudeDescription());
            variables.put("gpsAltitude", desc.getGpsAltitudeDescription());
        }
        String author = "";
        String photographer = "";
        String objectName = "";
        String keywords = "";
        String copyright = "";
        String category = "";
        if (metadata.containsDirectory(IptcDirectory.class)) {
            Directory dir2 = metadata.getDirectory(IptcDirectory.class);
            String iptcComment = dir2.getString(632);
            if (this.iptcCaption && AlbumBean.exists(iptcComment)) {
                variables.put("comment", iptcComment);
            }
            author = dir2.getString(634);
            photographer = dir2.getString(592);
            objectName = dir2.getString(517);
            keywords = dir2.getString(537);
            copyright = dir2.getString(628);
            category = dir2.getString(527);
        }
        variables.put("author", author);
        variables.put("writer", author);
        variables.put("photographer", photographer);
        variables.put("objectName", objectName);
        variables.put("keywords", keywords);
        variables.put("copyright", copyright);
        variables.put("category", category);
        if (metadata.containsDirectory(ExifDirectory.class) || metadata.containsDirectory(IptcDirectory.class)) {
            variables.put("meta", new MetaObjectCache(file, null));
        }
    }

    static Map getMetaObjectContent(Metadata imageInfo) {
        PrintSafeHashMap meta = new PrintSafeHashMap();
        Iterator dirs = imageInfo.getDirectoryIterator();
        while (dirs.hasNext()) {
            Directory dir = (Directory)dirs.next();
            String prefix = dir.getName() + ".";
            if (prefix.equalsIgnoreCase("exif.")) {
                prefix = "";
            }
            Iterator it = dir.getTagIterator();
            while (it.hasNext()) {
                Tag tag = (Tag)it.next();
                try {
                    meta.put(prefix + tag.getTagName(), tag.getDescription());
                }
                catch (MetadataException ex) {}
            }
        }
        return meta;
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    private String getSlideName(File file) {
        String imageFileName = file.getName();
        String base = IO.baseName(imageFileName);
        return base + this.pageExtension;
    }

    private String getIndexName(int indexNum) {
        if (indexNum == 0) {
            return this.indexPageName + this.pageExtension;
        }
        return this.indexPageName + (indexNum + 1) + this.pageExtension;
    }

    BufferedImage createBufferedImage(Image img) {
        int iw = img.getWidth(this);
        int ih = img.getHeight(this);
        return this.createBufferedImage(img, iw, ih);
    }

    private BufferedImage createBufferedImage(Image img, int iw, int ih) {
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return bi;
    }

    static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale), (int)((double)height / maxScale));
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return this.createBufferedImage(image);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        ImageScaler scaler = ImageScaler.getScaler(method, this.isHardwareScaling());
        BufferedImage bufImage = scaler.scale(image, newWidth, newHeight);
        image.flush();
        if (this.sharpenPercent >= 5 && !SCALE_FAST.equals(method)) {
            BufferedImageOp sharpenOp = AlbumBean.getSharpenOperation(this.sharpenPercent);
            bufImage = sharpenOp.filter(bufImage, null);
        }
        try {
            System.gc();
            Thread.sleep(20L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        return bufImage;
    }

    private static BufferedImageOp getSharpenOperation(int percent) {
        float[] sharpenKernel = new float[]{-0.083333336f, -0.25f, -0.083333336f, -0.25f, 2.3333333f, -0.25f, -0.083333336f, -0.25f, -0.083333336f};
        float[] originalKernel = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] resultingKernel = new float[9];
        float w = (float)((double)percent / 120.0);
        for (int i = 0; i < resultingKernel.length; ++i) {
            resultingKernel[i] = w * sharpenKernel[i] + (1.0f - w) * originalKernel[i];
        }
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, resultingKernel), 1, null);
        return op;
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    private static Dimension parseSize(String sizeString) throws ParameterException {
        String size = sizeString.toLowerCase();
        StringTokenizer tokens = new StringTokenizer(size, "x ");
        try {
            int w = Integer.parseInt(tokens.nextToken());
            int h = Integer.parseInt(tokens.nextToken());
            if (w < 0 || h < 0) {
                throw new Exception();
            }
            return new Dimension(w, h);
        }
        catch (Exception ex) {
            throw new ParameterException(Msg.get("engine.invalidSizeError", sizeString));
        }
    }

    private String encode(String s) {
        if (!this.urlEncode) {
            return s;
        }
        return IO.urlEncode(s);
    }

    static boolean isSupported(File file) {
        return FileFilters.isFileSupported(file);
    }

    public synchronized void removeAlbumBeanListener(AlbumBeanListener l) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l)) {
            Vector v = (Vector)this.albumBeanListeners.clone();
            v.removeElement(l);
            this.albumBeanListeners = v;
        }
    }

    public synchronized void addAlbumBeanListener(AlbumBeanListener l) {
        Vector v;
        Vector vector = v = this.albumBeanListeners == null ? new Vector(2) : (Vector)this.albumBeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.albumBeanListeners = v;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addFilter(JAFilter filter) {
        this.addFilter(filter, 2);
    }

    public Iterator filterIterator(int stage) {
        Iterator all = this.filters.iterator();
        LinkedList<JAFilter> matching = new LinkedList<JAFilter>();
        while (all.hasNext()) {
            JAFilterNode node = (JAFilterNode)all.next();
            if (node.getStage() != stage) continue;
            matching.addLast(node.getFilter());
        }
        return matching.iterator();
    }

    public boolean addFilter(JAFilter filter, int stage) {
        this.filters.addLast(new JAFilterNode(filter, stage));
        return true;
    }

    public boolean removeFilter(JAFilter filter, int stage) {
        return this.filters.remove(new JAFilterNode(filter, stage));
    }

    public void removeAllFilters() {
        this.filters = new LinkedList();
    }

    private static BufferedImage copyImage(BufferedImage im) {
        BufferedImage bi = new BufferedImage(im.getWidth(), im.getHeight(), 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)im, 0, 0, null);
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage processFilters(FilterRenderer filterRenderer, BufferedImage im, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        vars = vars.push(this.extras);
        if (filterRenderer != null && stage == 1) {
            im = filterRenderer.applyPrescaleFilters(im);
        } else if (filterRenderer != null && stage == 2) {
            im = filterRenderer.applyPostscaleFilters(im);
        }
        boolean isACopy = false;
        for (JAFilterNode node : this.filters) {
            JAFilter filter;
            if (node.getStage() != stage) continue;
            if (stage == 3 && !isACopy) {
                im = AlbumBean.copyImage(im);
                isACopy = true;
            }
            JAFilter jAFilter = filter = node.getFilter();
            synchronized (jAFilter) {
                im = filter.filter(im, vars);
            }
        }
        return im;
    }

    Dimension getFilteredSize(FilterRenderer fr, Dimension size, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        vars = vars.push(this.extras);
        if (fr != null) {
            if (stage == 1) {
                size = fr.getPrescaleFilteredSize(size);
            } else if (stage == 2) {
                size = fr.getPostscaleFilteredSize(size);
            }
        }
        for (JAFilterNode node : this.filters) {
            if (node.getStage() != stage || !(node.getFilter() instanceof ModifiesSize)) continue;
            size = ((ModifiesSize)((Object)node.getFilter())).getModifiedSize(size, vars);
        }
        return size;
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Throwable t, File f) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).errorOccured(t, f);
            }
        }
    }

    public void setSubdirs(boolean newSubdirs) {
        this.subdirs = newSubdirs;
    }

    public boolean isSubdirs() {
        return this.subdirs;
    }

    public void setAppendImages(boolean newAppendImages) {
        this.appendImages = newAppendImages;
    }

    public boolean isAppendImages() {
        return this.appendImages;
    }

    public void setUpdatedDirsOnly(boolean newUpdatedDirsOnly) {
        this.updatedDirsOnly = newUpdatedDirsOnly;
    }

    public boolean isUpdatedDirsOnly() {
        return this.updatedDirsOnly;
    }

    public void setExcludeByDefault(boolean newExcludeByDefault) {
        this.excludeByDefault = newExcludeByDefault;
    }

    public boolean isExcludeByDefault() {
        return this.excludeByDefault;
    }

    public void setKeepMetaData(boolean newKeepMetaData) {
        this.keepMetaData = newKeepMetaData;
    }

    public boolean isKeepMetaData() {
        return this.keepMetaData;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyle() {
        return this.style;
    }

    public void setIndexPageName(String newIndexPageName) {
        this.indexPageName = newIndexPageName.trim();
    }

    public String getIndexPageName() {
        return this.indexPageName;
    }

    public void setUrlEncode(boolean newUrlEncode) {
        this.urlEncode = newUrlEncode;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setImageOrdering(String newImageOrdering) {
        this.imageOrdering = newImageOrdering.equals(ORDER_BY_DATE) ? ORDER_BY_DATE : (newImageOrdering.equals(ORDER_BY_NAME) ? ORDER_BY_NAME : ORDER_BY_SIMPLE_NAME);
        this.customImageOrdering = null;
    }

    public String getImageOrdering() {
        return this.imageOrdering;
    }

    public void setCustomImageOrdering(Comparator fileComparator) {
        this.customImageOrdering = fileComparator;
    }

    public Comparator getCustomImageOrdering() {
        return this.customImageOrdering;
    }

    public void setMediaRSS(boolean newMediaRSS) {
        this.mediaRSS = newMediaRSS;
    }

    public boolean isMediaRSS() {
        return this.mediaRSS;
    }

    public void setWidgetInjection(boolean newWidgetInjection) {
        this.widgetInjection = newWidgetInjection;
    }

    public boolean isWidgetInjection() {
        return this.widgetInjection;
    }

    public boolean isSuppressIEWarnings() {
        return this.suppressIEWarnings;
    }

    public void setSuppressIEWarnings(boolean supressIEWarnings) {
        this.suppressIEWarnings = supressIEWarnings;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setMetaData(boolean newMetaData) {
        this.metaData = newMetaData;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    public void setSameDirectory(boolean newSameDirectory) {
        this.sameDirectory = newSameDirectory;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setOutputDirectory(String newOutputDirectory) {
        this.outputDirectory = newOutputDirectory;
    }

    public String getOutputDirectory() {
        return this.sameDirectory ? this.directory : this.outputDirectory;
    }

    public File getInterpretedOutputDirectory() {
        File f = new File(this.getOutputDirectory());
        if (!f.isAbsolute()) {
            f = new File(this.directory, this.outputDirectory);
        }
        return f;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setImageLinking(String newImageLinking) {
        this.imageLinking = newImageLinking.equals(LINK_ORIGINALS) ? LINK_ORIGINALS : (newImageLinking.equals(LINK_ORIGINALS_VIA_SCALED) ? LINK_ORIGINALS_VIA_SCALED : LINK_SCALED);
    }

    public String getImageLinking() {
        return this.imageLinking;
    }

    private String getImageLinking(Scope vars) {
        Boolean b = (Boolean)(vars != null ? vars.get("includeOriginal") : null);
        if (b != null && b.booleanValue() && this.imageLinking.equals(LINK_SCALED)) {
            return LINK_ORIGINALS_VIA_SCALED;
        }
        return this.imageLinking;
    }

    public void setCopyOriginals(boolean newCopyOriginals) {
        this.copyOriginals = newCopyOriginals;
    }

    public boolean isCopyOriginals() {
        return this.copyOriginals;
    }

    public void setSkin(String newSkin) {
        this.skin = newSkin;
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.srcResDir = new File(this.skinDir, "res");
        this.skinProperties = new SkinProperties(this.skinDir);
    }

    public String getSkin() {
        return this.skin;
    }

    public void setPageExtension(String newPageExtension) {
        this.pageExtension = newPageExtension.trim();
    }

    public String getPageExtension() {
        return this.pageExtension;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getThumbnailDirectory() {
        return this.thumbDirectory;
    }

    public String getCloseupDirectory() {
        return this.closeupDirectory;
    }

    public String getSlideDirectory() {
        return this.slideDirectory;
    }

    public String getThumbnailPrefix() {
        return this.thumbnailPrefix;
    }

    public String getCloseupPrefix() {
        return this.closeupPrefix;
    }

    public void setTextFileComment(boolean newtextFileComment) {
        this.textFileComment = newtextFileComment;
    }

    public boolean isTextFileComment() {
        return this.textFileComment;
    }

    public void setJpegComment(boolean newjpegComment) {
        this.jpegComment = newjpegComment;
    }

    public boolean isJpegComment() {
        return this.jpegComment;
    }

    public void setIptcCaption(boolean newiptcCaption) {
        this.iptcCaption = newiptcCaption;
    }

    public boolean isIptcCaption() {
        return this.iptcCaption;
    }

    public void setExifUserComment(boolean newexifUserComment) {
        this.exifUserComment = newexifUserComment;
    }

    public boolean isExifUserComment() {
        return this.exifUserComment;
    }

    public void setHighQualityThumbs(boolean newhighQualityThumbs) {
        this.highQualityThumbs = newhighQualityThumbs;
    }

    public boolean isHighQualityThumbs() {
        return this.highQualityThumbs;
    }

    public void setExifImageDescription(boolean newexifImageDescription) {
        this.exifImageDescription = newexifImageDescription;
    }

    public boolean isExifImageDescription() {
        return this.exifImageDescription;
    }

    public void setIncludeDirectories(boolean newIncludeDirectories) {
        this.includeDirectories = newIncludeDirectories;
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setUserVariables(Map newUserVariables) {
        this.userVariables = newUserVariables;
        File f = new File(this.skinDir, "onload.bsh");
        if (f.exists()) {
            for (Map.Entry entry : this.userVariables.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                entry.setValue(this.interpretDataType((String)entry.getValue()));
            }
        }
        this.extras = new PrintSafeHashMap();
        this.extras.putAll(this.userVariables);
        this.extras.putAll(this.skinVariables);
    }

    public void setSkinVariables(Map newSkinVariables) {
        this.skinVariables = newSkinVariables;
        for (Map.Entry entry : this.skinVariables.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(this.interpretDataType((String)entry.getValue()));
        }
        this.extras = new PrintSafeHashMap();
        this.extras.putAll(this.userVariables);
        this.extras.putAll(this.skinVariables);
    }

    private Object interpretDataType(String s) {
        if (s.indexOf(0) == 34 && s.length() >= 2) {
            return s.substring(1, s.length() - 2);
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        try {
            return new Integer(s);
        }
        catch (NumberFormatException ex) {
            try {
                return new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                return s;
            }
        }
    }

    public Map getUserVariables() {
        return this.userVariables;
    }

    public Map getSkinVariables() {
        return this.skinVariables;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim();
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setAccountProfileName(String newAccountProfileName) {
        String oldName = this.accountProfileName;
        this.accountProfileName = newAccountProfileName;
        this.firePropertyChange("accountProfileName", oldName, newAccountProfileName);
    }

    public String getAccountProfileName() {
        return this.accountProfileName;
    }

    public void setReverseOrder(boolean newReverseOrder) {
        this.reverseOrder = newReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setCharacterEncoding(String newCharacterEncoding) {
        this.characterEncoding = newCharacterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setTextEncoding(String newTextEncoding) {
        this.textEncoding = newTextEncoding;
        System.setProperty("file.encoding", this.textEncoding);
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setWriteUTF8(boolean newWriteUTF8) {
        this.writeUTF8 = newWriteUTF8;
    }

    public boolean isWriteUTF8() {
        return this.writeUTF8;
    }

    public void setDirectoriesFirst(boolean newDirectoriesFirst) {
        this.directoriesFirst = newDirectoriesFirst;
    }

    public boolean isDirectoriesFirst() {
        return this.directoriesFirst;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    static void setVars(Map variables, Interpreter interpreter) throws ElementException {
        Iterator it = variables.entrySet().iterator();
        try {
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String name = (String)e.getKey();
                if (name.indexOf(46) != -1) continue;
                Object val = e.getValue();
                if (val instanceof Integer) {
                    interpreter.set(name, ((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Long) {
                    interpreter.set(name, ((Long)val).longValue());
                    continue;
                }
                if (val instanceof Float) {
                    interpreter.set(name, ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Double) {
                    interpreter.set(name, ((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    interpreter.set(name, ((Boolean)val).booleanValue());
                    continue;
                }
                interpreter.set(name, val);
            }
        }
        catch (EvalError e) {
            throw new ElementException(e.getMessage());
        }
    }

    public void setUsing(Object using) {
        this.using = using;
    }

    public String getScalingMethod() {
        return this.scalingMethod;
    }

    public void setScalingMethod(String scalingMethod) {
        this.scalingMethod = scalingMethod;
    }

    public boolean isHardwareScaling() {
        return this.hardwareScaling;
    }

    public void setHardwareScaling(boolean hardwareScaling) {
        this.hardwareScaling = hardwareScaling;
    }

    class TemplateParser {
        private Map variables = new HashMap();
        int imageNum;
        Set includedPages = new HashSet();
        Set evaluatedDefinitions = new HashSet();
        private final String[] names = new String[]{"ja:ignore", "ja:if", "ja:switch", "ja:eval", "%", "ja:include", "ja:rowiterator", "ja:coliterator", "ja:fileiterator", "ja:widget"};

        public TemplateParser() {
        }

        public TemplateParser(Map variables) throws ElementException {
            this();
            this.putAll(variables);
        }

        public void putAll(Map variables) throws ElementException {
            this.variables.putAll(variables);
            AlbumBean.setVars(variables, AlbumBean.this.interpreter);
        }

        public void reset() throws ElementException {
            try {
                for (String name : this.variables.keySet()) {
                    if (name.indexOf(46) != -1) continue;
                    AlbumBean.this.interpreter.unset(name);
                }
                this.variables.clear();
            }
            catch (EvalError e) {
                throw new ElementException(e.getMessage());
            }
        }

        public void removeAll(Collection variableKeys) throws ElementException {
            try {
                this.variables.keySet().removeAll(variableKeys);
                for (String name : variableKeys) {
                    if (name.indexOf(46) != -1) continue;
                    AlbumBean.this.interpreter.unset(name);
                }
            }
            catch (EvalError e) {
                throw new ElementException(e.getMessage());
            }
        }

        public Map getVariables() {
            return this.variables;
        }

        public String parseElements(String doc) throws ElementException {
            StringBuilder buf = new StringBuilder();
            this.parseElements(doc, buf);
            return buf.toString();
        }

        public void parseElements(String doc, StringBuilder buf) throws ElementException {
            block15: {
                try {
                    doc = Elements.stripJSPComments(doc);
                    Element elem = Elements.getNextElement(this.names, doc, true);
                    if (elem == null) {
                        buf.append(doc);
                        return;
                    }
                    buf.append(elem.getPreElement());
                    if (elem.getName().equals("ja:if")) {
                        this.handleIfElse(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:switch")) {
                        this.handleSwitch(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:ignore")) {
                        this.handleIgnore(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:include")) {
                        this.handleInclude(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:eval")) {
                        this.handleEval(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("%")) {
                        this.handleScriptlet(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("$")) {
                        this.handleExpressionLanguage(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:rowiterator")) {
                        this.handleRowIterator(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:coliterator")) {
                        this.handleColIterator(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:fileiterator")) {
                        this.handleFileIterator(elem, buf);
                        break block15;
                    }
                    if (elem.getName().equals("ja:widget")) {
                        this.handleWidget(elem, buf);
                        break block15;
                    }
                    throw new ElementException(Msg.get("scripting.unknownElementError") + elem.getName());
                }
                catch (EvalError ex) {
                    throw new ElementException(ex.getMessage());
                }
                catch (UtilEvalError ex) {
                    throw new ElementException(ex.getMessage());
                }
            }
        }

        private void handleRowIterator(Element rowIterator, StringBuilder buf) throws ElementException {
            this.imageNum = AlbumBean.this.indexNum * AlbumBean.this.imagesPerIndex;
            for (int row = 0; row < AlbumBean.this.currentRows; ++row) {
                this.parseElements(rowIterator.getContent(), buf);
                this.imageNum += AlbumBean.this.cols;
            }
            this.parseElements(rowIterator.getPostElement(), buf);
        }

        private void handleColIterator(Element colsElement, StringBuilder buf) throws ElementException {
            Template template = new Template(colsElement.getContent());
            for (int i = this.imageNum; i < AlbumBean.this.files.length && i < this.imageNum + AlbumBean.this.cols; ++i) {
                Scope locals = (Scope)AlbumBean.this.fileVariables.get(AlbumBean.this.files[i]);
                Map allLocals = locals.push(AlbumBean.this.extras).flatten();
                this.putAll(allLocals);
                this.parseElements(template.toString(allLocals), buf);
                this.removeAll(allLocals.keySet());
            }
            this.putAll(AlbumBean.this.indexVariables.push(AlbumBean.this.extras));
            this.parseElements(colsElement.getPostElement(), buf);
        }

        private File[] filterFiles(File[] files, boolean dirs) {
            LinkedList<File> res = new LinkedList<File>();
            for (File f : files) {
                if (f.isDirectory()) {
                    if (!dirs) continue;
                    res.add(f);
                    continue;
                }
                if (dirs) continue;
                res.add(f);
            }
            return res.toArray(new File[res.size()]);
        }

        private void handleFileIterator(Element fileIterator, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
            this.imageNum = AlbumBean.this.indexNum * AlbumBean.this.imagesPerIndex;
            boolean dirs = fileIterator.getAttributes().containsKey("dirs");
            boolean nodirs = fileIterator.getAttributes().containsKey("nodirs");
            File[] localFiles = AlbumBean.this.files;
            if (dirs) {
                localFiles = this.filterFiles(AlbumBean.this.files, true);
            }
            if (nodirs) {
                localFiles = this.filterFiles(AlbumBean.this.files, false);
            }
            HashMap variablesBackup = new HashMap();
            variablesBackup.putAll(this.variables);
            Template template = new Template(fileIterator.getContent());
            if (fileIterator.getAttributes().containsKey("start")) {
                int start;
                boolean relative = false;
                String s = this.parseAttributeValue(fileIterator.getAttribute("start"));
                if (s.startsWith("+")) {
                    relative = true;
                    start = Integer.parseInt(s.substring(1));
                } else {
                    start = Integer.parseInt(s);
                }
                if (start < 0) {
                    relative = true;
                }
                int count = Integer.parseInt(this.parseAttributeValue(fileIterator.getAttribute("count", "2147483647")));
                int step = Integer.parseInt(this.parseAttributeValue(fileIterator.getAttribute("step", "1")));
                if (relative) {
                    NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
                    try {
                        Primitive imageNum = (Primitive)ns.getVariable("imageNum");
                        if (imageNum == Primitive.VOID) {
                            throw new ElementException("Relative indexing in ja:fileiterator not allowed in this scope");
                        }
                        int current = imageNum.intValue() - 1;
                        start += current;
                    }
                    catch (UtilEvalError ex) {
                        throw new ElementException(ex.toString());
                    }
                }
                int oldStart = start;
                if (start < 0) {
                    start = 0;
                }
                count -= Math.abs(start - oldStart);
                for (int i = start; i >= 0 && i < localFiles.length && count-- > 0; i += step) {
                    this.handleIteration(i, template, buf, localFiles);
                }
            } else {
                for (int i = this.imageNum; i < localFiles.length && i - this.imageNum < AlbumBean.this.currentRows * AlbumBean.this.cols; ++i) {
                    this.handleIteration(i, template, buf, localFiles);
                }
            }
            this.putAll(variablesBackup);
            this.parseElements(fileIterator.getPostElement(), buf);
        }

        private void handleIteration(int i, Template template, StringBuilder buf, File[] localFiles) throws ElementException {
            Scope locals = (Scope)AlbumBean.this.fileVariables.get(localFiles[i]);
            Scope fix = new Scope(locals);
            fix.put("imageNum", new Integer(i + 1));
            fix.put("files", localFiles);
            Map allLocals = fix.push(AlbumBean.this.extras).flatten();
            this.putAll(allLocals);
            this.parseElements(template.toString(allLocals), buf);
            this.removeAll(allLocals.keySet());
        }

        private void handleSwitch(Element switchElem, StringBuilder buf) throws ElementException {
            String testExpression = switchElem.getAttribute("test");
            if (testExpression == null) {
                throw new ElementException(Msg.get("scripting.missingTestAttibuteForJaSwitchElement"));
            }
            try {
                String value = this.parseAttributeValue(testExpression);
                Element nextElem = Elements.getElementByName("ja:", switchElem.getContent(), true);
                while (nextElem != null) {
                    if (nextElem.getName().equals("ja:case")) {
                        String caseValue = nextElem.getAttribute("value");
                        if (value.equals(caseValue)) {
                            this.parseElements(nextElem.getContent(), buf);
                            break;
                        }
                    } else if (nextElem.getName().equals("ja:default")) {
                        if (Elements.getElementByName("ja:", nextElem.getPostElement(), true) != null) {
                            throw new ElementException(Msg.get("scripting.JaDefaultNotLastInJaSwitch"));
                        }
                        this.parseElements(nextElem.getContent(), buf);
                    } else {
                        throw new ElementException(Msg.get("scripting.invalidElementForJaSwitch") + ": " + nextElem.getName());
                    }
                    nextElem = Elements.getElementByName("ja:", nextElem.getPostElement(), true);
                }
                this.parseElements(switchElem.getPostElement(), buf);
            }
            catch (Exception ex) {
                throw new ElementException(ex.toString());
            }
        }

        private void handleIfElse(Element ifElem, StringBuilder buf) throws ElementException {
            String whiteCheck;
            StringTokenizer testTokenizer;
            String existTest = ifElem.getAttribute("exists");
            String testExpression = ifElem.getAttribute("test");
            String valueExpression = ifElem.getAttribute("value");
            if (valueExpression == null) {
                valueExpression = "true";
            }
            boolean not = ifElem.getAttributes().containsKey("not");
            if (existTest == null && testExpression == null) {
                throw new ElementException(Msg.get("scripting.missingAttibutesForJaIfElement"));
            }
            Element elseElem = null;
            Element nextElem = Elements.getElementByName("ja:", ifElem.getPostElement(), true);
            if (nextElem != null && nextElem.getName().equals("ja:else") && (testTokenizer = new StringTokenizer(whiteCheck = (elseElem = nextElem).getPreElement())).hasMoreTokens()) {
                throw new ElementException(Msg.get("scripting.elseNotFollowingIfError"));
            }
            try {
                if (existTest != null && (!not ? this.exists(existTest) : !this.exists(existTest)) || testExpression != null && (not ? !this.parseAttributeValue(testExpression).equals(valueExpression) : this.parseAttributeValue(testExpression).equals(valueExpression))) {
                    this.parseElements(ifElem.getContent(), buf);
                    if (elseElem == null) {
                        this.parseElements(ifElem.getPostElement(), buf);
                    } else {
                        this.parseElements(elseElem.getPostElement(), buf);
                    }
                } else if (elseElem == null) {
                    this.parseElements(ifElem.getPostElement(), buf);
                } else {
                    this.parseElements(elseElem.getContent(), buf);
                    this.parseElements(elseElem.getPostElement(), buf);
                }
            }
            catch (ElementException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new ElementException(Msg.get("scripting.expressionNotEvaluatingToBooleanError") + testExpression + Msg.get("scripting.expressionNotEvaluatingToBooleanError2"));
            }
        }

        private boolean exists(String name) throws UtilEvalError {
            NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
            Object val = ns.getVariable(name);
            if (val == null || val == Primitive.NULL || val == Primitive.VOID) {
                return false;
            }
            if (!(val instanceof String) && !(val instanceof StringBuilder)) {
                return true;
            }
            return val.toString().length() > 0;
        }

        private void handleIgnore(Element elem, StringBuilder buf) throws ElementException {
            buf.append(elem.getContent());
            this.parseElements(elem.getPostElement(), buf);
        }

        private void handleInclude(Element elem, StringBuilder buf) throws ElementException, EvalError, UtilEvalError {
            String page = (String)elem.getAttributes().get("page");
            if (page == null) {
                throw new ElementException(Msg.get("scripting.missingPageAttributeForJaIncludeElementError"));
            }
            page = this.parseAttributeValue(page);
            File f = new File(page);
            boolean once = elem.getAttributes().containsKey("once");
            boolean root = elem.getAttributes().containsKey("root");
            if (once && this.includedPages.contains(f.getAbsolutePath())) {
                this.parseElements(elem.getPostElement(), buf);
                return;
            }
            this.includedPages.add(f.getAbsolutePath());
            if (!f.isAbsolute()) {
                File curdir;
                if (root) {
                    curdir = (File)this.variables.get("rootImageDirectory");
                    if (curdir != null) {
                        f = new File(curdir, page);
                    }
                } else {
                    curdir = (File)this.variables.get("imageDirectory");
                    if (curdir != null) {
                        f = new File(curdir, page);
                    }
                    if (!f.exists() && (curdir = (File)this.variables.get("skinDirectory")) != null && !(f = new File(curdir, page)).exists()) {
                        curdir = new File(((AlbumBean)AlbumBean.this).cfg.progDir, "includes");
                        f = new File(curdir, page);
                    }
                }
            }
            try {
                if (f.exists()) {
                    String data = IO.readTextFile(f);
                    Template t = new Template(data);
                    data = t.toString(this.variables);
                    this.parseElements(data, buf);
                } else {
                    this.parseElements(elem.getContent(), buf);
                }
            }
            catch (IOException ex) {
                buf.append(elem.getContent());
            }
            this.parseElements(elem.getPostElement(), buf);
        }

        private void handleEval(Element evalElem, StringBuilder buf) throws ElementException {
            StringWriter sw = new StringWriter();
            String result = this.eval(evalElem.getContent(), sw);
            buf.append(sw.toString());
            buf.append(result);
            this.parseElements(evalElem.getPostElement(), buf);
        }

        private void handleWidget(Element elem, StringBuilder buf) throws ElementException, EvalError {
            if (AlbumBean.this.widgetInjection) {
                String pageType = elem.getAttribute("pageType");
                if (pageType == null) {
                    throw new ElementException(Msg.get("scripting.missingPageTypeAttributeForJaWidgetElementError"));
                }
                String rootPath = (String)AlbumBean.this.interpreter.get("rootPath");
                String injectionCode = AlbumBean.this.getWidgetInjectionCode(pageType, rootPath);
                buf.append(injectionCode);
            }
            this.parseElements(elem.getPostElement(), buf);
        }

        private String upperInitial(String s) {
            return "" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }

        private Object invokeGetter(Object bean, String name) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            Class<?> beanClass = bean.getClass();
            Method m = null;
            try {
                m = beanClass.getMethod("get" + this.upperInitial(name), null);
            }
            catch (NoSuchMethodException ex) {
                try {
                    m = beanClass.getMethod("is" + this.upperInitial(name), null);
                }
                catch (NoSuchMethodException ex2) {
                    throw ex;
                }
            }
            return m.invoke(bean, (Object[])null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleExpressionLanguage(Element exprElem, StringBuilder buf) throws ElementException {
            try {
                Object o;
                block11: {
                    String next;
                    StringTokenizer tokens;
                    block13: {
                        String expr;
                        block12: {
                            expr = exprElem.getContent();
                            o = null;
                            if (expr.indexOf(46) == -1) break block12;
                            tokens = new StringTokenizer(expr, ".");
                            String token = tokens.nextToken();
                            next = tokens.nextToken();
                            o = AlbumBean.this.interpreter.get(token);
                            if (!(o instanceof SmartResourceBundle)) break block13;
                            String key = expr.substring(expr.indexOf(46) + 1);
                            buf.append(((SmartResourceBundle)o).getString(key));
                            o = null;
                            break block11;
                        }
                        if (AlbumBean.this.using != null) {
                            try {
                                Field f = AlbumBean.this.using.getClass().getField(expr);
                                o = f.get(AlbumBean.this.using);
                            }
                            catch (NoSuchFieldException ex) {
                                NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
                                o = ns.getVariable(expr);
                            }
                            break block11;
                        } else {
                            NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
                            o = ns.getVariable(expr);
                        }
                        break block11;
                    }
                    while (true) {
                        if (o instanceof Map) {
                            o = ((Map)o).get(next);
                        } else if (o != null) {
                            o = this.invokeGetter(o, next);
                        }
                        if (!tokens.hasMoreTokens()) break;
                        next = tokens.nextToken();
                    }
                }
                if (o != null && o != Primitive.NULL && o != Primitive.VOID) {
                    buf.append(o.toString());
                }
            }
            catch (Exception ex) {
                throw new ElementException(ex.toString());
            }
            this.parseElements(exprElem.getPostElement(), buf);
        }

        private void handleScriptlet(Element scriptlet, StringBuilder buf) throws ElementException {
            if (scriptlet.isDefinitionScriptlet()) {
                Integer contentHash = new Integer(scriptlet.getContent().hashCode());
                if (this.evaluatedDefinitions.contains(contentHash)) {
                    this.parseElements(scriptlet.getPostElement(), buf);
                    return;
                }
                this.evaluatedDefinitions.add(contentHash);
            }
            StringWriter sw = new StringWriter();
            String result = this.eval(scriptlet.getContent(), sw);
            buf.append(sw.toString());
            if (scriptlet.isEvalScriptlet()) {
                buf.append(result);
            }
            this.parseElements(scriptlet.getPostElement(), buf);
        }

        private String parseAttributeValue(String s) throws ElementException, EvalError, UtilEvalError {
            StringWriter sw = new StringWriter();
            StringBuilder buf = new StringBuilder();
            Element scriptlet = Elements.getScriptlet(s);
            if (scriptlet == null) {
                scriptlet = Elements.getExpressionLanguage(s);
                if (scriptlet == null) {
                    return s;
                }
                buf.append(scriptlet.getPreElement());
                this.handleExpressionLanguage(scriptlet, buf);
                return buf.toString();
            }
            buf.append(scriptlet.getPreElement());
            String result = this.eval(scriptlet.getContent(), sw);
            buf.append(sw.toString());
            if (scriptlet.isEvalScriptlet()) {
                buf.append(result);
            }
            buf.append(scriptlet.getPostElement());
            return buf.toString();
        }

        private String eval(String expr, Writer writer) throws ElementException {
            PrintWriter out = new PrintWriter(writer);
            try {
                AlbumBean.this.interpreter.set("out", (Object)out);
                Object ret = AlbumBean.this.doProcessExpression(expr);
                out.flush();
                return ret != null ? ret.toString() : "";
            }
            catch (EvalError e) {
                throw new ElementException("Evaluation error on line " + e.getErrorLineNumber() + ":\n\nDetails:\n" + e.getMessage());
            }
        }
    }

    static class Counter {
        private int x;

        public Counter(int startValue) {
            this.x = startValue;
        }

        public synchronized int value() {
            return this.x;
        }

        public synchronized int next() {
            return this.x++;
        }
    }

    class EvalStat {
        String expr;
        int invocations;
        Stopwatch stopwatch = new Stopwatch();

        EvalStat() {
        }

        public String toString() {
            return this.stopwatch + "\tInvocations: " + this.invocations + "\tExpr: " + this.expr.substring(0, this.expr.length() <= 40 ? this.expr.length() - 1 : 40);
        }
    }

    private class ImageProcessingThread
    extends Thread {
        private Counter counter;
        private File dir;
        private File outputDir;
        private File[] files;
        Throwable throwable;

        public ImageProcessingThread(ThreadGroup tg, String name, Counter counter, File dir, File outputDir, File[] files) {
            super(tg, name);
            this.counter = counter;
            this.dir = dir;
            this.outputDir = outputDir;
            this.files = files;
            this.setDaemon(true);
        }

        public void run() {
            block2: {
                try {
                    AlbumBean.this.makeThumbs(this.counter, this.dir, this.outputDir, this.files);
                }
                catch (Throwable t) {
                    this.throwable = t;
                    if (t instanceof OperationAbortedException) break block2;
                    t.printStackTrace(System.err);
                }
            }
        }
    }
}

