/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import java.util.Vector;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.event.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerSelectionModel {
    static final int NORTH = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int EAST = 4;
    private JExplorerPanel explorer;
    int lastClickedIndex = 0;
    boolean wasAlreadySelected = false;
    private JAlbumObject focusedObject;
    private int selectionCount = 0;
    private transient Vector selectionListeners;

    public ExplorerSelectionModel(JExplorerPanel explorer) {
        this.explorer = explorer;
    }

    int indexOf(Component comp) {
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != comp) continue;
            return i;
        }
        return -1;
    }

    void deselectAll() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JAlbumObject)comps[i]).setSelected(false);
        }
        this.selectionListeners = tmpListeners;
        this.selectionCount = 0;
        this.fireSelectionChange();
    }

    int getSelectionCount() {
        return this.selectionCount;
    }

    void selectAll() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JAlbumObject)comps[i]).setSelected(true);
        }
        this.selectionListeners = tmpListeners;
        this.selectionCount = comps.length;
        this.fireSelectionChange();
    }

    void invertSelection() {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            boolean sel = !jao.isSelected();
            jao.setSelected(sel);
        }
        this.selectionListeners = tmpListeners;
        this.fireSelectionChange();
    }

    void selectRange(int startIndex, int endIndex) {
        Vector tmpListeners = this.selectionListeners;
        this.selectionListeners = null;
        Component[] comps = this.explorer.getComponents();
        if (startIndex > endIndex) {
            int tmp = startIndex;
            startIndex = endIndex;
            endIndex = tmp;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            jao.setSelected(true);
        }
        this.selectionCount = endIndex - startIndex + 1;
        this.selectionListeners = tmpListeners;
        this.fireSelectionChange();
    }

    void objectSelected(JAlbumObject jao, boolean selected) {
        this.selectionCount = selected ? ++this.selectionCount : --this.selectionCount;
        this.fireSelectionChange();
    }

    LinkedList<JAlbumObject> getSelectedObjects() {
        LinkedList<JAlbumObject> list = new LinkedList<JAlbumObject>();
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            if (!jao.isSelected()) continue;
            list.add(jao);
        }
        return list;
    }

    JAlbumObject getSingleSelected() {
        JAlbumObject selected = null;
        Component[] comps = this.explorer.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            if (!jao.isSelected()) continue;
            if (selected != null) {
                return null;
            }
            selected = jao;
        }
        return selected;
    }

    JAlbumObject getFocusedObject() {
        return this.focusedObject;
    }

    void setFocusedObject(JAlbumObject jao) {
        this.focusedObject = jao;
    }

    JAlbumObject getNeighbourObject(JAlbumObject jao, int direction) {
        Point p = jao.getLocation();
        Dimension dim = this.explorer.objectSize;
        p.x += dim.width / 2;
        p.y += dim.height / 2;
        switch (direction) {
            case 1: {
                p.y -= dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 2: {
                p.y += dim.height + this.explorer.explorerThumbsLayout.getVgap();
                break;
            }
            case 3: {
                p.x -= dim.width + this.explorer.explorerThumbsLayout.getHgap();
                break;
            }
            case 4: {
                p.x += dim.width + this.explorer.explorerThumbsLayout.getHgap();
            }
        }
        return (JAlbumObject)this.explorer.getNearestComponent(p);
    }

    public synchronized void removeSelectionListener(SelectionListener l) {
        if (this.selectionListeners != null && this.selectionListeners.contains(l)) {
            Vector v = (Vector)this.selectionListeners.clone();
            v.removeElement(l);
            this.selectionListeners = v;
        }
    }

    public synchronized void addSelectionListener(SelectionListener l) {
        Vector v;
        Vector vector = v = this.selectionListeners == null ? new Vector(2) : (Vector)this.selectionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.selectionListeners = v;
        }
    }

    protected void fireSelectionChange() {
        if (this.selectionListeners != null) {
            Vector listeners = this.selectionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((SelectionListener)listeners.elementAt(i)).selectionChange(this);
            }
        }
    }
}

