/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class JSmartTextPane
extends JTextPane {
    private static final Font standardFont = new JLabel().getFont();

    public JSmartTextPane() {
        this.init();
    }

    public JSmartTextPane(String s) {
        this.init();
        this.setText(s);
    }

    private void init() {
        this.setFocusable(false);
        this.setContentType("text/html");
        JSmartTextPane.setJTextPaneFont(this, standardFont);
        this.setOpaque(false);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setText(String text) {
        super.setText("<html><body>" + text + "</body></html>");
        JSmartTextPane.setJTextPaneFont(this, standardFont);
        this.setSize(360, Integer.MAX_VALUE);
        this.setPreferredSize(new Dimension(360, this.getPreferredSize().height));
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        Dimension ms = super.getMinimumSize();
        if (ms.height == 0) {
            return super.getPreferredSize();
        }
        return new Dimension(ps.width, ms.height);
    }

    public static void setJTextPaneFont(JTextPane jtp, Font font) {
        MutableAttributeSet attrs = jtp.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyledDocument doc = jtp.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }
}

