/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected String title;
    protected Color color = Color.black;
    protected JTextField textComponent;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (JColorSelector.this.textComponent != null) {
                JColorSelector.this.textComponent.setText(JColorSelector.this.getHTMLColor());
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JColorSelector.this.textComponentChanged();
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            JColorSelector.this.textComponentChanged();
        }
    };
    Vector listeners;
    private final int Y_OFFSET = 1;

    public JColorSelector() {
        this("");
    }

    public JColorSelector(String title) {
        this.title = title;
        this.addPropertyChangeListener("color", this.propertyChangeListener);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void textComponentChanged() {
        this.removePropertyChangeListener("color", this.propertyChangeListener);
        this.setColor(this.textComponent.getText());
        this.addPropertyChangeListener("color", this.propertyChangeListener);
    }

    public JColorSelector(JTextField comp) {
        this("");
        this.setTextComponent(comp);
    }

    public JColorSelector(String title, JTextField comp) {
        this(title);
        this.setTextComponent(comp);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public JTextField getTextComponent() {
        return this.textComponent;
    }

    public void setTextComponent(JTextField textComponent) {
        if (textComponent != null) {
            textComponent.removeActionListener(this.actionListener);
            textComponent.removeFocusListener(this.focusListener);
        }
        this.textComponent = textComponent;
        textComponent.addActionListener(this.actionListener);
        textComponent.addFocusListener(this.focusListener);
        textComponent.setText(this.getHTMLColor());
    }

    public String getHTMLColor() {
        return "#" + Integer.toHexString(this.color.getRGB()).substring(2);
    }

    public String toString() {
        return this.getHTMLColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String htmlColor) {
        this.setColor(Colors.getHTMLColor(htmlColor));
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = color;
        this.repaint();
        this.firePropertyChange("color", oldColor, this.getHTMLColor());
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(20, 15 + this.Y_OFFSET));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(JColorSelector.this), JColorSelector.this.title, JColorSelector.this.color);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                    JColorSelector.this.fireActionOccured(new ActionEvent(JColorSelector.this, 0, JColorSelector.this.getHTMLColor()));
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.color.brighter());
        g.fillRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
        g.setColor(this.color);
        g.fillRoundRect(1, this.Y_OFFSET + 1, w - 2, h - this.Y_OFFSET - 2, 0, 0);
        g.setColor(this.color.darker());
        g.drawRoundRect(0, this.Y_OFFSET, w - 1, h - this.Y_OFFSET - 1, 5, 5);
    }
}

