/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JCollapsiblePanel
extends JPanel {
    private static ImageIcon collapsedTriangle = new ImageIcon(JCollapsiblePanel.class.getResource("images/triangle0-dark.png"));
    private static ImageIcon expandedTriangle = new ImageIcon(JCollapsiblePanel.class.getResource("images/triangle1-dark.png"));
    private JPanel contentPanel = new JPanel();
    private JLabel titleLabel = new JLabel(collapsedTriangle);
    private JPanel titlePanel = new JPanel(new FlowLayout(3));
    private Border titleBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.lightGray);
    private JPanel bottomPanel = new JPanel();
    private boolean expanded = false;

    public JCollapsiblePanel() {
        this.init(null);
    }

    public JCollapsiblePanel(LayoutManager layout) {
        this.contentPanel.setLayout(layout);
        this.init(null);
    }

    public JCollapsiblePanel(String title) {
        this.init(title);
    }

    public JCollapsiblePanel(String title, LayoutManager layout) {
        this.contentPanel.setLayout(layout);
        this.init(title);
    }

    private void init(String title) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.titlePanel.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.bottomPanel.setOpaque(false);
        this.titlePanel.setBorder(this.titleBorder);
        this.titleLabel.setText(title);
        this.titleLabel.setForeground(SystemColor.darkGray);
        if (System.getProperty("mrj.version") != null) {
            Font f = this.titleLabel.getFont();
            this.titleLabel.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }
        this.titlePanel.add(this.titleLabel);
        this.add((Component)this.titlePanel, "North");
        this.titlePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JCollapsiblePanel.this.setExpanded(!JCollapsiblePanel.this.expanded);
            }

            public void mouseEntered(MouseEvent e) {
                JCollapsiblePanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                JCollapsiblePanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.bottomPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.lightGray));
    }

    public JLabel getLabel() {
        return this.titleLabel;
    }

    public void setLabel(JLabel label) {
        this.titleLabel = label;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setContentPanel(JPanel contentPanel) {
        if (this.expanded) {
            this.remove(this.contentPanel);
            this.add((Component)contentPanel, "Center");
            this.invalidate();
        }
        this.contentPanel = contentPanel;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        if (expanded) {
            this.titleLabel.setIcon(expandedTriangle);
            this.add((Component)this.contentPanel, "Center");
            this.titlePanel.setBorder(null);
            this.add((Component)this.bottomPanel, "South");
        } else {
            this.titleLabel.setIcon(collapsedTriangle);
            this.titlePanel.setBorder(this.titleBorder);
            this.remove(this.contentPanel);
            this.remove(this.bottomPanel);
        }
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.firePropertyChange("expanded", !expanded, expanded);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }
}

