/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.SepiaControl;
import se.datadosen.jalbum.Msg;

public class SepiaFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 6592860195353596506L;
    protected int strength = 100;
    protected SepiaControl sepiaControl;

    public SepiaFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.sepia.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.sepia.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/sepia.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.sepia.description");
        this.help = "";
        this.other = "";
        this.prescale = true;
        this.postscale = true;
        this.sepiaControl = new SepiaControl(this);
    }

    public JPanel getControls() {
        return this.sepiaControl;
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage out = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        for (int x = 0; x < bi.getWidth(); ++x) {
            for (int y = 0; y < bi.getHeight(); ++y) {
                int rgb = bi.getRGB(x, y);
                int alpha = (int)(((long)rgb & 0xFF000000L) >> 24);
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                int rn = (int)((double)gray * 1.3 * (double)((float)this.strength / 100.0f) + (double)((float)r * (1.0f - (float)this.strength / 100.0f)));
                if (rn > 255) {
                    rn = 255;
                }
                int gn = (int)((float)gray * ((float)this.strength / 100.0f) + (float)g * (1.0f - (float)this.strength / 100.0f));
                int bn = (int)((float)(gray * 2 / 3) * ((float)this.strength / 100.0f) + (float)b * (1.0f - (float)this.strength / 100.0f));
                rgb = (alpha & 0xFF) << 24 | (rn & 0xFF) << 16 | (gn & 0xFF) << 8 | bn & 0xFF;
                out.setRGB(x, y, rgb);
            }
        }
        return out;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }
}

