/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.jalbum.filters.BoxControl;
import net.jalbum.filters.CroppingFilterPlugin;
import se.datadosen.jalbum.Msg;

public class CroppingControl
extends BoxControl {
    private static final long serialVersionUID = -5810631993955435525L;
    protected CroppingFilterPlugin croppingFilterPlugin;
    protected JCheckBox keepRatio;
    protected JComboBox predefinedRatio;
    protected JComboBox aspectRatio;
    protected Vector<Double> predefinedRatioList;

    public CroppingControl() {
    }

    public CroppingControl(CroppingFilterPlugin croppingFilterPlugin) {
        this.init(croppingFilterPlugin);
        this.addCroppingControl();
    }

    protected void init(CroppingFilterPlugin croppingFilterPlugin) {
        this.croppingFilterPlugin = croppingFilterPlugin;
        super.init(croppingFilterPlugin);
    }

    protected void addCroppingControl() {
        this.keepRatio = new JCheckBox(Msg.getString((Object)this, (String)"filters.cropping.keepRatio"));
        this.predefinedRatio = new JComboBox();
        this.aspectRatio = new JComboBox();
        this.predefinedRatioList = new Vector();
        this.initiatePredefinedRatios();
        this.aspectRatio.addItem(Msg.getString((Object)this, (String)"filters.cropping.landscape"));
        this.aspectRatio.addItem(Msg.getString((Object)this, (String)"filters.cropping.portrait"));
        this.keepRatio.addActionListener(this);
        this.predefinedRatio.addActionListener(this);
        this.aspectRatio.addActionListener(this);
        this.add("br", this.keepRatio);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.cropping.predefinedRatio")));
        this.add("br", this.predefinedRatio);
        this.add("br", this.aspectRatio);
        if (this.croppingFilterPlugin.getResizableBox().isKeepRatio()) {
            this.keepRatio.setSelected(true);
            this.predefinedRatio.setEnabled(!this.keepRatio.isSelected());
        }
    }

    public void initiatePredefinedRatios() {
        this.predefinedRatio.removeAllItems();
        this.predefinedRatioList.removeAllElements();
        this.predefinedRatio.addItem("");
        this.predefinedRatio.addItem("1:4");
        this.predefinedRatioList.add(new Double(0.25));
        this.predefinedRatio.addItem("1:3");
        this.predefinedRatioList.add(new Double(0.3333333333333333));
        this.predefinedRatio.addItem("1:2");
        this.predefinedRatioList.add(new Double(0.5));
        this.predefinedRatio.addItem("5:8 " + Msg.getString((Object)this, (String)"filters.cropping.goldenRatio"));
        this.predefinedRatioList.add(new Double(0.625));
        this.predefinedRatio.addItem("2:3, 10:15, 20:30");
        this.predefinedRatioList.add(new Double(0.6666666666666666));
        this.predefinedRatio.addItem("9:13");
        this.predefinedRatioList.add(new Double(0.6923076923076923));
        this.predefinedRatio.addItem("11:15");
        this.predefinedRatioList.add(new Double(0.7333333333333333));
        this.predefinedRatio.addItem("3:4, 15:20");
        this.predefinedRatioList.add(new Double(0.75));
        this.predefinedRatio.addItem("13:17");
        this.predefinedRatioList.add(new Double(0.7647058823529411));
        this.predefinedRatio.addItem("4:5");
        this.predefinedRatioList.add(new Double(0.8));
        this.predefinedRatio.addItem("1:1");
        this.predefinedRatioList.add(new Double(1.0));
        int counter = 0;
        double imageRatio = (double)this.objectWidth / (double)this.objectHeight;
        imageRatio = Math.min(imageRatio, 1.0 / imageRatio);
        while (true) {
            if (this.predefinedRatioList.get(counter) >= imageRatio) break;
            ++counter;
        }
        this.predefinedRatio.insertItemAt(Msg.getString((Object)this, (String)"filters.cropping.imageRatio"), counter + 1);
        this.predefinedRatio.setSelectedIndex(counter + 1);
        this.predefinedRatioList.add(counter, imageRatio);
    }

    public void update(double x1, double y1, double boxWidth, double boxHeight) {
        super.update(x1, y1, boxWidth, boxHeight);
    }

    public void actionPerformed(ActionEvent e) {
        double imageRatio;
        double currentRatio;
        super.actionPerformed(e);
        if (e.getSource() == this.predefinedRatio) {
            int index = this.predefinedRatio.getSelectedIndex();
            if (index > 0) {
                double imageRatio2;
                Double desieredRatio = this.predefinedRatioList.get(index - 1);
                if (this.aspectRatio.getSelectedIndex() == 0) {
                    desieredRatio = 1.0 / desieredRatio;
                }
                if ((imageRatio2 = (double)this.objectWidth / (double)this.objectHeight) < desieredRatio) {
                    this.boxWidth = 1.0;
                    this.boxHeight = 1.0 / desieredRatio * imageRatio2;
                } else {
                    this.boxHeight = 1.0;
                    this.boxWidth = desieredRatio / imageRatio2;
                }
                this.X1 = 0.5 - this.boxWidth / 2.0;
                this.Y1 = 0.5 - this.boxHeight / 2.0;
                this.croppingFilterPlugin.updateObject(this.X1, this.Y1, this.boxWidth, this.boxHeight);
                this.keepRatio.setSelected(true);
                e.setSource(this.keepRatio);
            }
        } else if (e.getSource() == this.aspectRatio && ((currentRatio = this.boxWidth * (imageRatio = (double)this.objectWidth / (double)this.objectHeight) / this.boxHeight) < 1.0 && this.aspectRatio.getSelectedIndex() == 0 || currentRatio > 1.0 && this.aspectRatio.getSelectedIndex() == 1)) {
            Double desieredRatio = 1.0 / currentRatio;
            if (imageRatio < desieredRatio) {
                this.boxWidth = 1.0;
                this.boxHeight = 1.0 / desieredRatio * imageRatio;
            } else {
                this.boxHeight = 1.0;
                this.boxWidth = desieredRatio / imageRatio;
            }
            this.X1 = 0.5 - this.boxWidth / 2.0;
            this.Y1 = 0.5 - this.boxHeight / 2.0;
            this.croppingFilterPlugin.updateObject(this.X1, this.Y1, this.boxWidth, this.boxHeight);
            this.croppingFilterPlugin.getResizableBox().adjustKeepRatio(this.keepRatio.isSelected());
        }
        if (e.getSource() == this.keepRatio) {
            this.croppingFilterPlugin.getResizableBox().adjustKeepRatio(this.keepRatio.isSelected());
            this.predefinedRatio.setEnabled(!this.keepRatio.isSelected());
            if (!this.keepRatio.isSelected()) {
                this.predefinedRatio.setSelectedIndex(0);
            }
        }
        this.croppingFilterPlugin.updateObject(this.X1, this.Y1, this.boxWidth, this.boxHeight);
    }
}

