/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.messages;

import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.services.ServiceAction;
import net.sbbi.upnp.services.ServiceStateVariable;
import net.sbbi.upnp.services.UPNPService;

public class UPNPMessageFactory {
    private UPNPService service;

    private UPNPMessageFactory(UPNPService service) {
        this.service = service;
    }

    public static UPNPMessageFactory getNewInstance(UPNPService service) {
        return new UPNPMessageFactory(service);
    }

    public ActionMessage getMessage(String serviceActionName) {
        ServiceAction serviceAction = this.service.getUPNPServiceAction(serviceActionName);
        if (serviceAction != null) {
            return new ActionMessage(this.service, serviceAction);
        }
        return null;
    }

    public StateVariableMessage getStateVariableMessage(String serviceStateVariable) {
        ServiceStateVariable stateVar = this.service.getUPNPServiceStateVariable(serviceStateVariable);
        if (stateVar != null) {
            return new StateVariableMessage(this.service, stateVar);
        }
        return null;
    }
}

