/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Attributizer;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PersistentList;

public class PropertyBinder {
    public static Properties getProperties(JComponentHolder jComponentHolder) {
        return PropertyBinder.getProperties(jComponentHolder, new Properties());
    }

    public static Properties getProperties(JComponentHolder jComponentHolder, Properties existing) {
        Properties props = existing;
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                fields[i].setAccessible(true);
                int mods = fields[i].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                Object comp = fields[i].get(jComponentHolder);
                if (comp instanceof JComponentHolder) {
                    Properties subProps = PropertyBinder.getProperties((JComponentHolder)comp);
                    props.putAll((Map<?, ?>)subProps);
                    continue;
                }
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        props.setProperty(name, tc.getText());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        Object sel = jc.getSelectedItem();
                        if (sel == null) continue;
                        if (sel instanceof Item) {
                            sel = ((Item)sel).value.toString();
                        }
                        props.setProperty(name, sel.toString());
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        props.setProperty(name, cb.isSelected() ? "true" : "false");
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        props.setProperty(name, tb.isSelected() ? "true" : "false");
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        props.setProperty(name, cs.getHTMLColor());
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        props.setProperty(name, "" + js.getValue());
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    props.setProperty(name, PropertyBinder.toAttributes(((PersistentList)comp).getContent()));
                    continue;
                }
                if (comp instanceof ButtonGroup) {
                    ButtonGroup bg = (ButtonGroup)comp;
                    Enumeration<AbstractButton> buttons = bg.getElements();
                    while (buttons.hasMoreElements()) {
                        AbstractButton button = buttons.nextElement();
                        if (!button.isSelected()) continue;
                        props.setProperty(name, button.getActionCommand());
                    }
                    continue;
                }
                if (!(comp instanceof Attributizer)) continue;
                Attributizer attr = (Attributizer)comp;
                props.setProperty(name, attr.getAttributes());
            }
            return props;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static void syncUI(Map props, JComponentHolder jComponentHolder) {
        try {
            Class<?> guiClass = jComponentHolder.getClass();
            Field[] fields = BeanBinder.getFields(guiClass);
            block4: for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                fields[i].setAccessible(true);
                int mods = fields[i].getModifiers();
                if (Modifier.isPrivate(mods) || Modifier.isProtected(mods)) continue;
                Object comp = fields[i].get(jComponentHolder);
                if (!props.containsKey(name) && !(comp instanceof JComponentHolder)) continue;
                if (comp instanceof JComponentHolder) {
                    PropertyBinder.syncUI(props, (JComponentHolder)comp);
                    continue;
                }
                String value = props.get(name).toString();
                if (comp instanceof JComponent) {
                    if (comp instanceof JTextComponent) {
                        JTextComponent tc = (JTextComponent)comp;
                        tc.setText(value);
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        JComboBox jc = (JComboBox)comp;
                        boolean setOk = false;
                        for (int k = 0; k < jc.getItemCount(); ++k) {
                            Object item = jc.getItemAt(k);
                            if (item instanceof Integer) {
                                item = ((Integer)item).toString();
                            }
                            if (!item.equals(value)) continue;
                            jc.setSelectedIndex(k);
                            setOk = true;
                            break;
                        }
                        if (setOk) continue;
                        jc.setSelectedItem(value);
                        continue;
                    }
                    if (comp instanceof JCheckBox) {
                        JCheckBox cb = (JCheckBox)comp;
                        cb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JToggleButton) {
                        JToggleButton tb = (JToggleButton)comp;
                        tb.setSelected(value.equals("true") || value.equals("yes") || value.equals("1"));
                        continue;
                    }
                    if (comp instanceof JColorSelector) {
                        JColorSelector cs = (JColorSelector)comp;
                        cs.setColor(value);
                        continue;
                    }
                    if (comp instanceof JSlider) {
                        JSlider js = (JSlider)comp;
                        js.setValue(Integer.parseInt(value));
                        continue;
                    }
                    if (!(comp instanceof PersistentList)) continue;
                    try {
                        String val;
                        ArrayList<String> values = new ArrayList<String>();
                        Properties p = AttributeTokenizer.getProperties(value);
                        int j = 1;
                        while ((val = p.getProperty("item" + j)) != null) {
                            values.add(val);
                            ++j;
                        }
                        ((PersistentList)comp).setContent(values.toArray(new String[values.size()]));
                        continue;
                    }
                    catch (ElementException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!(comp instanceof ButtonGroup)) continue;
                ButtonGroup bg = (ButtonGroup)comp;
                Enumeration<AbstractButton> buttons = bg.getElements();
                while (buttons.hasMoreElements()) {
                    AbstractButton button = buttons.nextElement();
                    String ac = button.getActionCommand();
                    if (ac == null || !ac.equals(value)) continue;
                    bg.setSelected(button.getModel(), true);
                    continue block4;
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static String toAttributes(String[] values) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < values.length; ++i) {
            if (!first) {
                buf.append(' ');
            }
            first = false;
            buf.append("item" + (i + 1) + "=\"" + values[i] + "\"");
        }
        return buf.toString();
    }
}

