/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.SkinManager;

public class SpecialMacHandler
implements ApplicationListener {
    private static int counter = 1;

    public SpecialMacHandler() {
        SpecialMacHandler.setSystemProperties();
        SpecialMacHandler.registerAsApplicationListener(this);
    }

    private static void registerAsApplicationListener(ApplicationListener l) {
        Application app = Application.getApplication();
        app.addApplicationListener(l);
        app.addPreferencesMenuItem();
        app.setEnabledAboutMenu(true);
        app.setEnabledPreferencesMenu(true);
    }

    private static void setSystemProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JAlbum");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.interpolation", "bilinear");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
        JAlbumFrame f = JAlbum.mainFrame;
        if (!f.isVisible()) {
            f.setVisible(true);
        }
        if (f.getExtendedState() != 0) {
            f.setExtendedState(0);
        }
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        String fileName = applicationEvent.getFilename();
        this.handleFileOpen(fileName);
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
        JAlbum.mainFrame.showAboutBox();
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
        JAlbum.mainFrame.actions.showPreferencesWindowAction.actionPerformed(null);
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
        System.out.println("handlePrintFile");
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        if (!JAlbum.mainFrame.isVisible()) {
            System.exit(0);
        }
        JAlbum.mainFrame.doExit(null);
    }

    private void handleFileOpen(final String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SpecialMacHandler.this.ensureGuiStarted();
                if (fileName.endsWith("jaskin")) {
                    new SkinManager().installSkin(new File(fileName));
                } else {
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(new File(fileName));
                    JAlbum.mainFrame.albumExplorer.explorer.handleFileAdd(files);
                }
            }
        });
    }

    private void ensureGuiStarted() {
        while (!JAlbum.initialized) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

