/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Metadata;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import se.datadosen.jalbum.AlbumBean;

public class MetaObjectCache
implements Map,
Serializable {
    private static Map meta;
    private static File currentFile;
    private File thisFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaObjectCache(File imageFile, Map meta) {
        MetaObjectCache metaObjectCache = this;
        synchronized (metaObjectCache) {
            this.thisFile = imageFile;
            MetaObjectCache.meta = meta;
            currentFile = this.thisFile;
        }
    }

    private synchronized Map load() {
        if (meta != null && this.thisFile.equals(currentFile)) {
            return meta;
        }
        try {
            Metadata imageInfo = JpegMetadataReader.readMetadata((File)this.thisFile);
            if (imageInfo != null) {
                meta = AlbumBean.getMetaObjectContent(imageInfo);
                currentFile = this.thisFile;
                return meta;
            }
        }
        catch (JpegProcessingException ex) {
            System.err.println((Object)ex);
        }
        return null;
    }

    public int size() {
        Map m = this.load();
        return m.size();
    }

    public boolean isEmpty() {
        Map m = this.load();
        return m.isEmpty();
    }

    public boolean containsKey(Object key) {
        Map m = this.load();
        return m.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Map m = this.load();
        return m.containsValue(value);
    }

    public Object get(Object key) {
        Map m = this.load();
        return m.get(key);
    }

    public Object put(Object key, Object value) {
        Map m = this.load();
        return m.put(key, value);
    }

    public Object remove(Object key) {
        Map m = this.load();
        return m.remove(key);
    }

    public void putAll(Map t) {
        Map m = this.load();
        m.putAll(t);
    }

    public void clear() {
        Map m = this.load();
        m.clear();
    }

    public Set keySet() {
        Map m = this.load();
        return m.keySet();
    }

    public Collection values() {
        Map m = this.load();
        return m.values();
    }

    public Set entrySet() {
        Map m = this.load();
        return m.entrySet();
    }

    public boolean equals(Object o) {
        Map m = this.load();
        return ((Object)m).equals(o);
    }

    public int hashCode() {
        Map m = this.load();
        return ((Object)m).hashCode();
    }

    public String toString() {
        Map m = this.load();
        return m.toString();
    }
}

