/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.component.JIconToggleButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Stopwatch;

public class JProgressDialog
extends JDialog
implements AlbumBeanListener {
    private JPanel thePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton abortOrCloseButton = new JButton();
    private JButton viewAlbumButton = new JButton();
    private JToggleButton pauseButton = new JIconToggleButton();
    private JLabel directory = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private JLabel file = new JLabel();
    private JLabel timeInfo = new JLabel();
    private Stopwatch timer = new Stopwatch();
    boolean abort = false;
    private boolean finished = false;
    private Window parent;

    public JProgressDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal, boolean abortOnly) {
        super(parent, title, modal);
        this.parent = parent;
        try {
            this.initComponents(abortOnly);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void init() {
        try {
            this.initComponents(false);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents(boolean abortOnly) throws Exception {
        this.thePanel.setLayout(new BorderLayout());
        if (!abortOnly) {
            this.viewAlbumButton.setAction(((JAlbumFrame)this.parent).actions.viewAlbumAction);
            this.viewAlbumButton.setText(Msg.getString("ui.preview"));
            this.viewAlbumButton.setIcon(new ImageIcon(JProgressDialog.class.getResource("button_images/preview.png")));
            this.viewAlbumButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JProgressDialog.this.finished) {
                        JProgressDialog.this.dispose();
                    }
                }
            });
            this.getRootPane().setDefaultButton(this.viewAlbumButton);
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JProgressDialog.this.pauseButton_actionPerformed(e);
                }
            });
            this.pauseButton.setText(Msg.getString("progress.pause"));
            this.pauseButton.setIcon(new ImageIcon(JAlbumFrame.class.getResource("images/media_pause.png")));
        }
        this.abortOrCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.abortOrClosePerformed(e);
            }
        });
        this.abortOrCloseButton.setText(Msg.getString("abort"));
        this.abortOrCloseButton.setIcon(new ImageIcon(JAlbumFrame.class.getResource("images/media_stop.png")));
        Dimension a = this.abortOrCloseButton.getPreferredSize();
        this.abortOrCloseButton.setPreferredSize(new Dimension((int)((double)a.width * 1.25), a.height));
        this.buttonPanel.setLayout(new RiverLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.getString("progress.processingInfo"));
        this.file.setText(Msg.getString("progress.fileInfo"));
        this.timeInfo.setText(Msg.getString("progress.estimatedTimeLeftInfo"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JProgressDialog.this.this_windowClosing(e);
            }
        });
        this.getContentPane().add(this.thePanel);
        this.thePanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.directory, null);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br", this.timeInfo);
        this.thePanel.add((Component)this.buttonPanel, "South");
        if (!abortOnly) {
            this.buttonPanel.add("center", this.viewAlbumButton);
            this.buttonPanel.add(this.pauseButton);
        }
        this.buttonPanel.add("center", this.abortOrCloseButton);
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction("close"){

            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.abortOrClosePerformed(null);
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
    }

    private static String twoDigits(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    private static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + JProgressDialog.twoDigits(minutes) + ":" + JProgressDialog.twoDigits(seconds);
    }

    public synchronized void imageProcessingStarted(final AlbumBeanEvent e) {
        if (this.finished) {
            return;
        }
        if (this.pauseButton.isSelected()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isVisible() && !this.abort) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JProgressDialog.this.updateStateAndSetVisible(true);
                }
            });
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!JProgressDialog.this.timer.isRunning()) {
                    JProgressDialog.this.timer.start();
                    JProgressDialog.this.directory.setText(Msg.getString("progress.processingInfo"));
                    JProgressDialog.this.directory.setVisible(true);
                    JProgressDialog.this.file.setText(e.msg);
                    JProgressDialog.this.file.setVisible(true);
                    if (!JProgressDialog.this.progressBar.isIndeterminate()) {
                        JProgressDialog.this.progressBar.setValue(1);
                        JProgressDialog.this.progressBar.setMaximum(e.totalFiles);
                        JProgressDialog.this.progressBar.setStringPainted(true);
                        JProgressDialog.this.progressBar.setString(Msg.get("progress.processingInfo2", e.processedFiles, e.totalFiles));
                    }
                }
                JProgressDialog.this.directory.setText(Msg.get("progress.processingInfo") + " " + e.directory);
                JProgressDialog.this.file.setText(e.msg);
            }
        });
    }

    public synchronized void imageProcessingFinished(final AlbumBeanEvent e) {
        if (this.finished) {
            return;
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int processedImages = e.processedFiles;
                if (JProgressDialog.this.progressBar.getValue() < processedImages) {
                    if (!JProgressDialog.this.progressBar.isIndeterminate()) {
                        JProgressDialog.this.progressBar.setValue(processedImages);
                        JProgressDialog.this.progressBar.setMaximum(e.totalFiles);
                        JProgressDialog.this.progressBar.setStringPainted(true);
                        JProgressDialog.this.progressBar.setString(Msg.get("progress.processingInfo2", processedImages, e.totalFiles));
                    }
                    if (processedImages < e.totalFiles) {
                        long elapsed = JProgressDialog.this.timer.getMillis();
                        long totalMillis = (long)e.totalFiles * elapsed / (long)processedImages;
                        int secsLeft = (int)(totalMillis - elapsed) / 1000;
                        JProgressDialog.this.timeInfo.setText(Msg.getString("progress.estimatedTimeLeftInfo") + " " + JProgressDialog.timerFormat(secsLeft));
                    } else {
                        JProgressDialog.this.setDialogToFinishedState();
                    }
                }
            }
        });
    }

    void setDialogToFinishedState() {
        final JProgressDialog theDialog = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JProgressDialog.this.finished) {
                    return;
                }
                JProgressDialog.this.finished = true;
                JProgressDialog.this.progressBar.setIndeterminate(false);
                JProgressDialog.this.progressBar.setValue(JProgressDialog.this.progressBar.getMaximum());
                JProgressDialog.this.pauseButton.setEnabled(false);
                JProgressDialog.this.abortOrCloseButton.setText(Msg.getString("close"));
                JProgressDialog.this.directory.setVisible(false);
                JProgressDialog.this.file.setText(Msg.getString("ui.albumGenerationDone"));
                JProgressDialog.this.timer.stop();
                long secsElapsed = JProgressDialog.this.timer.getMillis() / 1000L;
                JProgressDialog.this.timeInfo.setText(Msg.getString("progress.timeElapsedInfo") + " " + JProgressDialog.timerFormat((int)secsElapsed));
                if (JAlbum.isMac()) {
                    if (!theDialog.isFocused()) {
                        theDialog.setVisible(false);
                        theDialog.setVisible(true);
                    }
                } else {
                    theDialog.toFront();
                    theDialog.requestFocus();
                }
            }
        });
    }

    public void errorOccured(Throwable t, File f) {
    }

    synchronized void abortOrClosePerformed(ActionEvent e) {
        this.updateStateAndSetVisible(false);
        if (!this.finished) {
            this.abort = true;
            this.pauseButton.setSelected(false);
            this.notifyAll();
        }
    }

    synchronized void pauseButton_actionPerformed(ActionEvent e) {
        if (this.pauseButton.isSelected()) {
            this.timer.stop();
        } else {
            this.timer.start();
            this.notifyAll();
        }
    }

    public void setIndeterminate(boolean b) {
        this.progressBar.setIndeterminate(b);
    }

    public void updateStateAndSetVisible(boolean visible) {
        if (visible) {
            this.pauseButton.setSelected(false);
            this.pauseButton.setEnabled(true);
            Dimension parentSize = this.parent.getSize();
            Dimension mySize = this.getSize();
            Point loc = this.parent.getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            this.directory.setText(" ");
            this.file.setText(" ");
            this.timeInfo.setText(" ");
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.timer.reset();
            this.abort = false;
            this.finished = false;
            this.abortOrCloseButton.setText(Msg.getString("abort"));
            this.abortOrCloseButton.setIcon(new ImageIcon(JAlbumFrame.class.getResource("images/media_stop.png")));
        }
        super.setVisible(visible);
    }

    void this_windowClosing(WindowEvent e) {
        if (!this.finished) {
            this.abort = true;
        }
    }
}

