/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import net.jalbum.slideshow.SlideShowFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JPrefsPanel_language_actionAdapter;
import se.datadosen.jalbum.JPrefsPanel_lookAndFeel_actionAdapter;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LanguageMapper;
import se.datadosen.util.PropertyBinder;

public class JPreferencesWindow
extends JSmartDialog
implements JComponentHolder {
    JAlbumFrame parent;
    JCheckBox debugMode = new JCheckBox();
    JCheckBox checkForUpdates = new JCheckBox();
    JCheckBox closeProgressDialog = new JCheckBox();
    JCheckBox useLayoutHints = new JCheckBox();
    JCheckBox restorePreviousSettings = new JCheckBox();
    JCheckBox autoWriteCommentsToFile = new JCheckBox();
    JComboBox language = new JComboBox<Object>(JPreferencesWindow.fillLanguages());
    JComboBox lookAndFeel = new JComboBox<Object>(JPreferencesWindow.fillLookAndFeels());
    ControlPanel skins = new ControlPanel();
    ControlPanel editing = new ControlPanel();
    ControlPanel publishing = new ControlPanel();
    ControlPanel guides = new ControlPanel();
    JCheckBox showWarnings = new JCheckBox();
    ControlPanel multipleProcessors = new ControlPanel();
    JLabel nThreadsLabel = new JLabel();
    JComboBox nThreads = new JComboBox<Object>(JPreferencesWindow.fillNThreads());
    JLabel myAlbumsLocationLabel = new JLabel();
    JTextField myAlbumsLocation = new JSmartTextField();
    JLabel languageLabel = new JLabel();
    JLabel lookAndFeelLabel = new JLabel();
    JLabel slideShowLabel = new JLabel();
    JCheckBox cleanOutputFiles = new JCheckBox();
    JCheckBox synchronizeOutputDirectory = new JCheckBox();
    JCheckBox cacheThumbnails = new JCheckBox();
    JCheckBox thumbnailsInFileChooser = new JCheckBox();
    public JToggleButton largeThumbnails = new JToggleButton("", true);
    JCheckBox updateProfilePage = new JCheckBox();
    JCheckBox browsePublishedAlbums = new JCheckBox();

    public JPreferencesWindow(JAlbumFrame parent) {
        super((Frame)parent, false);
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        this.setTexts();
        this.useLayoutHints.setSelected(true);
        this.restorePreviousSettings.setSelected(true);
        this.showWarnings.setSelected(true);
        this.cleanOutputFiles.setSelected(true);
        this.synchronizeOutputDirectory.setSelected(true);
        this.cacheThumbnails.setSelected(true);
        this.thumbnailsInFileChooser.setSelected(true);
        this.updateProfilePage.setSelected(true);
        this.browsePublishedAlbums.setSelected(true);
        this.checkForUpdates.setSelected(true);
        File userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
        File myAlbums = new File(userHome, Msg.get("newproject.myAlbumsDirectory"));
        this.myAlbumsLocation.setText(myAlbums.getAbsolutePath());
        this.nThreads.setSelectedIndex(0);
        this.debugMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.setProperty("log.level", JPreferencesWindow.this.debugMode.isSelected() ? "DEBUG" : "OFF");
                String logLevel = System.getProperty("log.level");
                if (logLevel == null || logLevel.equals("OFF")) {
                    Logger.setLevel((Level)Level.OFF);
                } else {
                    Logger.setLevel((Level)Level.getLevel((String)logLevel));
                }
            }
        });
        AbstractAction okAction = new AbstractAction(Msg.get("ok")){

            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.savePreferences();
            }
        };
        AbstractAction cancelAction = new AbstractAction(Msg.get("cancel")){

            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.cancelPreferences();
            }
        };
        this.registerActions(okAction, cancelAction);
        this.language.addActionListener(new JPrefsPanel_language_actionAdapter(this));
        this.lookAndFeel.addActionListener(new JPrefsPanel_lookAndFeel_actionAdapter(this));
        c.add("br", this.languageLabel);
        c.add("tab", this.language);
        c.add("br", this.lookAndFeelLabel);
        c.add("tab", this.lookAndFeel);
        c.add("br", this.nThreadsLabel);
        c.add("tab", this.nThreads);
        c.add("br", this.myAlbumsLocationLabel);
        c.add("tab hfill", this.myAlbumsLocation);
        if (Runtime.getRuntime().availableProcessors() < 2) {
            this.multipleProcessors.setEnabled(false);
        }
        c.add("p", this.checkForUpdates);
        c.add("br", this.closeProgressDialog);
        c.add("br", this.showWarnings);
        c.add("br", this.debugMode);
        c.add("br", this.cleanOutputFiles);
        c.add("br", this.synchronizeOutputDirectory);
        c.add("br", this.thumbnailsInFileChooser);
        this.skins.add(this.useLayoutHints);
        this.skins.add("br", this.restorePreviousSettings);
        c.add("br", this.skins);
        this.editing.add(this.autoWriteCommentsToFile);
        c.add("br", this.editing);
        this.publishing.add(this.updateProfilePage);
        this.publishing.add("br", this.browsePublishedAlbums);
        c.add("br", this.publishing);
    }

    public void setTexts() {
        this.languageLabel.setText(Msg.get("prefs.language"));
        this.lookAndFeelLabel.setText(Msg.get("prefs.lookAndFeel"));
        this.slideShowLabel.setText(Msg.get("prefs.slideShow"));
        this.debugMode.setText(Msg.get("ui.debugMode"));
        this.debugMode.setToolTipText(Msg.get("ui.debugModeToolTip"));
        this.cleanOutputFiles.setText(Msg.get("prefs.cleanOutputFiles"));
        this.synchronizeOutputDirectory.setText(Msg.get("prefs.synchronizeOutputDirectory"));
        this.synchronizeOutputDirectory.setToolTipText(Msg.get("prefs.synchronizeOutputDirectoryToolTip"));
        this.cacheThumbnails.setText(Msg.get("prefs.cacheThumbnails"));
        this.thumbnailsInFileChooser.setText(Msg.get("prefs.thumbnailsInFileChooser"));
        this.updateProfilePage.setText(Msg.get("prefs.updateProfilePage"));
        this.browsePublishedAlbums.setText(Msg.get("prefs.browsePublishedAlbums"));
        this.checkForUpdates.setText(Msg.get("ui.checkForUpdates"));
        this.checkForUpdates.setToolTipText(Msg.get("ui.checkForUpdatesToolTip"));
        this.closeProgressDialog.setText(Msg.get("prefs.closeProgressDialog"));
        this.useLayoutHints.setText(Msg.get("ui.useLayoutHints"));
        this.useLayoutHints.setToolTipText(Msg.get("ui.useLayoutHintsToolTip"));
        this.restorePreviousSettings.setText(Msg.get("ui.restorePreviousSettings"));
        this.restorePreviousSettings.setToolTipText(Msg.get("ui.restorePreviousSettingsToolTip"));
        this.autoWriteCommentsToFile.setText(Msg.get("prefs.autoWriteCommentsToFile"));
        this.skins.setTitle(Msg.get("prefs.skinsBorder"));
        this.editing.setTitle(Msg.get("prefs.imageEditingBorder"));
        this.guides.setTitle(Msg.get("prefs.guidesBorder"));
        this.publishing.setTitle(Msg.get("ui.publishingTitle"));
        this.showWarnings.setText(Msg.get("prefs.showWarnings"));
        this.multipleProcessors.setTitle(Msg.get("prefs.multipleProcessorsBorder"));
        this.nThreadsLabel.setText(Msg.get("prefs.nThreadsLabel"));
        this.myAlbumsLocationLabel.setText(Msg.get("prefs.myAlbumsLocation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreferences() {
        FileOutputStream fos = null;
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            PropertyBinder.getProperties(this, defaults);
            BeanBinder.setProperties((Object)Config.getConfig(), defaults);
            fos = new FileOutputStream(JAlbumFrame.defaultProjectFile);
            defaults.store(fos, "JAlbum Project");
            IO.close(fos);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
        finally {
            IO.close(fos);
        }
    }

    private void cancelPreferences() {
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            PropertyBinder.syncUI(defaults, this);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
    }

    private static Object[] fillLanguages() {
        File dir = new File(Config.getConfig().progDir, "texts");
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".properties");
            }
        });
        Object[] result = new Object[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            int underscoreIndex = name.indexOf(95);
            String iso2 = underscoreIndex == -1 ? "en" : name.substring(underscoreIndex + 1, name.lastIndexOf(46));
            result[i + 1] = new Item(iso2, LanguageMapper.getFullName(iso2));
        }
        Arrays.sort(result, 1, result.length - 1, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)((Item)o1).item).compareToIgnoreCase((String)((Item)o2).item);
            }
        });
        result[0] = new Item("default", Msg.get("prefs.systemDefault"));
        return result;
    }

    private static Object[] fillLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Object[] result = new Object[lafInfo.length + 2];
        result[0] = new Item(UIManager.getSystemLookAndFeelClassName(), Msg.get("prefs.systemDefault"));
        result[1] = new Item("com.incors.plaf.alloy.AlloyLookAndFeel", "Alloy");
        for (int i = 0; i < lafInfo.length; ++i) {
            result[i + 2] = new Item(lafInfo[i].getClassName(), lafInfo[i].getName());
        }
        return result;
    }

    private static Object[] fillSlideShow() {
        Object[] slideShowKeys = SlideShowFactory.getSlideShowKeys();
        return slideShowKeys;
    }

    private static Object[] fillNThreads() {
        Object[] result = new Object[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Integer(i + 1);
        }
        return result;
    }

    void language_actionPerformed(ActionEvent e) {
        Item lang = (Item)this.language.getSelectedItem();
        String newLang = (String)lang.value;
        Config config = Config.getConfig();
        if (!config.getLanguage().equals(newLang)) {
            config.setLanguage(newLang);
            this.parent.setTexts();
        }
    }

    void lookAndFeel_actionPerformed(ActionEvent e) {
        String laf = (String)((Item)this.lookAndFeel.getSelectedItem()).value;
        Config config = Config.getConfig();
        if (!config.getLookAndFeel().equals(laf)) {
            config.setLookAndFeel(laf);
            try {
                UIManager.setLookAndFeel(laf);
                AlloyLookAndFeel.updateAllUIs();
                this.pack();
                this.parent.validate();
            }
            catch (Exception ex) {
                this.parent.statusBar.setText(ex.toString());
            }
        }
    }
}

