/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JHyperTextDialog;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.JSmartTextPane;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Replacer;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;

public class JMarketingDialog
extends JSmartDialog {
    ImageIcon tellCommunityIcon = new ImageIcon(JMarketingDialog.class.getResource("button_images/user1_message.png"));
    ImageIcon mailIcon = new ImageIcon(JMarketingDialog.class.getResource("button_images/mail.png"));
    ImageIcon checkIcon = new ImageIcon(JMarketingDialog.class.getResource("button_images/check2.png"));
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private JLabel emailCheck = new JLabel(this.checkIcon);
    private JLabel tellCommunityCheck = new JLabel(this.checkIcon);
    private final JAlbumFrame window;
    private final JPublishWizard publishWizard;
    private final String albumUrl;

    public JMarketingDialog(JPublishWizard parent, JAlbumFrame window, String albumUrl) {
        super(parent);
        this.publishWizard = parent;
        this.window = window;
        this.albumUrl = albumUrl;
        this.init();
    }

    private void init() {
        this.setTitle(Msg.get("market.tellAFriendTitle"));
        this.tellCommunityCheck.setVisible(false);
        this.emailCheck.setVisible(false);
        JButton tellCommunityButton = new JButton(Msg.get("market.tellJAlbumCommunity"), this.tellCommunityIcon);
        tellCommunityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    HttpResponse resp;
                    JMarketingDialog.this.setCursor(new Cursor(3));
                    AlbumObject root = ((JMarketingDialog)JMarketingDialog.this).window.albumExplorer.getRootFolder();
                    String thumbnailPath = root.getThumbnailPath();
                    String cid = JMarketingDialog.this.publishWizard.getMyJAlbumCid();
                    HttpConnection conn = new HttpConnection(new URL(JAlbumSite.getInstance().getAddAlbumUrl()));
                    Properties data = new Properties();
                    data.setProperty("albumUrl", JMarketingDialog.urlEncode(JMarketingDialog.this.albumUrl));
                    if (thumbnailPath != null) {
                        String thumbnailUrl = JMarketingDialog.urlEncode(IO.combinePaths(JMarketingDialog.this.albumUrl, thumbnailPath));
                        data.setProperty("thumbnailUrl", thumbnailUrl);
                    }
                    data.setProperty("albumName", root.getName());
                    data.setProperty("albumDescription", root.getComment());
                    data.setProperty("skin", ((JMarketingDialog)JMarketingDialog.this).window.engine.getSkin());
                    data.setProperty("style", ((JMarketingDialog)JMarketingDialog.this).window.engine.getStyle());
                    if (cid != null) {
                        data.setProperty("cid", cid);
                    }
                    if ((resp = conn.Post(data)).getStatusCode() != 200) {
                        throw new IOException(Msg.get("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
                    }
                    String content = resp.getContentAsString();
                    String result = JMarketingDialog.contentOfElement("result", content);
                    if (result == null) {
                        return;
                    }
                    boolean ok = result.equals("ok");
                    String htmlMessage = JMarketingDialog.contentOfElement("htmlMessage", content);
                    if (htmlMessage != null) {
                        JHyperTextDialog dialog = new JHyperTextDialog(JMarketingDialog.this, Msg.get("market.tellJAlbumCommunity"), htmlMessage, ok ? 1 : 0);
                        dialog.setVisible(true);
                    }
                    if (ok) {
                        JMarketingDialog.this.tellCommunityCheck.setVisible(true);
                    }
                    JMarketingDialog.this.setCursor(new Cursor(0));
                }
                catch (Exception ex) {
                    JMarketingDialog.this.setCursor(new Cursor(0));
                    Debug.showErrorDialog(JMarketingDialog.this, ex);
                }
            }
        });
        JButton emailButton = new JButton(Msg.get("market.emailYourFriends"), this.mailIcon);
        emailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlbumObject root = ((JMarketingDialog)JMarketingDialog.this).window.albumExplorer.getRootFolder();
                String subject = Msg.get("market.emailSubject", root.getName(), JMarketingDialog.urlEncode(JMarketingDialog.this.albumUrl));
                String body = Msg.get("market.emailBody", root.getName(), JMarketingDialog.urlEncode(JMarketingDialog.this.albumUrl));
                try {
                    String emailUrl = "mailto:?subject=" + JMarketingDialog.mailtoEncode(subject) + "&body=" + JMarketingDialog.mailtoEncode(body);
                    System.out.println(emailUrl);
                    BrowserLauncher.openURL(emailUrl);
                    JMarketingDialog.this.emailCheck.setVisible(true);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        });
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        c.add("br", new JLabel(Msg.get("market.tellAFriendInfo", this.albumUrl)));
        try {
            JAlbumSite site = JAlbumSite.getInstance();
            if (site.getAddAlbumUrl() != null) {
                c.add("p", tellCommunityButton);
                c.add(this.tellCommunityCheck);
                c.add("br left hfill", new JSmartTextPane(Msg.get("market.tellJAlbumCommunityInfo", this.albumUrl, site.getCommunityUrl(), site.getAddAlbumInfoUrl())));
                c.add("br", new JLabel(""));
            }
        }
        catch (IOException ex) {
        }
        catch (ElementException ex) {
            // empty catch block
        }
        c.add("p", emailButton);
        c.add(this.emailCheck);
        c.add("br left hfill", new JSmartTextPane(Msg.get("market.emailYourFriendsInfo")));
        AbstractAction closeAction = new AbstractAction(Msg.get("close")){

            public void actionPerformed(ActionEvent e) {
                JMarketingDialog.this.setVisible(false);
            }
        };
        this.registerActions(closeAction);
        this.pack();
    }

    private static String mailtoEncode(String s) {
        if (JAlbum.isMac()) {
            Replacer encoder = new Replacer();
            encoder.add("+", "%20");
            try {
                String tmp = URLEncoder.encode(s, "UTF-8");
                return encoder.replace(tmp);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        Replacer encoder = new Replacer();
        encoder.add("%", "%25");
        encoder.add(" ", "%20");
        encoder.add("\n", "%0D%0A");
        encoder.add("&", "%26");
        return encoder.replace(s);
    }

    private static String urlEncode(String s) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || chars[i] == ' ' || chars[i] == '#' || chars[i] == '%' || chars[i] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    private static String contentOfElement(String name, String doc) throws ElementException {
        Element el = Elements.getElementByName(name, doc, false);
        return el != null ? el.getContent() : null;
    }
}

