/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;

public class JHyperTextDialog
extends JSmartDialog {
    private String htmlMessage;
    private String confirmationText;
    private boolean okPressed;
    private int messageType;
    private JTextPane infoPane = new JTextPane();
    private JCheckBox confirm = new JCheckBox();
    private Action okAction = new AbstractAction(Msg.getString("ok")){

        public void actionPerformed(ActionEvent e) {
            JHyperTextDialog.this.okPressed = true;
            JHyperTextDialog.this.setVisible(false);
        }
    };
    private Action cancelAction = new AbstractAction(Msg.getString("cancel")){

        public void actionPerformed(ActionEvent e) {
            JHyperTextDialog.this.okPressed = false;
            JHyperTextDialog.this.setVisible(false);
        }
    };

    public JHyperTextDialog(JDialog parent, String title, String htmlMessage, int dialogType) {
        this(parent, title, htmlMessage, dialogType, null);
    }

    public JHyperTextDialog(JDialog parent, String title, String htmlMessage, int messageType, String confirmationText) {
        super((Dialog)parent, true);
        this.setTitle(title);
        this.htmlMessage = htmlMessage;
        this.messageType = messageType;
        this.confirmationText = confirmationText;
        this.init();
        this.okAction.setEnabled(confirmationText == null);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void init() {
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        this.infoPane.setFocusable(false);
        this.infoPane.setContentType("text/html");
        this.infoPane.setOpaque(false);
        this.infoPane.setEditable(false);
        this.infoPane.setText("<html><body><font face=\"sansserif\" size=3>" + this.htmlMessage + "</font></body></html>");
        if (JAlbum.isMac()) {
            this.infoPane.setText("<html><body><font face=\"Lucida Grande,sansserif\" size=13px><br>" + this.htmlMessage + "</font></body></html>");
        }
        JLabel dummy = new JLabel();
        this.infoPane.setFont(dummy.getFont());
        this.infoPane.setSize(360, Integer.MAX_VALUE);
        this.infoPane.setPreferredSize(new Dimension(360, this.infoPane.getPreferredSize().height));
        this.infoPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL(e.getURL().toExternalForm());
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(JHyperTextDialog.this.getOwner(), ex.getMessage(), Msg.getString("wiz.openFailed"), 0);
                    }
                }
            }
        });
        c.add("hfill vfill", this.infoPane);
        if (this.confirmationText != null) {
            this.confirm.setText(this.confirmationText);
            this.confirm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JHyperTextDialog.this.okAction.setEnabled(JHyperTextDialog.this.confirm.isSelected());
                }
            });
            c.add("br", this.confirm);
            this.registerActions(this.okAction, this.cancelAction);
        } else {
            this.registerActions(this.okAction);
        }
        Icon icon = this.getIconForType(this.messageType);
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 3, 3));
            iconLabel.setVerticalAlignment(1);
            this.getRealContentPane().add((Component)iconLabel, "Before");
        }
        this.pack();
    }

    protected Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }
}

