/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class JAlbumSite {
    private static JAlbumSite theInstance;
    private String padContent;
    private String clientVersion;
    private Properties properties;

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getMyJAlbumActivationUrl() {
        return this.getProperty("myJAlbumActivationUrl");
    }

    public String getMyJAlbumAltActivationUrl() {
        return this.getProperty("myJAlbumAltActivationUrl");
    }

    public String getMyJAlbumInfoUrl() {
        return this.getProperty("myJAlbumInfoUrl");
    }

    public String getMyJAlbumQuotaUrl() {
        return this.getProperty("myJAlbumQuotaUrl");
    }

    public String getMyJAlbumPasswordProtectUrl(String hostName) {
        String path = this.getProperty("myJAlbumPasswordProtectPath");
        if (path == null) {
            return null;
        }
        return IO.combinePaths("http://" + hostName, path);
    }

    public String getMyJAlbumUpgradeUrl() {
        String url = this.getProperty("myJAlbumUpgradeUrl");
        return url != null ? url : this.getMyJAlbumInfoUrl();
    }

    public String getAddAlbumUrl() {
        return this.getProperty("addAlbumUrl");
    }

    public String getUpdateAlbumUrl() {
        return this.getProperty("updateAlbumUrl");
    }

    public String getAddAlbumInfoUrl() {
        return this.getProperty("addAlbumInfoUrl");
    }

    public String getCommunityUrl() {
        return this.getProperty("communityUrl");
    }

    private String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    private Properties getProperties() {
        return this.properties;
    }

    private JAlbumSite() throws IOException, ElementException {
        URL padUrl = new URL("http://jalbum.net/pad.xml?java.version=" + IO.urlEncode(System.getProperty("java.version")) + "&jalbum.version=" + IO.urlEncode("8.0.9") + "&os.name=" + IO.urlEncode(System.getProperty("os.name")));
        BufferedReader in = new BufferedReader(new InputStreamReader(padUrl.openStream()));
        this.padContent = IO.readAll(in);
        Element programVersion = Elements.getElementByName("Program_Version", this.padContent, false);
        if (programVersion == null) {
            throw new IOException(Msg.getString("ui.cannotFindVersionInformationError") + " " + padUrl);
        }
        this.clientVersion = programVersion.getContent();
        Element extensionData = Elements.getElementByName("JalbumExtension_Data", this.padContent, false);
        this.properties = extensionData == null ? new Properties() : AttributeTokenizer.getProperties(extensionData.getContent());
    }

    public static JAlbumSite getInstance() throws ElementException, IOException {
        if (theInstance == null) {
            theInstance = new JAlbumSite();
        }
        return theInstance;
    }
}

