/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.beans.Beans;
import java.io.File;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.jdesktop.jdic.init.JdicManager;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumConsole;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SplashScreen;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.Timer;

public class JAlbum {
    public static JAlbumFrame mainFrame = null;
    public static final Object initializedOkMonitor = new Object();
    static boolean initialized = false;
    private JAlbumAdapter dummyAdapter;
    private Timer dummyTimer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAlbum(String[] args) throws Exception {
        SplashScreen splash = new SplashScreen();
        splash.setVisible(true);
        Object object = initializedOkMonitor;
        synchronized (object) {
            try {
                JdicManager jm = JdicManager.getManager();
                jm.initShareNative();
            }
            catch (Throwable t) {
                // empty catch block
            }
            File projectFile = null;
            if (args.length > 0) {
                projectFile = new File(args[0]);
            }
            PluginManager.loadPlugins();
            mainFrame = new JAlbumFrame(projectFile);
            JAlbumContext.setFrame(mainFrame);
            mainFrame.setResizable(true);
            mainFrame.packThis();
            mainFrame.validate();
            mainFrame.setVisible(true);
            splash.setVisible(false);
            initialized = true;
        }
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static boolean isUsingAlloyLAF() {
        return UIManager.getLookAndFeel().getClass().getName().indexOf("Alloy") >= 0;
    }

    public static boolean isUsingSystemLAF() {
        return UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName());
    }

    public static void main(String[] args) {
        File defaultProjectFile = new File(System.getProperty("user.home"), ".jalbum-defaults.jap");
        try {
            boolean explicitLookAndFeel = false;
            Config config = Config.getConfig();
            if (defaultProjectFile.exists()) {
                Properties props = IO.readPropertyFile(defaultProjectFile);
                BeanBinder.setProperties((Object)config, props);
                if (props.containsKey("lookAndFeel")) {
                    explicitLookAndFeel = true;
                }
            }
            if (JAlbum.isMac()) {
                try {
                    Beans.instantiate(JAlbum.class.getClassLoader(), "se.datadosen.jalbum.SpecialMacHandler");
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Error: Failed to load extended Mac support...");
                    e.printStackTrace(System.err);
                }
            }
            if (!JAlbum.isMac() && !explicitLookAndFeel) {
                config.setLookAndFeel("com.incors.plaf.alloy.AlloyLookAndFeel");
            }
            if (config.getLookAndFeel().equals("com.incors.plaf.alloy.AlloyLookAndFeel")) {
                ImageIcon expandedIcon = new ImageIcon(JAlbumExplorer.class.getResource("images/tree_expanded.png"));
                ImageIcon collapsedIcon = new ImageIcon(JAlbumExplorer.class.getResource("images/tree_collapsed.png"));
                UIManager.getDefaults().put("Tree.expandedIcon", expandedIcon);
                UIManager.getDefaults().put("Tree.collapsedIcon", collapsedIcon);
            }
            Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
            BeanBinder.setProperties((Object)Config.getConfig(), commandLineProperties);
            SmartResourceBundle.getBundle(config.progDir, "texts/texts");
            if (commandLineProperties.size() > 0 && !commandLineProperties.containsKey("ui")) {
                Stopwatch timer = new Stopwatch();
                timer.start();
                new JAlbumConsole(commandLineProperties);
                System.out.println("Elapsed time: " + timer);
                System.exit(0);
            } else {
                AlloyLookAndFeel.setProperty((String)"alloy.licenseCode", (String)"x#David_Ekholm#y9qpca#do9gyo");
                UIManager.setLookAndFeel(config.getLookAndFeel());
                if (args.length > 0 && args[0].endsWith(".jaskin")) {
                    SkinManager sm = new SkinManager();
                    sm.installSkin(new File(args[0]), config.chainedSkinsDir.getDirectory());
                } else {
                    new JAlbum(args);
                }
            }
        }
        catch (MissingResourceException ex) {
            System.err.println("JAlbum: Cannot locate resources. Either set -programDirectory to JAlbum install directory or run JAlbum from its install directory.");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

