/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.buttonbar.PercentLayout;
import se.datadosen.jalbum.Msg;

class JAboutWindow
extends JDialog {
    private final ImageIcon dorImage = new ImageIcon(JAboutWindow.class.getResource("images/jalbumApp48.png"));
    private final ImageIcon theTeamImage = new ImageIcon(JAboutWindow.class.getResource("images/the_team.jpg"));
    private final Color lineColor = new Color(0, 0, 0, 70);

    public JAboutWindow(Frame parent) {
        super(parent, "Jalbum");
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setResizable(false);
        this.pack();
    }

    private void init() throws Exception {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.createTopPanel(), "North");
        content.add((Component)this.createCenterPanel(), "Center");
        content.add((Component)this.createBottomPanel(), "South");
    }

    private JComponent createTopPanel() {
        JPanel p = new JPanel(new BorderLayout()){

            public void paintComponent(Graphics go) {
                Graphics2D g = (Graphics2D)go;
                Point p0 = new Point(80, 0);
                Color c0 = new Color(255, 255, 255, 190);
                Point p1 = new Point(this.getWidth(), 0);
                Color c1 = new Color(140, 140, 140, 50);
                g.setPaint(new GradientPaint(p0, c0, p1, c1));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(c1);
                g.fillRect(0, 0, this.getWidth(), 1);
                g.fillRect(0, 0, this.getWidth(), 2);
                g.fillRect(0, this.getHeight() - 3, this.getWidth(), this.getHeight());
                g.fillRect(0, this.getHeight() - 2, this.getWidth(), this.getHeight());
            }
        };
        p.setPreferredSize(new Dimension(510, 79));
        MatteBorder lineSouth = BorderFactory.createMatteBorder(0, 0, 1, 0, this.lineColor);
        Border insets = BorderFactory.createEmptyBorder(9, 12, 3, 3);
        p.setBorder(BorderFactory.createCompoundBorder(lineSouth, insets));
        p.setBackground(Color.white);
        JPanel left = new JPanel(new BorderLayout());
        left.setOpaque(false);
        String tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String header = "<b>About the Jalbum Application</b>";
        String slogan = "Set your pictures free!";
        left.add((Component)JAboutWindow.html(header + "<p>" + tab + slogan), "West");
        p.add((Component)left, "Center");
        p.add((Component)new JLabel(this.dorImage), "East");
        return p;
    }

    private JComponent createCenterPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setPreferredSize(new Dimension(540, 310));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.setBorder(BorderFactory.createEmptyBorder(9, 9, 0, 9));
        tabPane.addTab("Application", this.createApplicationTab());
        tabPane.addTab("Team", this.createTeamTab());
        tabPane.addTab("System", this.createSystemTab());
        p.add((Component)tabPane, "Center");
        return p;
    }

    private JComponent createApplicationTab() {
        ControlPanel p = new ControlPanel();
        p.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        p.setLayout(new RiverLayout(6, 6));
        ((Container)p).add("hfill", JAboutWindow.html("<b>Jalbum 8.0.9</b>"));
        ((Container)p).add("br hfill", JAboutWindow.text("Copyright 2002-2008 Jalbum AB"));
        ((Container)p).add("p hfill", JAboutWindow.text(Msg.getString("about.translationInfo")));
        ((Container)p).add("p", JAboutWindow.text(Msg.getString("about.freewareInfo")));
        ((Container)p).add("br", new JLinkLabel("http://jalbum.net", "www.jalbum.net"));
        return p;
    }

    private JComponent createTeamTab() {
        ControlPanel p = new ControlPanel();
        p.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel teamLabel = new JLabel(this.theTeamImage);
        teamLabel.setBorder(this.createImageBorder());
        ((Container)p).add("vtop", teamLabel);
        ControlPanel namesPanel = new ControlPanel();
        namesPanel.setLayout(new RiverLayout(12, 6));
        ((Container)namesPanel).add("hfill", new JSmartSeparator("The Jalbum Team"));
        JLinkLabel daniel = new JLinkLabel("mailto:daniel@jalbum.net", "Daniel Frisk");
        JLinkLabel david = new JLinkLabel("mailto:david@jalbum.net", "David Ekholm");
        JLinkLabel anders = new JLinkLabel("mailto:anders@jalbum.net", "Anders Callertun");
        JLinkLabel carl = new JLinkLabel("mailto:carl@jalbum.net", "Carl M\u00e5rtensson");
        JLinkLabel dor = new JLinkLabel("mailto:dor@jalbum.net", "Dor");
        ((Container)namesPanel).add("p", daniel);
        ((Container)namesPanel).add("tab", JAboutWindow.text("Client Developer"));
        ((Container)namesPanel).add("br", david);
        ((Container)namesPanel).add("tab", JAboutWindow.text("Client Developer/Founder"));
        ((Container)namesPanel).add("br", anders);
        ((Container)namesPanel).add("tab", JAboutWindow.text("Web Developer"));
        ((Container)namesPanel).add("br", carl);
        ((Container)namesPanel).add("tab", JAboutWindow.text("Business Developer"));
        ((Container)namesPanel).add("br", dor);
        ((Container)namesPanel).add("tab", JAboutWindow.text("Friendly Frog"));
        ((Container)p).add(namesPanel);
        return p;
    }

    private Border createImageBorder() {
        Border[] borders = new Border[]{BorderFactory.createLineBorder(new Color(0x333333)), BorderFactory.createLineBorder(new Color(16645112), 7), BorderFactory.createLineBorder(new Color(0xCCCCCC))};
        Border border = borders[0];
        for (int i = 1; i < borders.length; ++i) {
            border = BorderFactory.createCompoundBorder(borders[i], border);
        }
        return border;
    }

    private JComponent createSystemTab() {
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.setBorder(BorderFactory.createEmptyBorder(0, 6, 12, 6));
        JMapTable table = new JMapTable("Property", "Value");
        table.putAll(System.getProperties());
        table.setRowHeight(table.getRowHeight() + 2);
        JScrollPane scrollTable = new JScrollPane(table);
        JPanel insetPanel = new JPanel(new BorderLayout());
        insetPanel.setOpaque(false);
        insetPanel.setBorder(BorderFactory.createEmptyBorder(14, 9, 3, 9));
        insetPanel.add((Component)scrollTable, "Center");
        p.add((Component)insetPanel, "Center");
        return p;
    }

    private JComponent createBottomPanel() {
        JPanel p = new JPanel(new PercentLayout());
        p.setBorder(BorderFactory.createEmptyBorder(3, 12, 9, 12));
        AbstractAction closeAction = new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                JAboutWindow.this.dispose();
            }
        };
        p.add(Box.createGlue(), "*");
        p.add(new JButton(closeAction));
        return p;
    }

    private static JLabel text(String text) {
        return new JLabel(text);
    }

    private static JLabel html(String text) {
        return new JLabel("<html>" + text + "</html>");
    }
}

