/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ImageIcon;

public class IconRepository {
    private static final String ICON_PROPERTIES_FILE = "icons.properties";
    private static String iconPackName = "standard";
    private static Properties properties;

    public static ImageIcon getIcon(String key) {
        String path = IconRepository.getProperties().getProperty(key);
        if (path == null) {
            throw new RuntimeException("No icon set in properties file for key=" + key);
        }
        path = "/icons/" + iconPackName + "/" + path;
        try {
            return new ImageIcon(IconRepository.class.getResource(path));
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Icon not found for path=" + path, e);
        }
    }

    public static Image getImage(String key) {
        return IconRepository.getIcon(key).getImage();
    }

    public static void setIconPack(String name) {
        try {
            iconPackName = name;
            properties = null;
            IconRepository.getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set iconpack=" + name, e);
        }
    }

    private static Properties getProperties() {
        if (properties == null) {
            try {
                properties = new Properties();
                String fileName = "/icons/" + iconPackName + "/" + ICON_PROPERTIES_FILE;
                InputStream in = IconRepository.class.getResourceAsStream(fileName);
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Property file for icons not found", e);
            }
        }
        return properties;
    }
}

