/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifDirectory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManager;
import org.jdesktop.jdic.fileutil.FileUtil;
import org.netbeans.editor.WeakPropertyChangeSupport;
import photoorganizer.formats.StrippedJpeg;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.DateResetter;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.StringCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectImpl
implements AlbumObject {
    public static final String COMMENTS_FILE_NAME = "comments.properties";
    public static final String META_FILE_NAME = "meta.properties";
    public static final String ALBUMFILES_FILE_NAME = "albumfiles.txt";
    public static final String JALBUM_FOLDER_NAME = ".jalbum";
    public static final Dimension THUMBNAIL_DIMENSION = new Dimension(160, 160);
    public static final String THUMBNAILS_FOLDER = "thumbs";
    private static DateResetter dateResetter = new DateResetter();
    private static ImageIcon folderImage = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed.png"));
    private static ImageIcon faintFolderImage = new ImageIcon(JAlbumObject.class.getResource("images/folder_closed_faint.png"));
    private static ImageIcon brokenLinkImage = new ImageIcon(JAlbumObject.class.getResource("images/broken_link.png"));
    private static DataFlavor[] flavors = new DataFlavor[]{albumObjectFlavor, DataFlavor.javaFileListFlavor};
    AlbumObjectFactory factory;
    private AlbumObject parent;
    File file;
    String comment;
    List children;
    boolean included = true;
    boolean doCache = true;
    AlbumObjectMetadata meta;
    SoftReference<AlbumObjectProperties> properties;
    private AlbumObject representingAlbumObject;
    private WeakPropertyChangeSupport changeSupport;
    FileCollection fc;

    AlbumObjectImpl(File file, AlbumObject parent, AlbumObjectFactory factory) {
        this.file = file;
        this.parent = parent;
        this.factory = factory;
        if (this.isFolder()) {
            File f = this.getFolderThumbnailFile();
            if (f != null) {
                this.representingAlbumObject = factory.createInstance(f);
            }
            this.fc = new FileCollection(factory.engine, file);
        } else {
            File thumbFile = new File(file.getParentFile(), IO.baseName(file.getName()) + ".THM");
            if (!file.equals(thumbFile) && thumbFile.exists()) {
                this.representingAlbumObject = factory.createInstance(thumbFile);
            }
        }
    }

    @Override
    public AlbumObject getParent() {
        return this.parent;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getLastModified() {
        long fileLastMod = this.file.lastModified();
        long filtersLastMod = 0L;
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        if (propFile.exists()) {
            filtersLastMod = propFile.lastModified();
        }
        return Math.max(fileLastMod, filtersLastMod);
    }

    @Override
    public Image loadImage() throws IOException {
        return this.loadImage(false, null);
    }

    @Override
    public Image loadImage(boolean useFastLoading, Dimension imageDim) throws IOException {
        BufferedImage im;
        if (!this.isDisplayableImage()) {
            return null;
        }
        if (useFastLoading) {
            int scale = FileFilters.calculateSubsamplingByScale(this.file, imageDim);
            im = FileFilters.loadImage(this.file, scale);
        } else {
            im = FileFilters.loadImage(this.file);
        }
        this.getMetadata();
        if (im.getWidth() > im.getHeight()) {
            return RotationSupport.adjustOrientation(im, this.file);
        }
        return im;
    }

    @Override
    public AlbumObjectFactory getFactory() {
        return this.factory;
    }

    @Override
    public void rotateLeft() throws IOException {
        int r = RotationSupport.getOrientation(this.meta.imageInfo);
        switch (r) {
            case 1: {
                RotationSupport.setOrientation(8, this.file);
                this.firePropertyChange("orientation", r, 8);
                break;
            }
            case 6: {
                RotationSupport.setOrientation(1, this.file);
                this.firePropertyChange("orientation", r, 1);
            }
        }
        this.meta = null;
        this.getMetadata();
    }

    @Override
    public void rotateRight() throws IOException {
        int r = RotationSupport.getOrientation(this.meta.imageInfo);
        switch (r) {
            case 1: {
                RotationSupport.setOrientation(6, this.file);
                this.firePropertyChange("orientation", r, 6);
                break;
            }
            case 8: {
                RotationSupport.setOrientation(1, this.file);
                this.firePropertyChange("orientation", r, 1);
            }
        }
        this.meta = null;
        this.getMetadata();
    }

    private void deleteFromParent() throws IOException {
        AlbumObjectImpl pao = (AlbumObjectImpl)this.parent;
        if (pao != null) {
            pao.children.remove(this);
        }
        pao.setChildren(pao.children);
    }

    @Override
    public void delete() throws IOException, PermissionException {
        File cachedThumbnailFile;
        if (!this.isLink()) {
            try {
                FileUtil fu = new FileUtil();
                fu.recycle(this.file);
            }
            catch (Throwable t) {
                if (this.isFolder()) {
                    List<AlbumObject> children = this.getChildren();
                    if (children.size() > 0) {
                        throw new PermissionException(Msg.get("edit.folderNotEmptyError", this.getName()));
                    }
                    this.deleteFolderSafely(this.file);
                }
                this.file.delete();
            }
        }
        File aop = AlbumObjectProperties.getPropertyFile(this.file);
        if (aop.exists()) {
            aop.delete();
        }
        if ((cachedThumbnailFile = AlbumObjectImpl.getCachedThumbnailFile(this.file)).exists()) {
            cachedThumbnailFile.delete();
        }
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        albumSynchronizer.delete(albumSynchronizer.translate(this));
        this.deleteFromParent();
    }

    private boolean deleteFolderSafely(File folder) throws IOException {
        File f = new File(folder, COMMENTS_FILE_NAME);
        f.delete();
        f = new File(folder, META_FILE_NAME);
        f.delete();
        f = new File(folder, ALBUMFILES_FILE_NAME);
        f.delete();
        File jalbumFolder = new File(folder, JALBUM_FOLDER_NAME);
        if (jalbumFolder.exists()) {
            AlbumObjectImpl.deleteDirRecursively(jalbumFolder);
        }
        File dsStore = new File(folder, ".DS_Store");
        dsStore.delete();
        File thumbsDb = new File(folder, "THUMBS.DB");
        thumbsDb.delete();
        return folder.delete();
    }

    private static void deleteDirRecursively(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                AlbumObjectImpl.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    @Override
    public AlbumObject createFolder(String suggestedName) throws IOException {
        File folderFile = new File(this.file, suggestedName);
        if (folderFile.exists()) {
            int i = 1;
            while ((folderFile = new File(this.file, suggestedName + i)).exists()) {
                ++i;
            }
        }
        folderFile.mkdir();
        AlbumObject ao = this.factory.createInstance(folderFile, this);
        this.children.add(ao);
        return ao;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean setName(String newName) {
        newName = newName.trim();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        String oldName = this.file.getName();
        File renamedFile = new File(this.file.getParentFile(), newName);
        if (!this.isFolder() && !IO.extensionOf(newName).equals(IO.extensionOf(this.file))) {
            renamedFile = new File(renamedFile.getParentFile(), IO.baseName(renamedFile) + "." + IO.extensionOf(this.file));
        }
        if (this.isLink()) {
            renamedFile = new LinkFile(((LinkFile)this.file).getLink().getParentFile(), renamedFile.getName(), this.file.getAbsoluteFile());
        }
        if (this.file.renameTo(renamedFile)) {
            if (this.parent != null) {
                AlbumObjectImpl.setComment(this.getComment(), renamedFile, this.file);
            }
            File propFile = AlbumObjectProperties.getPropertyFile(this.file);
            File renamedPropFile = AlbumObjectProperties.getPropertyFile(renamedFile);
            if (propFile.exists()) {
                propFile.renameTo(renamedPropFile);
            }
            File thumbFile = AlbumObjectImpl.getCachedThumbnailFile(this.file);
            File renamedThumbFile = AlbumObjectImpl.getCachedThumbnailFile(renamedFile);
            if (thumbFile.exists()) {
                thumbFile.renameTo(renamedThumbFile);
            }
            File fromTranslated = albumSynchronizer.translate(this);
            this.file = renamedFile;
            File toTranslated = albumSynchronizer.translate(this);
            albumSynchronizer.moveTo(fromTranslated, toTranslated);
            try {
                if (this.parent != null) {
                    this.parent.setChildren(this.parent.getChildren());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.invalidate();
            this.firePropertyChange("name", oldName, newName);
            return true;
        }
        return false;
    }

    @Override
    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        if (this.isFolder()) {
            try {
                Map props = this.getFolderProperties();
                this.comment = (String)props.get("descript");
                return this.comment != null ? this.comment : "";
            }
            catch (IOException ex) {
                return "";
            }
        }
        this.getMetadata();
        this.comment = this.factory.engine.readComment(this.file, this.parent != null ? this.parent.getFile() : this.file.getParentFile(), this.meta.imageInfo);
        return this.comment;
    }

    @Override
    public void setComment(String newComment) throws IOException {
        String oldComment = this.comment;
        if (newComment.equals(oldComment)) {
            return;
        }
        if (this.isFolder()) {
            Map props = this.getFolderProperties();
            props.put("descript", newComment);
            this.setFolderProperties(props);
            this.comment = newComment;
        } else {
            String ext;
            AlbumObjectImpl.setComment(newComment, this.file, this.file);
            this.comment = newComment;
            if (JAlbum.mainFrame.preferencesWindow.autoWriteCommentsToFile.isSelected() && ((ext = IO.extensionOf(this.file).toLowerCase()).equals("jpeg") || ext.equals("jpg"))) {
                new Thread("CommentWritingThread"){

                    public void run() {
                        try {
                            AlbumObjectImpl.this.doWriteJPEGComment(AlbumObjectImpl.this.comment);
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(null, ex);
                        }
                    }
                }.start();
            }
        }
        this.firePropertyChange("comment", oldComment, newComment);
    }

    @Override
    public String getPathFromRoot() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.getParent() == null) {
            return this.getName();
        }
        return this.parent.getPathFromRoot() + '/' + this.getName();
    }

    private void doWriteJPEGComment(String comment) throws IOException {
        long lastModified = this.file.lastModified();
        JAlbumFrame parentFrame = JAlbum.mainFrame;
        StrippedJpeg jpeg = new StrippedJpeg(this.file);
        String encoding = parentFrame.settingsWindow.textEncoding.getSelectedItem().toString();
        StrippedJpeg.setEncoding(encoding);
        if (parentFrame.settingsWindow.writeUTF8.isSelected()) {
            encoding = "UTF-8";
        }
        if (!StringCodec.isEncodable(comment, encoding)) {
            encoding = "UTF-8";
        }
        jpeg.setComment(comment);
        StrippedJpeg.setEncoding(encoding);
        File tmpFile = File.createTempFile("JAlbum", "JPG");
        jpeg.transform(tmpFile.getAbsolutePath(), 8);
        if (tmpFile.length() < this.file.length() / 2L) {
            throw new IOException(Msg.get("edit.commentWritingError"));
        }
        IO.copyFile(tmpFile, this.file);
        if (!this.file.setLastModified(lastModified)) {
            dateResetter.addFile(this.file, lastModified);
        }
        tmpFile.delete();
    }

    @Override
    public AlbumObjectMetadata getMetadata() {
        if (this.meta == null) {
            try {
                this.meta = new AlbumObjectMetadata(this.file);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.meta;
    }

    @Override
    public AlbumObjectProperties getProperties() {
        AlbumObjectProperties aop;
        AlbumObjectProperties albumObjectProperties = aop = this.properties != null ? this.properties.get() : null;
        if (aop == null) {
            aop = new AlbumObjectProperties(this);
            this.properties = new SoftReference<AlbumObjectProperties>(aop);
        }
        return aop;
    }

    @Override
    public boolean isDisplayableImage() {
        return this.file.exists() && !FileFilters.hasIcon(this.file);
    }

    @Override
    public boolean isLink() {
        return this.file instanceof LinkFile;
    }

    @Override
    public boolean isFolder() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        boolean oldIncluded = this.included;
        this.included = included;
        this.firePropertyChange("included", new Boolean(oldIncluded), new Boolean(included));
    }

    @Override
    public List<AlbumObject> getChildren() {
        if (this.isFolder() && this.children == null) {
            this.children = new LinkedList();
            if (!this.file.equals(this.fc.getBaseDir())) {
                this.fc = new FileCollection(this.factory.engine, this.file);
            }
            this.fc.setDoSort(true);
            File[] files = this.fc.listFiles(this.factory.getFilter(), true, true);
            for (int i = 0; i < files.length; ++i) {
                AlbumObjectImpl ao = new AlbumObjectImpl(files[i], this, this.factory);
                if (this.fc.isExcluded(files[i])) {
                    ao.setIncluded(false);
                }
                this.children.add(ao);
            }
        }
        return this.children;
    }

    @Override
    public void setChildren(List<AlbumObject> children) throws IOException {
        this.children = children;
        StringBuilder content = new StringBuilder();
        content.append("# This file is created by JAlbum. It sets custom file filtering and ordering for this image directory.\r\n# Each row indicate a file and it's order. Files not listed here are added to the end of the album\r\n# Rows beginning with \"-\" indicate excluded files.\r\n# Rows containing a tab character indicate links, where the text before the tab is the logical file name\r\n# and the path to the right is the target path.\r\n# Note: This file allows absolute paths to files and directories in other locations and thereby\r\n# allows you to compile albums consisting of files from several different locations.\r\n\r\n");
        for (AlbumObjectImpl albumObjectImpl : children) {
            if (!albumObjectImpl.isIncluded()) {
                content.append('-');
            }
            content.append(albumObjectImpl.file.getName());
            if (albumObjectImpl.file instanceof LinkFile) {
                content.append('\t');
                content.append(albumObjectImpl.file.getAbsolutePath());
            }
            content.append("\r\n");
        }
        File file = new File(this.file, ALBUMFILES_FILE_NAME);
        String textEncoding = this.factory.engine.isWriteUTF8() ? "UTF-8" : this.factory.engine.getTextEncoding();
        String s = content.toString();
        if (!textEncoding.equals("UTF-8") && !StringCodec.isEncodable(s, textEncoding)) {
            textEncoding = "UTF-8";
        }
        IO.writeTextFile(s, file, textEncoding);
    }

    @Override
    public boolean containsName(String name) {
        List<AlbumObject> childObjects = this.getChildren();
        for (AlbumObject child : childObjects) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveTo(AlbumObject newParent) throws IOException {
        this.moveTo(newParent, -1);
    }

    @Override
    public boolean repairLink(File newTarget) throws IOException {
        if (!this.isLink() || this.file.exists()) {
            return false;
        }
        this.file = new LinkFile(((LinkFile)this.file).getLink().getParentFile(), this.file.getName(), newTarget);
        this.invalidate();
        this.parent.setChildren(this.parent.getChildren());
        return true;
    }

    @Override
    public void moveTo(AlbumObject newParent, int position) throws IOException {
        File newFile;
        if (!newParent.isFolder()) {
            throw new IllegalArgumentException("Argument must be a folder");
        }
        if (newParent.containsName(this.getName())) {
            throw new IOException(Msg.get("edit.objectAlreadyExists", this.getName()));
        }
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.factory.engine);
        File fromTranslated = albumSynchronizer.translate(this);
        if (this.isLink()) {
            newFile = new LinkFile(newParent.getFile(), this.getName(), this.file.getAbsoluteFile());
        } else {
            newFile = new File(newParent.getFile(), this.getName());
            if (!this.file.renameTo(newFile)) {
                throw new IOException(Msg.get("edit.moveError", newFile));
            }
        }
        if (this.parent != null) {
            AlbumObjectImpl.setComment(this.getComment(), newFile, this.file);
        }
        File propFile = AlbumObjectProperties.getPropertyFile(this.file);
        File renamedPropFile = AlbumObjectProperties.getPropertyFile(newFile);
        if (propFile.exists()) {
            renamedPropFile.getParentFile().mkdir();
            propFile.renameTo(renamedPropFile);
        }
        File thumbFile = AlbumObjectImpl.getCachedThumbnailFile(this.file);
        File renamedThumbFile = AlbumObjectImpl.getCachedThumbnailFile(newFile);
        if (thumbFile.exists()) {
            renamedThumbFile.getParentFile().mkdirs();
            thumbFile.renameTo(renamedThumbFile);
        }
        this.invalidate();
        this.deleteFromParent();
        this.file = newFile;
        this.parent = newParent;
        List<AlbumObject> l = newParent.getChildren();
        if (position != -1) {
            l.add(position, this);
        } else {
            l.add(this);
        }
        newParent.setChildren(l);
        File toTranslated = albumSynchronizer.translate(this);
        albumSynchronizer.moveTo(fromTranslated, toTranslated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(List<File> files) throws IOException {
        try {
            this.getChildren();
            for (File f : files) {
                if (this.containsName(f.getName())) {
                    throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                }
                AlbumObject ao = this.factory.createInstance(new LinkFile(this.file, f.getName(), f), this);
                this.children.add(ao);
            }
        }
        finally {
            this.setChildren(this.children);
        }
    }

    @Override
    public String getOrdering() {
        return this.fc.getOrdering();
    }

    @Override
    public void setOrdering(String ordering) throws IOException {
        this.fc.setOrdering(ordering);
    }

    @Override
    public String getFolderOrdering() {
        return this.fc.getFolderOrdering();
    }

    @Override
    public void setFolderOrdering(String folderOrdering) throws IOException {
        this.fc.setFolderOrdering(folderOrdering);
    }

    @Override
    public boolean isFoldersFirst() {
        return this.fc.isFoldersFirst();
    }

    @Override
    public void setFoldersFirst(boolean foldersFirst) throws IOException {
        this.fc.setFoldersFirst(foldersFirst);
    }

    @Override
    public boolean isReverseOrdering() {
        return this.fc.isReverseOrdering();
    }

    @Override
    public void setReverseOrdering(boolean reverseOrdering) throws IOException {
        this.fc.setReverseOrdering(reverseOrdering);
    }

    @Override
    public boolean isReverseFolderOrdering() {
        return this.fc.isReverseFolderOrdering();
    }

    @Override
    public void setReverseFolderOrdering(boolean reverseFolderOrdering) throws IOException {
        this.fc.setReverseFolderOrdering(reverseFolderOrdering);
    }

    @Override
    public void invalidate() {
        this.children = null;
    }

    @Override
    public ImageIcon getRepresentingIcon(Dimension bounds, boolean enlarge) throws IOException {
        if (!this.isDisplayableImage()) {
            ImageIcon repIcon = null;
            if (this.representingAlbumObject != null) {
                repIcon = this.representingAlbumObject.getRepresentingIcon(bounds, enlarge);
                if (this.isFolder() && !this.representingAlbumObject.isFolder() && repIcon != null) {
                    Image ri = repIcon.getImage();
                    ri = this.factory.engine.createBufferedImage(ri);
                    Graphics2D g = (Graphics2D)ri.getGraphics();
                    Image fi = faintFolderImage.getImage();
                    g.drawImage(fi, (ri.getWidth(null) - fi.getWidth(null)) / 2, (ri.getHeight(null) - fi.getHeight(null)) / 2, null);
                    g.dispose();
                    repIcon = new ImageIcon(ri);
                }
                return repIcon;
            }
            repIcon = !this.file.exists() ? brokenLinkImage : (this.isFolder() ? folderImage : new ImageIcon(FileFilters.getIconFor(this.file, this.factory.engine).toURL()));
            return repIcon;
        }
        try {
            File thumbnailFile = AlbumObjectImpl.getCachedThumbnailFile(this.file);
            if (thumbnailFile.exists()) {
                if (thumbnailFile.lastModified() < this.file.lastModified()) {
                    this.updateRepresentingIcon();
                }
                ImageIcon ii = new ImageIcon(FileFilters.loadImage(thumbnailFile));
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, enlarge), this.file);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.getMetadata();
            if (this.meta.imageInfo != null && this.meta.imageInfo.containsDirectory(ExifDirectory.class)) {
                Directory dir = this.meta.imageInfo.getDirectory(ExifDirectory.class);
                byte[] rawImage = (byte[])dir.getObject(61441);
                ImageIcon ii = new ImageIcon(rawImage);
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, enlarge), this.file);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(this.file));
            if (it.hasNext()) {
                ImageReader ir = it.next();
                ImageInputStream iis = ImageIO.createImageInputStream(this.file);
                ir.setInput(iis);
                int minIndex = ir.getMinIndex();
                if (ir.hasThumbnails(minIndex)) {
                    BufferedImage bi = ir.readThumbnail(minIndex, minIndex);
                    iis.close();
                    if (bi != null) {
                        return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(new ImageIcon(bi), bounds, enlarge), this.file);
                    }
                } else {
                    iis.close();
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            int scale = FileFilters.calculateSubsamplingByScale(this.file, THUMBNAIL_DIMENSION);
            BufferedImage bi = FileFilters.loadImage(this.file, scale);
            ImageIcon ii = new ImageIcon(bi);
            try {
                this.setRepresentingIcon(bi, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, bounds, enlarge), this.file);
            }
            catch (Exception e) {
                return AlbumObjectImpl.scaleToFit(ii, bounds, enlarge);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public File getRepresentingIconFile() {
        if (this.representingAlbumObject != null) {
            return this.representingAlbumObject.getRepresentingIconFile();
        }
        if (this.isFolder()) {
            return null;
        }
        return this.file;
    }

    @Override
    public void setRepresentingIconFile(File f) {
        try {
            Map props = this.getFolderProperties();
            props.remove("folderIconDirectory");
            if (f == null) {
                props.remove("folderIcon");
                this.representingAlbumObject = null;
            } else {
                if (f instanceof LinkFile) {
                    props.put("folderIcon", IO.relativePath(((LinkFile)f).getLink(), this.file));
                } else {
                    props.put("folderIcon", IO.relativePath(f, this.file));
                }
                this.representingAlbumObject = this.factory.createInstance(f);
            }
            this.setFolderProperties(props);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public String getThumbnailPath() {
        File f = this.factory.engine.getFolderThumbnailFile(this.file, true);
        if (f != null) {
            String path = IO.relativePath(AlbumObjectImpl.getAlbumParentFile(f), this.file);
            if (".".equals(path)) {
                path = "";
            }
            path = IO.combinePaths(path, this.factory.engine.getThumbnailDirectory());
            path = IO.combinePaths(path, this.factory.engine.getThumbnailPrefix() + AlbumBean.jpegName(f.getName()));
            return path;
        }
        return null;
    }

    public static ImageIcon scaleToFit(ImageIcon image, Dimension boundingBox, boolean enlarge) {
        Image scaled;
        int width = image.getIconWidth();
        int height = image.getIconHeight();
        if (!enlarge && width <= boundingBox.width && height <= boundingBox.height) {
            return image;
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        if (newWidth * 2 <= width) {
            scaled = image.getImage().getScaledInstance(newWidth, newHeight, 4);
        } else {
            Image doubleSized = image.getImage().getScaledInstance(newWidth * 2, newHeight * 2, 2);
            scaled = doubleSized.getScaledInstance(newWidth, newHeight, 4);
        }
        scaled.flush();
        return new ImageIcon(scaled);
    }

    private static BufferedImage quickScaleToFit(BufferedImage image, Dimension boundingBox) {
        int width = image.getWidth();
        int height = image.getHeight();
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        ImageScaler scaler = ImageScaler.getScaler("ScaleFast");
        return scaler.scale(image, newWidth, newHeight);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AlbumObject)) {
            return false;
        }
        AlbumObjectImpl otherAO = (AlbumObjectImpl)o;
        return this.file.equals(otherAO.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    static void setComment(String comment, File file, File oldFile) {
        boolean done = false;
        try {
            Map<String, String> map;
            File oldMapFile = new File(AlbumObjectImpl.getAlbumParentFile(oldFile), COMMENTS_FILE_NAME);
            File newMapFile = new File(AlbumObjectImpl.getAlbumParentFile(file), COMMENTS_FILE_NAME);
            if (oldMapFile.exists()) {
                map = IO.readMapFile(oldMapFile);
                if (oldFile != null) {
                    map.remove(oldFile.getName());
                }
                if (newMapFile.equals(oldMapFile)) {
                    if (comment.length() > 0) {
                        map.put(file.getName(), comment);
                    } else {
                        map.remove(file.getName());
                    }
                    done = true;
                }
                IO.writeMapFile(map, oldMapFile);
                if (done) {
                    return;
                }
            }
            map = new HashMap();
            if (newMapFile.exists()) {
                map = IO.readMapFile(newMapFile);
            }
            if (comment.length() > 0) {
                map.put(file.getName(), comment);
            } else {
                map.remove(file.getName());
            }
            IO.writeMapFile(map, newMapFile);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private Map getFolderProperties() throws IOException {
        return AlbumBean.getFolderProperties(this.file);
    }

    private void setFolderProperties(Map properties) throws IOException {
        IO.writeMapFile(properties, new File(this.file, META_FILE_NAME));
    }

    private File getFolderThumbnailFile() {
        return this.factory.engine.getFolderThumbnailFile(this.file, this.factory.engine.isUseThumbForFolderIcon());
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        if (flavor.equals(flavors[1])) {
            return new File[]{this.file};
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void setRepresentingIcon(BufferedImage thumbnail, boolean changed) throws IOException {
        if (this.factory.isCacheThumbnails()) {
            try {
                int existingOrientation = RotationSupport.getOrientation(this.file);
                if (existingOrientation == 6) {
                    existingOrientation = 8;
                } else if (existingOrientation == 8) {
                    existingOrientation = 6;
                }
                thumbnail = RotationSupport.adjustOrientation(thumbnail, existingOrientation);
            }
            catch (IOException ex) {
                // empty catch block
            }
            AlbumImage ai = new AlbumImage(thumbnail, this.factory.engine);
            ai = ai.scaleToFit(THUMBNAIL_DIMENSION);
            File thumbnailFile = AlbumObjectImpl.getCachedThumbnailFile(this.file);
            thumbnailFile.getParentFile().mkdirs();
            ai.saveJPEG(thumbnailFile);
        }
        if (changed) {
            this.firePropertyChange("imageUpdated", null, null);
        }
    }

    @Override
    public void updateRepresentingIcon() throws IOException {
        int scale = FileFilters.calculateSubsamplingByScale(this.file, THUMBNAIL_DIMENSION);
        BufferedImage im = FileFilters.loadImage(this.file, scale);
        if (im.getWidth() > im.getHeight()) {
            im = RotationSupport.adjustOrientation(im, this.file);
        }
        FilterManager fm = new FilterManager(null);
        AlbumObjectProperties props = this.getProperties();
        FilterList fl = (FilterList)props.get("filterList");
        if (fl != null) {
            fm.setFilterList(fl);
            im = fm.applyPrescaleFilters(im);
            im = AlbumObjectImpl.quickScaleToFit(im, new Dimension(600, 600));
            im = fm.applyPostscaleFilters(im);
        }
        this.setRepresentingIcon(im, true);
    }

    static File getThumbnailsFolder(File f) {
        return new File(AlbumObjectImpl.getJAlbumFolder(f), THUMBNAILS_FOLDER);
    }

    private static File getCachedThumbnailFile(File f) {
        return new File(AlbumObjectImpl.getThumbnailsFolder(f), AlbumBean.jpegName(f.getName()));
    }

    static File getAlbumParentFile(File f) {
        return f instanceof LinkFile ? ((LinkFile)f).getLink().getParentFile() : f.getParentFile();
    }

    static File getJAlbumFolder(File f) {
        return new File(AlbumObjectImpl.getAlbumParentFile(f), JALBUM_FOLDER_NAME);
    }
}

