/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.HashMap;

public class ChainedDirectory
implements Serializable {
    private File dir;
    private ChainedDirectory backgroundDir;

    public ChainedDirectory(File dir) {
        this.dir = dir;
    }

    public ChainedDirectory(File dir, ChainedDirectory backgroundDir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.dir = dir;
        this.backgroundDir = backgroundDir;
    }

    public File getDirectory() {
        return this.dir;
    }

    public ChainedDirectory getBackgroundDirectory() {
        return this.backgroundDir;
    }

    public File getFile(String name) {
        File f = new File(this.dir, name);
        if (!f.exists() && this.backgroundDir != null) {
            return this.backgroundDir.getFile(name);
        }
        return f;
    }

    public File[] listFiles() {
        return this.listFiles(null);
    }

    public File[] listFiles(FileFilter filter) {
        int i;
        File[] files = this.dir.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        if (this.backgroundDir == null) {
            return files;
        }
        File[] bgfiles = this.backgroundDir.listFiles(filter);
        HashMap<String, File> allfiles = new HashMap<String, File>();
        for (i = 0; i < files.length; ++i) {
            allfiles.put(files[i].getName(), files[i]);
        }
        for (i = 0; i < bgfiles.length; ++i) {
            if (allfiles.containsKey(bgfiles[i].getName())) continue;
            allfiles.put(bgfiles[i].getName(), bgfiles[i]);
        }
        return allfiles.values().toArray(new File[0]);
    }
}

