/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.imaging.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import se.datadosen.imaging.exif.TagFormatter;
import se.datadosen.util.FormattedDate;

public class ImageInfoFormatter
implements Serializable {
    protected static TagFormatter meterFormatter = new TagFormatter(){

        public Object format(Object data) {
            Rational distance = (Rational)data;
            return distance.floatValue() + "m";
        }
    };
    protected static TagFormatter millimeterFormatter = new TagFormatter(){

        public Object format(Object data) {
            Rational distance = (Rational)data;
            return distance.floatValue() + "mm";
        }
    };
    protected static TagFormatter floatFormatter = new TagFormatter(){

        public Object format(Object data) {
            if (data instanceof String) {
                return new Float((String)data);
            }
            Rational r = (Rational)data;
            return new Float(r.floatValue());
        }
    };
    protected static TagFormatter commentFormatter = new TagFormatter(){

        public Object format(Object data) {
            return "" + data;
        }
    };
    protected static TagFormatter secondFormatter = new TagFormatter(){

        public Object format(Object data) {
            Rational time = (Rational)data;
            Rational normalisedTime = time.getNumerator() < time.getDenominator() ? new Rational(1L, time.getDenominator() / time.getNumerator()) : new Rational(time.getNumerator() / time.getDenominator(), 1L);
            if (time.floatValue() < 0.3f) {
                return normalisedTime.toString() + "s";
            }
            return time.floatValue() + "s";
        }
    };
    private Metadata info;
    private HashMap ruleMap = new HashMap();
    private DateFormat dateFormat;
    protected TagFormatter dateFormatter = new TagFormatter(){

        public Object format(Object data) {
            String dateString = data.toString();
            Date d = ImageInfoFormatter.parseExifDate(dateString);
            if (d != null) {
                return new FormattedDate(d, ImageInfoFormatter.this.dateFormat);
            }
            return dateString;
        }
    };

    public ImageInfoFormatter() {
        this(null);
    }

    public ImageInfoFormatter(Metadata info) {
        this.info = info;
        this.put(36867, this.dateFormatter);
        this.put(36868, this.dateFormatter);
        this.put(37382, meterFormatter);
        this.put(37381, floatFormatter);
        this.put(37378, floatFormatter);
        this.put(33434, secondFormatter);
        this.put(37377, floatFormatter);
        this.put(37386, millimeterFormatter);
        this.put(33437, floatFormatter);
        this.put(37510, commentFormatter);
        this.put(37383, new TagFormatter(){

            public Object format(Object data) {
                switch ((Integer)data) {
                    case 2: {
                        return "Center-weighted averaging";
                    }
                    case 3: {
                        return "Spot";
                    }
                    case 5: {
                        return "Evaluative";
                    }
                }
                return data.toString();
            }
        });
        this.put(41495, new TagFormatter(){

            public Object format(Object data) {
                switch ((Integer)data) {
                    case 0: {
                        return "Undefined";
                    }
                    case 1: {
                        return "MonochromeArea";
                    }
                    case 2: {
                        return "OneChipColorArea";
                    }
                    case 3: {
                        return "TwoChipColorArea";
                    }
                    case 4: {
                        return "ThreeChipColorArea";
                    }
                    case 5: {
                        return "ColorSequentialArea";
                    }
                    case 6: {
                        return "MonochromeLinear";
                    }
                    case 7: {
                        return "ColorSequentialLinear";
                    }
                }
                return data.toString();
            }
        });
        this.put(41486, floatFormatter);
        this.put(41487, floatFormatter);
        this.put(41488, new TagFormatter(){

            public Object format(Object data) {
                switch ((Integer)data) {
                    case 1: {
                        return "Inch";
                    }
                    case 2: {
                        return "Meter";
                    }
                    case 3: {
                        return "Centimeter";
                    }
                    case 4: {
                        return "Millimeter";
                    }
                    case 5: {
                        return "Micrometer";
                    }
                }
                return data.toString();
            }
        });
    }

    public void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setMetadata(Metadata info) {
        this.info = info;
    }

    public static Date parseExifDate(String exifDate) {
        String[] patterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "dd-MM-yyyy HH:mm:ss", "dd-MM-yy HH:mm:ss", "dd-MM-yyyy", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy", "dd.MM.yyyy", "dd.MM.yy HH:mm", "yyyyMMdd HHmmss", "yyyyMMdd HHmm", "MM/dd/yy hh:mm a", "HH:mm:ss dd.MM.yyyy", "yyyy:MM:dd", "yyyy-MM-dd", "dd.MM.yy", "yyyyMMdd", "MM/dd/yy"};
        for (int i = 0; i < patterns.length; ++i) {
            try {
                SimpleDateFormat parser = new SimpleDateFormat(patterns[i]);
                return parser.parse(exifDate);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public void put(int tagType, TagFormatter tf) {
        this.ruleMap.put(new Integer(tagType), tf);
    }

    public Object format(Object data, int tagType) throws MetadataException {
        try {
            if (data == null) {
                return "";
            }
            TagFormatter tf = (TagFormatter)this.ruleMap.get(new Integer(tagType));
            if (tf != null) {
                return tf.format(data);
            }
            return data;
        }
        catch (ArithmeticException ex) {
            return "N/A";
        }
    }

    public Object format(int tagType) throws MetadataException {
        Directory dir = this.info.getDirectory(ExifDirectory.class);
        Object data = dir.getObject(tagType);
        return this.format(data, tagType);
    }

    public static void main(String[] args) throws Exception {
    }
}

