/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JExplorerPanel
extends JPanel
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    public static final String NAME = "explorerPanel";
    private static final Color rubberBandColor = new Color(SystemColor.textHighlight.getRed(), SystemColor.textHighlight.getGreen(), SystemColor.textHighlight.getBlue(), 70);
    private static final Color dropTargetColor = new Color(200, 200, 200);
    private static final Image dropTargetImage = new ImageIcon(JAlbumObject.class.getResource("images/droptarget.png")).getImage();
    static final int SMALL_OBJECT_SIZE = 96;
    static final int LARGE_OBJECT_SIZE = 160;
    static final int LABEL_HEIGHT = 20;
    SmartFlowLayout explorerThumbsLayout = new SmartFlowLayout();
    Rectangle rubberband;
    private Point caretLocation;
    ExplorerSelectionModel selectionModel = new ExplorerSelectionModel(this);
    final JAlbumExplorer context;
    JAlbumObject closestComp;
    JAlbumObject dropFolder;
    boolean insertBefore;
    private LinkedList<JAlbumObject> draggedObjects;
    private transient Vector structureListeners;
    Dimension iconBounds;
    Dimension objectSize;

    public JExplorerPanel(JAlbumExplorer context) {
        this.context = context;
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        if (context.parent.preferencesWindow.largeThumbnails.isSelected()) {
            this.setIconBounds(new Dimension(160, 160));
        } else {
            this.setIconBounds(new Dimension(96, 96));
        }
        this.explorerThumbsLayout.setAlignment(0);
        this.explorerThumbsLayout.setHgap(32);
        this.explorerThumbsLayout.setVgap(26);
        this.setLayout(this.explorerThumbsLayout);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void setIconBounds(Dimension bounds) {
        this.iconBounds = bounds;
        this.objectSize = new Dimension(this.iconBounds.width, this.iconBounds.height + 20);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension p = super.getPreferredSize();
        int preferredWidth = this.getParent().getWidth();
        return new Dimension(preferredWidth, p.height);
    }

    private boolean isProjectLoaded() {
        return this.context.rootFolder != null && this.context.rootFolder.getName().length() > 0;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        boolean projectLoaded = this.isProjectLoaded();
        if (!projectLoaded) {
            this.paintDropTarget(g);
        }
        if (this.rubberband != null) {
            this.paintRubberband(g);
        }
        if (this.caretLocation != null) {
            this.paintCaret(g);
        }
        if (this.dropFolder != null) {
            this.paintDropTargetFolder(g);
        }
        this.context.newFolderAction.setEnabled(projectLoaded);
        this.context.editModeAction.setEnabled(projectLoaded);
        this.context.propertiesAction.setEnabled(projectLoaded);
    }

    private void paintDropTarget(Graphics g) {
        int cw = this.getWidth();
        int ch = this.getHeight();
        int iw = dropTargetImage.getWidth(null);
        int ih = dropTargetImage.getHeight(null);
        int ix = (cw - iw) / 2;
        int iy = (ch - ih) / 2 - 18;
        g.drawImage(dropTargetImage, ix, iy, this);
        g.setColor(dropTargetColor);
        String dropString = Msg.get("ui.dropPrompt");
        Font oldFont = g.getFont();
        g.setFont(new Font("SansSerif", 1, 15));
        Rectangle2D sb = g.getFontMetrics().getStringBounds(dropString, g);
        int sw = (int)sb.getWidth();
        int sh = (int)sb.getHeight();
        int sx = (cw - sw) / 2;
        int sy = iy + ih + sh + 8;
        g.drawString(dropString, sx, sy);
        g.setFont(oldFont);
    }

    private void paintRubberband(Graphics g) {
        g.setColor(rubberBandColor);
        g.fillRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        g.setColor(SystemColor.textHighlight);
        g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
    }

    private void paintCaret(Graphics g) {
        g.setColor(Color.black);
        Point cl = this.caretLocation;
        int h = this.objectSize.height + 4;
        g.fillRect(cl.x, cl.y, 2, h);
        g.drawLine(cl.x - 2, cl.y, cl.x + 3, cl.y);
        g.drawLine(cl.x - 1, cl.y + 1, cl.x + 2, cl.y + 1);
        g.drawLine(cl.x - 2, cl.y + h, cl.x + 3, cl.y + h);
        g.drawLine(cl.x - 1, cl.y + h - 1, cl.x + 2, cl.y + h - 1);
    }

    private void paintDropTargetFolder(Graphics g) {
        Rectangle r = this.dropFolder.getBounds();
        g.setColor(rubberBandColor);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    JAlbumObject getPreviousComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = 1; i < comps.length; ++i) {
            if (comps[i] != rel) continue;
            while (i >= 0 && !comps[--i].isVisible()) {
            }
            if (i < 0) continue;
            return (JAlbumObject)comps[i];
        }
        return null;
    }

    JAlbumObject getNextComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length - 1; ++i) {
            if (comps[i] != rel) continue;
            while (i < comps.length && !comps[++i].isVisible()) {
            }
            if (i >= comps.length) continue;
            return (JAlbumObject)comps[i];
        }
        return null;
    }

    Component getNearestComponent(Point p) {
        Component nearestComp = null;
        Rectangle smallest = null;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Rectangle bounds = comps[i].getBounds();
            if (bounds.contains(p)) {
                return comps[i];
            }
            bounds.add(p);
            if (smallest != null && bounds.width * bounds.height >= smallest.width * smallest.height) continue;
            smallest = bounds;
            nearestComp = comps[i];
        }
        return nearestComp;
    }

    private static String dndActionsToString(int sa) {
        return ((sa & 1) != 0 ? "ACTION_COPY " : "") + ((sa & 2) != 0 ? "ACTION_MOVE " : "") + ((sa & 0x40000000) != 0 ? "ACTION_LINK " : "");
    }

    private static int decideDropAction(DropTargetEvent dtde) {
        int dropAction;
        boolean isJAlbumObject;
        if (dtde instanceof DropTargetDragEvent) {
            isJAlbumObject = ((DropTargetDragEvent)dtde).isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor);
            dropAction = ((DropTargetDragEvent)dtde).getDropAction();
        } else {
            isJAlbumObject = ((DropTargetDropEvent)dtde).isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor);
            dropAction = ((DropTargetDropEvent)dtde).getDropAction();
        }
        if (isJAlbumObject) {
            return 2;
        }
        if (dropAction == 1) {
            return 1;
        }
        return 0x40000000;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrag(JExplorerPanel.decideDropAction(dtde));
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(JExplorerPanel.decideDropAction(dtde));
        Rectangle r = new Rectangle(dtde.getLocation(), new Dimension(60, 60));
        r.translate(-30, -30);
        this.scrollRectToVisible(r);
        Point dragLocation = dtde.getLocation();
        int xpos = this.getInsets().left;
        int ypos = this.getInsets().top;
        JAlbumObject jao = this.closestComp = (JAlbumObject)this.getNearestComponent(dragLocation);
        if (jao != null) {
            ypos = jao.getY() - 2;
            int center = jao.getX() + jao.getWidth() / 2;
            this.insertBefore = dragLocation.x < center;
            xpos = this.insertBefore ? jao.getX() - this.explorerThumbsLayout.hgap / 2 : jao.getX() + jao.getWidth() + this.explorerThumbsLayout.hgap / 2;
        }
        this.caretLocation = new Point(xpos, ypos);
        this.dropFolder = null;
        if (jao != null) {
            if (jao.isSelected()) {
                this.caretLocation = null;
            } else if (jao.ao.isFolder() && jao.getBounds().contains(dragLocation)) {
                this.dropFolder = jao;
                this.caretLocation = null;
            }
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        dtde.acceptDrag(JExplorerPanel.decideDropAction(dtde));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.caretLocation = null;
        this.dropFolder = null;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        int dropAction = JExplorerPanel.decideDropAction(dtde);
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            if (this.getComponentCount() > 0 && this.caretLocation == null && this.dropFolder == null) {
                dtde.rejectDrop();
                return;
            }
            this.caretLocation = null;
            try {
                dtde.acceptDrop(JExplorerPanel.decideDropAction(dtde));
                if (dtde.isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor)) {
                    this.handleJAlbumObjectDrop(dtde);
                } else {
                    List<File> files = JExplorerPanel.getFilesFromTransferable(dtde.getTransferable());
                    if (files != null && files.size() > 0) {
                        dtde.dropComplete(true);
                        this.handleFileAdd(files, dropAction);
                        return;
                    }
                }
                dtde.dropComplete(true);
                this.context.currentFolder.setOrdering("custom");
                this.context.customOrderingAction.setSelected(true);
                this.context.handleDisablingOfOrderingMenus();
                this.fireStructureChanged(new StructureEvent(this));
            }
            catch (Exception exc) {
                exc.printStackTrace();
                dtde.dropComplete(false);
            }
            finally {
                this.dropFolder = null;
                this.draggedObjects = null;
            }
        } else {
            dtde.rejectDrop();
        }
        this.validate();
        this.repaint();
    }

    private void handleJAlbumObjectDrop(DropTargetDropEvent dtde) {
        List<JAlbumObject> objectsToMove = this.getDraggedObjects();
        if (this.dropFolder != null) {
            try {
                for (JAlbumObject jao : objectsToMove) {
                    jao.ao.moveTo(this.dropFolder.ao);
                    this.remove(jao);
                }
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        } else if (this.context.currentFolder.equals(objectsToMove.get((int)0).ao.getParent())) {
            for (JAlbumObject jao : objectsToMove) {
                this.remove(jao);
            }
            int insertIndex = this.findInsertIndex();
            for (JAlbumObject jao : objectsToMove) {
                this.add((Component)jao, insertIndex++);
            }
        } else {
            try {
                int insertIndex = this.findInsertIndex();
                for (JAlbumObject jao : objectsToMove) {
                    jao.ao.moveTo(this.context.currentFolder);
                    this.add((Component)jao, insertIndex++);
                }
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    public AlbumObject[] getSelectedAlbumObjects() {
        ArrayList<AlbumObject> selected = new ArrayList<AlbumObject>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            if (!jao.isSelected()) continue;
            selected.add(jao.ao);
        }
        return selected.toArray(new AlbumObject[selected.size()]);
    }

    private static List<File> getFilesFromTransferable(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                LinkedList<File> files = new LinkedList<File>();
                StringTokenizer tokens = new StringTokenizer(urls);
                while (tokens.hasMoreTokens()) {
                    String urlString = tokens.nextToken();
                    URL url = new URL(urlString);
                    files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
                }
                return files;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List filterSupportedFiles(List files) {
        LinkedList<File> supported = new LinkedList<File>();
        for (File f : files) {
            if (!FileFilters.isFileSupported(f) && !FileFilters.hasIcon(f)) continue;
            supported.add(f);
        }
        return supported;
    }

    public boolean handleFileAdd(List<File> files) {
        return this.handleFileAdd(files, 0x40000000);
    }

    public boolean handleFileAdd(List<File> files, int dropAction) {
        if (this.handleSpecialFileTypes(files)) {
            return true;
        }
        if (this.needsDelayedProcessing(files)) {
            return true;
        }
        files = this.filterSupportedFiles(files);
        if (this.context.currentFolder == null) {
            this.context.currentFolder = this.context.rootFolder;
        }
        if (this.dropFolder != null) {
            try {
                this.dropFolder.ao.add(files);
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this.context, ex);
            }
        } else {
            try {
                AlbumObjectFactory factory = JAlbumContext.getAlbumObjectfactory();
                int insertIndex = this.findInsertIndex();
                for (File target : files) {
                    AlbumObject ao;
                    if (target.isDirectory() && dropAction == 1) {
                        ao = this.buildVirtualTree(this.context.currentFolder, target);
                    } else {
                        LinkFile link = new LinkFile(this.context.currentFolder.getFile(), target.getName(), target);
                        ao = factory.createInstance(link, this.context.currentFolder);
                    }
                    JAlbumObject jao = new JAlbumObject(ao, this);
                    this.context.prepareJAO(jao);
                    this.add((Component)jao, insertIndex++);
                }
                this.validate();
                this.context.currentFolder.invalidate();
                this.fireStructureChanged(new StructureEvent(this));
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, ex);
            }
        }
        return false;
    }

    private AlbumObject buildVirtualTree(AlbumObject parent, File target) throws IOException {
        File dir = new File(parent.getFile(), target.getName());
        dir.mkdir();
        AlbumObjectFactory factory = JAlbumContext.getAlbumObjectfactory();
        AlbumObject ao = factory.createInstance(dir, parent);
        LinkedList<AlbumObject> children = new LinkedList<AlbumObject>();
        for (File f : target.listFiles(parent.getFactory().getFilter())) {
            if (!FileFilters.isFileSupported(f) && !FileFilters.hasIcon(f)) continue;
            if (f.isDirectory()) {
                children.add(this.buildVirtualTree(ao, f));
                continue;
            }
            LinkFile link = new LinkFile(ao.getFile(), f.getName(), f);
            AlbumObject child = factory.createInstance(link, ao);
            children.add(child);
        }
        ao.setChildren(children);
        return ao;
    }

    private boolean handleSpecialFileTypes(List files) {
        if (files.size() > 0) {
            File file = (File)files.get(0);
            String fileName = file.getName();
            if (fileName.endsWith(".jap")) {
                this.createOrLoadProject(files);
                return true;
            }
            if (fileName.endsWith(".jaskin")) {
                new SkinManager().installSkin(file);
                return true;
            }
        }
        return false;
    }

    private int findInsertIndex() {
        int insertIndex = -1;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != this.closestComp) continue;
            insertIndex = i;
            if (this.insertBefore) break;
            ++insertIndex;
            break;
        }
        if (insertIndex < 0) {
            insertIndex = comps.length;
        }
        return insertIndex;
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor dropFlavor = flavors[i];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor) && !dropFlavor.equals(JAlbumObject.jAlbumObjectFlavor) && !dropFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    public List<JAlbumObject> getDraggedObjects() {
        return this.draggedObjects;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        event.startDrag(null, (JAlbumObject)event.getComponent(), this);
        this.draggedObjects = this.selectionModel.getSelectedObjects();
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.draggedObjects = null;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        JAlbumObject jao = (JAlbumObject)comp;
        if (jao.isSelected()) {
            this.selectionModel.objectSelected(jao, false);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.selectionModel.deselectAll();
    }

    public synchronized void removeStructureListener(StructureListener l) {
        if (this.structureListeners != null && this.structureListeners.contains(l)) {
            Vector v = (Vector)this.structureListeners.clone();
            v.removeElement(l);
            this.structureListeners = v;
        }
    }

    public synchronized void addStructureListener(StructureListener l) {
        Vector v;
        Vector vector = v = this.structureListeners == null ? new Vector(2) : (Vector)this.structureListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.structureListeners = v;
        }
    }

    protected void fireStructureChanged(StructureEvent e) {
        if (this.structureListeners != null) {
            Vector listeners = this.structureListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((StructureListener)listeners.elementAt(i)).structureChanged(e);
            }
        }
    }

    private boolean needsDelayedProcessing(final List files) {
        if (this.isProjectLoaded()) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JExplorerPanel.this.createOrLoadProject(files);
            }
        });
        return true;
    }

    private void createOrLoadProject(List files) {
        if (files.size() == 1) {
            File file = (File)files.get(0);
            if (file.isDirectory()) {
                File projectFile = new File(file, "jalbum-settings.jap");
                if (projectFile.exists()) {
                    this.context.parent.loadProject(projectFile);
                } else {
                    this.context.parent.initProject(file);
                }
            } else if (file.getName().endsWith(".jap")) {
                this.context.parent.loadProject(file);
            } else {
                this.showNewProjectDialog(this.filterSupportedFiles(files));
            }
        } else {
            this.showNewProjectDialog(this.filterSupportedFiles(files));
        }
    }

    private void showNewProjectDialog(List files) {
        JNewProjectDialog newProjectDialog = new JNewProjectDialog(this.context.parent);
        String albumNameSuggestion = this.findAlbumNameSuggestion(files);
        newProjectDialog.setAlbumName(albumNameSuggestion);
        newProjectDialog.setFiles(files);
        this.context.parent.show(newProjectDialog);
    }

    private String findAlbumNameSuggestion(List files) {
        String parentNameForAllFiles = null;
        for (File file : files) {
            String parentNameOfCurrentFile = file.getParentFile().getName();
            if (parentNameForAllFiles == null) {
                parentNameForAllFiles = parentNameOfCurrentFile;
                continue;
            }
            if (parentNameForAllFiles.equals(parentNameOfCurrentFile)) continue;
            return Msg.get("newproject.defaultName");
        }
        return parentNameForAllFiles;
    }
}

