/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.JAlbumImageFilterInterface;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JHeadingPanel;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JCommentPanel;
import se.datadosen.explorer.JFiltersPanel;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.IconRepository;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JEditPanel
extends JPanel
implements FilterManagerFriend {
    public static final String NAME = "editPanel";
    private static final int CROSS_PADDING = 20;
    private final JAlbumExplorer context;
    AlbumObject ao;
    ControlPanel metaPanel = new ControlPanel();
    JPanel centerPanel = new JPanel();
    JBackgroundPanel imagePanel;
    JSplitPane vSplitPane = new JSplitPane(0);
    private CardLayout filterPanelViewMode = new CardLayout();
    JPanel filterPanel = new JPanel(this.filterPanelViewMode);
    JFiltersPanel filtersPanel = new JFiltersPanel(this);
    FilterManager filterManager = new FilterManager(this);
    JAlbumImageFilterInterface currentFilter;
    JHeadingPanel filterUIHeadingPanel;
    JPanel filterUIContainer = new JPanel(new BorderLayout());
    JPanel filterUI;
    JPanel filterManagerControls;
    JCommentPanel commentPanel = new JCommentPanel(this);
    JPropertyPanel propertyPanel = new JPropertyPanel(this);
    JSplitPane hSplitPane = new JSplitPane(1);
    JPanel buttonPanel = new JPanel();
    JButton returnButton;
    JButton previousButton;
    JButton nextButton;
    Action previousImageAction;
    Action nextImageAction;
    Action cancelAction;
    BufferedImage bufferedImage;

    public JEditPanel(JAlbumExplorer context) {
        this.context = context;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAO(AlbumObject ao) {
        this.ao = ao;
        try {
            this.commentPanel.setAlbumObject(ao);
            this.propertyPanel.setAlbumObject(ao);
            this.refreshUI();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void moveTo(AlbumObject dest) {
        if (dest == null) {
            return;
        }
        this.setAO(dest);
    }

    void setFiltersViewMode() {
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
    }

    private JAlbumObject getPreviousComponent(AlbumObject ao) {
        return this.context.explorer.getPreviousComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getPreviousComponent() {
        return this.getPreviousComponent(this.ao);
    }

    private JAlbumObject getNextComponent(AlbumObject ao) {
        return this.context.explorer.getNextComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getNextComponent() {
        return this.getNextComponent(this.ao);
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.text);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.filtersPanel.setFocusable(false);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.setBackground(SystemColor.text);
        this.setToolTipText(Msg.get("edit.tipLabel"));
        this.setPreferredSize(new Dimension(760, 600));
        this.filterPanel.add((Component)this.filtersPanel, "filtersPanel");
        this.filterPanel.add((Component)this.filterUIContainer, "filterUI");
        Color borderColor = new Color(165, 165, 165);
        this.vSplitPane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
        this.vSplitPane.setTopComponent(this.filterPanel);
        this.vSplitPane.setResizeWeight(1.0);
        this.vSplitPane.setBottomComponent(this.propertyPanel);
        KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
        KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.previousImageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JEditPanel.this.commentPanel.save();
                JEditPanel.this.propertyPanel.save();
                JAlbumObject dest = JEditPanel.this.getPreviousComponent();
                if (dest != null) {
                    JEditPanel.this.moveTo(dest.ao);
                    JAlbumObject previous = JEditPanel.this.getPreviousComponent(dest.ao);
                    ((JEditPanel)JEditPanel.this).context.imageCache.preload(previous != null ? previous.ao : null);
                }
            }
        };
        this.previousImageAction.putValue("AcceleratorKey", pgUp);
        this.nextImageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JEditPanel.this.commentPanel.save();
                JEditPanel.this.propertyPanel.save();
                JAlbumObject dest = JEditPanel.this.getNextComponent();
                if (dest != null) {
                    JEditPanel.this.moveTo(dest.ao);
                    JAlbumObject next = JEditPanel.this.getNextComponent(dest.ao);
                    ((JEditPanel)JEditPanel.this).context.imageCache.preload(next != null ? next.ao : null);
                }
            }
        };
        this.nextImageAction.putValue("AcceleratorKey", pgDown);
        this.cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                JEditPanel.this.context.setExplorerView();
            }
        };
        this.registerKeyboardAction(this.cancelAction, "cancel-dialog", escape, 2);
        this.previousButton = new JButton(this.previousImageAction);
        this.previousButton.setToolTipText(Msg.get("edit.previousImageToolTip"));
        this.previousButton.setIcon(IconRepository.getIcon("small.previous"));
        this.nextButton = new JButton(this.nextImageAction);
        this.nextButton.setToolTipText(Msg.get("edit.nextImageToolTip"));
        this.nextButton.setIcon(IconRepository.getIcon("small.next"));
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", pgUp, 2);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", pgDown, 2);
        this.returnButton = new JButton(this.cancelAction);
        this.returnButton.setToolTipText(Msg.get("edit.leaveTooltip"));
        this.returnButton.setText("");
        this.returnButton.setIcon(IconRepository.getIcon("small.return"));
        FlowLayout fl = new FlowLayout(4);
        fl.setVgap(0);
        this.buttonPanel.setLayout(fl);
        MatteBorder topBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor);
        if (!JAlbum.isMac()) {
            this.buttonPanel.setBorder(BorderFactory.createCompoundBorder(topBorder, BorderFactory.createEmptyBorder(3, 0, 3, 0)));
        } else {
            this.buttonPanel.setBorder(topBorder);
        }
        this.buttonPanel.add(this.previousButton);
        this.buttonPanel.add(this.nextButton);
        this.buttonPanel.add(this.returnButton);
        this.add((Component)this.buttonPanel, "South");
        this.hSplitPane.setBorder(null);
        this.hSplitPane.setBackground(SystemColor.text);
        this.imagePanel = new JBackgroundPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (!JEditPanel.this.ao.isIncluded()) {
                    Image crossImage = JAlbumObject.getCrossImage();
                    g.drawImage(crossImage, JEditPanel.this.imagePanel.getImageTopCornerXCoordinate() + 20, JEditPanel.this.imagePanel.getImageTopCornerYCoordinate() + 20, null);
                }
            }
        };
        this.imagePanel.setBackground(SystemColor.text);
        this.imagePanel.setImageBorder(this.createImageBorder());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof JComponent) {
                    ((JComponent)e.getSource()).requestFocus();
                }
                JEditPanel.this.requestFocus();
            }
        };
        this.addMouseListener(ml);
        this.centerPanel.addMouseListener(ml);
        this.imagePanel.addMouseListener(ml);
        this.centerPanel.add((Component)this.imagePanel, "Center");
        this.centerPanel.add((Component)this.commentPanel, "South");
        this.hSplitPane.setLeftComponent(this.centerPanel);
        this.hSplitPane.setRightComponent(this.vSplitPane);
        this.hSplitPane.setDividerSize(3);
        this.hSplitPane.setResizeWeight(1.0);
        this.add((Component)this.hSplitPane, "Center");
    }

    private Border createImageBorder() {
        return BorderFactory.createLineBorder(new Color(96, 96, 96));
    }

    private void refreshUI() throws IOException {
        this.context.updateRotateActions(this.ao);
        this.updateImage(true);
        this.enableImageBrowseActions();
        this.filtersPanel.setEnabled(!this.ao.isFolder() && this.ao.isDisplayableImage());
        this.context.parent.statusBar.setText(Msg.get("ui.editModeStatusText", this.ao.getFile().getAbsolutePath()));
    }

    void updateImage(boolean loadStack) throws IOException {
        this.imagePanel.setBackgroundImage(null);
        if (this.ao == null) {
            return;
        }
        if (this.ao.isDisplayableImage()) {
            if (loadStack) {
                AlbumObjectProperties props = this.ao.getProperties();
                Object stack = props.get("filterList");
                if (stack != null) {
                    this.filterManager.setFilterList((FilterList)stack);
                } else {
                    this.filterManager.setFilterList(null);
                }
            }
            Image closeup = this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage((BufferedImage)closeup, this.filterManager.getFilterList());
            closeup = this.scaleToFit(closeup, this.imagePanel.getDisplayableImageSize());
            if (this.filterManager.hasFiltersInList()) {
                closeup = this.filterManager.renderImage((BufferedImage)closeup);
            }
            this.imagePanel.setBackgroundImage(closeup);
        } else {
            Image closeup = this.ao.getRepresentingIcon(this.imagePanel.getDisplayableImageSize(), false).getImage();
            this.imagePanel.setBackgroundImage(closeup);
        }
        this.imagePanel.repaint();
    }

    void saveFilters() {
        AlbumObjectProperties props = this.ao.getProperties();
        props.putHidden("filterList", this.filterManager.getFilterList());
        props.save();
        BufferedImage thumbnail = this.filterManager.renderImage(this.bufferedImage);
        try {
            this.ao.setRepresentingIcon(thumbnail, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Image scaleToFit(Image image, Dimension boundingBox) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        if (newWidth < width && newHeight < height) {
            return ImageCache.scale(image, newWidth, newHeight);
        }
        return image;
    }

    void useFilter(JAlbumImageFilterInterface filter) {
        this.currentFilter = filter;
        this.setImageInFilter();
        this.filterManager.addFilter(filter);
        this.imagePanel.addMouseListener(filter);
        this.imagePanel.addMouseMotionListener(filter);
        this.imagePanel.addMouseWheelListener(filter);
        this.imagePanel.addKeyListener(filter);
        this.cancelAction.setEnabled(false);
        this.switchFilterUIHeading(filter.getShortName());
        this.switchFilterUI(this.filterManager.getFilterControls());
        this.disableImageBrowseActions();
        this.switchFilterManagerControls(this.filterManager.getFilterManagerControls());
        this.filtersPanel.setUndoRedoEnabled(false);
        this.context.setTopBarActionsEnabled(false);
        this.commentPanel.setFocusable(false);
        this.propertyPanel.setFocusable(false);
        this.filterPanelViewMode.show(this.filterPanel, "filterUI");
        this.validate();
        this.commentPanel.setFocusable(true);
        this.propertyPanel.setFocusable(true);
    }

    void setImageInFilter() {
        try {
            this.bufferedImage = (BufferedImage)this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage(this.bufferedImage, this.filterManager.getFilterList());
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void switchFilterUIHeading(String heading) {
        if (this.filterUIHeadingPanel != null) {
            this.filterUIContainer.remove(this.filterUIHeadingPanel);
        }
        this.filterUIHeadingPanel = new JHeadingPanel(heading);
        this.filterUIContainer.add((Component)this.filterUIHeadingPanel, "North");
    }

    private void switchFilterUI(JPanel filterControls) {
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterUI);
        }
        this.filterUI = filterControls;
        if (this.filterUI != null) {
            this.filterUIContainer.add((Component)this.filterUI, "Center");
        }
    }

    private void switchFilterManagerControls(JPanel managerControls) {
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
        }
        this.filterManagerControls = managerControls;
        if (this.filterManagerControls != null) {
            this.filterUIContainer.add((Component)this.filterManagerControls, "South");
        }
    }

    private void disableImageBrowseActions() {
        this.nextImageAction.setEnabled(false);
        this.propertyPanel.nextImage.setEnabled(false);
        this.previousImageAction.setEnabled(false);
        this.propertyPanel.previousImage.setEnabled(false);
    }

    private void enableImageBrowseActions() {
        boolean hasNext = this.getNextComponent() != null;
        boolean hasPrevious = this.getPreviousComponent() != null;
        this.nextImageAction.setEnabled(hasNext);
        this.propertyPanel.nextImage.setEnabled(hasNext);
        this.previousImageAction.setEnabled(hasPrevious);
        this.propertyPanel.previousImage.setEnabled(hasPrevious);
    }

    public BufferedImage scaleImage(BufferedImage bi) {
        AlbumImage ai = new AlbumImage(bi, this.context.parent.engine);
        ai = ai.scaleToFit(this.imagePanel.getDisplayableImageSize());
        return (BufferedImage)ai.getImage();
    }

    public void filterMenuClosed(BufferedImage bi, boolean saveBeforeClose) {
        this.setImage(bi);
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterUI);
            this.filterUI = null;
        }
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
            this.filterManagerControls = null;
        }
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
        this.enableImageBrowseActions();
        if (saveBeforeClose) {
            this.saveFilters();
        }
        this.filtersPanel.setUndoRedoEnabled(true);
        this.context.setTopBarActionsEnabled(true);
        this.cancelAction.setEnabled(true);
        this.cleanFilterListeners();
        this.currentFilter = null;
        this.validate();
    }

    protected void cleanFilterListeners() {
        if (this.currentFilter != null) {
            this.imagePanel.removeMouseListener(this.currentFilter);
            this.imagePanel.removeMouseMotionListener(this.currentFilter);
            this.imagePanel.removeMouseWheelListener(this.currentFilter);
            this.imagePanel.removeKeyListener(this.currentFilter);
        }
    }

    public void setImage(BufferedImage bi) {
        this.imagePanel.setBackgroundImage(bi);
        this.imagePanel.repaint();
    }

    public JComponent getImageComponent() {
        return this.imagePanel;
    }

    public Point getImageCoordinates(MouseEvent e) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        Dimension boundingBox = this.imagePanel.getDisplayableImageSize();
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        float xDistance = (float)((boundingBox.getWidth() - (double)newWidth) / 2.0);
        float yDistance = (float)((boundingBox.getHeight() - (double)newHeight) / 2.0);
        Point p = e.getPoint();
        int tx = (int)((double)p.x * maxScale - (double)xDistance);
        int ty = (int)((double)p.y * maxScale - (double)yDistance);
        return new Point(tx, ty);
    }
}

