/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import se.datadosen.component.Ruler;

public class RiverLayout
extends FlowLayout
implements LayoutManager,
Serializable {
    public static final String LINE_BREAK = "br";
    public static final String PARAGRAPH_BREAK = "p";
    public static final String TAB_STOP = "tab";
    public static final String HFILL = "hfill";
    public static final String VFILL = "vfill";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CENTER = "center";
    public static final String VTOP = "vtop";
    public static final String VCENTER = "vcenter";
    public static final String VBOTTOM = "vbottom";
    Map constraints = new HashMap();
    String valign = "vcenter";
    int hgap;
    int vgap;
    Insets extraInsets;
    Insets totalInsets = new Insets(0, 0, 0, 0);

    public RiverLayout() {
        this(9, 5);
    }

    public RiverLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setExtraInsets(new Insets(vgap, hgap, vgap, hgap));
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
        this.setExtraInsets(new Insets(this.vgap, hgap, this.vgap, hgap));
    }

    public int getVgap() {
        return this.vgap;
    }

    public Insets getExtraInsets() {
        return this.extraInsets;
    }

    public void setExtraInsets(Insets newExtraInsets) {
        this.extraInsets = newExtraInsets;
    }

    protected Insets getInsets(Container target) {
        Insets insets = target.getInsets();
        this.totalInsets.top = insets.top + this.extraInsets.top;
        this.totalInsets.left = insets.left + this.extraInsets.left;
        this.totalInsets.bottom = insets.bottom + this.extraInsets.bottom;
        this.totalInsets.right = insets.right + this.extraInsets.right;
        return this.totalInsets;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
        this.setExtraInsets(new Insets(vgap, this.hgap, vgap, this.hgap));
    }

    public void addLayoutComponent(String name, Component comp) {
        this.constraints.put(comp, name);
    }

    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    boolean isFirstInRow(Component comp) {
        String cons = (String)this.constraints.get(comp);
        return cons != null && (cons.indexOf(LINE_BREAK) != -1 || cons.indexOf(PARAGRAPH_BREAK) != -1);
    }

    boolean hasHfill(Component comp) {
        return this.hasConstraint(comp, HFILL);
    }

    boolean hasVfill(Component comp) {
        return this.hasConstraint(comp, VFILL);
    }

    boolean hasConstraint(Component comp, String test) {
        String cons = (String)this.constraints.get(comp);
        if (cons == null) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(cons);
        while (tokens.hasMoreTokens()) {
            if (!tokens.nextToken().equals(test)) continue;
            return true;
        }
        return false;
    }

    protected Ruler calcTabs(Container target) {
        Ruler ruler = new Ruler();
        int nmembers = target.getComponentCount();
        int x = 0;
        int tabIndex = 0;
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (this.isFirstInRow(m) || i == 0) {
                x = 0;
                tabIndex = 0;
            } else {
                x += this.hgap;
            }
            if (this.hasConstraint(m, TAB_STOP)) {
                ruler.setTab(tabIndex, x);
                x = ruler.getTab(tabIndex++);
            }
            Dimension d = m.getPreferredSize();
            x += d.width;
        }
        return ruler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            Dimension rowDim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            for (int i = 0; i < nmembers; ++i) {
                Component comp = target.getComponent(i);
                if (this.isFirstInRow(comp)) {
                    tabIndex = 0;
                    dim.width = Math.max(dim.width, rowDim.width);
                    dim.height += rowDim.height + this.vgap;
                    if (this.hasConstraint(comp, PARAGRAPH_BREAK)) {
                        dim.height += 2 * this.vgap;
                    }
                    rowDim = new Dimension(0, 0);
                }
                if (this.hasConstraint(comp, TAB_STOP)) {
                    rowDim.width = ruler.getTab(tabIndex++);
                }
                Dimension d = comp.getPreferredSize();
                rowDim.height = Math.max(rowDim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    rowDim.width += this.hgap;
                }
                rowDim.width += d.width;
            }
            dim.width = Math.max(dim.width, rowDim.width);
            dim.height += rowDim.height;
            Insets insets = this.getInsets(target);
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            Dimension rowDim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            int tabIndex = 0;
            Ruler ruler = this.calcTabs(target);
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (this.isFirstInRow(m)) {
                    tabIndex = 0;
                    dim.width = Math.max(dim.width, rowDim.width);
                    dim.height += rowDim.height + this.vgap;
                    if (this.hasConstraint(m, PARAGRAPH_BREAK)) {
                        dim.height += 2 * this.vgap;
                    }
                    rowDim = new Dimension(0, 0);
                }
                if (this.hasConstraint(m, TAB_STOP)) {
                    rowDim.width = ruler.getTab(tabIndex++);
                }
                Dimension d = m.getMinimumSize();
                rowDim.height = Math.max(rowDim.height, d.height);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    rowDim.width += this.hgap;
                }
                rowDim.width += d.width;
            }
            dim.width = Math.max(dim.width, rowDim.width);
            dim.height += rowDim.height;
            Insets insets = this.getInsets(target);
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr, Ruler ruler) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            int tabIndex = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (this.hasConstraint(m, TAB_STOP)) {
                    x = this.getInsets((Container)target).left + ruler.getTab(tabIndex++);
                }
                int dy = 0;
                dy = this.valign == VTOP ? 0 : (this.valign == VBOTTOM ? height - m.getHeight() : (height - m.getHeight()) / 2);
                if (ltr) {
                    m.setLocation(x, y + dy);
                } else {
                    m.setLocation(target.getWidth() - x - m.getWidth(), y + dy);
                }
                x += m.getWidth() + this.hgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void relMove(Container target, int dx, int dy, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                m.setLocation(m.getX() + dx, m.getY() + dy);
            }
        }
    }

    protected void adjustAlignment(Component m) {
        if (this.hasConstraint(m, LEFT)) {
            this.setAlignment(0);
        } else if (this.hasConstraint(m, RIGHT)) {
            this.setAlignment(2);
        } else if (this.hasConstraint(m, CENTER)) {
            this.setAlignment(1);
        }
        if (this.hasConstraint(m, VTOP)) {
            this.valign = VTOP;
        } else if (this.hasConstraint(m, VCENTER)) {
            this.valign = VCENTER;
        } else if (this.hasConstraint(m, VBOTTOM)) {
            this.valign = VBOTTOM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        this.setAlignment(0);
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            Insets insets = this.getInsets(target);
            int maxwidth = target.getWidth() - (insets.left + insets.right);
            int maxheight = target.getHeight() - (insets.top + insets.bottom);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowh = 0;
            int start = 0;
            int moveDownStart = 0;
            int rowStart = 0;
            int vfillStart = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component toHfill = null;
            boolean[] vfill = new boolean[nmembers + 1];
            vfill[0] = false;
            boolean vfillRow = false;
            Ruler ruler = this.calcTabs(target);
            int tabIndex = 0;
            for (i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (this.isFirstInRow(m)) {
                    tabIndex = 0;
                }
                if (this.hasConstraint(m, TAB_STOP)) {
                    x = ruler.getTab(tabIndex++);
                }
                if (!this.isFirstInRow(m)) {
                    if (i > 0 && !this.hasConstraint(m, TAB_STOP)) {
                        x += this.hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                } else {
                    if (vfillRow) {
                        vfillStart = rowStart;
                        moveDownStart = i;
                    }
                    rowStart = i;
                    if (toHfill != null) {
                        toHfill.setSize(toHfill.getWidth() + maxwidth - x, toHfill.getHeight());
                        x = maxwidth;
                    }
                    this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, i, ltr, ruler);
                    x = d.width;
                    y += this.vgap + rowh;
                    if (this.hasConstraint(m, PARAGRAPH_BREAK)) {
                        y += 2 * this.vgap;
                    }
                    rowh = d.height;
                    start = i;
                    toHfill = null;
                    vfillRow = false;
                }
                if (this.hasHfill(m)) {
                    toHfill = m;
                }
                if (this.hasVfill(m)) {
                    vfill[i + 1] = true;
                    vfillRow = true;
                } else {
                    vfill[i + 1] = false;
                }
                this.adjustAlignment(m);
            }
            if (vfillRow) {
                vfillStart = rowStart;
                moveDownStart = nmembers;
            }
            rowStart = nmembers;
            if (toHfill != null) {
                toHfill.setSize(toHfill.getWidth() + maxwidth - x, toHfill.getHeight());
                x = maxwidth;
            }
            this.moveComponents(target, insets.left, y, maxwidth - x, rowh, start, nmembers, ltr, ruler);
            y += rowh;
            rowh = 0;
            for (i = vfillStart; i < moveDownStart; ++i) {
                rowh = Math.max(rowh, target.getComponent(i).getHeight());
            }
            y -= rowh;
            int yslackMax = Integer.MIN_VALUE;
            for (int i2 = vfillStart; i2 < moveDownStart; ++i2) {
                Component m = target.getComponent(i2);
                int yslack = maxheight - y + insets.top - m.getHeight();
                if (yslack != 0 && vfill[i2 + 1]) {
                    m.setSize(m.getWidth(), yslack + m.getHeight());
                }
                yslackMax = Math.max(yslackMax, yslack);
            }
            if (yslackMax > Integer.MIN_VALUE) {
                this.relMove(target, 0, yslackMax, moveDownStart, nmembers);
            }
        }
    }
}

