/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRatingSlider
extends JPanel {
    private static final ImageIcon greyStarIcon = new ImageIcon(JRatingSlider.class.getResource("images/star_grey.png"));
    private static final ImageIcon yellowStarIcon = new ImageIcon(JRatingSlider.class.getResource("images/star_yellow.png"));
    private int maxValue = 5;
    private int value;
    private int lastValue = this.value = 0;
    private JLabel[] labels;
    private static final int MARGIN = 5;
    private volatile Vector<ChangeListener> changeListeners;

    public JRatingSlider() {
        this.init();
    }

    public JRatingSlider(int maxValue) {
        this.maxValue = maxValue;
        this.init();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        if (value < 0) {
            value = 0;
        }
        if (value > this.maxValue) {
            value = this.maxValue;
        }
        for (int i = 0; i < this.maxValue; ++i) {
            this.labels[i].setIcon(i < value ? yellowStarIcon : greyStarIcon);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        this.changeListeners.add(cl);
    }

    public void removeChangeListner(ChangeListener cl) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(cl);
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.changeListeners) {
            cl.stateChanged(ce);
        }
    }

    private void init() {
        this.setOpaque(false);
        this.setLayout(new FlowLayout(3, 0, 0));
        this.labels = new JLabel[this.maxValue];
        for (int i = 0; i < this.maxValue; ++i) {
            this.labels[i] = new JLabel(greyStarIcon);
            this.add(this.labels[i]);
        }
        this.setValue(this.value);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                JRatingSlider.this.lastValue = JRatingSlider.this.value;
            }

            public void mouseReleased(MouseEvent e) {
                JRatingSlider.this.mouseAt(e.getPoint());
                if (JRatingSlider.this.value != JRatingSlider.this.lastValue) {
                    JRatingSlider.this.fireStateChanged();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                JRatingSlider.this.mouseAt(e.getPoint());
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void mouseAt(Point p) {
        if (p.x < 5) {
            this.setValue(0);
        } else {
            for (int i = this.maxValue; i > 0; --i) {
                if (p.x - 5 < this.labels[i - 1].getLocation().x) continue;
                this.setValue(i);
                break;
            }
        }
    }
}

