/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.slideshow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.jalbum.slideshow.SlideShow;
import se.datadosen.explorer.ImageCache;
import se.datadosen.jalbum.AlbumObject;

class BasicSlideShow
extends JFrame
implements SlideShow {
    BorderLayout borderLayout1 = new BorderLayout();
    List albumObjects;
    int currentIndex;
    Image previousImage;
    Image currentImage;
    Image nextImage;
    JLabel imageLabel = new JLabel();
    Dimension screenSize = this.getGraphicsConfiguration().getBounds().getSize();
    ImageCache slideCache = new ImageCache(4, this.screenSize);

    BasicSlideShow(List albumObjects, AlbumObject start) {
        try {
            this.albumObjects = albumObjects;
            this.jbInit();
            for (int i = 0; i < albumObjects.size(); ++i) {
                AlbumObject ao = (AlbumObject)albumObjects.get(i);
                if (ao != start) continue;
                this.currentIndex = i;
                this.showImage(i);
                return;
            }
            this.showImage(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void showImage(int index) {
        try {
            ImageIcon icon = new ImageIcon(this.slideCache.getImage((AlbumObject)this.albumObjects.get(index)));
            this.currentImage = icon.getImage();
            this.imageLabel.setIcon(icon);
            if (index < this.albumObjects.size() - 1) {
                this.slideCache.preload((AlbumObject)this.albumObjects.get(index + 1));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    void forward() {
        if (this.currentIndex < this.albumObjects.size() - 1) {
            this.showImage(++this.currentIndex);
        } else {
            if (this.imageLabel.getIcon() == null) {
                this.quit();
            }
            this.imageLabel.setIcon(null);
        }
    }

    void backward() {
        if (this.currentIndex > 0) {
            this.showImage(--this.currentIndex);
        }
    }

    void first() {
        this.currentIndex = 0;
        this.showImage(this.currentIndex);
    }

    void last() {
        this.currentIndex = this.albumObjects.size() - 1;
        this.showImage(this.currentIndex);
    }

    private void quit() {
        this.setVisible(false);
        this.slideCache.dispose();
        this.dispose();
    }

    void jbInit() throws Exception {
        this.setUndecorated(true);
        Container c = this.getContentPane();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        BasicSlideShow.this.quit();
                        break;
                    }
                    case 10: 
                    case 32: 
                    case 34: 
                    case 39: 
                    case 40: {
                        BasicSlideShow.this.forward();
                        break;
                    }
                    case 8: 
                    case 33: 
                    case 37: 
                    case 38: {
                        BasicSlideShow.this.backward();
                        break;
                    }
                    case 36: {
                        BasicSlideShow.this.first();
                        break;
                    }
                    case 35: {
                        BasicSlideShow.this.last();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    BasicSlideShow.this.forward();
                } else if (e.getButton() == 3) {
                    BasicSlideShow.this.backward();
                }
            }
        });
        this.imageLabel.setHorizontalAlignment(0);
        c.setBackground(Color.black);
        c.setLayout(this.borderLayout1);
        c.add((Component)this.imageLabel, "Center");
        this.setSize(this.screenSize);
    }

    public void start() {
        this.setVisible(true);
    }
}

