/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.FilterManagerUI;
import net.jalbum.filterManager.JAlbumImageFilterInterface;
import se.datadosen.jalbum.ModifiesSize;

public class FilterManager {
    FilterManagerFriend friend;
    FilterList filterList;
    FilterManagerUI filterManagerUI;
    JAlbumImageFilterInterface newFilter;
    BufferedImage bi;
    BufferedImage biOut;
    BufferedImage prescaleCache;
    BufferedImage postscaleCache;
    private static int count = 0;

    public FilterManager(FilterManagerFriend friend) {
        this.friend = friend;
        if (friend != null) {
            this.filterManagerUI = new FilterManagerUI(this);
        }
    }

    public boolean hasFiltersInList() {
        return this.filterList != null && this.filterList.getFilters().size() > 0;
    }

    public BufferedImage setImage(BufferedImage bi, FilterList filterList) {
        if (filterList == null) {
            this.filterList = new FilterList();
            this.filterList.setVersionNumber(1);
        } else {
            this.filterList = filterList;
        }
        this.bi = FilterManager.cloneBufferedImage(bi);
        this.biOut = this.renderImage(this.bi);
        return this.biOut;
    }

    public void addFilter(JAlbumImageFilterInterface filter) {
        BufferedImage filterInputImage;
        if (!filter.isPrescale() && !filter.isPostscale()) {
            return;
        }
        this.newFilter = filter;
        this.newFilter.init();
        this.newFilter.setFilterManager(this);
        if (this.newFilter.isPrescale() && this.filterListHasPostscaleFilters()) {
            filterInputImage = this.prescaleCache;
            this.filterManagerUI.indicatePreview(true);
        } else {
            filterInputImage = this.biOut;
            this.filterManagerUI.indicatePreview(false);
        }
        this.filterManagerUI.loadFilterInfoPanel(this.newFilter);
        this.newFilter.setImage(filterInputImage);
    }

    public void setGUIImage(BufferedImage bi) {
        this.friend.setImage(bi);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return this.renderImage(bi, true);
    }

    public BufferedImage renderImage(BufferedImage bi, boolean scaleImage) {
        BufferedImage biOutClone = this.applyPrescaleFilters(bi);
        if (scaleImage) {
            biOutClone = this.scaleImage(biOutClone);
        }
        biOutClone = this.applyPostscaleFilters(biOutClone);
        return biOutClone;
    }

    public BufferedImage applyPrescaleFilters(BufferedImage bi) {
        this.prescaleCache = bi;
        if (!this.filterListHasPrescaleFilters()) {
            return bi;
        }
        BufferedImage biOutClone = FilterManager.cloneBufferedImage(bi);
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale()) continue;
            biOutClone = filter.renderImage(biOutClone);
        }
        this.prescaleCache = FilterManager.cloneBufferedImage(biOutClone);
        return biOutClone;
    }

    protected BufferedImage scaleImage(BufferedImage bi) {
        BufferedImage out = this.friend.scaleImage(bi);
        this.postscaleCache = FilterManager.cloneBufferedImage(out);
        return out;
    }

    public BufferedImage applyPostscaleFilters(BufferedImage bi) {
        this.postscaleCache = bi;
        if (!this.filterListHasPostscaleFilters()) {
            return bi;
        }
        BufferedImage biOutClone = FilterManager.cloneBufferedImage(bi);
        this.postscaleCache = FilterManager.cloneBufferedImage(biOutClone);
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale()) continue;
            biOutClone = filter.renderImage(biOutClone);
        }
        return biOutClone;
    }

    public Dimension getPrescaleFilteredSize(Dimension dim) {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }

    public Dimension getPostscaleFilteredSize(Dimension dim) {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }

    protected boolean filterListHasPostscaleFilters() {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale()) continue;
            return true;
        }
        return false;
    }

    protected boolean filterListHasPrescaleFilters() {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilterInterface filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale()) continue;
            return true;
        }
        return false;
    }

    public boolean isUndoPossible() {
        return this.filterList.getPosition() > 0;
    }

    public BufferedImage undo() {
        if (this.filterList.getPosition() > 0) {
            this.filterList.setPosition(this.filterList.getPosition() - 1);
            JAlbumImageFilterInterface undoneFilter = this.filterList.getFilters().get(this.filterList.getPosition());
            if (undoneFilter.isPrescale()) {
                this.biOut = this.applyPrescaleFilters(this.bi);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (undoneFilter.isPostscale() && !undoneFilter.isPrescale()) {
                this.biOut = this.applyPostscaleFilters(this.postscaleCache);
            }
        }
        return this.biOut;
    }

    public boolean isRedoPossible() {
        return this.filterList.getFilters().size() > this.filterList.getPosition();
    }

    public BufferedImage redo() {
        if (this.filterList.getFilters().size() > this.filterList.getPosition()) {
            this.filterList.setPosition(this.filterList.getPosition() + 1);
            JAlbumImageFilterInterface redoneFilter = this.filterList.getFilters().get(this.filterList.getPosition() - 1);
            if (redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(FilterManager.cloneBufferedImage(this.prescaleCache));
                this.prescaleCache = FilterManager.cloneBufferedImage(this.biOut);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (redoneFilter.isPostscale() && !redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(FilterManager.cloneBufferedImage(this.postscaleCache));
            }
        }
        return this.biOut;
    }

    protected BufferedImage renderPreview() {
        BufferedImage previewImage = FilterManager.cloneBufferedImage(this.bi);
        if (this.newFilter.isPrescale()) {
            previewImage = this.newFilter.renderImage(FilterManager.cloneBufferedImage(this.prescaleCache));
            previewImage = this.friend.scaleImage(previewImage);
            previewImage = this.applyPostscaleFilters(previewImage);
        } else {
            previewImage = this.newFilter.isPostscale() && !this.newFilter.isPrescale() ? this.newFilter.renderImage(FilterManager.cloneBufferedImage(this.biOut)) : this.biOut;
        }
        return previewImage;
    }

    public JComponent getImageComponen() {
        return this.friend.getImageComponent();
    }

    public Point getImageCoordinates(MouseEvent e) {
        return this.friend.getImageCoordinates(e);
    }

    public JPanel getFilterControls() {
        return this.newFilter.getControls();
    }

    public JPanel getFilterManagerControls() {
        return this.filterManagerUI;
    }

    public FilterList getFilterList() {
        return this.filterList;
    }

    public void setFilterList(FilterList filterList) {
        this.filterList = filterList;
    }

    public void setCursor(Cursor cursor) {
        this.friend.getImageComponent().setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.friend.getImageComponent().getCursor();
    }

    protected void applyFilter() {
        if (this.filterList.getFilters().size() > this.filterList.getPosition()) {
            int listSize = this.filterList.getFilters().size();
            for (int i = this.filterList.getPosition(); i < listSize; ++i) {
                this.filterList.getFilters().remove(this.filterList.getPosition());
            }
        }
        this.filterList.getFilters().add(this.newFilter);
        this.filterList.setPosition(this.filterList.getPosition() + 1);
        if (this.newFilter.isPrescale()) {
            this.biOut = this.newFilter.renderImage(FilterManager.cloneBufferedImage(this.prescaleCache));
            this.prescaleCache = FilterManager.cloneBufferedImage(this.biOut);
            this.biOut = this.scaleImage(this.biOut);
            this.biOut = this.applyPostscaleFilters(this.biOut);
        } else if (this.newFilter.isPostscale() && !this.newFilter.isPrescale()) {
            this.biOut = this.newFilter.renderImage(FilterManager.cloneBufferedImage(this.biOut));
        }
        this.friend.filterMenuClosed(this.biOut, true);
    }

    public void cancel() {
        this.friend.filterMenuClosed(this.biOut, false);
    }

    public static BufferedImage cloneBufferedImage(BufferedImage img) {
        ++count;
        int iw = img.getWidth();
        int ih = img.getHeight();
        return FilterManager.createBufferedImage(img, iw, ih);
    }

    private static BufferedImage createBufferedImage(BufferedImage img, int iw, int ih) {
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        img.flush();
        return bi;
    }

    public JAlbumImageFilterInterface getNewFilter() {
        return this.newFilter;
    }

    public void setNewFilter(JAlbumImageFilterInterface newFilter) {
        this.newFilter = newFilter;
    }
}

