/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.ParseState;
import com.adobe.xmp.impl.XMPDateTimeImpl;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.SimpleTimeZone;

public final class ISO8601Converter {
    private ISO8601Converter() {
    }

    public static XMPDateTime parse(String string) throws XMPException {
        return ISO8601Converter.parse(string, new XMPDateTimeImpl());
    }

    public static XMPDateTime parse(String string, XMPDateTime xMPDateTime) throws XMPException {
        int n;
        int n2;
        boolean bl;
        ParameterAsserts.assertNotNull(string);
        ParseState parseState = new ParseState(string);
        boolean bl2 = bl = parseState.ch(0) == 'T' || parseState.length() >= 2 && parseState.ch(1) == ':' || parseState.length() >= 3 && parseState.ch(2) == ':';
        if (!bl) {
            if (parseState.ch(0) == '-') {
                parseState.skip();
            }
            n2 = parseState.gatherInt("Invalid year in date string", 9999);
            if (parseState.hasNext() && parseState.ch() != '-') {
                throw new XMPException("Invalid date string, after year", 5);
            }
            if (parseState.ch(0) == '-') {
                n2 = -n2;
            }
            xMPDateTime.setYear(n2);
            if (!parseState.hasNext()) {
                return xMPDateTime;
            }
            parseState.skip();
            n2 = parseState.gatherInt("Invalid month in date string", 12);
            if (parseState.hasNext() && parseState.ch() != '-') {
                throw new XMPException("Invalid date string, after month", 5);
            }
            xMPDateTime.setMonth(n2);
            if (!parseState.hasNext()) {
                return xMPDateTime;
            }
            parseState.skip();
            n2 = parseState.gatherInt("Invalid day in date string", 31);
            if (parseState.hasNext() && parseState.ch() != 'T') {
                throw new XMPException("Invalid date string, after day", 5);
            }
            xMPDateTime.setDay(n2);
            if (!parseState.hasNext()) {
                return xMPDateTime;
            }
        } else {
            xMPDateTime.setMonth(1);
            xMPDateTime.setDay(1);
        }
        if (parseState.ch() == 'T') {
            parseState.skip();
        } else if (!bl) {
            throw new XMPException("Invalid date string, missing 'T' after date", 5);
        }
        n2 = parseState.gatherInt("Invalid hour in date string", 23);
        if (parseState.ch() != ':') {
            throw new XMPException("Invalid date string, after hour", 5);
        }
        xMPDateTime.setHour(n2);
        parseState.skip();
        n2 = parseState.gatherInt("Invalid minute in date string", 59);
        if (parseState.hasNext() && parseState.ch() != ':' && parseState.ch() != 'Z' && parseState.ch() != '+' && parseState.ch() != '-') {
            throw new XMPException("Invalid date string, after minute", 5);
        }
        xMPDateTime.setMinute(n2);
        if (parseState.ch() == ':') {
            parseState.skip();
            n2 = parseState.gatherInt("Invalid whole seconds in date string", 59);
            if (parseState.hasNext() && parseState.ch() != '.' && parseState.ch() != 'Z' && parseState.ch() != '+' && parseState.ch() != '-') {
                throw new XMPException("Invalid date string, after whole seconds", 5);
            }
            xMPDateTime.setSecond(n2);
            if (parseState.ch() == '.') {
                parseState.skip();
                n = parseState.pos();
                n2 = parseState.gatherInt("Invalid fractional seconds in date string", 999999999);
                if (parseState.ch() != 'Z' && parseState.ch() != '+' && parseState.ch() != '-') {
                    throw new XMPException("Invalid date string, after fractional second", 5);
                }
                for (n = parseState.pos() - n; n > 9; --n) {
                    n2 /= 10;
                }
                while (n < 9) {
                    n2 *= 10;
                    ++n;
                }
                xMPDateTime.setNanoSecond(n2);
            }
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        if (parseState.ch() == 'Z') {
            parseState.skip();
        } else if (parseState.hasNext()) {
            if (parseState.ch() == '+') {
                n = 1;
            } else if (parseState.ch() == '-') {
                n = -1;
            } else {
                throw new XMPException("Time zone must begin with 'Z', '+', or '-'", 5);
            }
            parseState.skip();
            n3 = parseState.gatherInt("Invalid time zone hour in date string", 23);
            if (parseState.ch() != ':') {
                throw new XMPException("Invalid date string, after time zone hour", 5);
            }
            parseState.skip();
            n4 = parseState.gatherInt("Invalid time zone minute in date string", 59);
        }
        int n5 = (n3 * 3600 * 1000 + n4 * 60 * 1000) * n;
        xMPDateTime.setTimeZone(new SimpleTimeZone(n5, ""));
        if (parseState.hasNext()) {
            throw new XMPException("Invalid date string, extra chars at end", 5);
        }
        return xMPDateTime;
    }

    public static String render(XMPDateTime xMPDateTime) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("0000", new DecimalFormatSymbols(Locale.ENGLISH));
        stringBuffer.append(decimalFormat.format(xMPDateTime.getYear()));
        if (xMPDateTime.getMonth() == 0) {
            return stringBuffer.toString();
        }
        decimalFormat.applyPattern("'-'00");
        stringBuffer.append(decimalFormat.format(xMPDateTime.getMonth()));
        if (xMPDateTime.getDay() == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append(decimalFormat.format(xMPDateTime.getDay()));
        if (xMPDateTime.getHour() != 0 || xMPDateTime.getMinute() != 0 || xMPDateTime.getSecond() != 0 || xMPDateTime.getNanoSecond() != 0 || xMPDateTime.getTimeZone() != null && xMPDateTime.getTimeZone().getRawOffset() != 0) {
            stringBuffer.append('T');
            decimalFormat.applyPattern("00");
            stringBuffer.append(decimalFormat.format(xMPDateTime.getHour()));
            stringBuffer.append(':');
            stringBuffer.append(decimalFormat.format(xMPDateTime.getMinute()));
            if (xMPDateTime.getSecond() != 0 || xMPDateTime.getNanoSecond() != 0) {
                double d = (double)xMPDateTime.getSecond() + (double)xMPDateTime.getNanoSecond() / 1.0E9;
                decimalFormat.applyPattern(":00.#########");
                stringBuffer.append(decimalFormat.format(d));
            }
            if (xMPDateTime.getTimeZone() != null) {
                if (xMPDateTime.getTimeZone().getRawOffset() == 0) {
                    stringBuffer.append('Z');
                } else {
                    int n = xMPDateTime.getTimeZone().getRawOffset();
                    int n2 = n / 3600000;
                    int n3 = Math.abs(n % 3600000 / 60000);
                    decimalFormat.applyPattern("+00;-00");
                    stringBuffer.append(decimalFormat.format(n2));
                    decimalFormat.applyPattern(":00");
                    stringBuffer.append(decimalFormat.format(n3));
                }
            }
        }
        return stringBuffer.toString();
    }
}

