/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.XMPDateTimeImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class XMPDateTimeFactory {
    private XMPDateTimeFactory() {
    }

    public static XMPDateTime createFromCalendar(Calendar calendar) {
        return new XMPDateTimeImpl(calendar);
    }

    public static XMPDateTime create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        XMPDateTimeImpl xMPDateTimeImpl = new XMPDateTimeImpl();
        xMPDateTimeImpl.setYear(n);
        xMPDateTimeImpl.setMonth(n2);
        xMPDateTimeImpl.setDay(n3);
        xMPDateTimeImpl.setHour(n4);
        xMPDateTimeImpl.setMinute(n5);
        xMPDateTimeImpl.setSecond(n6);
        xMPDateTimeImpl.setNanoSecond(n7);
        return xMPDateTimeImpl;
    }

    public static XMPDateTime createFromISO8601(String string) throws XMPException {
        return new XMPDateTimeImpl(string);
    }

    public static XMPDateTime getCurrentDateTime() {
        return new XMPDateTimeImpl(new GregorianCalendar());
    }

    public static XMPDateTime setLocalTimeZone(XMPDateTime xMPDateTime) {
        Calendar calendar = xMPDateTime.getCalendar();
        calendar.setTimeZone(TimeZone.getDefault());
        return new XMPDateTimeImpl(calendar);
    }

    public static XMPDateTime convertToUTCTime(XMPDateTime xMPDateTime) {
        Calendar calendar = xMPDateTime.getCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return new XMPDateTimeImpl(calendar);
    }

    public static XMPDateTime convertToLocalTime(XMPDateTime xMPDateTime) {
        Calendar calendar = xMPDateTime.getCalendar();
        calendar.setTimeZone(TimeZone.getDefault());
        return new XMPDateTimeImpl(calendar);
    }
}

