/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.java.plugin.PluginManager;
import org.java.plugin.util.IoUtil;

public class StandardPluginLocation
implements PluginManager.PluginLocation {
    private final URL context;
    private final URL manifest;

    public static PluginManager.PluginLocation create(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            URL manifestUrl = StandardPluginLocation.getManifestUrl(file);
            return manifestUrl == null ? null : new StandardPluginLocation(IoUtil.file2url(file), manifestUrl);
        }
        String fileName = file.getName().toLowerCase(Locale.getDefault());
        if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) {
            return null;
        }
        URL manifestUrl = StandardPluginLocation.getManifestUrl(file);
        return manifestUrl == null ? null : new StandardPluginLocation(new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/"), manifestUrl);
    }

    private static URL getManifestUrl(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            File result = new File(file, "plugin.xml");
            if (result.isFile()) {
                return IoUtil.file2url(result);
            }
            result = new File(file, "plugin-fragment.xml");
            if (result.isFile()) {
                return IoUtil.file2url(result);
            }
            result = new File(file, "META-INF" + File.separator + "plugin.xml");
            if (result.isFile()) {
                return IoUtil.file2url(result);
            }
            result = new File(file, "META-INF" + File.separator + "plugin-fragment.xml");
            if (result.isFile()) {
                return IoUtil.file2url(result);
            }
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        URL url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin.xml");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin-fragment.xml");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin.xml");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin-fragment.xml");
        if (IoUtil.isResourceExists(url)) {
            return url;
        }
        return null;
    }

    public StandardPluginLocation(URL aContext, URL aManifest) {
        if (aContext == null) {
            throw new NullPointerException("context");
        }
        if (aManifest == null) {
            throw new NullPointerException("manifest");
        }
        this.context = aContext;
        this.manifest = aManifest;
    }

    public StandardPluginLocation(File file, String manifestPath) throws MalformedURLException {
        this.context = file.isDirectory() ? IoUtil.file2url(file) : new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/");
        this.manifest = new URL(this.context, manifestPath.startsWith("/") ? manifestPath.substring(1) : manifestPath);
    }

    public URL getManifestLocation() {
        return this.manifest;
    }

    public URL getContextLocation() {
        return this.context;
    }

    public String toString() {
        return this.context.toString();
    }
}

