/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;
import net.sf.jabref.sql.DBImportExportDialog;
import net.sf.jabref.sql.DBImporterExporter;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;

public abstract class DBExporter
extends DBImporterExporter {
    String fieldStr = SQLUtil.getFieldStr();
    DBStrings dbStrings = null;
    ArrayList<String> dbNames = new ArrayList();

    private void performExport(BibtexDatabase database, MetaData metaData, Set<String> keySet, Object out, String dbName) throws Exception {
        List<BibtexEntry> entries = FileActions.getSortedEntries(database, keySet, false);
        GroupTreeNode gtn = metaData.getGroups();
        int database_id = this.getDatabaseIDByName(metaData, out, dbName);
        this.removeAllRecordsForAGivenDB(out, database_id);
        this.populateEntryTypesTable(out);
        this.populateEntriesTable(database_id, entries, out);
        this.populateStringTable(database, out, database_id);
        this.populateGroupTypesTable(out);
        this.populateGroupsTable(gtn, 0, 1, out, database_id);
        this.populateEntryGroupsTable(gtn, 0, 1, out, database_id);
    }

    private void populateEntriesTable(int database_id, List<BibtexEntry> entries, Object out) throws SQLException {
        String query = "";
        String val = "";
        String insert = "INSERT INTO entries (jabref_eid, entry_types_id, cite_key, " + this.fieldStr + ", database_id) VALUES (";
        for (BibtexEntry entry : entries) {
            query = insert + "'" + entry.getId() + "'" + ", (SELECT entry_types_id FROM entry_types WHERE label='" + entry.getType().getName().toLowerCase() + "'), '" + entry.getCiteKey() + "'";
            for (int i = 0; i < SQLUtil.getAllFields().size(); ++i) {
                query = query + ", ";
                val = entry.getField(SQLUtil.getAllFields().get(i));
                if (val != null) {
                    val = val.replace("\\", "\\\\");
                    val = val.replace("\"", "\\\"");
                    val = val.replace("'", "''");
                    val = val.replace("`", "\\`");
                    query = query + "'" + val + "'";
                    continue;
                }
                query = query + "NULL";
            }
            query = query + ", '" + database_id + "');";
            SQLUtil.processQuery(out, query);
        }
    }

    private int populateEntryGroupsTable(GroupTreeNode cursor, int parentID, int currentID, Object out, int database_id) throws SQLException {
        if (cursor.getGroup() instanceof ExplicitGroup) {
            ExplicitGroup grp = (ExplicitGroup)cursor.getGroup();
            for (BibtexEntry be : grp.getEntries()) {
                SQLUtil.processQuery(out, "INSERT INTO entry_group (entries_id, groups_id) VALUES ((SELECT entries_id FROM entries WHERE jabref_eid='" + be.getId() + "' AND database_id = " + database_id + "), " + "(SELECT groups_id FROM groups WHERE database_id=" + "'" + database_id + "' AND parent_id=" + "'" + parentID + "' AND label=" + "'" + grp.getName() + "')" + ");");
            }
        }
        Object response = SQLUtil.processQueryWithResults(out, "SELECT groups_id FROM groups WHERE label='" + cursor.getGroup().getName() + "' AND database_id='" + database_id + "' AND parent_id='" + parentID + "';");
        int myID = ++currentID;
        if (response instanceof Statement) {
            ResultSet rs = ((Statement)response).getResultSet();
            rs.next();
            myID = rs.getInt("groups_id");
        }
        Enumeration<GroupTreeNode> e = cursor.children();
        while (e.hasMoreElements()) {
            currentID = this.populateEntryGroupsTable(e.nextElement(), myID, currentID, out, database_id);
        }
        return currentID;
    }

    private void populateEntryTypesTable(Object out) throws SQLException {
        String query = "";
        ArrayList<String> fieldRequirement = new ArrayList<String>();
        ArrayList<String> existentTypes = new ArrayList<String>();
        if (out instanceof Connection) {
            ResultSet rs = ((Statement)SQLUtil.processQueryWithResults(out, "SELECT label FROM entry_types")).getResultSet();
            while (rs.next()) {
                existentTypes.add(rs.getString(1));
            }
        }
        for (BibtexEntryType val : BibtexEntryType.ALL_TYPES.values()) {
            int i;
            fieldRequirement.clear();
            for (int i2 = 0; i2 < SQLUtil.getAllFields().size(); ++i2) {
                fieldRequirement.add(i2, "gen");
            }
            List<String> reqFields = Arrays.asList(val.getRequiredFields() != null ? val.getRequiredFields() : new String[]{});
            List<String> optFields = Arrays.asList(val.getOptionalFields() != null ? val.getOptionalFields() : new String[]{});
            List<String> utiFields = Arrays.asList(val.getUtilityFields() != null ? val.getUtilityFields() : new String[]{});
            fieldRequirement = SQLUtil.setFieldRequirement(SQLUtil.getAllFields(), reqFields, optFields, utiFields, fieldRequirement);
            if (!existentTypes.contains(val.getName().toLowerCase())) {
                String insert = "INSERT INTO entry_types (label, " + this.fieldStr + ") VALUES (";
                query = insert + "'" + val.getName().toLowerCase() + "'";
                for (i = 0; i < fieldRequirement.size(); ++i) {
                    query = query + ", '" + fieldRequirement.get(i) + "'";
                }
                query = query + ");";
            } else {
                String[] update = this.fieldStr.split(",");
                query = "UPDATE entry_types SET \n";
                for (i = 0; i < fieldRequirement.size(); ++i) {
                    query = query + update[i] + "='" + fieldRequirement.get(i) + "',";
                }
                query = query.substring(0, query.lastIndexOf(","));
                query = query + " WHERE label='" + val.getName().toLowerCase() + "'";
            }
            SQLUtil.processQuery(out, query);
        }
    }

    private int populateGroupsTable(GroupTreeNode cursor, int parentID, int currentID, Object out, int database_id) throws SQLException {
        AbstractGroup group = cursor.getGroup();
        String searchField = null;
        String searchExpr = null;
        String caseSens = null;
        String reg_exp = null;
        int hierContext = group.getHierarchicalContext();
        if (group instanceof KeywordGroup) {
            searchField = ((KeywordGroup)group).getSearchField();
            searchExpr = ((KeywordGroup)group).getSearchExpression();
            caseSens = ((KeywordGroup)group).isCaseSensitive() ? "1" : "0";
            reg_exp = ((KeywordGroup)group).isRegExp() ? "1" : "0";
        } else if (group instanceof SearchGroup) {
            searchExpr = ((SearchGroup)group).getSearchExpression();
            caseSens = ((SearchGroup)group).isCaseSensitive() ? "1" : "0";
            String string = reg_exp = ((SearchGroup)group).isRegExp() ? "1" : "0";
        }
        if (searchField != null) {
            searchField = Util.quote(searchField, "'", '\\');
        }
        if (searchExpr != null) {
            searchExpr = Util.quote(searchExpr, "'", '\\');
        }
        SQLUtil.processQuery(out, "INSERT INTO groups (label, parent_id, group_types_id, search_field, search_expression, case_sensitive, reg_exp, hierarchical_context, database_id) VALUES ('" + group.getName() + "', " + parentID + ", (SELECT group_types_id FROM group_types where label='" + group.getTypeId() + "')" + ", " + (searchField != null ? "'" + searchField + "'" : "NULL") + ", " + (searchExpr != null ? "'" + searchExpr + "'" : "NULL") + ", " + (caseSens != null ? "'" + caseSens + "'" : "NULL") + ", " + (reg_exp != null ? "'" + reg_exp + "'" : "NULL") + ", " + hierContext + ", '" + database_id + "');");
        Object response = SQLUtil.processQueryWithResults(out, "SELECT groups_id FROM groups WHERE label='" + cursor.getGroup().getName() + "' AND database_id='" + database_id + "' AND parent_id='" + parentID + "';");
        int myID = currentID;
        if (response instanceof Statement) {
            ResultSet rs = ((Statement)response).getResultSet();
            rs.next();
            myID = rs.getInt("groups_id");
        }
        Enumeration<GroupTreeNode> e = cursor.children();
        while (e.hasMoreElements()) {
            ++currentID;
            currentID = this.populateGroupsTable(e.nextElement(), myID, currentID, out, database_id);
        }
        return currentID;
    }

    private void populateGroupTypesTable(Object out) throws SQLException {
        int quantidade = 0;
        if (out instanceof Connection) {
            ResultSet res = ((Statement)SQLUtil.processQueryWithResults(out, "SELECT COUNT(*) AS amount FROM group_types")).getResultSet();
            res.next();
            quantidade = res.getInt("amount");
            res.getStatement().close();
        }
        if (quantidade == 0) {
            String[] typeNames = new String[]{"AllEntriesGroup:", "ExplicitGroup:", "KeywordGroup:", "SearchGroup:"};
            for (int i = 0; i < typeNames.length; ++i) {
                String typeName = typeNames[i];
                String insert = "INSERT INTO group_types (label) VALUES ('" + typeName + "');";
                SQLUtil.processQuery(out, insert);
            }
        }
    }

    private void populateStringTable(BibtexDatabase database, Object out, int database_id) throws SQLException {
        String insert = "INSERT INTO strings (label, content, database_id) VALUES (";
        if (database.getPreamble() != null) {
            String dml = insert + "'@PREAMBLE', " + "'" + Util.quote(database.getPreamble(), "'", '\\') + "', " + "'" + database_id + "');";
            SQLUtil.processQuery(out, dml);
        }
        for (String key : database.getStringKeySet()) {
            BibtexString string = database.getString(key);
            String dml = insert + "'" + Util.quote(string.getName(), "'", '\\') + "', " + "'" + Util.quote(string.getContent(), "'", '\\') + "', " + "'" + database_id + "'" + ");";
            SQLUtil.processQuery(out, dml);
        }
    }

    public abstract Connection connectToDB(DBStrings var1) throws Exception;

    protected abstract void createTables(Object var1) throws SQLException;

    public void exportDatabaseAsFile(BibtexDatabase database, MetaData metaData, Set<String> keySet, String file) throws Exception {
        File outfile = new File(file);
        if (outfile.exists()) {
            outfile.delete();
        }
        BufferedOutputStream writer = null;
        writer = new BufferedOutputStream(new FileOutputStream(outfile));
        PrintStream fout = null;
        fout = new PrintStream(writer);
        this.performExport(database, metaData, keySet, fout, "file");
        fout.close();
    }

    public void exportDatabaseToDBMS(BibtexDatabase database, MetaData metaData, Set<String> keySet, DBStrings dbStrings, JabRefFrame frame) throws Exception {
        String dbName = "";
        Connection conn = null;
        boolean redisplay = false;
        try {
            conn = this.connectToDB(dbStrings);
            this.createTables(conn);
            Vector<Vector<String>> matrix = this.createExistentDBNamesMatrix(dbStrings);
            DBImportExportDialog dialogo = new DBImportExportDialog(frame, matrix, DBImportExportDialog.DialogType.EXPORTER);
            if (dialogo.removeAction) {
                dbName = this.getDBName(matrix, dbStrings, frame, dialogo);
                this.removeDB(dialogo, dbName, conn, metaData);
                redisplay = true;
            } else if (dialogo.hasDBSelected) {
                dbName = this.getDBName(matrix, dbStrings, frame, dialogo);
                this.performExport(database, metaData, keySet, conn, dbName);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
                conn.setAutoCommit(true);
            }
            conn.close();
            if (redisplay) {
                this.exportDatabaseToDBMS(database, metaData, keySet, dbStrings, frame);
            }
        }
        catch (SQLException ex) {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
            throw ex;
        }
    }

    private String getDBName(Vector<Vector<String>> matrix, DBStrings dbStrings, JabRefFrame frame, DBImportExportDialog dialogo) throws SQLException, Exception {
        String dbName = "";
        if (matrix.size() > 1) {
            if (dialogo.hasDBSelected) {
                dbName = dialogo.selectedDB;
                if (dialogo.selectedInt == 0 && !dialogo.removeAction) {
                    dbName = JOptionPane.showInputDialog(dialogo.getDiag(), "Please enter the desired name:", "SQL Export", 1);
                    if (dbName != null) {
                        while (!this.isValidDBName(this.dbNames, dbName)) {
                            dbName = JOptionPane.showInputDialog(dialogo.getDiag(), "You have entered an invalid or already existent DB name.\n Please enter the desired name:", "SQL Export", 0);
                        }
                    } else {
                        this.getDBName(matrix, dbStrings, frame, new DBImportExportDialog(frame, matrix, DBImportExportDialog.DialogType.EXPORTER));
                    }
                }
            }
        } else {
            dbName = JOptionPane.showInputDialog(frame, "Please enter the desired name:", "SQL Export", 1);
        }
        return dbName;
    }

    private Vector<Vector<String>> createExistentDBNamesMatrix(DBStrings dbStrings) throws SQLException, Exception {
        ResultSet rs = SQLUtil.queryAllFromTable(this.connectToDB(dbStrings), "jabref_database");
        Vector<Vector<String>> matrix = new Vector<Vector<String>>();
        this.dbNames.clear();
        Vector<String> v = new Vector<String>();
        v.add(Globals.lang("< CREATE NEW DATABASE >"));
        matrix.add(v);
        while (rs.next()) {
            v = new Vector();
            v.add(rs.getString("database_name"));
            matrix.add(v);
            this.dbNames.add(rs.getString("database_name"));
        }
        return matrix;
    }

    private boolean isValidDBName(ArrayList<String> dbNames, String desiredName) throws SQLException {
        if (desiredName.trim().length() <= 1) {
            return false;
        }
        return !dbNames.contains(desiredName);
    }
}

