/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupTreeNode;

public class RemoveFromGroupAction
extends AbstractAction {
    protected GroupTreeNode m_node;
    protected BasePanel m_panel;

    public RemoveFromGroupAction(GroupTreeNode node, BasePanel panel) {
        super(node.getGroup().getName());
        this.m_node = node;
        this.m_panel = panel;
    }

    public RemoveFromGroupAction() {
        super(Globals.lang("Remove entry selection from this group"));
    }

    public void setNode(GroupTreeNode node) {
        this.m_node = node;
    }

    public void setBasePanel(BasePanel panel) {
        this.m_panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_node.getGroup()}, this.m_panel.getSelectedEntries(), this.m_panel.getDatabase(), this.m_panel.frame())) {
            return;
        }
        AbstractUndoableEdit undo = this.m_node.removeFromGroup(this.m_panel.getSelectedEntries());
        if (undo == null) {
            return;
        }
        this.m_panel.undoManager.addEdit(undo);
        this.m_panel.markBaseChanged();
        this.m_panel.updateEntryEditorIfShowing();
        this.m_panel.getGroupSelector().valueChanged(null);
    }
}

