/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class EncodedFileInputStream
extends InputStream {
    private final ByteStreamBuffer buffer = new ByteStreamBuffer();
    private int streamPointer = 0;
    private int streamMarker = -1;
    private int markTTL = 2048;
    private final InputStream stream;
    private String charEncoding = null;

    public EncodedFileInputStream(File file) throws FileNotFoundException {
        this.stream = new FileInputStream(file);
    }

    public EncodedFileInputStream(File file, Charset charset) throws FileNotFoundException {
        this.stream = new FileInputStream(file);
    }

    public EncodedFileInputStream(File file, String charsetName) throws UnsupportedEncodingException, FileNotFoundException {
        this.stream = new FileInputStream(file);
        "encodingTest".getBytes(charsetName);
        this.charEncoding = charsetName;
    }

    @Override
    public int read() throws IOException {
        if (this.stream.available() != 0) {
            this.buffer.add(this.stream.read());
        }
        if (this.streamPointer < this.buffer.size()) {
            if (this.streamMarker > 0 && this.streamPointer - this.streamMarker > this.markTTL) {
                this.streamMarker = -1;
            }
            return this.buffer.get(this.streamPointer++);
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.stream.available() != 0) {
            return this.stream.available();
        }
        return this.buffer.size() - this.streamPointer;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.streamMarker = this.streamPointer;
        this.markTTL = readLimit;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.streamMarker >= 0) {
            this.streamPointer = this.streamMarker;
        }
    }

    @Override
    public void close() throws IOException {
    }

    private class ByteStreamBuffer {
        private LinkedList<Byte> buffer = new LinkedList();

        private ByteStreamBuffer() {
        }

        public void add(Integer read) {
            if (read != null) {
                byte[] b;
                if (EncodedFileInputStream.this.charEncoding != null) {
                    try {
                        b = Character.valueOf((char)read.intValue()).toString().getBytes(EncodedFileInputStream.this.charEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        return;
                    }
                } else {
                    b = Character.valueOf((char)read.intValue()).toString().getBytes();
                }
                this.addToBuffer(b);
            }
        }

        private void addToBuffer(byte[] bytes) {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.buffer.add(b);
                ++n2;
            }
        }

        public byte get(int index) {
            return this.buffer.get(index);
        }

        public int size() {
            return this.buffer.size();
        }
    }
}

