/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType4;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDDeviceN
extends PDColorSpace {
    private static final Log log = LogFactory.getLog(PDDeviceN.class);
    public static final String NAME = "DeviceN";
    private COSArray array;

    public PDDeviceN() {
        this.array = new COSArray();
        this.array.add(COSName.DEVICEN);
        this.array.add(COSName.getPDFName(""));
    }

    public PDDeviceN(COSArray separation) {
        this.array = separation;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return this.getColorantNames().size();
    }

    @Override
    protected ColorSpace createColorSpace() throws IOException {
        try {
            PDColorSpace alt = this.getAlternateColorSpace();
            return alt.getJavaColorSpace();
        }
        catch (IOException ioexception) {
            log.error(ioexception, ioexception);
            throw ioexception;
        }
        catch (Exception exception) {
            log.error(exception, exception);
            throw new IOException("Failed to Create ColorSpace");
        }
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        log.info("About to create ColorModel for " + this.getAlternateColorSpace().toString());
        return this.getAlternateColorSpace().createColorModel(bpc);
    }

    public List<COSBase> getColorantNames() {
        COSArray names = (COSArray)this.array.getObject(1);
        return COSArrayList.convertCOSNameCOSArrayToList(names);
    }

    public void setColorantNames(List<COSBase> names) {
        COSArray namesArray = COSArrayList.convertStringListToCOSNameCOSArray(names);
        this.array.set(1, namesArray);
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSBase alternate = this.array.getObject(2);
        return PDColorSpaceFactory.createColorSpace(alternate);
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        return PDFunction.create(this.array.getObject(3));
    }

    public void setTintTransform(PDFunction tint) {
        this.array.set(3, tint);
    }

    public PDDeviceNAttributes getAttributes() {
        PDDeviceNAttributes retval = null;
        if (this.array.size() < 5) {
            retval = new PDDeviceNAttributes();
            this.setAttributes(retval);
        }
        return retval;
    }

    public void setAttributes(PDDeviceNAttributes attributes) {
        if (attributes == null) {
            this.array.remove(4);
        } else {
            while (this.array.size() < 5) {
                this.array.add(COSNull.NULL);
            }
            this.array.set(4, attributes.getCOSDictionary());
        }
    }

    public COSArray calculateColorValues(List<COSBase> tintValues) throws IOException {
        PDFunction tintTransform = this.getTintTransform();
        if (tintTransform instanceof PDFunctionType4) {
            log.warn("Unsupported tint transformation type: " + tintTransform.getClass().getName() + " in " + this.getClass().getName() + ".getColorValues()" + " using color black instead.");
            int numberOfComponents = this.getAlternateColorSpace().getNumberOfComponents();
            float colorValue = numberOfComponents == 4 ? 1.0f : 0.0f;
            COSArray retval = new COSArray();
            for (int i = 0; i < numberOfComponents; ++i) {
                retval.add(new COSFloat(colorValue));
            }
            return retval;
        }
        COSArray tint = new COSArray();
        tint.addAll(tintValues);
        return tintTransform.eval(tint);
    }
}

