/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.util.EncryptionNotSupportedException;
import net.sf.jabref.util.XMPSchemaBibtex;
import org.apache.jempbox.impl.DateConverter;
import org.apache.jempbox.impl.XMLUtil;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPUtil {
    public static List<BibtexEntry> readXMP(String filename) throws IOException {
        return XMPUtil.readXMP(new File(filename));
    }

    public static void writeXMP(String filename, BibtexEntry entry, BibtexDatabase database) throws IOException, TransformerException {
        XMPUtil.writeXMP(new File(filename), entry, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BibtexEntry> readXMP(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            List<BibtexEntry> list = XMPUtil.readXMP(is);
            return list;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BibtexEntry> readXMP(InputStream inputStream) throws IOException {
        LinkedList<BibtexEntry> result = new LinkedList<BibtexEntry>();
        PDDocument document = null;
        try {
            BibtexEntry entry;
            document = PDDocument.load(inputStream);
            if (document.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata meta = XMPUtil.getXMPMetadata(document);
            if (meta != null) {
                List<XMPSchema> schemas = meta.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
                for (XMPSchemaBibtex xMPSchemaBibtex : schemas) {
                    result.add(xMPSchemaBibtex.getBibtexEntry());
                }
                if (result.size() == 0) {
                    schemas = meta.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
                    for (XMPSchemaDublinCore xMPSchemaDublinCore : schemas) {
                        BibtexEntry entry2 = XMPUtil.getBibtexEntryFromDublinCore(xMPSchemaDublinCore);
                        if (entry2 == null) continue;
                        result.add(entry2);
                    }
                }
            }
            if (result.size() == 0 && (entry = XMPUtil.getBibtexEntryFromDocumentInformation(document.getDocumentInformation())) != null) {
                result.add(entry);
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static BibtexEntry getBibtexEntryFromDocumentInformation(PDDocumentInformation di) {
        BibtexEntry entry = new BibtexEntry();
        String s = di.getAuthor();
        if (s != null) {
            entry.setField("author", s);
        }
        if ((s = di.getTitle()) != null) {
            entry.setField("title", s);
        }
        if ((s = di.getKeywords()) != null) {
            entry.setField("keywords", s);
        }
        if ((s = di.getSubject()) != null) {
            entry.setField("abstract", s);
        }
        COSDictionary dict = di.getDictionary();
        Iterator<COSName> it = dict.keyList().iterator();
        while (it.hasNext()) {
            String key = it.next().getName();
            if (!key.startsWith("bibtex/")) continue;
            String value = dict.getString(key);
            if ((key = key.substring("bibtex/".length())).equals("entrytype")) {
                BibtexEntryType type = BibtexEntryType.getStandardType(value);
                if (type == null) continue;
                entry.setType(type);
                continue;
            }
            entry.setField(key, value);
        }
        return entry.getAllFields().size() > 0 ? entry : null;
    }

    public static BibtexEntry getBibtexEntryFromDublinCore(XMPSchemaDublinCore dcSchema) {
        BibtexEntryType type;
        List<String> l;
        List<String> subjects;
        List<String> relationships;
        List<String> publishers;
        String s2;
        List<String> dates;
        List<String> creators;
        BibtexEntry entry = new BibtexEntry();
        List<String> contributors = dcSchema.getContributors();
        if (contributors != null) {
            Iterator<String> it = contributors.iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                if (sb != null) {
                    sb.append(" and ");
                } else {
                    sb = new StringBuffer();
                }
                sb.append((Object)it.next());
            }
            if (sb != null) {
                entry.setField("editor", sb.toString());
            }
        }
        if ((creators = dcSchema.getCreators()) != null) {
            Iterator<String> it = creators.iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                if (sb != null) {
                    sb.append(" and ");
                } else {
                    sb = new StringBuffer();
                }
                sb.append((Object)it.next());
            }
            if (sb != null) {
                entry.setField("author", sb.toString());
            }
        }
        if ((dates = dcSchema.getSequenceList("dc:date")) != null && dates.size() > 0) {
            String date = dates.get(0).trim();
            Calendar c = null;
            try {
                c = DateConverter.toCalendar(date);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c != null) {
                entry.setField("year", String.valueOf(c.get(1)));
                if (date.length() > 4) {
                    entry.setField("month", "#" + Globals.MONTHS[c.get(2)] + "#");
                }
            }
        }
        if ((s2 = dcSchema.getDescription()) != null) {
            entry.setField("abstract", s2);
        }
        if ((s2 = dcSchema.getIdentifier()) != null) {
            entry.setField("doi", s2);
        }
        if ((publishers = dcSchema.getPublishers()) != null) {
            Iterator<String> it = dcSchema.getPublishers().iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                if (sb != null) {
                    sb.append(" and ");
                } else {
                    sb = new StringBuffer();
                }
                sb.append((Object)it.next());
            }
            if (sb != null) {
                entry.setField("publishers", sb.toString());
            }
        }
        if ((relationships = dcSchema.getRelationships()) != null) {
            for (String s2 : relationships) {
                int i;
                if (!s2.startsWith("bibtex/") || (i = (s2 = s2.substring("bibtex/".length())).indexOf(47)) == -1) continue;
                entry.setField(s2.substring(0, i), s2.substring(i + 1));
            }
        }
        if ((s2 = dcSchema.getRights()) != null) {
            entry.setField("rights", s2);
        }
        if ((s2 = dcSchema.getSource()) != null) {
            entry.setField("source", s2);
        }
        if ((subjects = dcSchema.getSubjects()) != null) {
            Iterator<String> it = subjects.iterator();
            StringBuffer sb = null;
            while (it.hasNext()) {
                if (sb != null) {
                    sb.append(",");
                } else {
                    sb = new StringBuffer();
                }
                sb.append((Object)it.next());
            }
            if (sb != null) {
                entry.setField("keywords", sb.toString());
            }
        }
        if ((s2 = dcSchema.getTitle()) != null) {
            entry.setField("title", s2);
        }
        if ((l = dcSchema.getTypes()) != null && l.size() > 0 && (s2 = l.get(0)) != null && (type = BibtexEntryType.getStandardType(s2)) != null) {
            entry.setType(type);
        }
        return entry.getAllFields().size() > 0 ? entry : null;
    }

    public static void writeXMP(File file, BibtexEntry entry, BibtexDatabase database) throws IOException, TransformerException {
        LinkedList<BibtexEntry> l = new LinkedList<BibtexEntry>();
        l.add(entry);
        XMPUtil.writeXMP(file, l, database, true);
    }

    public static void toXMP(Collection<BibtexEntry> bibtexEntries, BibtexDatabase database, OutputStream outputStream) throws IOException, TransformerException {
        if (database != null) {
            bibtexEntries = database.resolveForStrings(bibtexEntries, true);
        }
        XMPMetadata x = new XMPMetadata();
        for (BibtexEntry e : bibtexEntries) {
            XMPSchemaBibtex schema = new XMPSchemaBibtex(x);
            x.addSchema(schema);
            schema.setBibtexEntry(e);
        }
        x.save(outputStream);
    }

    public static String toXMP(Collection<BibtexEntry> bibtexEntries, BibtexDatabase database) throws TransformerException {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            XMPUtil.toXMP(bibtexEntries, database, bs);
            return bs.toString();
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMPMetadata readRawXMP(InputStream inputStream) throws IOException {
        PDDocument document = null;
        try {
            document = PDDocument.load(inputStream);
            if (document.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot read metadata from encrypted document.");
            }
            XMPMetadata xMPMetadata = XMPUtil.getXMPMetadata(document);
            return xMPMetadata;
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    static XMPMetadata getXMPMetadata(PDDocument document) throws IOException {
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metaRaw = catalog.getMetadata();
        if (metaRaw == null) {
            return null;
        }
        XMPMetadata meta = new XMPMetadata(XMLUtil.parse(metaRaw.createInputStream()));
        meta.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMPMetadata readRawXMP(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            XMPMetadata xMPMetadata = XMPUtil.readRawXMP(is);
            return xMPMetadata;
        }
        finally {
            is.close();
        }
    }

    static void writeToDCSchema(XMPSchemaDublinCore dcSchema, BibtexEntry entry, BibtexDatabase database) {
        if (database != null) {
            entry = database.resolveForStrings(entry, false);
        }
        for (String field : entry.getAllFields()) {
            int i;
            int n;
            String authors;
            String o;
            if (field.equals("editor")) {
                o = entry.getField(field.toString()).toString();
                authors = o.toString();
                AuthorList list = AuthorList.getAuthorList(authors);
                n = list.size();
                for (i = 0; i < n; ++i) {
                    dcSchema.addContributor(list.getAuthor(i).getFirstLast(false));
                }
                continue;
            }
            if (field.equals("author")) {
                o = entry.getField(field.toString()).toString();
                authors = o.toString();
                AuthorList list = AuthorList.getAuthorList(authors);
                n = list.size();
                for (i = 0; i < n; ++i) {
                    dcSchema.addCreator(list.getAuthor(i).getFirstLast(false));
                }
                continue;
            }
            if (field.equals("month")) continue;
            if (field.equals("year")) {
                String publicationDate = Util.getPublicationDate(entry);
                if (publicationDate == null) continue;
                dcSchema.addSequenceValue("dc:date", publicationDate);
                continue;
            }
            if (field.equals("abstract")) {
                o = entry.getField(field.toString()).toString();
                dcSchema.setDescription(o.toString());
                continue;
            }
            if (field.equals("doi")) {
                o = entry.getField(field.toString()).toString();
                dcSchema.setIdentifier(o.toString());
                continue;
            }
            if (field.equals("publisher")) {
                o = entry.getField(field.toString()).toString();
                dcSchema.addPublisher(o.toString());
                continue;
            }
            if (field.equals("keywords")) {
                o = entry.getField(field.toString()).toString();
                String[] keywords = o.toString().split(",");
                for (int i2 = 0; i2 < keywords.length; ++i2) {
                    dcSchema.addSubject(keywords[i2].trim());
                }
                continue;
            }
            if (field.equals("title")) {
                o = entry.getField(field.toString()).toString();
                dcSchema.setTitle(o.toString());
                continue;
            }
            o = entry.getField(field.toString()).toString();
            dcSchema.addRelation("bibtex/" + field.toString() + "/" + o);
        }
        dcSchema.setFormat("application/pdf");
        String o = entry.getType().getName();
        if (o != null) {
            dcSchema.addType(o.toString());
        }
    }

    public static void writeDublinCore(PDDocument document, BibtexEntry entry, BibtexDatabase database) throws IOException, TransformerException {
        ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
        entries.add(entry);
        XMPUtil.writeDublinCore(document, entries, database);
    }

    public static void writeDublinCore(PDDocument document, Collection<BibtexEntry> entries, BibtexDatabase database) throws IOException, TransformerException {
        PDDocumentCatalog catalog;
        PDMetadata metaRaw;
        if (database != null) {
            entries = database.resolveForStrings(entries, false);
        }
        XMPMetadata meta = (metaRaw = (catalog = document.getDocumentCatalog()).getMetadata()) != null ? new XMPMetadata(XMLUtil.parse(metaRaw.createInputStream())) : new XMPMetadata();
        List<XMPSchema> schemas = meta.getSchemasByNamespaceURI("http://purl.org/dc/elements/1.1/");
        for (XMPSchema bib : schemas) {
            bib.getElement().getParentNode().removeChild(bib.getElement());
        }
        for (BibtexEntry entry : entries) {
            XMPSchemaDublinCore dcSchema = new XMPSchemaDublinCore(meta);
            XMPUtil.writeToDCSchema(dcSchema, entry, null);
            meta.addSchema(dcSchema);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        meta.save(os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        PDMetadata metadataStream = new PDMetadata(document, is, false);
        catalog.setMetadata(metadataStream);
    }

    public static void writeDocumentInformation(PDDocument document, BibtexEntry entry, BibtexDatabase database) {
        PDDocumentInformation di = document.getDocumentInformation();
        if (database != null) {
            entry = database.resolveForStrings(entry, false);
        }
        Set<String> fields = entry.getAllFields();
        for (String field : fields) {
            if (field.equals("author")) {
                di.setAuthor(entry.getField("author").toString());
                continue;
            }
            if (field.equals("title")) {
                di.setTitle(entry.getField("title").toString());
                continue;
            }
            if (field.equals("keywords")) {
                di.setKeywords(entry.getField("keywords").toString());
                continue;
            }
            if (field.equals("abstract")) {
                di.setSubject(entry.getField("abstract").toString());
                continue;
            }
            di.setCustomMetadataValue("bibtex/" + field.toString(), entry.getField(field.toString()).toString());
        }
        di.setCustomMetadataValue("bibtex/entrytype", entry.getType().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMP(File file, Collection<BibtexEntry> bibtexEntries, BibtexDatabase databasee, boolean writePDFInfo) throws IOException, TransformerException {
        if (databasee != null) {
            bibtexEntries = databasee.resolveForStrings(bibtexEntries, false);
        }
        PDDocument document = null;
        try {
            PDDocumentCatalog catalog;
            PDMetadata metaRaw;
            document = PDDocument.load(file.getAbsoluteFile());
            if (document.isEncrypted()) {
                throw new EncryptionNotSupportedException("Error: Cannot add metadata to encrypted document.");
            }
            if (writePDFInfo && bibtexEntries.size() == 1) {
                XMPUtil.writeDocumentInformation(document, bibtexEntries.iterator().next(), null);
                XMPUtil.writeDublinCore(document, bibtexEntries, null);
            }
            XMPMetadata meta = (metaRaw = (catalog = document.getDocumentCatalog()).getMetadata()) != null ? new XMPMetadata(XMLUtil.parse(metaRaw.createInputStream())) : new XMPMetadata();
            meta.addXMLNSMapping("http://jabref.sourceforge.net/bibteXMP/", XMPSchemaBibtex.class);
            List<XMPSchema> schemas = meta.getSchemasByNamespaceURI("http://jabref.sourceforge.net/bibteXMP/");
            for (XMPSchemaBibtex xMPSchemaBibtex : schemas) {
                xMPSchemaBibtex.getElement().getParentNode().removeChild(xMPSchemaBibtex.getElement());
            }
            for (BibtexEntry bibtexEntry : bibtexEntries) {
                XMPSchemaBibtex bibtex = new XMPSchemaBibtex(meta);
                meta.addSchema(bibtex);
                bibtex.setBibtexEntry(bibtexEntry, null);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            meta.save(byteArrayOutputStream);
            ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            PDMetadata metadataStream = new PDMetadata(document, is, false);
            catalog.setMetadata(metadataStream);
            try {
                document.save(file.getAbsolutePath());
            }
            catch (COSVisitorException e) {
                throw new TransformerException("Could not write XMP-metadata: " + e.getLocalizedMessage());
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    protected static void usage() {
        System.out.println("Read or write XMP-metadata from or to pdf file.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("Read from PDF and print as bibtex:");
        System.out.println("  xmpUtil <pdf>");
        System.out.println("Read from PDF and print raw XMP:");
        System.out.println("  xmpUtil -x <pdf>");
        System.out.println("Write the entry in <bib> given by <key> to the PDF:");
        System.out.println("  xmpUtil <key> <bib> <pdf>");
        System.out.println("Write all entries in <bib> to the PDF:");
        System.out.println("  xmpUtil <bib> <pdf>");
        System.out.println("");
        System.out.println("To report bugs visit http://jabref.sourceforge.net");
    }

    public static void main(String[] args) throws IOException, TransformerException {
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        switch (args.length) {
            case 0: {
                XMPUtil.usage();
                break;
            }
            case 1: {
                if (args[0].endsWith(".pdf")) {
                    List<BibtexEntry> l = XMPUtil.readXMP(new File(args[0]));
                    for (BibtexEntry e : l) {
                        StringWriter sw = new StringWriter();
                        e.write(sw, new LatexFieldFormatter(), false);
                        System.out.println(sw.getBuffer().toString());
                    }
                    break;
                }
                if (args[0].endsWith(".bib")) {
                    ParserResult result = BibtexParser.parse(new FileReader(args[0]));
                    Collection<BibtexEntry> entries = result.getDatabase().getEntries();
                    if (entries.size() == 0) {
                        System.err.println("Could not find BibtexEntry in " + args[0]);
                        break;
                    }
                    System.out.println(XMPUtil.toXMP(entries, result.getDatabase()));
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 2: {
                if (args[0].equals("-x") && args[1].endsWith(".pdf")) {
                    XMPMetadata meta = XMPUtil.readRawXMP(new File(args[1]));
                    if (meta == null) {
                        System.err.println("The given pdf does not contain any XMP-metadata.");
                        break;
                    }
                    XMLUtil.save((Node)meta.getXMPDocument(), System.out, "UTF-8");
                    break;
                }
                if (args[0].endsWith(".bib") && args[1].endsWith(".pdf")) {
                    ParserResult result = BibtexParser.parse(new FileReader(args[0]));
                    Collection<BibtexEntry> entries = result.getDatabase().getEntries();
                    if (entries.size() == 0) {
                        System.err.println("Could not find BibtexEntry in " + args[0]);
                        break;
                    }
                    XMPUtil.writeXMP(new File(args[1]), entries, result.getDatabase(), false);
                    System.out.println("XMP written.");
                    break;
                }
                XMPUtil.usage();
                break;
            }
            case 3: {
                if (!args[1].endsWith(".bib") && !args[2].endsWith(".pdf")) {
                    XMPUtil.usage();
                    break;
                }
                ParserResult result = BibtexParser.parse(new FileReader(args[1]));
                BibtexEntry e = result.getDatabase().getEntryByKey(args[0]);
                if (e == null) {
                    System.err.println("Could not find BibtexEntry " + args[0] + " in " + args[0]);
                    break;
                }
                XMPUtil.writeXMP(new File(args[2]), e, result.getDatabase());
                System.out.println("XMP written.");
                break;
            }
            default: {
                XMPUtil.usage();
            }
        }
    }

    public static boolean hasMetadata(InputStream is) {
        try {
            List<BibtexEntry> l = XMPUtil.readXMP(is);
            return l.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

