/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class AdvancedCiteDialog {
    static boolean defaultInPar = true;
    boolean okPressed = false;
    JDialog diag;
    JRadioButton inPar = new JRadioButton(Globals.lang("Cite selected entries"));
    JRadioButton inText = new JRadioButton(Globals.lang("Cite selected entries with in-text citation"));
    JTextField pageInfo = new JTextField(15);
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));

    public AdvancedCiteDialog(JabRefFrame parent) {
        this.diag = new JDialog(parent, Globals.lang("Cite special"), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.inPar);
        bg.add(this.inText);
        if (defaultInPar) {
            this.inPar.setSelected(true);
        } else {
            this.inText.setSelected(true);
        }
        this.inPar.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                defaultInPar = AdvancedCiteDialog.this.inPar.isSelected();
            }
        });
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        b.append((Component)this.inPar, 3);
        b.nextLine();
        b.append((Component)this.inText, 3);
        b.nextLine();
        b.append(Globals.lang("Extra information (e.g. page number)") + ":");
        b.append(this.pageInfo);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)b.getPanel(), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedCiteDialog.this.okPressed = true;
                AdvancedCiteDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(okAction);
        this.pageInfo.addActionListener(okAction);
        this.inPar.addActionListener(okAction);
        this.inText.addActionListener(okAction);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedCiteDialog.this.okPressed = false;
                AdvancedCiteDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        b.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
        b.getPanel().getActionMap().put("close", cancelAction);
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    public boolean cancelled() {
        return !this.okPressed;
    }

    public String getPageInfo() {
        return this.pageInfo.getText().trim();
    }

    public boolean isInParenthesisCite() {
        return this.inPar.isSelected();
    }
}

