/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.UndoableFieldChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JournalAbbreviations {
    static String TOOLTIPTEXT = "<HTML>" + Globals.lang("Switches between full and abbreviated journal name if the journal name is known.") + "<BR>" + Globals.lang("To set up, go to <B>Tools -> Manage journal abbreviations</B>") + ".</HTML>";
    TreeMap<String, String> fullNameKeyed = new TreeMap();
    HashMap<String, String> abbrNameKeyed = new HashMap();
    HashMap<String, String> abbrNoDotsToAbbr = new HashMap();
    TreeMap<String, String> all = new TreeMap();

    public JournalAbbreviations() {
    }

    public JournalAbbreviations(String resource) {
        this.readJournalList(resource);
    }

    public JournalAbbreviations(File file) throws FileNotFoundException {
        this.readJournalList(file);
    }

    public Iterator<String> fullNameIterator() {
        return this.fullNameKeyed.keySet().iterator();
    }

    public boolean isKnownName(String journalName) {
        String s = journalName.toLowerCase();
        return this.fullNameKeyed.get(s) != null || this.abbrNameKeyed.get(s) != null || this.abbrNoDotsToAbbr.get(s) != null;
    }

    public boolean isAbbreviatedName(String journalName) {
        String s = journalName.toLowerCase();
        return this.abbrNameKeyed.get(s) != null || this.abbrNoDotsToAbbr.get(s) != null;
    }

    public String dotsToNodots(String name) {
        return name.replaceAll("\\.", " ").replaceAll("  ", " ").trim();
    }

    public String getAbbreviatedName(String journalName, boolean withDots) {
        String abbr;
        String s = journalName.toLowerCase();
        if (this.fullNameKeyed.containsKey(s)) {
            abbr = this.fullNameKeyed.get(s);
        } else if (this.abbrNameKeyed.containsKey(s)) {
            abbr = journalName;
        } else if (this.abbrNoDotsToAbbr.containsKey(s)) {
            abbr = this.abbrNoDotsToAbbr.get(s);
        } else {
            return null;
        }
        if (!withDots) {
            abbr = this.dotsToNodots(abbr);
        }
        return abbr;
    }

    public String getFullName(String journalName) {
        String s = this.getAbbreviatedName(journalName, true);
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        String o = this.abbrNameKeyed.get(s);
        if (o == null) {
            if (this.fullNameKeyed.containsKey(s)) {
                o = s;
            } else {
                return null;
            }
        }
        s = o;
        return s;
    }

    public void readJournalList(String resourceFileName) {
        URL url = JournalAbbreviations.class.getResource(resourceFileName);
        try {
            this.readJournalList(new InputStreamReader(url.openStream()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readJournalList(File file) throws FileNotFoundException {
        this.readJournalList(new FileReader(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readJournalList(Reader in) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(in);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.startsWith("#") || (parts = line.split("=")).length != 2) continue;
                String fullName = parts[0].trim();
                String fullNameLC = fullName.toLowerCase();
                String abbrName = parts[1].trim();
                if (abbrName.indexOf(59) >= 0) {
                    String[] restParts = abbrName.split(";");
                    abbrName = restParts[0];
                }
                String abbrNameLC = abbrName.toLowerCase();
                String abbrNoDots = this.dotsToNodots(abbrName);
                String abbrNoDotsLC = abbrNoDots.toLowerCase();
                if (fullName.length() <= 0 || abbrName.length() <= 0) continue;
                this.fullNameKeyed.put(fullNameLC, abbrName);
                this.abbrNameKeyed.put(abbrNameLC, fullName);
                this.abbrNoDotsToAbbr.put(abbrNoDotsLC, abbrName);
                this.all.put(fullName, abbrName);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public boolean abbreviate(BibtexDatabase database, BibtexEntry entry, String fieldName, CompoundEdit ce, boolean withDots) {
        String text = entry.getField(fieldName);
        if (text == null) {
            return false;
        }
        String origText = text;
        if (database != null) {
            text = database.resolveForStrings(text);
        }
        if (this.isKnownName(text) && !this.isAbbreviatedName(text)) {
            String newText = this.getAbbreviatedName(text, withDots);
            if (newText == null) {
                return false;
            }
            entry.setField(fieldName, newText);
            ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
            return true;
        }
        String unabbr = this.getFullName(text);
        if (unabbr != null) {
            String newText = this.getAbbreviatedName(unabbr, withDots);
            if (newText == null) {
                return false;
            }
            entry.setField(fieldName, newText);
            ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
            return true;
        }
        return false;
    }

    public boolean unabbreviate(BibtexDatabase database, BibtexEntry entry, String fieldName, CompoundEdit ce) {
        String text = entry.getField(fieldName);
        if (text == null) {
            return false;
        }
        String origText = text;
        if (database != null) {
            text = database.resolveForStrings(text);
        }
        if (this.isKnownName(text) && this.isAbbreviatedName(text)) {
            String newText = this.getFullName(text);
            if (newText == null) {
                return false;
            }
            entry.setField(fieldName, newText);
            ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
            return true;
        }
        return false;
    }

    public Map<String, String> getJournals() {
        return Collections.unmodifiableMap(this.all);
    }

    public static JComponent getNameSwitcher(final EntryEditor entryEditor, final FieldEditor editor, final UndoManager undoManager) {
        JButton button = new JButton(Globals.lang("Toggle abbreviation"));
        button.setToolTipText(TOOLTIPTEXT);
        button.addActionListener(new ActionListener(){
            boolean withDots = true;

            public void actionPerformed(ActionEvent actionEvent) {
                String text = editor.getText();
                if (Globals.journalAbbrev.isKnownName(text)) {
                    String s;
                    if (Globals.journalAbbrev.isAbbreviatedName(text)) {
                        if (!this.withDots) {
                            s = Globals.journalAbbrev.getAbbreviatedName(text, false);
                            this.withDots = true;
                        } else {
                            s = Globals.journalAbbrev.getFullName(text);
                        }
                    } else {
                        s = Globals.journalAbbrev.getAbbreviatedName(text, true);
                        this.withDots = false;
                    }
                    if (s != null) {
                        editor.setText(s);
                        entryEditor.storeFieldAction.actionPerformed(new ActionEvent(editor, 0, ""));
                        undoManager.addEdit(new UndoableFieldChange(entryEditor.getEntry(), editor.getFieldName(), text, s));
                    }
                }
            }
        });
        return button;
    }

    public TableModel getTableModel() {
        Object[][] cells = new Object[this.fullNameKeyed.size()][2];
        int row = 0;
        Iterator<String> i = this.fullNameIterator();
        while (i.hasNext()) {
            String name = i.next();
            cells[row][0] = this.getFullName(name);
            cells[row][1] = this.getAbbreviatedName(name, true);
            ++row;
        }
        DefaultTableModel tableModel = new DefaultTableModel(cells, new Object[]{Globals.lang("Full name"), Globals.lang("Abbreviation")}){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        return tableModel;
    }
}

