/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilverPlatterImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "SilverPlatter";
    }

    @Override
    public String getCLIId() {
        return "silverplatter";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("Record.*INSPEC.*");
        while ((str = in.readLine()) != null) {
            if (pat1.matcher(str).find()) {
                return false;
            }
            if (str.length() < 5 || !str.substring(0, 5).equals("TI:  ")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        boolean isChapter = false;
        StringBuffer sb = new StringBuffer();
        while ((str = in.readLine()) != null) {
            if (str.length() < 2) {
                sb.append("__::__").append(str);
                continue;
            }
            sb.append("__NEWFIELD__").append(str);
        }
        in.close();
        String[] entries = sb.toString().split("__::__");
        String Type2 = "";
        HashMap<String, String> h = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            Object titleO;
            if (entries[i].trim().length() < 6) continue;
            h.clear();
            String[] fields = entries[i].split("__NEWFIELD__");
            for (int j = 0; j < fields.length; ++j) {
                String yr;
                String jr;
                if (fields[j].length() < 6) continue;
                String s = fields[j];
                String f3 = s.substring(0, 2);
                String frest = s.substring(5);
                if (f3.equals("TI")) {
                    h.put("title", frest);
                    continue;
                }
                if (f3.equals("AU")) {
                    if (frest.trim().endsWith("(ed)")) {
                        String ed = frest.trim();
                        ed = ed.substring(0, ed.length() - 4);
                        h.put("editor", AuthorList.fixAuthor_lastNameFirst(ed.replaceAll(",-", ", ").replaceAll(";", " and ")));
                        continue;
                    }
                    h.put("author", AuthorList.fixAuthor_lastNameFirst(frest.replaceAll(",-", ", ").replaceAll(";", " and ")));
                    continue;
                }
                if (f3.equals("AB")) {
                    h.put("abstract", frest);
                    continue;
                }
                if (f3.equals("DE")) {
                    String kw = frest.replaceAll("-;", ",").toLowerCase();
                    h.put("keywords", kw.substring(0, kw.length() - 1));
                    continue;
                }
                if (f3.equals("SO")) {
                    int m = frest.indexOf(".");
                    if (m < 0) continue;
                    jr = frest.substring(0, m);
                    h.put("journal", jr.replaceAll("-", " "));
                    frest = frest.substring(m);
                    m = frest.indexOf(";");
                    if (m < 5) continue;
                    yr = frest.substring(m - 5, m).trim();
                    h.put("year", yr);
                    frest = frest.substring(m);
                    m = frest.indexOf(":");
                    if (m < 0) continue;
                    String pg = frest.substring(m + 1).trim();
                    h.put("pages", pg);
                    h.put("volume", frest.substring(1, m));
                    continue;
                }
                if (f3.equals("PB")) {
                    int m = frest.indexOf(":");
                    if (m < 0) continue;
                    jr = frest.substring(0, m);
                    h.put("publisher", jr.replaceAll("-", " ").trim());
                    frest = frest.substring(m);
                    m = frest.indexOf(", ");
                    if (m + 2 >= frest.length()) continue;
                    yr = frest.substring(m + 2).trim();
                    try {
                        Integer.parseInt(yr);
                        h.put("year", yr);
                    }
                    catch (NumberFormatException ex) {}
                    continue;
                }
                if (f3.equals("AF")) {
                    h.put("school", frest.trim());
                    continue;
                }
                if (!f3.equals("DT")) continue;
                if ((frest = frest.trim()).equals("Monograph")) {
                    Type2 = "book";
                    continue;
                }
                if (frest.startsWith("Dissertation")) {
                    Type2 = "phdthesis";
                    continue;
                }
                if (frest.toLowerCase().indexOf("journal") >= 0) {
                    Type2 = "article";
                    continue;
                }
                if (frest.equals("Contribution") || frest.equals("Chapter")) {
                    Type2 = "incollection";
                    isChapter = true;
                    continue;
                }
                Type2 = frest.replaceAll(" ", "");
            }
            if (isChapter && (titleO = h.get("title")) != null) {
                String title = ((String)titleO).trim();
                int inPos = title.indexOf("\" in ");
                int pgPos = title.lastIndexOf(" ");
                if (inPos > 1) {
                    h.put("title", title.substring(1, inPos));
                }
                if (pgPos > inPos) {
                    h.put("pages", title.substring(pgPos).replaceAll("-", "--"));
                }
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(h);
            bibitems.add(b);
        }
        return bibitems;
    }
}

