/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.util.XMPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfXmpImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return Globals.lang("XMP-annotated PDF");
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream in, OutputPrinter status) throws IOException {
        return XMPUtil.readXMP(in);
    }

    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        return XMPUtil.hasMetadata(in);
    }

    public String getCLIid() {
        return "xmp";
    }
}

