/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfContentImporter
extends ImportFormat {
    private static Logger logger = Logger.getLogger(PdfContentImporter.class.getName());
    private String[] split;
    private int i;
    private String curString;
    private String year = null;

    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        return false;
    }

    private String removeNonLettersAtEnd(String input) {
        if ((input = input.trim()).length() == 0) {
            return input;
        }
        char lastC = input.charAt(input.length() - 1);
        while (!Character.isLetter(lastC) && lastC != ')' && (input = input.substring(0, input.length() - 1)).length() > 0) {
            lastC = input.charAt(input.length() - 1);
        }
        return input;
    }

    private String streamlineNames(String names) {
        String res;
        if (names.contains(",")) {
            String[] splitNames = names.split(",");
            res = "";
            boolean isFirst = true;
            for (int i = 0; i < splitNames.length; ++i) {
                String curName = this.removeNonLettersAtEnd(splitNames[i]);
                if (curName.indexOf("and") == 0) {
                    curName = curName.substring(3).trim();
                } else {
                    int posAnd = curName.indexOf(" and ");
                    if (posAnd >= 0) {
                        String nameBefore = curName.substring(0, posAnd);
                        res = res.concat(" and ").concat(this.removeNonLettersAtEnd(nameBefore));
                        curName = curName.substring(posAnd + 5);
                    }
                }
                if (curName.equals("")) continue;
                if (curName.equalsIgnoreCase("et al.")) {
                    curName = "others";
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    res = res.concat(" and ");
                }
                res = res.concat(curName);
            }
        } else {
            String[] splitNames = names.split(" ");
            if (splitNames.length == 0) {
                return "";
            }
            boolean workedOnFirstOrMiddle = false;
            boolean isFirst = true;
            int i = 0;
            res = "";
            do {
                if (!workedOnFirstOrMiddle) {
                    if (splitNames[i].equalsIgnoreCase("and")) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        res = res.concat(" and ");
                    }
                    if (splitNames[i].equalsIgnoreCase("et") && splitNames.length > i + 1 && splitNames[i + 1].equalsIgnoreCase("al.")) {
                        res = res.concat("others");
                        break;
                    }
                    res = res.concat(splitNames[i]).concat(" ");
                    workedOnFirstOrMiddle = true;
                    continue;
                }
                if (splitNames[i].contains(".")) {
                    res = res.concat(splitNames[i]).concat(" ");
                    continue;
                }
                res = res.concat(this.removeNonLettersAtEnd(splitNames[i]));
                if (Character.isLowerCase(splitNames[i].charAt(0))) {
                    res = res.concat(" ");
                    continue;
                }
                workedOnFirstOrMiddle = false;
            } while (++i < splitNames.length);
        }
        return res;
    }

    private String streamlineTitle(String title) {
        return this.removeNonLettersAtEnd(title);
    }

    private boolean isYear(String yearStr) {
        try {
            Integer.parseInt(yearStr);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BibtexEntry> importEntries(InputStream in, OutputPrinter status) throws IOException {
        ArrayList<BibtexEntry> res = new ArrayList<BibtexEntry>(1);
        PDDocument document = null;
        try {
            document = PDDocument.load(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Could not load document", e);
            return res;
        }
        try {
            String lower;
            if (document.isEncrypted()) {
                logger.log(Level.INFO, Globals.lang("Encrypted documents are not supported"));
            }
            PDFTextStripper stripper = new PDFTextStripper();
            stripper.setStartPage(1);
            stripper.setEndPage(1);
            stripper.setSortByPosition(true);
            stripper.setParagraphEnd(System.getProperty("line.separator"));
            StringWriter writer = new StringWriter();
            stripper.writeText(document, (Writer)writer);
            String textResult = writer.toString();
            String author = null;
            String editor = null;
            String institution = null;
            String abstractT = null;
            String keywords = null;
            String title = null;
            String conference = null;
            String DOI = null;
            String series = null;
            String volume = null;
            String number = null;
            String pages = null;
            String publisher = null;
            BibtexEntryType type = BibtexEntryType.INPROCEEDINGS;
            String lineBreak = System.getProperty("line.separator");
            this.split = textResult.split(lineBreak);
            this.proceedToNextNonEmptyLine();
            this.curString = this.split[this.i];
            ++this.i;
            if (this.curString.length() > 4) {
                this.extractYear();
                if (this.curString.contains("Conference")) {
                    this.fillCurStringWithNonEmptyLines();
                    conference = this.curString;
                    this.curString = "";
                } else {
                    lower = this.curString.toLowerCase();
                    if (lower.contains("copyright")) {
                        this.fillCurStringWithNonEmptyLines();
                        publisher = this.curString;
                        this.curString = "";
                    }
                }
            }
            this.fillCurStringWithNonEmptyLines();
            title = this.streamlineTitle(this.curString);
            this.curString = "";
            author = null;
            while (this.i < this.split.length && !this.split[this.i].equals("")) {
                this.curString = this.streamlineNames(this.split[this.i]);
                if (author == null) {
                    author = this.curString;
                } else if (!this.curString.equals("")) {
                    author = author.concat(" and ").concat(this.curString);
                }
                ++this.i;
            }
            this.curString = "";
            ++this.i;
            while (this.i < this.split.length) {
                this.curString = this.split[this.i];
                if (this.curString.length() >= "Abstract".length() && this.curString.substring(0, "Abstract".length()).equalsIgnoreCase("Abstract")) {
                    this.curString = this.curString.length() == "Abstract".length() ? "" : this.curString.substring("Abstract".length() + 1).trim().concat(lineBreak);
                    ++this.i;
                    while (this.i < this.split.length && !this.split[this.i].equals("")) {
                        this.curString = this.curString.concat(this.split[this.i]).concat(lineBreak);
                        ++this.i;
                    }
                    abstractT = this.curString;
                    ++this.i;
                    continue;
                }
                if (this.curString.length() >= "Keywords".length() && this.curString.substring(0, "Keywords".length()).equalsIgnoreCase("Keywords")) {
                    this.curString = this.curString.length() == "Keywords".length() ? "" : this.curString.substring("Keywords".length() + 1).trim();
                    ++this.i;
                    this.fillCurStringWithNonEmptyLines();
                    keywords = this.removeNonLettersAtEnd(this.curString);
                    continue;
                }
                lower = this.curString.toLowerCase();
                int pos = lower.indexOf("technical");
                if (pos >= 0) {
                    type = BibtexEntryType.TECHREPORT;
                    pos = this.curString.trim().lastIndexOf(32);
                    if (pos >= 0) {
                        number = this.curString.substring(pos + 1);
                    }
                }
                ++this.i;
                this.proceedToNextNonEmptyLine();
            }
            this.i = this.split.length - 1;
            while (this.i >= 0) {
                this.readLastBlock();
                this.extractYear();
                int pos = this.curString.indexOf("(Eds.)");
                if (pos >= 0 && publisher == null) {
                    publisher = "Springer";
                    editor = this.streamlineNames(this.curString.substring(0, pos - 1));
                    this.curString = this.curString.substring(pos + "(Eds.)".length() + 2);
                    String[] springerSplit = this.curString.split(", ");
                    if (springerSplit.length < 4) continue;
                    conference = springerSplit[0];
                    String seriesData = springerSplit[1];
                    int lastSpace = seriesData.lastIndexOf(32);
                    series = seriesData.substring(0, lastSpace);
                    volume = seriesData.substring(lastSpace + 1);
                    pages = springerSplit[2].substring(4);
                    if (springerSplit[3].length() < 4) continue;
                    this.year = springerSplit[3].substring(0, 4);
                    continue;
                }
                if (DOI == null) {
                    pos = this.curString.indexOf("DOI");
                    if (pos < 0) {
                        pos = this.curString.indexOf("doi");
                    }
                    if (pos >= 0) {
                        int nextSpace;
                        char delimiter = this.curString.charAt(pos += 3);
                        if (delimiter == ':' || delimiter == ' ') {
                            ++pos;
                        }
                        DOI = (nextSpace = this.curString.indexOf(32, pos)) > 0 ? this.curString.substring(pos, nextSpace) : this.curString.substring(pos);
                    }
                }
                if (publisher != null || this.curString.indexOf("IEEE") < 0) continue;
                publisher = "IEEE";
                if (conference != null || (pos = this.curString.indexOf(36)) <= 0) continue;
                pos -= 2;
                while (pos >= 0 && this.curString.charAt(pos) != ' ') {
                    --pos;
                }
                if (pos <= 0) continue;
                conference = this.curString.substring(0, pos);
            }
            BibtexEntry entry = new BibtexEntry();
            entry.setType(type);
            if (author != null) {
                entry.setField("author", author);
            }
            if (editor != null) {
                entry.setField("editor", editor);
            }
            if (institution != null) {
                entry.setField("institution", institution);
            }
            if (abstractT != null) {
                entry.setField("abstract", abstractT);
            }
            if (keywords != null) {
                entry.setField("keywords", keywords);
            }
            if (title != null) {
                entry.setField("title", title);
            }
            if (conference != null) {
                entry.setField("booktitle", conference);
            }
            if (DOI != null) {
                entry.setField("doi", DOI);
            }
            if (series != null) {
                entry.setField("series", series);
            }
            if (volume != null) {
                entry.setField("volume", volume);
            }
            if (number != null) {
                entry.setField("number", number);
            }
            if (pages != null) {
                entry.setField("pages", pages);
            }
            if (this.year != null) {
                entry.setField("year", this.year);
            }
            if (publisher != null) {
                entry.setField("publisher", publisher);
            }
            entry.setField("review", textResult);
            res.add(entry);
        }
        catch (NoClassDefFoundError e) {
            if (e.getMessage().equals("org/bouncycastle/jce/provider/BouncyCastleProvider")) {
                status.showMessage(Globals.lang("Java Bouncy Castle library not found. Please download and install it. For more information see http://www.bouncycastle.org/."));
            } else {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            document.close();
        }
        return res;
    }

    private void extractYear() {
        if (this.year != null) {
            return;
        }
        Pattern p = Pattern.compile("\\d\\d\\d\\d");
        Matcher m = p.matcher(this.curString);
        if (m.find()) {
            this.year = this.curString.substring(m.start(), m.end());
        }
    }

    private void proceedToNextNonEmptyLine() {
        while (this.i < this.split.length && this.split[this.i].trim().equals("")) {
            ++this.i;
        }
    }

    private void fillCurStringWithNonEmptyLines() {
        this.curString = this.curString.trim();
        while (this.i < this.split.length && !this.split[this.i].equals("")) {
            String curLine = this.split[this.i].trim();
            if (!curLine.equals("")) {
                if (this.curString.length() > 0) {
                    this.curString = this.curString.concat(" ");
                }
                this.curString = this.curString.concat(this.split[this.i]);
            }
            ++this.i;
        }
        this.proceedToNextNonEmptyLine();
    }

    private void readLastBlock() {
        while (this.i >= 0 && this.split[this.i].trim().equals("")) {
            --this.i;
        }
        int end = this.i;
        while (this.i >= 0 && !this.split[this.i].equals("")) {
            --this.i;
        }
        this.curString = "";
        for (int j = this.i + 1; j <= end; ++j) {
            this.curString = this.curString.concat(this.split[j].trim());
            if (j == end) continue;
            this.curString = this.curString.concat(" ");
        }
    }

    @Override
    public String getFormatName() {
        return "PDFcontent";
    }
}

