/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.MedlineHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedlineImporter
extends ImportFormat {
    private static Logger logger = Logger.getLogger(MedlineImporter.class.toString());

    @Override
    public String getFormatName() {
        return "Medline";
    }

    @Override
    public String getCLIId() {
        return "medline";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        for (int i = 0; (str = in.readLine()) != null && i < 50; ++i) {
            if (str.toLowerCase().indexOf("<pubmedarticle>") < 0) continue;
            return true;
        }
        return false;
    }

    public static List<BibtexEntry> fetchMedline(String id, OutputPrinter status) {
        String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&rettype=citation&id=" + id;
        try {
            URL url = new URL(baseUrl);
            URLConnection data = url.openConnection();
            return new MedlineImporter().importEntries(data.getInputStream(), status);
        }
        catch (IOException e) {
            return new ArrayList<BibtexEntry>();
        }
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(true);
        parserFactory.setNamespaceAware(true);
        ArrayList<BibtexEntry> bibItems = null;
        try {
            SAXParser parser = parserFactory.newSAXParser();
            MedlineHandler handler = new MedlineHandler();
            parser.parse(stream, (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
            status.showMessage(e1.getLocalizedMessage());
        }
        catch (SAXException e2) {
            logger.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
            status.showMessage(e2.getLocalizedMessage());
        }
        catch (IOException e3) {
            logger.log(Level.SEVERE, e3.getLocalizedMessage(), e3);
            status.showMessage(e3.getLocalizedMessage());
        }
        return bibItems;
    }
}

