/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTORFetcher
implements EntryFetcher {
    protected static int MAX_CITATIONS = 200;
    protected static final String COOKIE_TICKET = "Jstor_Ticket";
    protected static final String URL_TICKET = "http://www.jstor.org/search";
    protected static final String COOKIE_CITATIONS = "Jstor_citations0";
    protected static final String URL_BIBTEX = "http://www.jstor.org/browse/citations.txt?exportFormat=bibtex&exportAction=Display&frame=noframe&dpi=3&config=jstor&viewCitations=1&View=View";

    @Override
    public String getHelpPage() {
        return "JSTOR.html";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "JSTOR";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "JSTOR";
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        try {
            String ticket = this.openTicket();
            String citations = this.getCitations(ticket, query);
            Collection<BibtexEntry> entries = this.getBibtexEntries(ticket, citations);
            if (entries.size() == 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", query), Globals.lang("Search JSTOR"), 1);
                return false;
            }
            for (BibtexEntry entry : entries) {
                dialog.addEntry(entry);
            }
            return true;
        }
        catch (IOException e) {
            status.showMessage(Globals.lang("Error while fetching from JSTOR") + ": " + e.getMessage());
            return false;
        }
    }

    protected Collection<BibtexEntry> getBibtexEntries(String ticket, String citations) throws IOException {
        try {
            URL url = new URL(URL_BIBTEX);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Cookie", ticket + "; " + citations);
            conn.connect();
            BibtexParser parser = new BibtexParser(new BufferedReader(new InputStreamReader(conn.getInputStream())));
            return parser.parse().getDatabase().getEntries();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String openTicket() throws IOException {
        URL url = new URL(URL_TICKET);
        URLConnection conn = url.openConnection();
        return JSTORFetcher.getCookie(COOKIE_TICKET, conn);
    }

    protected String getCitations(String ticket, String query) throws IOException {
        String urlQuery;
        try {
            urlQuery = "http://www.jstor.org/search/BasicResults?hp=" + MAX_CITATIONS + "&si=1&gw=jtx&jtxsi=1&jcpsi=1&artsi=1&Query=" + URLEncoder.encode(query, "UTF-8") + "&wc=on&citationAction=saveAll";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        URL url = new URL(urlQuery);
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("Cookie", ticket);
        return JSTORFetcher.getCookie(COOKIE_CITATIONS, conn);
    }

    public static String getCookie(String name, URLConnection conn) throws IOException {
        int i = 0;
        while (true) {
            String headerName = conn.getHeaderFieldKey(i);
            String headerValue = conn.getHeaderField(i);
            if (headerName == null && headerValue == null) break;
            if (headerName != null && headerName.equals("Set-Cookie") && headerValue.startsWith(name)) {
                StringTokenizer st = new StringTokenizer(headerValue, "; ");
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    if (!token.startsWith(name)) continue;
                    return token;
                }
            }
            ++i;
        }
        return null;
    }
}

