/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndnoteImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Refer/Endnote";
    }

    @Override
    public String getCLIId() {
        return "refer";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("%A .*");
        Pattern pat2 = Pattern.compile("%E .*");
        while ((str = in.readLine()) != null) {
            if (!pat1.matcher(str).matches() && !pat2.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        String ENDOFRECORD = "__EOREOR__";
        boolean first = true;
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).indexOf("%0") == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append(ENDOFRECORD);
                }
                sb.append(str);
            } else {
                sb.append(str);
            }
            sb.append("\n");
        }
        String[] entries = sb.toString().split(ENDOFRECORD);
        HashMap<String, String> hm = new HashMap<String, String>();
        String author = "";
        String Type2 = "";
        String editor = "";
        String artnum = "";
        for (int i = 0; i < entries.length; ++i) {
            hm.clear();
            author = "";
            Type2 = "";
            editor = "";
            artnum = "";
            boolean IsEditedBook = false;
            String[] fields = entries[i].trim().substring(1).split("\n%");
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].length() < 3) continue;
                String prefix = fields[j].substring(0, 1);
                String val = fields[j].substring(2);
                if (prefix.equals("A")) {
                    if (author.equals("")) {
                        author = val;
                        continue;
                    }
                    author = author + " and " + val;
                    continue;
                }
                if (prefix.equals("E")) {
                    if (editor.equals("")) {
                        editor = val;
                        continue;
                    }
                    editor = editor + " and " + val;
                    continue;
                }
                if (prefix.equals("T")) {
                    hm.put("title", val);
                    continue;
                }
                if (prefix.equals("0")) {
                    if (val.indexOf("Journal") == 0) {
                        Type2 = "article";
                        continue;
                    }
                    if (val.indexOf("Book Section") == 0) {
                        Type2 = "incollection";
                        continue;
                    }
                    if (val.indexOf("Book") == 0) {
                        Type2 = "book";
                        continue;
                    }
                    if (val.indexOf("Edited Book") == 0) {
                        Type2 = "book";
                        IsEditedBook = true;
                        continue;
                    }
                    if (val.indexOf("Conference") == 0) {
                        Type2 = "inproceedings";
                        continue;
                    }
                    if (val.indexOf("Report") == 0) {
                        Type2 = "techreport";
                        continue;
                    }
                    if (val.indexOf("Review") == 0) {
                        Type2 = "article";
                        continue;
                    }
                    if (val.indexOf("Thesis") == 0) {
                        Type2 = "phdthesis";
                        continue;
                    }
                    Type2 = "misc";
                    continue;
                }
                if (prefix.equals("7")) {
                    hm.put("edition", val);
                    continue;
                }
                if (prefix.equals("C")) {
                    hm.put("address", val);
                    continue;
                }
                if (prefix.equals("D")) {
                    hm.put("year", val);
                    continue;
                }
                if (prefix.equals("8")) {
                    hm.put("date", val);
                    continue;
                }
                if (prefix.equals("J")) {
                    if (hm.get("journal") != null) continue;
                    hm.put("journal", val);
                    continue;
                }
                if (prefix.equals("B")) {
                    if (Type2.equals("article")) {
                        hm.put("journal", val);
                        continue;
                    }
                    if (Type2.equals("book") || Type2.equals("inbook")) {
                        hm.put("series", val);
                        continue;
                    }
                    hm.put("booktitle", val);
                    continue;
                }
                if (prefix.equals("I")) {
                    if (Type2.equals("phdthesis")) {
                        hm.put("school", val);
                        continue;
                    }
                    hm.put("publisher", val);
                    continue;
                }
                if (prefix.equals("P")) {
                    hm.put("pages", val.replaceAll("([0-9]) *- *([0-9])", "$1--$2"));
                    continue;
                }
                if (prefix.equals("V")) {
                    hm.put("volume", val);
                    continue;
                }
                if (prefix.equals("N")) {
                    hm.put("number", val);
                    continue;
                }
                if (prefix.equals("U")) {
                    hm.put("url", val);
                    continue;
                }
                if (prefix.equals("R")) {
                    String doi = val;
                    if (doi.startsWith("doi:")) {
                        doi = doi.substring(4);
                    }
                    hm.put("doi", doi);
                    continue;
                }
                if (prefix.equals("O")) {
                    if (val.startsWith("Artn")) {
                        String[] tokens = val.split("\\s");
                        artnum = tokens[1];
                        continue;
                    }
                    hm.put("note", val);
                    continue;
                }
                if (prefix.equals("K")) {
                    hm.put("keywords", val);
                    continue;
                }
                if (prefix.equals("X")) {
                    hm.put("abstract", val);
                    continue;
                }
                if (prefix.equals("9")) {
                    if (val.indexOf("Ph.D.") == 0) {
                        Type2 = "phdthesis";
                    }
                    if (val.indexOf("Masters") != 0) continue;
                    Type2 = "mastersthesis";
                    continue;
                }
                if (!prefix.equals("F")) continue;
                hm.put("bibtexkey", Util.checkLegalKey(val));
            }
            if (IsEditedBook && editor.equals("")) {
                editor = author;
                author = "";
            }
            if (!author.equals("")) {
                hm.put("author", this.fixAuthor(author));
            }
            if (!editor.equals("")) {
                hm.put("editor", this.fixAuthor(editor));
            }
            if ((hm.get("pages") == null || ((String)hm.get("pages")).equals("-")) && !artnum.equals("")) {
                hm.put("pages", artnum);
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            if (b.getAllFields().size() <= 0) continue;
            bibitems.add(b);
        }
        return bibitems;
    }

    private String fixAuthor(String s) {
        int index = s.indexOf(" and ");
        if (index >= 0) {
            return AuthorList.fixAuthor_lastNameFirst(s);
        }
        index = s.lastIndexOf(",");
        if (index == s.length() - 1) {
            String mod = s.substring(0, s.length() - 1).replaceAll(", ", " and ");
            return AuthorList.fixAuthor_lastNameFirst(mod);
        }
        return AuthorList.fixAuthor_lastNameFirst(s);
    }
}

